/*
 * Decompiled with CFR 0.152.
 */
package io.ksmt.cache.weak;

import io.ksmt.cache.CacheRemoveHandler;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\b&\u0018\u0000 9*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0002:\u00029:B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0010J\b\u0010\u0014\u001a\u00020\u0012H\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0002J\b\u0010\u0016\u001a\u00020\u0012H\u0002J\u001c\u0010\u0017\u001a\u00020\u00122\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000bH\u0002J\b\u0010\u0019\u001a\u00020\u0012H\u0002J\u0015\u0010\u001a\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001cJ#\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u000b2\u0006\u0010\u001b\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0017\u0010\u001f\u001a\u00020\u00122\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00120!H\u0082\bJ\u001b\u0010\"\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00028\u00002\u0006\u0010#\u001a\u00028\u0001\u00a2\u0006\u0002\u0010$J\u001d\u0010%\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00028\u00002\u0006\u0010&\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010$J\u0015\u0010'\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u001cJ?\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b2\u0006\u0010\u001b\u001a\u00028\u00002\f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010&\u001a\u00028\u00012\u0006\u0010*\u001a\u00020+H&\u00a2\u0006\u0002\u0010,J\u001f\u0010-\u001a\u00020\u00122\b\u0010\u001b\u001a\u0004\u0018\u00018\u00002\u0006\u0010&\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010.J%\u0010/\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001b\u001a\u00028\u00002\u0006\u0010&\u001a\u00028\u00012\u0006\u00100\u001a\u000201\u00a2\u0006\u0002\u00102J'\u00103\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001b\u001a\u00028\u00002\u0006\u0010&\u001a\u00028\u00012\u0006\u00100\u001a\u000201H\u0002\u00a2\u0006\u0002\u00102J\b\u00104\u001a\u00020\u0012H\u0002J\b\u00105\u001a\u00020\u0012H\u0002J\b\u00106\u001a\u00020\u0012H\u0002J+\u00107\u001a\u0004\u0018\u00018\u00012\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b2\u0006\u0010&\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u00108R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\t\u001a\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lio/ksmt/cache/weak/ConcurrentWeakHashMapCache;", "K", "", "V", "()V", "cleanupLock", "Ljava/util/concurrent/locks/ReentrantLock;", "cleanupStatus", "Ljava/util/concurrent/atomic/AtomicInteger;", "data", "Ljava/util/concurrent/ConcurrentHashMap;", "Lio/ksmt/cache/weak/ConcurrentWeakHashMapCache$KeyRefNode;", "keyReferenceQueue", "Ljava/lang/ref/ReferenceQueue;", "modificationsSinceLastCleanup", "removeHandler", "Lio/ksmt/cache/CacheRemoveHandler;", "addRemoveHandler", "", "handler", "afterRead", "afterWrite", "cleanup", "cleanupEntry", "node", "drainKeyReferences", "get", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "getNode", "(Ljava/lang/Object;)Lio/ksmt/cache/weak/ConcurrentWeakHashMapCache$KeyRefNode;", "ifNotProcessing", "body", "Lkotlin/Function0;", "internKey", "valueStub", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "internUtil", "value", "lookupKey", "newNode", "referenceQueue", "hash", "", "(Ljava/lang/Object;Ljava/lang/ref/ReferenceQueue;Ljava/lang/Object;I)Lio/ksmt/cache/weak/ConcurrentWeakHashMapCache$KeyRefNode;", "notifyRemove", "(Ljava/lang/Object;Ljava/lang/Object;)V", "put", "onlyIfAbsent", "", "(Ljava/lang/Object;Ljava/lang/Object;Z)Ljava/lang/Object;", "putUtil", "runCleanup", "runCleanupIfRequired", "scheduleCleanup", "updateValueIfAlive", "(Lio/ksmt/cache/weak/ConcurrentWeakHashMapCache$KeyRefNode;Ljava/lang/Object;)Ljava/lang/Object;", "Companion", "KeyRefNode", "ksmt-core"})
public abstract class ConcurrentWeakHashMapCache<K, V> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<Object, KeyRefNode<K, V>> data = new ConcurrentHashMap();
    @NotNull
    private final ReferenceQueue<K> keyReferenceQueue = new ReferenceQueue();
    @NotNull
    private final ReentrantLock cleanupLock = new ReentrantLock();
    @NotNull
    private final AtomicInteger cleanupStatus = new AtomicInteger(0);
    @NotNull
    private final AtomicInteger modificationsSinceLastCleanup = new AtomicInteger(0);
    @Nullable
    private CacheRemoveHandler<K, V> removeHandler;
    private static final int MODIFICATIONS_TO_CLEANUP = 16;
    private static final int IDLE = 0;
    private static final int REQUIRED = 1;
    private static final int PROCESSING_TO_IDLE = 2;
    private static final int PROCESSING_TO_REQUIRED = 3;

    @NotNull
    public abstract Object lookupKey(@NotNull K var1);

    @NotNull
    public abstract KeyRefNode<K, V> newNode(@NotNull K var1, @NotNull ReferenceQueue<K> var2, @NotNull V var3, int var4);

    public final void addRemoveHandler(@NotNull CacheRemoveHandler<K, V> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.removeHandler = handler;
    }

    @Nullable
    public final V get(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        KeyRefNode<K, V> keyRefNode = this.getNode(key);
        return (V)(keyRefNode != null ? keyRefNode.getValue() : null);
    }

    @Nullable
    public final V put(@NotNull K key, @NotNull V value, boolean onlyIfAbsent) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.putUtil(key, value, onlyIfAbsent);
    }

    @NotNull
    public final K internKey(@NotNull K key, @NotNull V valueStub) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(valueStub, (String)"valueStub");
        return this.internUtil(key, valueStub);
    }

    private final KeyRefNode<K, V> getNode(K key) {
        Object lookupKey = this.lookupKey(key);
        KeyRefNode<K, V> node = this.data.get(lookupKey);
        this.afterRead();
        return node;
    }

    private final V putUtil(K key, V value, boolean onlyIfAbsent) {
        V oldValue;
        KeyRefNode current;
        KeyRefNode<K, V> node = null;
        Object lookupKey = this.lookupKey(key);
        do {
            V v;
            if ((current = this.data.get(lookupKey)) == null) {
                if (node == null) {
                    node = this.newNode(key, this.keyReferenceQueue, value, lookupKey.hashCode());
                }
                if ((current = this.data.putIfAbsent(node.getKeyReference(), node)) == null) {
                    this.afterWrite();
                    return null;
                }
                if (!onlyIfAbsent) continue;
                V it = v = current.getValue();
                boolean bl = false;
                this.afterRead();
                return v;
            }
            if (!onlyIfAbsent) continue;
            V it = v = current.getValue();
            boolean bl = false;
            this.afterRead();
            return v;
        } while (!current.isAlive() || (oldValue = this.updateValueIfAlive(current, value)) == null);
        this.notifyRemove(key, oldValue);
        this.afterRead();
        return oldValue;
    }

    private final K internUtil(K key, V value) {
        KeyRefNode<K, V> node = null;
        Object lookupKey = this.lookupKey(key);
        while (true) {
            K currentKey;
            KeyRefNode current;
            if ((current = this.data.get(lookupKey)) == null) {
                if (node == null) {
                    node = this.newNode(key, this.keyReferenceQueue, value, lookupKey.hashCode());
                }
                if ((current = this.data.putIfAbsent(node.getKeyReference(), node)) == null) {
                    this.afterWrite();
                    return key;
                }
                currentKey = current.getKey();
                if (currentKey != null) {
                    return currentKey;
                }
                this.scheduleCleanup();
                continue;
            }
            currentKey = current.getKey();
            if (currentKey != null) {
                return currentKey;
            }
            this.scheduleCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final V updateValueIfAlive(KeyRefNode<K, V> node, V value) {
        V v;
        KeyRefNode<K, V> keyRefNode = node;
        synchronized (keyRefNode) {
            block4: {
                boolean bl = false;
                if (node.isAlive()) break block4;
                V v2 = null;
                return v2;
            }
            V oldValue = node.getValue();
            node.setValue(value);
            v = oldValue;
        }
        return v;
    }

    private final void notifyRemove(K key, V value) {
        block0: {
            CacheRemoveHandler<K, V> cacheRemoveHandler = this.removeHandler;
            if (cacheRemoveHandler == null) break block0;
            cacheRemoveHandler.onRemove(key, value);
        }
    }

    private final void afterRead() {
        this.runCleanupIfRequired();
    }

    private final void afterWrite() {
        if (this.modificationsSinceLastCleanup.incrementAndGet() >= 16) {
            this.modificationsSinceLastCleanup.set(0);
            this.scheduleCleanup();
        } else {
            this.runCleanupIfRequired();
        }
    }

    private final void runCleanupIfRequired() {
        if (this.cleanupStatus.get() == 1) {
            this.runCleanup();
        }
    }

    private final void scheduleCleanup() {
        block6: while (true) {
            switch (this.cleanupStatus.get()) {
                case 0: {
                    this.cleanupStatus.compareAndSet(0, 1);
                    this.runCleanup();
                    return;
                }
                case 1: {
                    this.runCleanup();
                    return;
                }
                case 2: {
                    if (!this.cleanupStatus.compareAndSet(2, 3)) continue block6;
                    return;
                }
                case 3: {
                    return;
                }
            }
        }
    }

    private final void ifNotProcessing(Function0<Unit> body) {
        boolean $i$f$ifNotProcessing = false;
        int status = this.cleanupStatus.get();
        switch (status) {
            case 2: 
            case 3: {
                return;
            }
        }
        body.invoke();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void runCleanup() {
        ConcurrentWeakHashMapCache this_$iv = this;
        boolean $i$f$ifNotProcessing = false;
        int status$iv = this_$iv.cleanupStatus.get();
        switch (status$iv) {
            case 2: 
            case 3: {
                return;
            }
            default: {
                boolean bl = false;
                if (!this.cleanupLock.tryLock()) return;
                try {
                    ConcurrentWeakHashMapCache this_$iv2 = this;
                    boolean $i$f$ifNotProcessing2 = false;
                    int status$iv2 = this_$iv2.cleanupStatus.get();
                    switch (status$iv2) {
                        case 2: 
                        case 3: {
                            return;
                        }
                        default: {
                            boolean bl2 = false;
                            this.cleanup();
                            return;
                        }
                    }
                }
                finally {
                    this.cleanupLock.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cleanup() {
        this.cleanupStatus.set(2);
        try {
            this.drainKeyReferences();
        }
        finally {
            if (!this.cleanupStatus.compareAndSet(2, 0)) {
                this.cleanupStatus.set(1);
            }
        }
    }

    private final void drainKeyReferences() {
        while (this.keyReferenceQueue.poll() != null) {
            Reference<K> keyRef;
            KeyRefNode<K, V> node = this.data.get(keyRef);
            if (node == null) continue;
            this.cleanupEntry(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cleanupEntry(KeyRefNode<K, V> node) {
        K key = node.getKey();
        Object keyRef = node.getKeyReference();
        Ref.BooleanRef nodeResurrected = new Ref.BooleanRef();
        Ref.BooleanRef removed = new Ref.BooleanRef();
        this.data.computeIfPresent(keyRef, (arg_0, arg_1) -> ConcurrentWeakHashMapCache.cleanupEntry$lambda$5((Function2)new Function2<Object, KeyRefNode<K, V>, KeyRefNode<K, V>>(node, key, nodeResurrected, removed){
            final /* synthetic */ KeyRefNode<K, V> $node;
            final /* synthetic */ K $key;
            final /* synthetic */ Ref.BooleanRef $nodeResurrected;
            final /* synthetic */ Ref.BooleanRef $removed;
            {
                this.$node = $node;
                this.$key = $key;
                this.$nodeResurrected = $nodeResurrected;
                this.$removed = $removed;
                super(2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public final KeyRefNode<K, V> invoke(@NotNull Object object, @NotNull KeyRefNode<K, V> newNode) {
                Intrinsics.checkNotNullParameter((Object)object, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter(newNode, (String)"newNode");
                if (newNode != this.$node) {
                    return newNode;
                }
                KeyRefNode<K, V> keyRefNode = newNode;
                K k = this.$key;
                Ref.BooleanRef booleanRef = this.$nodeResurrected;
                Ref.BooleanRef booleanRef2 = this.$removed;
                KeyRefNode<K, V> keyRefNode2 = keyRefNode;
                synchronized (keyRefNode2) {
                    block5: {
                        boolean bl = false;
                        if (k == null) break block5;
                        booleanRef.element = true;
                        KeyRefNode<K, V> keyRefNode3 = newNode;
                        return keyRefNode3;
                    }
                    newNode.die();
                    booleanRef2.element = true;
                    Unit unit = Unit.INSTANCE;
                }
                return null;
            }
        }, arg_0, arg_1));
        if (nodeResurrected.element) {
            return;
        }
        KeyRefNode<K, V> keyRefNode = node;
        synchronized (keyRefNode) {
            boolean bl = false;
            if (node.isAlive()) {
                node.die();
            }
            Unit unit = Unit.INSTANCE;
        }
        if (removed.element) {
            this.notifyRemove(key, node.getValue());
        }
    }

    private static final KeyRefNode cleanupEntry$lambda$5(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (KeyRefNode)$tmp0.invoke(p0, p1);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\b&\u0018\u0000 \u0013*\b\b\u0002\u0010\u0001*\u00020\u0002*\b\b\u0003\u0010\u0003*\u00020\u00022\u00020\u0002:\u0001\u0013B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\b\u001a\u00020\tJ\r\u0010\n\u001a\u0004\u0018\u00018\u0002\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\f\u001a\u00020\u0002J\r\u0010\r\u001a\u00028\u0003H&\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0015\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00028\u0003H&\u00a2\u0006\u0002\u0010\u0012R\u0016\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/ksmt/cache/weak/ConcurrentWeakHashMapCache$KeyRefNode;", "K", "", "V", "keyRef", "Ljava/lang/ref/Reference;", "(Ljava/lang/ref/Reference;)V", "keyReference", "die", "", "getKey", "()Ljava/lang/Object;", "getKeyReference", "getValue", "isAlive", "", "setValue", "value", "(Ljava/lang/Object;)V", "Companion", "ksmt-core"})
    public static abstract class KeyRefNode<K, V> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private volatile Reference<? extends K> keyReference;
        @NotNull
        private static final Reference deadRef = new WeakReference<Object>(null);

        public KeyRefNode(@NotNull Reference<K> keyRef) {
            Intrinsics.checkNotNullParameter(keyRef, (String)"keyRef");
            this.keyReference = keyRef;
        }

        @NotNull
        public final Object getKeyReference() {
            return this.keyReference;
        }

        @Nullable
        public final K getKey() {
            return this.keyReference.get();
        }

        @NotNull
        public abstract V getValue();

        public abstract void setValue(@NotNull V var1);

        public final boolean isAlive() {
            return this.keyReference != deadRef;
        }

        public final void die() {
            Reference<K> keyRef = this.keyReference;
            this.keyReference = deadRef;
            keyRef.clear();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u00a8\u0006\u0007"}, d2={"Lio/ksmt/cache/weak/ConcurrentWeakHashMapCache$KeyRefNode$Companion;", "", "()V", "deadRef", "Ljava/lang/ref/Reference;", "", "getDeadRef$annotations", "ksmt-core"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            private static /* synthetic */ void getDeadRef$annotations() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/ksmt/cache/weak/ConcurrentWeakHashMapCache$Companion;", "", "()V", "IDLE", "", "MODIFICATIONS_TO_CLEANUP", "PROCESSING_TO_IDLE", "PROCESSING_TO_REQUIRED", "REQUIRED", "ksmt-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

