/*
 * Decompiled with CFR 0.152.
 */
package io.ksmt.expr;

import io.ksmt.KContext;
import io.ksmt.cache.InternerUtilsKt;
import io.ksmt.decl.KDecl;
import io.ksmt.expr.KApp;
import io.ksmt.expr.KExpr;
import io.ksmt.expr.transformer.KTransformerBase;
import io.ksmt.sort.KBvSort;
import java.util.List;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B-\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0006H\u0016R \u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\t0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006#"}, d2={"Lio/ksmt/expr/KBvExtractExpr;", "Lio/ksmt/expr/KApp;", "Lio/ksmt/sort/KBvSort;", "ctx", "Lio/ksmt/KContext;", "high", "", "low", "value", "Lio/ksmt/expr/KExpr;", "(Lio/ksmt/KContext;IILio/ksmt/expr/KExpr;)V", "args", "", "getArgs", "()Ljava/util/List;", "decl", "Lio/ksmt/decl/KDecl;", "getDecl", "()Lio/ksmt/decl/KDecl;", "getHigh", "()I", "getLow", "sort", "getSort", "()Lio/ksmt/sort/KBvSort;", "getValue", "()Lio/ksmt/expr/KExpr;", "accept", "transformer", "Lio/ksmt/expr/transformer/KTransformerBase;", "internEquals", "", "other", "", "internHashCode", "ksmt-core"})
public final class KBvExtractExpr
extends KApp<KBvSort, KBvSort> {
    private final int high;
    private final int low;
    @NotNull
    private final KExpr<KBvSort> value;
    @NotNull
    private final KBvSort sort;

    public KBvExtractExpr(@NotNull KContext ctx, int high, int low, @NotNull KExpr<KBvSort> value) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        super(ctx);
        this.high = high;
        this.low = low;
        this.value = value;
        if (!(this.low <= this.high)) {
            boolean bl = false;
            String string = "High bit " + this.high + " must be greater than lower bit " + this.low;
            throw new IllegalArgumentException(string.toString());
        }
        this.sort = ctx.mkBvSort-WZ4Q5Ns(UInt.constructor-impl((int)(this.high - this.low + 1)));
    }

    public final int getHigh() {
        return this.high;
    }

    public final int getLow() {
        return this.low;
    }

    @NotNull
    public final KExpr<KBvSort> getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public List<KExpr<KBvSort>> getArgs() {
        return CollectionsKt.listOf(this.value);
    }

    @Override
    @NotNull
    public KDecl<KBvSort> getDecl() {
        return this.getCtx().mkBvExtractDecl(this.high, this.low, this.value);
    }

    @Override
    @NotNull
    public KBvSort getSort() {
        return this.sort;
    }

    @Override
    @NotNull
    public KExpr<KBvSort> accept(@NotNull KTransformerBase transformer) {
        Intrinsics.checkNotNullParameter((Object)transformer, (String)"transformer");
        return transformer.transform(this);
    }

    @Override
    public int internHashCode() {
        return InternerUtilsKt.hash(this.value, this.high, this.low);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean internEquals(@NotNull Object other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        KBvExtractExpr $this$structurallyEqual$iv = this;
        boolean $i$f$structurallyEqual = false;
        if (!(other instanceof KBvExtractExpr)) return false;
        KBvExtractExpr $this$internEquals_u24lambda_u241 = $this$structurallyEqual$iv;
        boolean bl = false;
        $this$internEquals_u24lambda_u241 = (KBvExtractExpr)other;
        KExpr<KBvSort> kExpr = $this$internEquals_u24lambda_u241.value;
        bl = false;
        if (!Intrinsics.areEqual(kExpr, $this$internEquals_u24lambda_u241.value)) return false;
        KBvExtractExpr $this$internEquals_u24lambda_u242 = $this$structurallyEqual$iv;
        boolean bl2 = false;
        $this$internEquals_u24lambda_u242 = (KBvExtractExpr)other;
        int n = $this$internEquals_u24lambda_u242.high;
        bl2 = false;
        int n2 = $this$internEquals_u24lambda_u242.high;
        if (n != n2) return false;
        KBvExtractExpr $this$internEquals_u24lambda_u243 = $this$structurallyEqual$iv;
        boolean bl3 = false;
        $this$internEquals_u24lambda_u243 = (KBvExtractExpr)other;
        n = $this$internEquals_u24lambda_u243.low;
        bl3 = false;
        n2 = $this$internEquals_u24lambda_u243.low;
        if (n != n2) return false;
        return true;
    }
}

