/*
 * Decompiled with CFR 0.152.
 */
package io.ksmt.expr.printer;

import io.ksmt.expr.KApp;
import io.ksmt.expr.KExpr;
import io.ksmt.expr.printer.ExpressionPrinter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002JR\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u00042\u0016\u0010\b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u00070\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0010\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\rH\u0002J\u001e\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\n2\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013J6\u0010\u0014\u001a\u00020\u000f2\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\u0018\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u00042\u0006\u0010\u0016\u001a\u00020\u0007H\u0002\u00a8\u0006\u0018"}, d2={"Lio/ksmt/expr/printer/ExpressionPrinterWithLetBindings;", "", "()V", "generateLetBindings", "", "Lkotlin/Pair;", "", "Lio/ksmt/expr/printer/ExpressionPrinterWithLetBindings$SingleExpressionPrinter;", "resolvedExpressionPrinters", "", "Lio/ksmt/expr/KExpr;", "unresolvedPrinters", "hasMultipleOccurrences", "", "print", "", "expr", "out", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "printToBuffer", "letBindings", "exprPrinter", "SingleExpressionPrinter", "ksmt-core"})
public final class ExpressionPrinterWithLetBindings {
    public final void print(@NotNull KExpr<?> expr, @NotNull StringBuilder out) {
        Object printer;
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        HashMap resolvedExpressionPrinters = new HashMap();
        ArrayList<Object> printQueue = new ArrayList<Object>();
        HashSet<KExpr> enqueuedToPrint = new HashSet<KExpr>();
        HashSet<KExpr> hasMultipleOccurrences = new HashSet<KExpr>();
        Object[] objectArray = new KExpr[]{expr};
        ArrayList exprStack = CollectionsKt.arrayListOf((Object[])objectArray);
        while (!((Collection)exprStack).isEmpty()) {
            SingleExpressionPrinter singleExpressionPrinter;
            KExpr e = (KExpr)CollectionsKt.removeLast((List)exprStack);
            if (((Map)resolvedExpressionPrinters).containsKey(e) || enqueuedToPrint.contains(e)) {
                hasMultipleOccurrences.add(e);
                continue;
            }
            SingleExpressionPrinter it = singleExpressionPrinter = new SingleExpressionPrinter(e);
            boolean bl = false;
            e.print(it);
            printer = singleExpressionPrinter;
            printQueue.add(printer);
            enqueuedToPrint.add(e);
            if (!((SingleExpressionPrinter)printer).getHasDependency()) {
                ((Map)resolvedExpressionPrinters).put(e, printer);
                continue;
            }
            exprStack.addAll((Collection)((SingleExpressionPrinter)printer).getDependency());
        }
        List<Pair<String, SingleExpressionPrinter>> letBindings = this.generateLetBindings(resolvedExpressionPrinters, CollectionsKt.asReversedMutable((List)printQueue), (Set)hasMultipleOccurrences);
        while (!((Collection)printQueue).isEmpty()) {
            printer = (SingleExpressionPrinter)CollectionsKt.removeLast((List)printQueue);
            if (((Map)resolvedExpressionPrinters).containsKey(((SingleExpressionPrinter)printer).getExpr())) continue;
            ((SingleExpressionPrinter)printer).resolveDependencies(resolvedExpressionPrinters);
            ((Map)resolvedExpressionPrinters).put(((SingleExpressionPrinter)printer).getExpr(), printer);
        }
        printer = letBindings.iterator();
        while (printer.hasNext()) {
            SingleExpressionPrinter printer2 = (SingleExpressionPrinter)((Pair)printer.next()).component2();
            printer2.resolveDependencies(resolvedExpressionPrinters);
        }
        SingleExpressionPrinter exprPrinter = (SingleExpressionPrinter)MapsKt.getValue((Map)resolvedExpressionPrinters, expr);
        this.printToBuffer(out, letBindings, exprPrinter);
    }

    private final List<Pair<String, SingleExpressionPrinter>> generateLetBindings(Map<KExpr<?>, SingleExpressionPrinter> resolvedExpressionPrinters, List<SingleExpressionPrinter> unresolvedPrinters, Set<? extends KExpr<?>> hasMultipleOccurrences) {
        ArrayList letBindings = new ArrayList();
        List immutableResolvedPrinters = CollectionsKt.toList((Iterable)resolvedExpressionPrinters.values());
        Sequence letBindingCandidates = SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)immutableResolvedPrinters), (Sequence)CollectionsKt.asSequence((Iterable)unresolvedPrinters));
        for (SingleExpressionPrinter printer : letBindingCandidates) {
            SingleExpressionPrinter singleExpressionPrinter;
            KExpr<?> expr = printer.getExpr();
            if (!hasMultipleOccurrences.contains(expr) || expr instanceof KApp && ((KApp)expr).getArgs().isEmpty()) continue;
            int bindingIdx = letBindings.size() + 1;
            String bindingName = "e!" + bindingIdx;
            ((Collection)letBindings).add(TuplesKt.to((Object)bindingName, (Object)printer));
            Map<KExpr<?>, SingleExpressionPrinter> map = resolvedExpressionPrinters;
            SingleExpressionPrinter $this$generateLetBindings_u24lambda_u241 = singleExpressionPrinter = new SingleExpressionPrinter(expr);
            boolean bl = false;
            $this$generateLetBindings_u24lambda_u241.append(bindingName);
            map.put(expr, singleExpressionPrinter);
        }
        return letBindings;
    }

    private final void printToBuffer(StringBuilder out, List<Pair<String, SingleExpressionPrinter>> letBindings, SingleExpressionPrinter exprPrinter) {
        if (!((Collection)letBindings).isEmpty()) {
            StringBuilder stringBuilder = out.append("(let (");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
            for (Pair<String, SingleExpressionPrinter> pair : letBindings) {
                String name = (String)pair.component1();
                SingleExpressionPrinter bindingPrinter = (SingleExpressionPrinter)pair.component2();
                out.append('(');
                out.append(name);
                out.append(' ');
                bindingPrinter.printToBuffer(out);
                StringBuilder stringBuilder2 = out.append(')');
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
            }
            StringBuilder stringBuilder3 = out.append(')');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        }
        exprPrinter.printToBuffer(out);
        if (!((Collection)letBindings).isEmpty()) {
            out.append(')');
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0014\u001a\u00020\u00152\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u0018\u001a\u00020\u00152\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bJ\u001e\u0010\u001c\u001a\u00020\u00152\u0016\u0010\u001d\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003\u0012\u0004\u0012\u00020\u00000\u001eR\u001b\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\b\u0012\u0004\u0012\u00020\u0012`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/ksmt/expr/printer/ExpressionPrinterWithLetBindings$SingleExpressionPrinter;", "Lio/ksmt/expr/printer/ExpressionPrinter;", "expr", "Lio/ksmt/expr/KExpr;", "(Lio/ksmt/expr/KExpr;)V", "dependency", "", "getDependency", "()Ljava/util/List;", "getExpr", "()Lio/ksmt/expr/KExpr;", "<set-?>", "", "hasDependency", "getHasDependency", "()Z", "parts", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "append", "", "str", "", "printToBuffer", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "resolveDependencies", "printedExpressions", "", "ksmt-core"})
    private static final class SingleExpressionPrinter
    implements ExpressionPrinter {
        @NotNull
        private final KExpr<?> expr;
        @NotNull
        private final ArrayList<Object> parts;
        private boolean hasDependency;

        public SingleExpressionPrinter(@NotNull KExpr<?> expr) {
            Intrinsics.checkNotNullParameter(expr, (String)"expr");
            this.expr = expr;
            this.parts = new ArrayList();
        }

        @NotNull
        public final KExpr<?> getExpr() {
            return this.expr;
        }

        public final boolean getHasDependency() {
            return this.hasDependency;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<KExpr<?>> getDependency() {
            List list;
            if (this.hasDependency) {
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = this.parts;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof KExpr)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        @Override
        public void append(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            this.parts.add(str);
        }

        @Override
        public void append(@NotNull KExpr<?> expr) {
            Intrinsics.checkNotNullParameter(expr, (String)"expr");
            this.parts.add(expr);
            this.hasDependency = true;
        }

        public final void resolveDependencies(@NotNull Map<KExpr<?>, SingleExpressionPrinter> printedExpressions) {
            Intrinsics.checkNotNullParameter(printedExpressions, (String)"printedExpressions");
            if (!this.hasDependency) {
                return;
            }
            List currentParts = CollectionsKt.toList((Iterable)this.parts);
            this.parts.clear();
            for (Object part : currentParts) {
                SingleExpressionPrinter printer;
                if (!(part instanceof KExpr)) {
                    this.parts.add(part);
                    continue;
                }
                if (printedExpressions.get(part) == null) {
                    throw new IllegalStateException("Printer failed".toString());
                }
                if (!(!printer.hasDependency)) {
                    boolean bl = false;
                    String string = "Printer has unresolved parts";
                    throw new IllegalStateException(string.toString());
                }
                this.parts.add(printer);
            }
            this.hasDependency = false;
        }

        public final void printToBuffer(@NotNull StringBuilder buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Object[] objectArray = new Object[]{this};
            ArrayList printerStack = CollectionsKt.arrayListOf((Object[])objectArray);
            while (!((Collection)printerStack).isEmpty()) {
                Object element = CollectionsKt.removeLast((List)printerStack);
                if (element instanceof String) {
                    buffer.append((String)element);
                    continue;
                }
                if (element instanceof SingleExpressionPrinter) {
                    if (!(!((SingleExpressionPrinter)element).hasDependency)) {
                        boolean bl = false;
                        String string = "Printer has unresolved parts";
                        throw new IllegalStateException(string.toString());
                    }
                    printerStack.addAll(CollectionsKt.asReversedMutable((List)((SingleExpressionPrinter)element).parts));
                    continue;
                }
                throw new IllegalStateException("Unexpected printer part".toString());
            }
        }
    }
}

