/*
 * Decompiled with CFR 0.152.
 */
package io.ksmt.expr.rewrite.simplify;

import io.ksmt.KContext;
import io.ksmt.expr.KAddArithExpr;
import io.ksmt.expr.KExpr;
import io.ksmt.expr.KIntNumExpr;
import io.ksmt.expr.KMulArithExpr;
import io.ksmt.expr.KRealNumExpr;
import io.ksmt.expr.KToRealIntExpr;
import io.ksmt.expr.KUnaryMinusArithExpr;
import io.ksmt.sort.KArithSort;
import io.ksmt.sort.KBoolSort;
import io.ksmt.sort.KIntSort;
import io.ksmt.sort.KRealSort;
import io.ksmt.utils.ArithUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a:\u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00060\b\u001a\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n\u001a\u0016\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n\u001a\u0016\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n\u001a:\u0010\u000f\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00060\b\u001a\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0001\u001a/\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0006\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u0016\u001as\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0006\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u00020\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00062\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00020\u000625\u0010\u001b\u001a1\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00060\u001c\u00a2\u0006\u0002\b\u001dH\u0086\b\u00f8\u0001\u0000\u001as\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00180\u0006\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u00020\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00062\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00020\u000625\u0010\u001f\u001a1\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00060\u001c\u00a2\u0006\u0002\b\u001dH\u0086\b\u00f8\u0001\u0000\u001a\u0090\u0001\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u00020\u0006\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u00020\u00142\u0012\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00060\"2/\u0010#\u001a+\u0012\u0004\u0012\u00020\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00060\"\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00060$\u00a2\u0006\u0002\b\u001d2)\u0010%\u001a%\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00060$\u00a2\u0006\u0002\b\u001dH\u0086\b\u00f8\u0001\u0000\u001aZ\u0010&\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0006\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u00020\u00142\u0012\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00060\"2$\u0010'\u001a \u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00060\"\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00060(H\u0086\b\u00f8\u0001\u0000\u001a\u0093\u0001\u0010)\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0006\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u00020\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00062\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00062)\u0010%\u001a%\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00060$\u00a2\u0006\u0002\b\u001d2*\u0010'\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00060$H\u0086\b\u00f8\u0001\u0000\u001ah\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00180\u0006\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u00020\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00062\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00062*\u0010'\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00060$H\u0086\b\u00f8\u0001\u0000\u001ah\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00180\u0006\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u00020\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00062\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00062*\u0010'\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00060$H\u0086\b\u00f8\u0001\u0000\u001aZ\u0010,\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0006\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u00020\u00142\u0012\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00060\"2$\u0010'\u001a \u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00060\"\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00060(H\u0086\b\u00f8\u0001\u0000\u001ah\u0010-\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0006\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u00020\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00062\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00062*\u0010'\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00060$H\u0086\b\u00f8\u0001\u0000\u001aN\u0010.\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0006\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u00020\u00142\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00062\u001e\u0010'\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00060(H\u0086\b\u00f8\u0001\u0000\u001a^\u00100\u001a\b\u0012\u0004\u0012\u00020\u00180\u0006*\u00020\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002010\u00062\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002010\u00062*\u0010'\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u0002010\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002010\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00060$H\u0086\b\u00f8\u0001\u0000\u001a^\u00102\u001a\b\u0012\u0004\u0012\u00020\u00180\u0006*\u00020\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002030\u00062\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002030\u00062*\u0010'\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u0002030\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002030\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00060$H\u0086\b\u00f8\u0001\u0000\u001a^\u00104\u001a\b\u0012\u0004\u0012\u0002010\u0006*\u00020\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002010\u00062\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002010\u00062*\u0010'\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u0002010\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002010\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002010\u00060$H\u0086\b\u00f8\u0001\u0000\u001a^\u00105\u001a\b\u0012\u0004\u0012\u0002010\u0006*\u00020\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002010\u00062\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002010\u00062*\u0010'\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u0002010\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002010\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002010\u00060$H\u0086\b\u00f8\u0001\u0000\u001aD\u00106\u001a\b\u0012\u0004\u0012\u0002030\u0006*\u00020\u00142\f\u0010/\u001a\b\u0012\u0004\u0012\u0002010\u00062\u001e\u0010'\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002010\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002030\u00060(H\u0086\b\u00f8\u0001\u0000\u001aD\u00107\u001a\b\u0012\u0004\u0012\u00020\u00180\u0006*\u00020\u00142\f\u0010/\u001a\b\u0012\u0004\u0012\u0002030\u00062\u001e\u0010'\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002030\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00060(H\u0086\b\u00f8\u0001\u0000\u001aD\u00108\u001a\b\u0012\u0004\u0012\u0002010\u0006*\u00020\u00142\f\u0010/\u001a\b\u0012\u0004\u0012\u0002030\u00062\u001e\u0010'\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002030\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002010\u00060(H\u0086\b\u00f8\u0001\u0000\u001a\u001c\u00109\u001a\u0004\u0018\u00010\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u0006\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006:"}, d2={"addArithTerm", "Lio/ksmt/utils/ArithUtils$RealValue;", "T", "Lio/ksmt/sort/KArithSort;", "value", "term", "Lio/ksmt/expr/KExpr;", "terms", "", "evalIntDiv", "Ljava/math/BigInteger;", "a", "b", "evalIntMod", "evalIntRem", "mulArithTerm", "tryEvalArithPower", "base", "power", "castRealValue", "Lio/ksmt/KContext;", "sort", "(Lio/ksmt/KContext;Lio/ksmt/utils/ArithUtils$RealValue;Lio/ksmt/sort/KArithSort;)Lio/ksmt/expr/KExpr;", "rewriteArithGe", "Lio/ksmt/sort/KBoolSort;", "lhs", "rhs", "rewriteArithLe", "Lkotlin/Function3;", "Lkotlin/ExtensionFunctionType;", "rewriteArithGt", "rewriteArithLt", "rewriteArithSub", "args", "", "rewriteArithAdd", "Lkotlin/Function2;", "rewriteArithUnaryMinus", "simplifyArithAddLight", "cont", "Lkotlin/Function1;", "simplifyArithDivLight", "simplifyArithLeLight", "simplifyArithLtLight", "simplifyArithMulLight", "simplifyArithPowerLight", "simplifyArithUnaryMinusLight", "arg", "simplifyEqIntLight", "Lio/ksmt/sort/KIntSort;", "simplifyEqRealLight", "Lio/ksmt/sort/KRealSort;", "simplifyIntModLight", "simplifyIntRemLight", "simplifyIntToRealLight", "simplifyRealIsIntLight", "simplifyRealToIntLight", "toRealValue", "ksmt-core"})
public final class ArithSimplificationRulesKt {
    @NotNull
    public static final <T extends KArithSort> KExpr<T> simplifyArithUnaryMinusLight(@NotNull KContext $this$simplifyArithUnaryMinusLight, @NotNull KExpr<T> arg, @NotNull Function1<? super KExpr<T>, ? extends KExpr<T>> cont) {
        Intrinsics.checkNotNullParameter((Object)$this$simplifyArithUnaryMinusLight, (String)"<this>");
        Intrinsics.checkNotNullParameter(arg, (String)"arg");
        Intrinsics.checkNotNullParameter(cont, (String)"cont");
        boolean $i$f$simplifyArithUnaryMinusLight = false;
        if (arg instanceof KIntNumExpr) {
            BigInteger bigInteger = ArithUtils.INSTANCE.getBigIntegerValue((KIntNumExpr)arg).negate();
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"this.negate()");
            KIntNumExpr $this$uncheckedCast$iv = $this$simplifyArithUnaryMinusLight.mkIntNum(bigInteger);
            boolean $i$f$uncheckedCast = false;
            return (KExpr)((Object)$this$uncheckedCast$iv);
        }
        if (arg instanceof KRealNumExpr) {
            BigInteger bigInteger = ArithUtils.INSTANCE.getBigIntegerValue(((KRealNumExpr)arg).getNumerator()).negate();
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"this.negate()");
            KRealNumExpr $this$uncheckedCast$iv = $this$simplifyArithUnaryMinusLight.mkRealNum($this$simplifyArithUnaryMinusLight.mkIntNum(bigInteger), ((KRealNumExpr)arg).getDenominator());
            boolean $i$f$uncheckedCast = false;
            return (KExpr)((Object)$this$uncheckedCast$iv);
        }
        if (arg instanceof KUnaryMinusArithExpr) {
            return ((KUnaryMinusArithExpr)arg).getArg();
        }
        return (KExpr)cont.invoke(arg);
    }

    @NotNull
    public static final <T extends KArithSort> KExpr<T> simplifyArithAddLight(@NotNull KContext $this$simplifyArithAddLight, @NotNull List<? extends KExpr<T>> args, @NotNull Function1<? super List<? extends KExpr<T>>, ? extends KExpr<T>> cont) {
        Intrinsics.checkNotNullParameter((Object)$this$simplifyArithAddLight, (String)"<this>");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter(cont, (String)"cont");
        boolean $i$f$simplifyArithAddLight = false;
        if (!(!((Collection)args).isEmpty())) {
            boolean $i$a$-require-ArithSimplificationRulesKt$simplifyArithAddLight$22 = false;
            String $i$a$-require-ArithSimplificationRulesKt$simplifyArithAddLight$22 = "Arith add requires at least a single argument";
            throw new IllegalArgumentException($i$a$-require-ArithSimplificationRulesKt$simplifyArithAddLight$22.toString());
        }
        ArrayList<KExpr> simplifiedArgs = new ArrayList<KExpr>(args.size());
        ArithUtils.RealValue constantTerm = ArithUtils.RealValue.Companion.getZero();
        for (KExpr<T> arg : args) {
            if (arg instanceof KAddArithExpr) {
                for (KExpr flatArg : ((KAddArithExpr)arg).getArgs()) {
                    constantTerm = ArithSimplificationRulesKt.addArithTerm(constantTerm, flatArg, (List)simplifiedArgs);
                }
                continue;
            }
            constantTerm = ArithSimplificationRulesKt.addArithTerm(constantTerm, arg, (List)simplifiedArgs);
        }
        if (simplifiedArgs.isEmpty()) {
            return ArithUtils.INSTANCE.numericValue($this$simplifyArithAddLight, constantTerm, (KArithSort)((KExpr)CollectionsKt.first(args)).getSort());
        }
        if (!constantTerm.isZero()) {
            KExpr firstArg = (KExpr)CollectionsKt.first((List)simplifiedArgs);
            simplifiedArgs.set(0, ArithUtils.INSTANCE.numericValue($this$simplifyArithAddLight, constantTerm, (KArithSort)firstArg.getSort()));
            simplifiedArgs.add(firstArg);
        }
        if (simplifiedArgs.size() == 1) {
            return (KExpr)CollectionsKt.single((List)simplifiedArgs);
        }
        return (KExpr)cont.invoke(simplifiedArgs);
    }

    @NotNull
    public static final <T extends KArithSort> KExpr<T> rewriteArithSub(@NotNull KContext $this$rewriteArithSub, @NotNull List<? extends KExpr<T>> args, @NotNull Function2<? super KContext, ? super List<? extends KExpr<T>>, ? extends KExpr<T>> rewriteArithAdd, @NotNull Function2<? super KContext, ? super KExpr<T>, ? extends KExpr<T>> rewriteArithUnaryMinus) {
        KExpr kExpr;
        Intrinsics.checkNotNullParameter((Object)$this$rewriteArithSub, (String)"<this>");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter(rewriteArithAdd, (String)"rewriteArithAdd");
        Intrinsics.checkNotNullParameter(rewriteArithUnaryMinus, (String)"rewriteArithUnaryMinus");
        boolean $i$f$rewriteArithSub = false;
        if (args.size() == 1) {
            kExpr = (KExpr)CollectionsKt.single(args);
        } else {
            if (!(!((Collection)args).isEmpty())) {
                boolean bl = false;
                String string = "Arith sub requires at least a single argument";
                throw new IllegalArgumentException(string.toString());
            }
            KExpr[] kExprArray = new KExpr[]{(KExpr)CollectionsKt.first(args)};
            ArrayList simplifiedArgs = CollectionsKt.arrayListOf((Object[])kExprArray);
            for (KExpr arg : CollectionsKt.drop((Iterable)args, (int)1)) {
                ((Collection)simplifiedArgs).add(rewriteArithUnaryMinus.invoke((Object)$this$rewriteArithSub, (Object)arg));
            }
            kExpr = (KExpr)rewriteArithAdd.invoke((Object)$this$rewriteArithSub, (Object)simplifiedArgs);
        }
        return kExpr;
    }

    @NotNull
    public static final <T extends KArithSort> KExpr<T> simplifyArithMulLight(@NotNull KContext $this$simplifyArithMulLight, @NotNull List<? extends KExpr<T>> args, @NotNull Function1<? super List<? extends KExpr<T>>, ? extends KExpr<T>> cont) {
        Intrinsics.checkNotNullParameter((Object)$this$simplifyArithMulLight, (String)"<this>");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter(cont, (String)"cont");
        boolean $i$f$simplifyArithMulLight = false;
        if (!(!((Collection)args).isEmpty())) {
            boolean $i$a$-require-ArithSimplificationRulesKt$simplifyArithMulLight$22 = false;
            String $i$a$-require-ArithSimplificationRulesKt$simplifyArithMulLight$22 = "Arith mul requires at least a single argument";
            throw new IllegalArgumentException($i$a$-require-ArithSimplificationRulesKt$simplifyArithMulLight$22.toString());
        }
        ArrayList<KExpr> simplifiedArgs = new ArrayList<KExpr>(args.size());
        ArithUtils.RealValue constantTerm = ArithUtils.RealValue.Companion.getOne();
        for (KExpr<T> arg : args) {
            if (arg instanceof KMulArithExpr) {
                for (KExpr flatArg : ((KMulArithExpr)arg).getArgs()) {
                    constantTerm = ArithSimplificationRulesKt.mulArithTerm(constantTerm, flatArg, (List)simplifiedArgs);
                }
                continue;
            }
            constantTerm = ArithSimplificationRulesKt.mulArithTerm(constantTerm, arg, (List)simplifiedArgs);
        }
        if (simplifiedArgs.isEmpty() || constantTerm.isZero()) {
            return ArithUtils.INSTANCE.numericValue($this$simplifyArithMulLight, constantTerm, (KArithSort)((KExpr)CollectionsKt.first(args)).getSort());
        }
        if (!Intrinsics.areEqual((Object)constantTerm, (Object)ArithUtils.RealValue.Companion.getOne())) {
            KExpr firstArg = (KExpr)CollectionsKt.first((List)simplifiedArgs);
            simplifiedArgs.set(0, ArithUtils.INSTANCE.numericValue($this$simplifyArithMulLight, constantTerm, (KArithSort)firstArg.getSort()));
            simplifiedArgs.add(firstArg);
        }
        if (simplifiedArgs.size() == 1) {
            return (KExpr)CollectionsKt.single((List)simplifiedArgs);
        }
        return (KExpr)cont.invoke(simplifiedArgs);
    }

    @NotNull
    public static final <T extends KArithSort> KExpr<KBoolSort> simplifyArithLeLight(@NotNull KContext $this$simplifyArithLeLight, @NotNull KExpr<T> lhs, @NotNull KExpr<T> rhs, @NotNull Function2<? super KExpr<T>, ? super KExpr<T>, ? extends KExpr<KBoolSort>> cont) {
        Intrinsics.checkNotNullParameter((Object)$this$simplifyArithLeLight, (String)"<this>");
        Intrinsics.checkNotNullParameter(lhs, (String)"lhs");
        Intrinsics.checkNotNullParameter(rhs, (String)"rhs");
        Intrinsics.checkNotNullParameter(cont, (String)"cont");
        boolean $i$f$simplifyArithLeLight = false;
        if (lhs instanceof KIntNumExpr && rhs instanceof KIntNumExpr) {
            return $this$simplifyArithLeLight.getExpr(ArithUtils.INSTANCE.compareTo((KIntNumExpr)lhs, (KIntNumExpr)rhs) <= 0);
        }
        if (lhs instanceof KRealNumExpr && rhs instanceof KRealNumExpr) {
            return $this$simplifyArithLeLight.getExpr(ArithUtils.INSTANCE.toRealValue((KRealNumExpr)lhs).compareTo(ArithUtils.INSTANCE.toRealValue((KRealNumExpr)rhs)) <= 0);
        }
        return (KExpr)cont.invoke(lhs, rhs);
    }

    @NotNull
    public static final <T extends KArithSort> KExpr<T> simplifyArithDivLight(@NotNull KContext $this$simplifyArithDivLight, @NotNull KExpr<T> lhs, @NotNull KExpr<T> rhs, @NotNull Function2<? super KContext, ? super KExpr<T>, ? extends KExpr<T>> rewriteArithUnaryMinus, @NotNull Function2<? super KExpr<T>, ? super KExpr<T>, ? extends KExpr<T>> cont) {
        Intrinsics.checkNotNullParameter((Object)$this$simplifyArithDivLight, (String)"<this>");
        Intrinsics.checkNotNullParameter(lhs, (String)"lhs");
        Intrinsics.checkNotNullParameter(rhs, (String)"rhs");
        Intrinsics.checkNotNullParameter(rewriteArithUnaryMinus, (String)"rewriteArithUnaryMinus");
        Intrinsics.checkNotNullParameter(cont, (String)"cont");
        boolean $i$f$simplifyArithDivLight = false;
        ArithUtils.RealValue rValue = ArithSimplificationRulesKt.toRealValue(rhs);
        if (rValue != null && !rValue.isZero()) {
            if (Intrinsics.areEqual((Object)rValue, (Object)ArithUtils.RealValue.Companion.getOne())) {
                return lhs;
            }
            if (Intrinsics.areEqual((Object)rValue, (Object)ArithUtils.RealValue.Companion.getMinusOne())) {
                return (KExpr)rewriteArithUnaryMinus.invoke((Object)$this$simplifyArithDivLight, lhs);
            }
            if (lhs instanceof KIntNumExpr) {
                KIntNumExpr $this$uncheckedCast$iv = $this$simplifyArithDivLight.mkIntNum(ArithSimplificationRulesKt.evalIntDiv(ArithUtils.INSTANCE.getBigIntegerValue((KIntNumExpr)lhs), rValue.getNumerator()));
                boolean $i$f$uncheckedCast = false;
                return (KExpr)((Object)$this$uncheckedCast$iv);
            }
            if (lhs instanceof KRealNumExpr) {
                ArithUtils.RealValue value = ArithUtils.INSTANCE.toRealValue((KRealNumExpr)lhs).div(rValue);
                KExpr<KArithSort> $this$uncheckedCast$iv = ArithUtils.INSTANCE.numericValue($this$simplifyArithDivLight, value, (KArithSort)((KRealNumExpr)lhs).getSort());
                boolean $i$f$uncheckedCast = false;
                return (KExpr)((Object)$this$uncheckedCast$iv);
            }
        }
        return (KExpr)cont.invoke(lhs, rhs);
    }

    @NotNull
    public static final <T extends KArithSort> KExpr<T> simplifyArithPowerLight(@NotNull KContext $this$simplifyArithPowerLight, @NotNull KExpr<T> lhs, @NotNull KExpr<T> rhs, @NotNull Function2<? super KExpr<T>, ? super KExpr<T>, ? extends KExpr<T>> cont) {
        ArithUtils.RealValue realValue;
        Intrinsics.checkNotNullParameter((Object)$this$simplifyArithPowerLight, (String)"<this>");
        Intrinsics.checkNotNullParameter(lhs, (String)"lhs");
        Intrinsics.checkNotNullParameter(rhs, (String)"rhs");
        Intrinsics.checkNotNullParameter(cont, (String)"cont");
        boolean $i$f$simplifyArithPowerLight = false;
        ArithUtils.RealValue lValue = ArithSimplificationRulesKt.toRealValue(lhs);
        ArithUtils.RealValue rValue = ArithSimplificationRulesKt.toRealValue(rhs);
        if (lValue != null && rValue != null && (realValue = ArithSimplificationRulesKt.tryEvalArithPower(lValue, rValue)) != null) {
            ArithUtils.RealValue it = realValue;
            boolean bl = false;
            return ArithSimplificationRulesKt.castRealValue($this$simplifyArithPowerLight, it, (KArithSort)lhs.getSort());
        }
        if (Intrinsics.areEqual((Object)lValue, (Object)ArithUtils.RealValue.Companion.getOne())) {
            return lhs;
        }
        if (Intrinsics.areEqual((Object)rValue, (Object)ArithUtils.RealValue.Companion.getOne())) {
            return lhs;
        }
        return (KExpr)cont.invoke(lhs, rhs);
    }

    @NotNull
    public static final <T extends KArithSort> KExpr<KBoolSort> simplifyArithLtLight(@NotNull KContext $this$simplifyArithLtLight, @NotNull KExpr<T> lhs, @NotNull KExpr<T> rhs, @NotNull Function2<? super KExpr<T>, ? super KExpr<T>, ? extends KExpr<KBoolSort>> cont) {
        Intrinsics.checkNotNullParameter((Object)$this$simplifyArithLtLight, (String)"<this>");
        Intrinsics.checkNotNullParameter(lhs, (String)"lhs");
        Intrinsics.checkNotNullParameter(rhs, (String)"rhs");
        Intrinsics.checkNotNullParameter(cont, (String)"cont");
        boolean $i$f$simplifyArithLtLight = false;
        if (lhs instanceof KIntNumExpr && rhs instanceof KIntNumExpr) {
            return $this$simplifyArithLtLight.getExpr(ArithUtils.INSTANCE.compareTo((KIntNumExpr)lhs, (KIntNumExpr)rhs) < 0);
        }
        if (lhs instanceof KRealNumExpr && rhs instanceof KRealNumExpr) {
            return $this$simplifyArithLtLight.getExpr(ArithUtils.INSTANCE.toRealValue((KRealNumExpr)lhs).compareTo(ArithUtils.INSTANCE.toRealValue((KRealNumExpr)rhs)) < 0);
        }
        return (KExpr)cont.invoke(lhs, rhs);
    }

    @NotNull
    public static final <T extends KArithSort> KExpr<KBoolSort> rewriteArithGe(@NotNull KContext $this$rewriteArithGe, @NotNull KExpr<T> lhs, @NotNull KExpr<T> rhs, @NotNull Function3<? super KContext, ? super KExpr<T>, ? super KExpr<T>, ? extends KExpr<KBoolSort>> rewriteArithLe) {
        Intrinsics.checkNotNullParameter((Object)$this$rewriteArithGe, (String)"<this>");
        Intrinsics.checkNotNullParameter(lhs, (String)"lhs");
        Intrinsics.checkNotNullParameter(rhs, (String)"rhs");
        Intrinsics.checkNotNullParameter(rewriteArithLe, (String)"rewriteArithLe");
        boolean $i$f$rewriteArithGe = false;
        return (KExpr)rewriteArithLe.invoke((Object)$this$rewriteArithGe, rhs, lhs);
    }

    @NotNull
    public static final <T extends KArithSort> KExpr<KBoolSort> rewriteArithGt(@NotNull KContext $this$rewriteArithGt, @NotNull KExpr<T> lhs, @NotNull KExpr<T> rhs, @NotNull Function3<? super KContext, ? super KExpr<T>, ? super KExpr<T>, ? extends KExpr<KBoolSort>> rewriteArithLt) {
        Intrinsics.checkNotNullParameter((Object)$this$rewriteArithGt, (String)"<this>");
        Intrinsics.checkNotNullParameter(lhs, (String)"lhs");
        Intrinsics.checkNotNullParameter(rhs, (String)"rhs");
        Intrinsics.checkNotNullParameter(rewriteArithLt, (String)"rewriteArithLt");
        boolean $i$f$rewriteArithGt = false;
        return (KExpr)rewriteArithLt.invoke((Object)$this$rewriteArithGt, rhs, lhs);
    }

    @NotNull
    public static final KExpr<KIntSort> simplifyIntModLight(@NotNull KContext $this$simplifyIntModLight, @NotNull KExpr<KIntSort> lhs, @NotNull KExpr<KIntSort> rhs, @NotNull Function2<? super KExpr<KIntSort>, ? super KExpr<KIntSort>, ? extends KExpr<KIntSort>> cont) {
        block4: {
            BigInteger rValue;
            block6: {
                block5: {
                    Intrinsics.checkNotNullParameter((Object)$this$simplifyIntModLight, (String)"<this>");
                    Intrinsics.checkNotNullParameter(lhs, (String)"lhs");
                    Intrinsics.checkNotNullParameter(rhs, (String)"rhs");
                    Intrinsics.checkNotNullParameter(cont, (String)"cont");
                    boolean $i$f$simplifyIntModLight = false;
                    if (!(rhs instanceof KIntNumExpr)) break block4;
                    rValue = ArithUtils.INSTANCE.getBigIntegerValue((KIntNumExpr)rhs);
                    if (Intrinsics.areEqual((Object)rValue, (Object)BigInteger.ONE)) break block5;
                    BigInteger bigInteger = BigInteger.ONE;
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"ONE");
                    BigInteger bigInteger2 = bigInteger.negate();
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"this.negate()");
                    if (!Intrinsics.areEqual((Object)rValue, (Object)bigInteger2)) break block6;
                }
                return $this$simplifyIntModLight.mkIntNum(0);
            }
            if (!Intrinsics.areEqual((Object)rValue, (Object)BigInteger.ZERO) && lhs instanceof KIntNumExpr) {
                return $this$simplifyIntModLight.mkIntNum(ArithSimplificationRulesKt.evalIntMod(ArithUtils.INSTANCE.getBigIntegerValue((KIntNumExpr)lhs), rValue));
            }
        }
        return (KExpr)cont.invoke(lhs, rhs);
    }

    @NotNull
    public static final KExpr<KIntSort> simplifyIntRemLight(@NotNull KContext $this$simplifyIntRemLight, @NotNull KExpr<KIntSort> lhs, @NotNull KExpr<KIntSort> rhs, @NotNull Function2<? super KExpr<KIntSort>, ? super KExpr<KIntSort>, ? extends KExpr<KIntSort>> cont) {
        block4: {
            BigInteger rValue;
            block6: {
                block5: {
                    Intrinsics.checkNotNullParameter((Object)$this$simplifyIntRemLight, (String)"<this>");
                    Intrinsics.checkNotNullParameter(lhs, (String)"lhs");
                    Intrinsics.checkNotNullParameter(rhs, (String)"rhs");
                    Intrinsics.checkNotNullParameter(cont, (String)"cont");
                    boolean $i$f$simplifyIntRemLight = false;
                    if (!(rhs instanceof KIntNumExpr)) break block4;
                    rValue = ArithUtils.INSTANCE.getBigIntegerValue((KIntNumExpr)rhs);
                    if (Intrinsics.areEqual((Object)rValue, (Object)BigInteger.ONE)) break block5;
                    BigInteger bigInteger = BigInteger.ONE;
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"ONE");
                    BigInteger bigInteger2 = bigInteger.negate();
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"this.negate()");
                    if (!Intrinsics.areEqual((Object)rValue, (Object)bigInteger2)) break block6;
                }
                return $this$simplifyIntRemLight.mkIntNum(0);
            }
            if (!Intrinsics.areEqual((Object)rValue, (Object)BigInteger.ZERO) && lhs instanceof KIntNumExpr) {
                return $this$simplifyIntRemLight.mkIntNum(ArithSimplificationRulesKt.evalIntRem(ArithUtils.INSTANCE.getBigIntegerValue((KIntNumExpr)lhs), rValue));
            }
        }
        return (KExpr)cont.invoke(lhs, rhs);
    }

    @NotNull
    public static final KExpr<KRealSort> simplifyIntToRealLight(@NotNull KContext $this$simplifyIntToRealLight, @NotNull KExpr<KIntSort> arg, @NotNull Function1<? super KExpr<KIntSort>, ? extends KExpr<KRealSort>> cont) {
        Intrinsics.checkNotNullParameter((Object)$this$simplifyIntToRealLight, (String)"<this>");
        Intrinsics.checkNotNullParameter(arg, (String)"arg");
        Intrinsics.checkNotNullParameter(cont, (String)"cont");
        boolean $i$f$simplifyIntToRealLight = false;
        return arg instanceof KIntNumExpr ? (KExpr)$this$simplifyIntToRealLight.mkRealNum((KIntNumExpr)arg) : (KExpr)cont.invoke(arg);
    }

    @NotNull
    public static final KExpr<KBoolSort> simplifyRealIsIntLight(@NotNull KContext $this$simplifyRealIsIntLight, @NotNull KExpr<KRealSort> arg, @NotNull Function1<? super KExpr<KRealSort>, ? extends KExpr<KBoolSort>> cont) {
        Intrinsics.checkNotNullParameter((Object)$this$simplifyRealIsIntLight, (String)"<this>");
        Intrinsics.checkNotNullParameter(arg, (String)"arg");
        Intrinsics.checkNotNullParameter(cont, (String)"cont");
        boolean $i$f$simplifyRealIsIntLight = false;
        if (arg instanceof KRealNumExpr) {
            return $this$simplifyRealIsIntLight.getExpr(Intrinsics.areEqual((Object)ArithUtils.INSTANCE.toRealValue((KRealNumExpr)arg).getDenominator(), (Object)BigInteger.ONE));
        }
        if (arg instanceof KToRealIntExpr) {
            return $this$simplifyRealIsIntLight.getTrueExpr();
        }
        return (KExpr)cont.invoke(arg);
    }

    @NotNull
    public static final KExpr<KIntSort> simplifyRealToIntLight(@NotNull KContext $this$simplifyRealToIntLight, @NotNull KExpr<KRealSort> arg, @NotNull Function1<? super KExpr<KRealSort>, ? extends KExpr<KIntSort>> cont) {
        Intrinsics.checkNotNullParameter((Object)$this$simplifyRealToIntLight, (String)"<this>");
        Intrinsics.checkNotNullParameter(arg, (String)"arg");
        Intrinsics.checkNotNullParameter(cont, (String)"cont");
        boolean $i$f$simplifyRealToIntLight = false;
        if (arg instanceof KRealNumExpr) {
            ArithUtils.RealValue realValue = ArithUtils.INSTANCE.toRealValue((KRealNumExpr)arg);
            return $this$simplifyRealToIntLight.mkIntNum(ArithSimplificationRulesKt.evalIntDiv(realValue.getNumerator(), realValue.getDenominator()));
        }
        if (arg instanceof KToRealIntExpr) {
            return ((KToRealIntExpr)arg).getArg();
        }
        return (KExpr)cont.invoke(arg);
    }

    @NotNull
    public static final KExpr<KBoolSort> simplifyEqIntLight(@NotNull KContext $this$simplifyEqIntLight, @NotNull KExpr<KIntSort> lhs, @NotNull KExpr<KIntSort> rhs, @NotNull Function2<? super KExpr<KIntSort>, ? super KExpr<KIntSort>, ? extends KExpr<KBoolSort>> cont) {
        Intrinsics.checkNotNullParameter((Object)$this$simplifyEqIntLight, (String)"<this>");
        Intrinsics.checkNotNullParameter(lhs, (String)"lhs");
        Intrinsics.checkNotNullParameter(rhs, (String)"rhs");
        Intrinsics.checkNotNullParameter(cont, (String)"cont");
        boolean $i$f$simplifyEqIntLight = false;
        if (Intrinsics.areEqual(lhs, rhs)) {
            return $this$simplifyEqIntLight.getTrueExpr();
        }
        if (lhs instanceof KIntNumExpr && rhs instanceof KIntNumExpr) {
            return $this$simplifyEqIntLight.getExpr(ArithUtils.INSTANCE.compareTo((KIntNumExpr)lhs, (KIntNumExpr)rhs) == 0);
        }
        return (KExpr)cont.invoke(lhs, rhs);
    }

    @NotNull
    public static final KExpr<KBoolSort> simplifyEqRealLight(@NotNull KContext $this$simplifyEqRealLight, @NotNull KExpr<KRealSort> lhs, @NotNull KExpr<KRealSort> rhs, @NotNull Function2<? super KExpr<KRealSort>, ? super KExpr<KRealSort>, ? extends KExpr<KBoolSort>> cont) {
        Intrinsics.checkNotNullParameter((Object)$this$simplifyEqRealLight, (String)"<this>");
        Intrinsics.checkNotNullParameter(lhs, (String)"lhs");
        Intrinsics.checkNotNullParameter(rhs, (String)"rhs");
        Intrinsics.checkNotNullParameter(cont, (String)"cont");
        boolean $i$f$simplifyEqRealLight = false;
        if (Intrinsics.areEqual(lhs, rhs)) {
            return $this$simplifyEqRealLight.getTrueExpr();
        }
        if (lhs instanceof KRealNumExpr && rhs instanceof KRealNumExpr) {
            return $this$simplifyEqRealLight.getExpr(ArithUtils.INSTANCE.toRealValue((KRealNumExpr)lhs).compareTo(ArithUtils.INSTANCE.toRealValue((KRealNumExpr)rhs)) == 0);
        }
        return (KExpr)cont.invoke(lhs, rhs);
    }

    @NotNull
    public static final <T extends KArithSort> ArithUtils.RealValue addArithTerm(@NotNull ArithUtils.RealValue value, @NotNull KExpr<T> term, @NotNull List<KExpr<T>> terms) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(term, (String)"term");
        Intrinsics.checkNotNullParameter(terms, (String)"terms");
        if (term instanceof KIntNumExpr) {
            return value.add(ArithUtils.INSTANCE.toRealValue((KIntNumExpr)term));
        }
        if (term instanceof KRealNumExpr) {
            return value.add(ArithUtils.INSTANCE.toRealValue((KRealNumExpr)term));
        }
        ((Collection)terms).add(term);
        return value;
    }

    @NotNull
    public static final <T extends KArithSort> ArithUtils.RealValue mulArithTerm(@NotNull ArithUtils.RealValue value, @NotNull KExpr<T> term, @NotNull List<KExpr<T>> terms) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(term, (String)"term");
        Intrinsics.checkNotNullParameter(terms, (String)"terms");
        if (term instanceof KIntNumExpr) {
            return value.mul(ArithUtils.INSTANCE.toRealValue((KIntNumExpr)term));
        }
        if (term instanceof KRealNumExpr) {
            return value.mul(ArithUtils.INSTANCE.toRealValue((KRealNumExpr)term));
        }
        ((Collection)terms).add(term);
        return value;
    }

    @Nullable
    public static final ArithUtils.RealValue tryEvalArithPower(@NotNull ArithUtils.RealValue base, @NotNull ArithUtils.RealValue power) {
        ArithUtils.RealValue realValue;
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)power, (String)"power");
        if (base.isZero() && power.isZero()) {
            realValue = null;
        } else if (power.isZero()) {
            realValue = ArithUtils.RealValue.Companion.getOne();
        } else if (base.isZero()) {
            realValue = ArithUtils.RealValue.Companion.getZero();
        } else if (Intrinsics.areEqual((Object)base, (Object)ArithUtils.RealValue.Companion.getOne())) {
            realValue = ArithUtils.RealValue.Companion.getOne();
        } else if (Intrinsics.areEqual((Object)power, (Object)ArithUtils.RealValue.Companion.getOne())) {
            realValue = base;
        } else if (Intrinsics.areEqual((Object)power, (Object)ArithUtils.RealValue.Companion.getMinusOne())) {
            realValue = base.inverse();
        } else {
            Integer n = power.smallIntValue();
            if (n != null) {
                int powerIntValue = ((Number)n).intValue();
                boolean bl = false;
                realValue = powerIntValue >= 0 ? base.pow(powerIntValue) : base.inverse().pow(Math.abs(powerIntValue));
            } else {
                realValue = null;
            }
        }
        return realValue;
    }

    @NotNull
    public static final <T extends KArithSort> KExpr<T> castRealValue(@NotNull KContext $this$castRealValue, @NotNull ArithUtils.RealValue value, @NotNull T sort) {
        KExpr kExpr;
        Intrinsics.checkNotNullParameter((Object)$this$castRealValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(sort, (String)"sort");
        T t = sort;
        if (Intrinsics.areEqual(t, (Object)$this$castRealValue.getRealSort())) {
            kExpr = ArithUtils.INSTANCE.numericValue($this$castRealValue, value, sort);
        } else if (Intrinsics.areEqual(t, (Object)$this$castRealValue.getIntSort())) {
            BigInteger bigInteger = value.getNumerator().divide(value.getDenominator());
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"this.divide(other)");
            KIntNumExpr $this$uncheckedCast$iv = $this$castRealValue.mkIntNum(bigInteger);
            boolean $i$f$uncheckedCast = false;
            kExpr = (KExpr)((Object)$this$uncheckedCast$iv);
        } else {
            throw new IllegalStateException(("Unexpected arith sort: " + sort).toString());
        }
        return kExpr;
    }

    @Nullable
    public static final <T extends KArithSort> ArithUtils.RealValue toRealValue(@NotNull KExpr<T> $this$toRealValue) {
        Intrinsics.checkNotNullParameter($this$toRealValue, (String)"<this>");
        KExpr<T> kExpr = $this$toRealValue;
        return kExpr instanceof KIntNumExpr ? ArithUtils.INSTANCE.toRealValue((KIntNumExpr)$this$toRealValue) : (kExpr instanceof KRealNumExpr ? ArithUtils.INSTANCE.toRealValue((KRealNumExpr)$this$toRealValue) : null);
    }

    @NotNull
    public static final BigInteger evalIntDiv(@NotNull BigInteger a, @NotNull BigInteger b) {
        BigInteger bigInteger;
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (a.compareTo(BigInteger.ZERO) >= 0) {
            BigInteger bigInteger2 = a.divide(b);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"this.divide(other)");
            return bigInteger2;
        }
        BigInteger[] bigIntegerArray = a.divideAndRemainder(b);
        Intrinsics.checkNotNullExpressionValue((Object)bigIntegerArray, (String)"divideAndRemainder(b)");
        BigInteger divisionRes = bigIntegerArray[0];
        BigInteger rem = bigIntegerArray[1];
        if (Intrinsics.areEqual((Object)rem, (Object)BigInteger.ZERO)) {
            Intrinsics.checkNotNullExpressionValue((Object)divisionRes, (String)"divisionRes");
            return divisionRes;
        }
        if (b.compareTo(BigInteger.ZERO) >= 0) {
            Intrinsics.checkNotNullExpressionValue((Object)divisionRes, (String)"divisionRes");
            BigInteger bigInteger3 = divisionRes;
            BigInteger bigInteger4 = BigInteger.ONE;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"ONE");
            BigInteger bigInteger5 = bigInteger3.subtract(bigInteger4);
            bigInteger = bigInteger5;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"this.subtract(other)");
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)divisionRes, (String)"divisionRes");
            BigInteger bigInteger6 = divisionRes;
            BigInteger bigInteger7 = BigInteger.ONE;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger7, (String)"ONE");
            BigInteger bigInteger8 = bigInteger6.add(bigInteger7);
            bigInteger = bigInteger8;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger8, (String)"this.add(other)");
        }
        return bigInteger;
    }

    @NotNull
    public static final BigInteger evalIntMod(@NotNull BigInteger a, @NotNull BigInteger b) {
        BigInteger bigInteger;
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        BigInteger bigInteger2 = a.remainder(b);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"this.remainder(other)");
        BigInteger remainder = bigInteger2;
        if (remainder.compareTo(BigInteger.ZERO) >= 0) {
            return remainder;
        }
        if (b.compareTo(BigInteger.ZERO) >= 0) {
            BigInteger bigInteger3 = remainder.add(b);
            bigInteger = bigInteger3;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"this.add(other)");
        } else {
            BigInteger bigInteger4 = remainder.subtract(b);
            bigInteger = bigInteger4;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"this.subtract(other)");
        }
        return bigInteger;
    }

    @NotNull
    public static final BigInteger evalIntRem(@NotNull BigInteger a, @NotNull BigInteger b) {
        BigInteger bigInteger;
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        BigInteger mod = ArithSimplificationRulesKt.evalIntMod(a, b);
        if (b.compareTo(BigInteger.ZERO) >= 0) {
            bigInteger = mod;
        } else {
            BigInteger bigInteger2 = mod.negate();
            bigInteger = bigInteger2;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"this.negate()");
        }
        return bigInteger;
    }
}

