/*
 * Decompiled with CFR 0.152.
 */
package io.ksmt.utils;

import io.ksmt.KContext;
import io.ksmt.cache.InternerUtilsKt;
import io.ksmt.expr.KExpr;
import io.ksmt.expr.KInt32NumExpr;
import io.ksmt.expr.KInt64NumExpr;
import io.ksmt.expr.KIntBigNumExpr;
import io.ksmt.expr.KIntNumExpr;
import io.ksmt.expr.KRealNumExpr;
import io.ksmt.sort.KArithSort;
import io.ksmt.utils.ArithUtils;
import io.ksmt.utils.UtilsKt;
import java.math.BigInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\b\u001a\u00020\t*\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0086\u0002J/\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\b\b\u0000\u0010\r*\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u0002H\r\u00a2\u0006\u0002\u0010\u0013J\n\u0010\u0014\u001a\u00020\u0011*\u00020\u0005J\n\u0010\u0014\u001a\u00020\u0011*\u00020\u0015R\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lio/ksmt/utils/ArithUtils;", "", "()V", "bigIntegerValue", "Ljava/math/BigInteger;", "Lio/ksmt/expr/KIntNumExpr;", "getBigIntegerValue", "(Lio/ksmt/expr/KIntNumExpr;)Ljava/math/BigInteger;", "compareTo", "", "other", "numericValue", "Lio/ksmt/expr/KExpr;", "T", "Lio/ksmt/sort/KArithSort;", "Lio/ksmt/KContext;", "realValue", "Lio/ksmt/utils/ArithUtils$RealValue;", "sort", "(Lio/ksmt/KContext;Lio/ksmt/utils/ArithUtils$RealValue;Lio/ksmt/sort/KArithSort;)Lio/ksmt/expr/KExpr;", "toRealValue", "Lio/ksmt/expr/KRealNumExpr;", "RealValue", "ksmt-core"})
public final class ArithUtils {
    @NotNull
    public static final ArithUtils INSTANCE = new ArithUtils();

    private ArithUtils() {
    }

    @NotNull
    public final <T extends KArithSort> KExpr<T> numericValue(@NotNull KContext $this$numericValue, @NotNull RealValue realValue, @NotNull T sort) {
        KExpr kExpr;
        Intrinsics.checkNotNullParameter((Object)$this$numericValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)realValue, (String)"realValue");
        Intrinsics.checkNotNullParameter(sort, (String)"sort");
        T t = sort;
        if (Intrinsics.areEqual(t, (Object)$this$numericValue.getIntSort())) {
            if (!Intrinsics.areEqual((Object)realValue.getDenominator(), (Object)BigInteger.ONE)) {
                boolean $i$a$-check-ArithUtils$numericValue$22 = false;
                String $i$a$-check-ArithUtils$numericValue$22 = "Integer with denominator " + realValue.getDenominator();
                throw new IllegalStateException($i$a$-check-ArithUtils$numericValue$22.toString());
            }
            KIntNumExpr $this$uncheckedCast$iv = $this$numericValue.mkIntNum(realValue.getNumerator());
            boolean $i$f$uncheckedCast = false;
            kExpr = (KExpr)((Object)$this$uncheckedCast$iv);
        } else if (Intrinsics.areEqual(t, (Object)$this$numericValue.getRealSort())) {
            KRealNumExpr $this$uncheckedCast$iv = $this$numericValue.mkRealNum($this$numericValue.mkIntNum(realValue.getNumerator()), $this$numericValue.mkIntNum(realValue.getDenominator()));
            boolean $i$f$uncheckedCast = false;
            kExpr = (KExpr)((Object)$this$uncheckedCast$iv);
        } else {
            throw new IllegalStateException(("Unexpected arith sort: " + sort).toString());
        }
        return kExpr;
    }

    public final int compareTo(@NotNull KIntNumExpr $this$compareTo, @NotNull KIntNumExpr other) {
        Intrinsics.checkNotNullParameter((Object)$this$compareTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return $this$compareTo instanceof KInt32NumExpr && other instanceof KInt32NumExpr ? Intrinsics.compare((int)((KInt32NumExpr)$this$compareTo).getValue(), (int)((KInt32NumExpr)other).getValue()) : ($this$compareTo instanceof KInt32NumExpr && other instanceof KInt64NumExpr ? Intrinsics.compare((long)((KInt32NumExpr)$this$compareTo).getValue(), (long)((KInt64NumExpr)other).getValue()) : ($this$compareTo instanceof KInt64NumExpr && other instanceof KInt64NumExpr ? Intrinsics.compare((long)((KInt64NumExpr)$this$compareTo).getValue(), (long)((KInt64NumExpr)other).getValue()) : ($this$compareTo instanceof KInt64NumExpr && other instanceof KInt32NumExpr ? Intrinsics.compare((long)((KInt64NumExpr)$this$compareTo).getValue(), (long)((KInt32NumExpr)other).getValue()) : this.getBigIntegerValue($this$compareTo).compareTo(this.getBigIntegerValue(other)))));
    }

    @NotNull
    public final RealValue toRealValue(@NotNull KIntNumExpr $this$toRealValue) {
        Intrinsics.checkNotNullParameter((Object)$this$toRealValue, (String)"<this>");
        return RealValue.Companion.create$default(RealValue.Companion, this.getBigIntegerValue($this$toRealValue), null, 2, null);
    }

    @NotNull
    public final RealValue toRealValue(@NotNull KRealNumExpr $this$toRealValue) {
        Intrinsics.checkNotNullParameter((Object)$this$toRealValue, (String)"<this>");
        return RealValue.Companion.create(this.getBigIntegerValue($this$toRealValue.getNumerator()), this.getBigIntegerValue($this$toRealValue.getDenominator()));
    }

    @NotNull
    public final BigInteger getBigIntegerValue(@NotNull KIntNumExpr $this$bigIntegerValue) {
        Intrinsics.checkNotNullParameter((Object)$this$bigIntegerValue, (String)"<this>");
        KIntNumExpr kIntNumExpr = $this$bigIntegerValue;
        return kIntNumExpr instanceof KInt32NumExpr ? UtilsKt.toBigInteger(((KInt32NumExpr)$this$bigIntegerValue).getValue()) : (kIntNumExpr instanceof KInt64NumExpr ? UtilsKt.toBigInteger(((KInt64NumExpr)$this$bigIntegerValue).getValue()) : (kIntNumExpr instanceof KIntBigNumExpr ? ((KIntBigNumExpr)$this$bigIntegerValue).getValue() : new BigInteger($this$bigIntegerValue.getDecl().getValue())));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0010\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\"B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\t\u001a\u00020\u0000J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000J\u0011\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0000H\u0096\u0002J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u0000H\u0002J\u0013\u0010\u0012\u001a\u00020\u00112\b\u0010\u000b\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\u0006\u0010\u0014\u001a\u00020\u0003J\b\u0010\u0015\u001a\u00020\rH\u0016J\u0006\u0010\u0016\u001a\u00020\u0000J\u0006\u0010\u0017\u001a\u00020\u0011J\u0006\u0010\u0018\u001a\u00020\u0011J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0000H\u0002J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0003J\b\u0010\u001c\u001a\u00020\u0000H\u0002J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\rJ\r\u0010\u001f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010 J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006#"}, d2={"Lio/ksmt/utils/ArithUtils$RealValue;", "", "numerator", "Ljava/math/BigInteger;", "denominator", "(Ljava/math/BigInteger;Ljava/math/BigInteger;)V", "getDenominator", "()Ljava/math/BigInteger;", "getNumerator", "abs", "add", "other", "compareTo", "", "div", "value", "eq", "", "equals", "", "floor", "hashCode", "inverse", "isNegative", "isZero", "lt", "b", "mul", "normalize", "pow", "power", "smallIntValue", "()Ljava/lang/Integer;", "sub", "Companion", "ksmt-core"})
    public static final class RealValue
    implements Comparable<RealValue> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final BigInteger numerator;
        @NotNull
        private final BigInteger denominator;
        @NotNull
        private static final Lazy<RealValue> zero$delegate = LazyKt.lazy((Function0)Companion.zero.2.INSTANCE);
        @NotNull
        private static final Lazy<RealValue> one$delegate = LazyKt.lazy((Function0)Companion.one.2.INSTANCE);
        @NotNull
        private static final Lazy<RealValue> two$delegate = LazyKt.lazy((Function0)Companion.two.2.INSTANCE);
        @NotNull
        private static final Lazy<RealValue> minusOne$delegate = LazyKt.lazy((Function0)Companion.minusOne.2.INSTANCE);

        private RealValue(BigInteger numerator, BigInteger denominator) {
            if (denominator.signum() < 0) {
                BigInteger bigInteger = numerator.negate();
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"this.negate()");
                this.numerator = bigInteger;
                BigInteger bigInteger2 = denominator.negate();
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"this.negate()");
                this.denominator = bigInteger2;
            } else {
                this.numerator = numerator;
                this.denominator = denominator;
            }
        }

        @NotNull
        public final BigInteger getNumerator() {
            return this.numerator;
        }

        @NotNull
        public final BigInteger getDenominator() {
            return this.denominator;
        }

        public final boolean isNegative() {
            return this.numerator.signum() < 0;
        }

        public final boolean isZero() {
            return Intrinsics.areEqual((Object)this.numerator, (Object)BigInteger.ZERO);
        }

        @NotNull
        public final RealValue abs() {
            BigInteger bigInteger = this.numerator.abs();
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"numerator.abs()");
            return new RealValue(bigInteger, this.denominator);
        }

        @NotNull
        public final RealValue inverse() {
            return new RealValue(this.denominator, this.numerator);
        }

        @NotNull
        public final BigInteger floor() {
            if (Intrinsics.areEqual((Object)this.denominator, (Object)BigInteger.ONE)) {
                return this.numerator;
            }
            BigInteger result = this.numerator.divide(this.denominator);
            if (this.isNegative()) {
                BigInteger bigInteger = result;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"result--");
                BigInteger bigInteger2 = bigInteger.subtract(BigInteger.ONE);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"this.subtract(BigInteger.ONE)");
                result = bigInteger2;
            }
            BigInteger bigInteger = result;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"result");
            return bigInteger;
        }

        @NotNull
        public final RealValue div(@NotNull BigInteger value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            BigInteger bigInteger = this.denominator.multiply(value);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"this.multiply(other)");
            return new RealValue(this.numerator, bigInteger).normalize();
        }

        @NotNull
        public final RealValue mul(@NotNull BigInteger value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            BigInteger bigInteger = this.numerator.multiply(value);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"this.multiply(other)");
            return new RealValue(bigInteger, this.denominator).normalize();
        }

        @NotNull
        public final RealValue add(@NotNull RealValue other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            BigInteger bigInteger = this.numerator.multiply(other.denominator);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"this.multiply(other)");
            BigInteger bigInteger2 = other.numerator.multiply(this.denominator);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"this.multiply(other)");
            BigInteger bigInteger3 = bigInteger.add(bigInteger2);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"this.add(other)");
            BigInteger resultNumerator = bigInteger3;
            BigInteger bigInteger4 = this.denominator.multiply(other.denominator);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"this.multiply(other)");
            BigInteger resultDenominator = bigInteger4;
            return new RealValue(resultNumerator, resultDenominator).normalize();
        }

        @NotNull
        public final RealValue sub(@NotNull RealValue other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            BigInteger bigInteger = this.numerator.multiply(other.denominator);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"this.multiply(other)");
            BigInteger bigInteger2 = other.numerator.multiply(this.denominator);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"this.multiply(other)");
            BigInteger bigInteger3 = bigInteger.subtract(bigInteger2);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"this.subtract(other)");
            BigInteger resultNumerator = bigInteger3;
            BigInteger bigInteger4 = this.denominator.multiply(other.denominator);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"this.multiply(other)");
            BigInteger resultDenominator = bigInteger4;
            return new RealValue(resultNumerator, resultDenominator).normalize();
        }

        @NotNull
        public final RealValue mul(@NotNull RealValue other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            BigInteger bigInteger = this.numerator.multiply(other.numerator);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"this.multiply(other)");
            BigInteger bigInteger2 = this.denominator.multiply(other.denominator);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"this.multiply(other)");
            return new RealValue(bigInteger, bigInteger2).normalize();
        }

        @NotNull
        public final RealValue div(@NotNull RealValue other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            BigInteger bigInteger = this.numerator.multiply(other.denominator);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"this.multiply(other)");
            BigInteger bigInteger2 = this.denominator.multiply(other.numerator);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"this.multiply(other)");
            return new RealValue(bigInteger, bigInteger2).normalize();
        }

        @NotNull
        public final RealValue pow(int power) {
            BigInteger bigInteger = this.numerator.pow(power);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"numerator.pow(power)");
            BigInteger bigInteger2 = this.denominator.pow(power);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"denominator.pow(power)");
            return new RealValue(bigInteger, bigInteger2).normalize();
        }

        @Nullable
        public final Integer smallIntValue() {
            if (!Intrinsics.areEqual((Object)this.denominator, (Object)BigInteger.ONE)) {
                return null;
            }
            if (this.numerator.bitLength() >= 32) {
                return null;
            }
            return this.numerator.intValueExact();
        }

        @Override
        public int compareTo(@NotNull RealValue other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.eq(other) ? 0 : (this.lt(other) ? -1 : 1);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof RealValue && this.eq((RealValue)other);
        }

        public int hashCode() {
            return InternerUtilsKt.hash(this.numerator, this.denominator);
        }

        private final boolean eq(RealValue other) {
            return Intrinsics.areEqual((Object)this.numerator, (Object)other.numerator) && Intrinsics.areEqual((Object)this.denominator, (Object)other.denominator);
        }

        private final boolean lt(RealValue b) {
            boolean bl;
            if (this.numerator.signum() < 0 && b.numerator.signum() >= 0) {
                bl = true;
            } else if (this.numerator.signum() > 0 && b.numerator.signum() <= 0) {
                bl = false;
            } else if (this.numerator.signum() == 0) {
                bl = b.numerator.signum() > 0;
            } else {
                BigInteger bigInteger = this.numerator.multiply(b.denominator);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"this.multiply(other)");
                BigInteger bigInteger2 = b.numerator.multiply(this.denominator);
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"this.multiply(other)");
                bl = bigInteger.compareTo(bigInteger2) < 0;
            }
            return bl;
        }

        private final RealValue normalize() {
            if (Intrinsics.areEqual((Object)this.denominator, (Object)BigInteger.ONE) || Intrinsics.areEqual((Object)this.numerator, (Object)BigInteger.ONE)) {
                return this;
            }
            BigInteger gcd = this.numerator.gcd(this.denominator);
            if (Intrinsics.areEqual((Object)gcd, (Object)BigInteger.ONE)) {
                return this;
            }
            BigInteger normalizedNumerator = this.numerator.divide(gcd);
            BigInteger normalizedDenominator = this.denominator.divide(gcd);
            Intrinsics.checkNotNullExpressionValue((Object)normalizedNumerator, (String)"normalizedNumerator");
            Intrinsics.checkNotNullExpressionValue((Object)normalizedDenominator, (String)"normalizedDenominator");
            return new RealValue(normalizedNumerator, normalizedDenominator);
        }

        public /* synthetic */ RealValue(BigInteger numerator, BigInteger denominator, DefaultConstructorMarker $constructor_marker) {
            this(numerator, denominator);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0014R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\b\u001a\u0004\b\n\u0010\u0006R\u001b\u0010\f\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\b\u001a\u0004\b\r\u0010\u0006R\u001b\u0010\u000f\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\b\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lio/ksmt/utils/ArithUtils$RealValue$Companion;", "", "()V", "minusOne", "Lio/ksmt/utils/ArithUtils$RealValue;", "getMinusOne", "()Lio/ksmt/utils/ArithUtils$RealValue;", "minusOne$delegate", "Lkotlin/Lazy;", "one", "getOne", "one$delegate", "two", "getTwo", "two$delegate", "zero", "getZero", "zero$delegate", "create", "numerator", "Ljava/math/BigInteger;", "denominator", "ksmt-core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final RealValue create(@NotNull BigInteger numerator, @NotNull BigInteger denominator) {
                Intrinsics.checkNotNullParameter((Object)numerator, (String)"numerator");
                Intrinsics.checkNotNullParameter((Object)denominator, (String)"denominator");
                return new RealValue(numerator, denominator, null).normalize();
            }

            public static /* synthetic */ RealValue create$default(Companion companion, BigInteger bigInteger, BigInteger bigInteger2, int n, Object object) {
                if ((n & 2) != 0) {
                    BigInteger bigInteger3 = BigInteger.ONE;
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"ONE");
                    bigInteger2 = bigInteger3;
                }
                return companion.create(bigInteger, bigInteger2);
            }

            @NotNull
            public final RealValue getZero() {
                Lazy lazy = zero$delegate;
                return (RealValue)lazy.getValue();
            }

            @NotNull
            public final RealValue getOne() {
                Lazy lazy = one$delegate;
                return (RealValue)lazy.getValue();
            }

            @NotNull
            public final RealValue getTwo() {
                Lazy lazy = two$delegate;
                return (RealValue)lazy.getValue();
            }

            @NotNull
            public final RealValue getMinusOne() {
                Lazy lazy = minusOne$delegate;
                return (RealValue)lazy.getValue();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

