/*
 * Decompiled with CFR 0.152.
 */
package io.ksmt.utils;

import io.ksmt.sort.KFp32Sort;
import io.ksmt.sort.KFp64Sort;
import io.ksmt.sort.KFpSort;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001b\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001c\u001a&\u0010\u001d\u001a\u0002H\u001e\"\n\b\u0000\u0010\u001e\u0018\u0001*\u0002H\u001f\"\u0006\b\u0001\u0010\u001f\u0018\u0001*\u0002H\u001fH\u0086\b\u00a2\u0006\u0002\u0010 \u001a\n\u0010!\u001a\u00020\u0013*\u00020\b\u001a\u001a\u0010\"\u001a\u00020\u0013*\u00020\u00022\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0001\u001a\u001a\u0010\"\u001a\u00020\b*\u00020\u00052\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0001\u001a\u0012\u0010&\u001a\u00020\u0013*\u00020\u00022\u0006\u0010#\u001a\u00020$\u001a\u0012\u0010&\u001a\u00020\b*\u00020\u00052\u0006\u0010#\u001a\u00020$\u001a\u0012\u0010'\u001a\u00020\u0013*\u00020\u00022\u0006\u0010%\u001a\u00020\u0001\u001a\u0012\u0010'\u001a\u00020\b*\u00020\u00052\u0006\u0010%\u001a\u00020\u0001\u001a\u0012\u0010(\u001a\u00020\b*\u00020\u00052\u0006\u0010%\u001a\u00020\u0001\u001a\u001f\u0010)\u001a\u00020\u0018*\u00020\u00182\u0006\u0010*\u001a\u00020\u001a\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b+\u0010,\u001a\n\u0010-\u001a\u00020\u0018*\u00020.\u001a\u0012\u0010-\u001a\u00020\u0018*\u00020/2\u0006\u00100\u001a\u00020\b\u001a\u001f\u00101\u001a\u00020/*\u00020\u00182\u0006\u0010*\u001a\u00020\u001a\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b2\u00103\u001a\n\u00101\u001a\u00020/*\u00020.\u001a\u0012\u00104\u001a\u000205*\u00020.\u00f8\u0001\u0001\u00a2\u0006\u0002\u00106\u001a\n\u00107\u001a\u00020\u0018*\u00020.\u001a\u001e\u00108\u001a\u0002H\u001e\"\u0004\b\u0000\u0010\u001f\"\u0004\b\u0001\u0010\u001e*\u0002H\u001fH\u0086\b\u00a2\u0006\u0002\u0010 \"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\"\u001b\u0010\u0007\u001a\u00020\b*\u00020\u00058F\u00a2\u0006\f\u0012\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\f\"\u001b\u0010\r\u001a\u00020\b*\u00020\u00028F\u00a2\u0006\f\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\"\u001b\u0010\r\u001a\u00020\b*\u00020\u00058F\u00a2\u0006\f\u0012\u0004\b\u000e\u0010\n\u001a\u0004\b\u0010\u0010\f\"\u001b\u0010\u0012\u001a\u00020\u0013*\u00020\u00028F\u00a2\u0006\f\u0012\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0015\u0010\u0016\"\u001b\u0010\u0012\u001a\u00020\b*\u00020\u00058F\u00a2\u0006\f\u0012\u0004\b\u0014\u0010\n\u001a\u0004\b\u0015\u0010\f\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u00069"}, d2={"booleanSignBit", "", "", "getBooleanSignBit", "(D)Z", "", "(F)Z", "halfPrecisionSignificand", "", "getHalfPrecisionSignificand$annotations", "(F)V", "getHalfPrecisionSignificand", "(F)I", "signBit", "getSignBit$annotations", "(D)V", "getSignBit", "(D)I", "significand", "", "getSignificand$annotations", "getSignificand", "(D)J", "powerOfTwo", "Ljava/math/BigInteger;", "power", "Lkotlin/UInt;", "powerOfTwo-WZ4Q5Ns", "(I)Ljava/math/BigInteger;", "cast", "T", "Base", "(Ljava/lang/Object;)Ljava/lang/Object;", "extendWithLeadingZeros", "extractExponent", "sort", "Lio/ksmt/sort/KFpSort;", "isBiased", "extractSignificand", "getExponent", "getHalfPrecisionExponent", "normalizeValue", "size", "normalizeValue-Qn1smSk", "(Ljava/math/BigInteger;I)Ljava/math/BigInteger;", "toBigInteger", "", "", "radix", "toBinary", "toBinary-Qn1smSk", "(Ljava/math/BigInteger;I)Ljava/lang/String;", "toULongValue", "Lkotlin/ULong;", "(Ljava/lang/Number;)J", "toUnsignedBigInteger", "uncheckedCast", "ksmt-core"})
public final class UtilsKt {
    @NotNull
    public static final String toBinary(@NotNull Number $this$toBinary) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$toBinary, (String)"<this>");
        Number number = $this$toBinary;
        if (number instanceof Byte) {
            string = StringsKt.padStart((String)UStringsKt.toString-LxnNnR4((byte)UByte.constructor-impl((byte)$this$toBinary.byteValue()), (int)2), (int)8, (char)'0');
        } else if (number instanceof Short) {
            string = StringsKt.padStart((String)UStringsKt.toString-olVBNx4((short)UShort.constructor-impl((short)$this$toBinary.shortValue()), (int)2), (int)16, (char)'0');
        } else if (number instanceof Integer) {
            string = StringsKt.padStart((String)UStringsKt.toString-V7xB4Y4((int)UInt.constructor-impl((int)$this$toBinary.intValue()), (int)2), (int)32, (char)'0');
        } else if (number instanceof Long) {
            string = StringsKt.padStart((String)UStringsKt.toString-JSWoG40((long)ULong.constructor-impl((long)$this$toBinary.longValue()), (int)2), (int)64, (char)'0');
        } else if (number instanceof Float) {
            string = UtilsKt.toBinary(Float.floatToRawIntBits($this$toBinary.floatValue()));
        } else if (number instanceof Double) {
            string = UtilsKt.toBinary(Double.doubleToRawLongBits($this$toBinary.doubleValue()));
        } else {
            throw new IllegalStateException(("Unsupported type for transformation into a binary string: " + Reflection.getOrCreateKotlinClass($this$toBinary.getClass()).getSimpleName()).toString());
        }
        return string;
    }

    public static final long toULongValue(@NotNull Number $this$toULongValue) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$toULongValue, (String)"<this>");
        Number number = $this$toULongValue;
        if (number instanceof Byte) {
            l = ULong.constructor-impl((long)((long)UByte.constructor-impl((byte)$this$toULongValue.byteValue()) & 0xFFL));
        } else if (number instanceof Short) {
            l = ULong.constructor-impl((long)((long)UShort.constructor-impl((short)$this$toULongValue.shortValue()) & 0xFFFFL));
        } else if (number instanceof Integer) {
            l = ULong.constructor-impl((long)((long)UInt.constructor-impl((int)$this$toULongValue.intValue()) & 0xFFFFFFFFL));
        } else if (number instanceof Long) {
            l = ULong.constructor-impl((long)$this$toULongValue.longValue());
        } else {
            throw new IllegalStateException(("Unsupported type for transformation into a ULong: " + Reflection.getOrCreateKotlinClass($this$toULongValue.getClass()).getSimpleName()).toString());
        }
        return l;
    }

    @NotNull
    public static final BigInteger toBigInteger(@NotNull Number $this$toBigInteger) {
        BigInteger bigInteger;
        Intrinsics.checkNotNullParameter((Object)$this$toBigInteger, (String)"<this>");
        if ($this$toBigInteger instanceof BigInteger) {
            bigInteger = (BigInteger)$this$toBigInteger;
        } else {
            BigInteger bigInteger2 = BigInteger.valueOf($this$toBigInteger.longValue());
            bigInteger = bigInteger2;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"valueOf(toLong())");
        }
        return bigInteger;
    }

    @NotNull
    public static final BigInteger toUnsignedBigInteger(@NotNull Number $this$toUnsignedBigInteger) {
        Intrinsics.checkNotNullParameter((Object)$this$toUnsignedBigInteger, (String)"<this>");
        return UtilsKt.toBigInteger(UtilsKt.toULongValue($this$toUnsignedBigInteger));
    }

    @NotNull
    public static final BigInteger powerOfTwo-WZ4Q5Ns(int power) {
        BigInteger bigInteger = BigInteger.ONE.shiftLeft(power);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"ONE.shiftLeft(power.toInt())");
        return bigInteger;
    }

    @NotNull
    public static final BigInteger normalizeValue-Qn1smSk(@NotNull BigInteger $this$normalizeValue_u2dQn1smSk, int size) {
        Intrinsics.checkNotNullParameter((Object)$this$normalizeValue_u2dQn1smSk, (String)"$this$normalizeValue");
        BigInteger bigInteger = $this$normalizeValue_u2dQn1smSk.mod(UtilsKt.powerOfTwo-WZ4Q5Ns(size));
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"this.mod(powerOfTwo(size))");
        return bigInteger;
    }

    @NotNull
    public static final String toBinary-Qn1smSk(@NotNull BigInteger $this$toBinary_u2dQn1smSk, int size) {
        Intrinsics.checkNotNullParameter((Object)$this$toBinary_u2dQn1smSk, (String)"$this$toBinary");
        String string = $this$toBinary_u2dQn1smSk.toString(2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(2)");
        return StringsKt.padStart((String)string, (int)size, (char)'0');
    }

    @NotNull
    public static final BigInteger toBigInteger(@NotNull String $this$toBigInteger, int radix) {
        Intrinsics.checkNotNullParameter((Object)$this$toBigInteger, (String)"<this>");
        return new BigInteger($this$toBigInteger, radix);
    }

    public static final int getHalfPrecisionSignificand(float $this$halfPrecisionSignificand) {
        return (Float.floatToRawIntBits($this$halfPrecisionSignificand) & 0x7FE000) >> 13;
    }

    public static /* synthetic */ void getHalfPrecisionSignificand$annotations(float f) {
    }

    public static final int getHalfPrecisionExponent(float $this$getHalfPrecisionExponent, boolean isBiased) {
        int biasedFloatExponent = UtilsKt.getExponent($this$getHalfPrecisionExponent, true);
        int fp16ExponentSign = (biasedFloatExponent & 0x80) >> 3;
        int fp16ExponentOtherBits = biasedFloatExponent & 0xF;
        int biasedFloat16Exponent = fp16ExponentSign | fp16ExponentOtherBits;
        return isBiased ? biasedFloat16Exponent : biasedFloat16Exponent - 15;
    }

    public static final int getSignificand(float $this$significand) {
        return Float.floatToRawIntBits($this$significand) & 0x7FFFFF;
    }

    public static /* synthetic */ void getSignificand$annotations(float f) {
    }

    public static final int getExponent(float $this$getExponent, boolean isBiased) {
        int exponent = (Float.floatToRawIntBits($this$getExponent) & 0x7F800000) >>> 23;
        return isBiased ? exponent : exponent - 127;
    }

    public static final int getSignBit(float $this$signBit) {
        return Float.floatToRawIntBits($this$signBit) >> 31 & 1;
    }

    public static /* synthetic */ void getSignBit$annotations(float f) {
    }

    public static final boolean getBooleanSignBit(float $this$booleanSignBit) {
        return UtilsKt.getSignBit($this$booleanSignBit) == 1;
    }

    public static final long getSignificand(double $this$significand) {
        return Double.doubleToRawLongBits($this$significand) & 0xFFFFFFFFFFFFFL;
    }

    public static /* synthetic */ void getSignificand$annotations(double d) {
    }

    public static final long getExponent(double $this$getExponent, boolean isBiased) {
        long exponent = (Double.doubleToRawLongBits($this$getExponent) & 0x7FF0000000000000L) >>> 52;
        return isBiased ? exponent : exponent - (long)1023;
    }

    public static final int getSignBit(double $this$signBit) {
        return (int)(Double.doubleToRawLongBits($this$signBit) >> 63) & 1;
    }

    public static /* synthetic */ void getSignBit$annotations(double d) {
    }

    public static final boolean getBooleanSignBit(double $this$booleanSignBit) {
        return UtilsKt.getSignBit($this$booleanSignBit) == 1;
    }

    public static final int extractSignificand(float $this$extractSignificand, @NotNull KFpSort sort) {
        Intrinsics.checkNotNullParameter((Object)sort, (String)"sort");
        int sizeBits = sort.getSignificandBits-pVg5ArA();
        int fp32SignificandBits = KFp32Sort.Companion.getSignificandBits-pVg5ArA();
        int significandMask = sizeBits >= fp32SignificandBits ? -1 : (1 << sizeBits - 1) - 1;
        int shiftForSortSpecificSignificandBits = Math.max(0, fp32SignificandBits - sizeBits);
        return Float.floatToRawIntBits($this$extractSignificand) >> shiftForSortSpecificSignificandBits & significandMask;
    }

    public static final long extendWithLeadingZeros(int $this$extendWithLeadingZeros) {
        long it = $this$extendWithLeadingZeros;
        boolean bl = false;
        return ((it >> 63 & 1L) << 31 | it) & 0xFFFFFFFFL;
    }

    public static final int extractExponent(float $this$extractExponent, @NotNull KFpSort sort, boolean isBiased) {
        Intrinsics.checkNotNullParameter((Object)sort, (String)"sort");
        int exponent = UtilsKt.getExponent($this$extractExponent, false);
        int maxUnbiasedExponentValue = 1 << sort.getExponentBits-pVg5ArA() - 1;
        int minUnbiasedExponentValue = -(maxUnbiasedExponentValue - 1);
        int constructedExponent = exponent <= minUnbiasedExponentValue ? minUnbiasedExponentValue : (exponent >= maxUnbiasedExponentValue ? maxUnbiasedExponentValue : exponent);
        return isBiased ? constructedExponent + sort.exponentShiftSize() : constructedExponent;
    }

    public static final long extractSignificand(double $this$extractSignificand, @NotNull KFpSort sort) {
        Intrinsics.checkNotNullParameter((Object)sort, (String)"sort");
        int significandBits = sort.getSignificandBits-pVg5ArA();
        int fp64Bits = KFp64Sort.Companion.getSignificandBits-pVg5ArA();
        long significandMask = significandBits >= fp64Bits ? -1L : (1L << significandBits - 1) - 1L;
        int shiftForSortSpecificSignificandBits = Math.max(0, 53 - significandBits);
        return Double.doubleToRawLongBits($this$extractSignificand) >> shiftForSortSpecificSignificandBits & significandMask;
    }

    public static final long extractExponent(double $this$extractExponent, @NotNull KFpSort sort, boolean isBiased) {
        Intrinsics.checkNotNullParameter((Object)sort, (String)"sort");
        long exponent = UtilsKt.getExponent($this$extractExponent, false);
        long sign = exponent >> 10 & 1L;
        long exponentBits = exponent & (1L << sort.getExponentBits-pVg5ArA() - 1) - 1L;
        long constructedExponent = sign << sort.getExponentBits-pVg5ArA() - 1 | exponentBits;
        return isBiased ? constructedExponent + (long)sort.exponentShiftSize() : constructedExponent;
    }

    public static final /* synthetic */ <T extends Base, Base> T cast(Base $this$cast) {
        boolean $i$f$cast = false;
        Intrinsics.reifiedOperationMarker((int)1, (String)"T");
        return (T)$this$cast;
    }

    public static final <Base, T> T uncheckedCast(Base $this$uncheckedCast) {
        boolean $i$f$uncheckedCast = false;
        return (T)$this$uncheckedCast;
    }
}

