/*
 * Decompiled with CFR 0.152.
 */
package io.ksmt.utils.library;

import io.ksmt.utils.library.NativeLibraryLoader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001!B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u0015\u0010\u0011\u001a\u00020\u0012\"\n\b\u0000\u0010\u0013\u0018\u0001*\u00020\u0014H\u0086\bJ\u001c\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0018J\"\u0010\u0019\u001a\u00020\u00122\u0017\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00120\u001b\u00a2\u0006\u0002\b\u001dH\u0082\bJ\u0014\u0010\u001e\u001a\u00020\u0004*\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u0004H\u0002J\u0014\u0010 \u001a\u00020\u0004*\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\""}, d2={"Lio/ksmt/utils/library/NativeLibraryLoaderUtils;", "", "()V", "ARM_ARCH_NAME", "", "LINUX_OS_NAME", "MAC_OS_NAME", "STALED_DIRECTORY_SUFFIX", "WINDOWS_OS_NAME", "X64_ARCH_NAME", "supportedArchs", "", "getSupportedArchs", "()Ljava/util/Set;", "findResource", "Ljava/net/URL;", "resourceName", "load", "", "Loader", "Lio/ksmt/utils/library/NativeLibraryLoader;", "loadLibrariesFromResources", "loader", "libraries", "", "withLibraryUnpacker", "body", "Lkotlin/Function1;", "Lio/ksmt/utils/library/NativeLibraryLoaderUtils$TmpDirLibraryUnpacker;", "Lkotlin/ExtensionFunctionType;", "osSpecificLibraryName", "libName", "resolveLibraryResourceName", "TmpDirLibraryUnpacker", "ksmt-core"})
public final class NativeLibraryLoaderUtils {
    @NotNull
    public static final NativeLibraryLoaderUtils INSTANCE = new NativeLibraryLoaderUtils();
    @NotNull
    public static final String LINUX_OS_NAME = "Linux";
    @NotNull
    public static final String WINDOWS_OS_NAME = "Windows";
    @NotNull
    public static final String MAC_OS_NAME = "Mac";
    @NotNull
    public static final String X64_ARCH_NAME = "X64";
    @NotNull
    public static final String ARM_ARCH_NAME = "Arm";
    @NotNull
    private static final Set<String> supportedArchs;
    @NotNull
    private static final String STALED_DIRECTORY_SUFFIX = ".ksmt-staled";

    private NativeLibraryLoaderUtils() {
    }

    @NotNull
    public final Set<String> getSupportedArchs() {
        return supportedArchs;
    }

    public final /* synthetic */ <Loader extends NativeLibraryLoader> void load() {
        Class<?> clazz;
        String string;
        boolean $i$f$load = false;
        String string2 = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(\"os.name\")");
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String osName = string3;
        if (StringsKt.startsWith$default((String)osName, (String)"linux", (boolean)false, (int)2, null)) {
            string = LINUX_OS_NAME;
        } else if (StringsKt.startsWith$default((String)osName, (String)"windows", (boolean)false, (int)2, null)) {
            string = WINDOWS_OS_NAME;
        } else if (StringsKt.startsWith$default((String)osName, (String)"mac", (boolean)false, (int)2, null)) {
            string = MAC_OS_NAME;
        } else {
            throw new IllegalStateException(("Unknown OS: " + osName).toString());
        }
        String resolvedOsName = string;
        String arch = System.getProperty("os.arch");
        if (!this.getSupportedArchs().contains(arch)) {
            boolean $i$a$-require-NativeLibraryLoaderUtils$load$22 = false;
            String $i$a$-require-NativeLibraryLoaderUtils$load$22 = "Not supported arch: " + arch;
            throw new IllegalArgumentException($i$a$-require-NativeLibraryLoaderUtils$load$22.toString());
        }
        String resolvedArchName = Intrinsics.areEqual((Object)arch, (Object)"aarch64") ? ARM_ARCH_NAME : X64_ARCH_NAME;
        StringBuilder stringBuilder = new StringBuilder();
        Intrinsics.reifiedOperationMarker((int)4, (String)"Loader");
        String resolvedLoaderClassName = stringBuilder.append(NativeLibraryLoader.class.getName()).append(resolvedOsName).append(resolvedArchName).toString();
        try {
            clazz = Class.forName(resolvedLoaderClassName);
        }
        catch (Throwable ex) {
            StringBuilder stringBuilder2 = new StringBuilder().append("No loader found for ");
            Intrinsics.reifiedOperationMarker((int)4, (String)"Loader");
            throw new IllegalStateException(stringBuilder2.append(NativeLibraryLoader.class.getName()).append(" OS: ").append(resolvedOsName).append(" Arch: ").append(resolvedArchName).toString().toString());
        }
        Class<?> resolvedLoaderClass = clazz;
        Object obj = resolvedLoaderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Intrinsics.reifiedOperationMarker((int)1, (String)"Loader");
        NativeLibraryLoader loader = (NativeLibraryLoader)obj;
        loader.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadLibrariesFromResources(@NotNull NativeLibraryLoader loader, @NotNull List<String> libraries) {
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        Intrinsics.checkNotNullParameter(libraries, (String)"libraries");
        NativeLibraryLoaderUtils this_$iv = this;
        boolean $i$f$withLibraryUnpacker = false;
        TmpDirLibraryUnpacker unpacker$iv = new TmpDirLibraryUnpacker();
        try {
            TmpDirLibraryUnpacker $this$loadLibrariesFromResources_u24lambda_u242 = unpacker$iv;
            boolean bl = false;
            for (String libName : libraries) {
                Path path;
                URL libraryResource;
                String osLibName = INSTANCE.osSpecificLibraryName(loader, libName);
                String resourceName = INSTANCE.resolveLibraryResourceName(loader, libName);
                if (INSTANCE.findResource(resourceName) == null) {
                    throw new IllegalStateException(("Can't find native library " + osLibName).toString());
                }
                URI libUri = libraryResource.toURI();
                if (Intrinsics.areEqual((Object)libUri.getScheme(), (Object)"file")) {
                    System.load(libUri.getPath());
                    continue;
                }
                Closeable closeable = libraryResource.openStream();
                Throwable throwable = null;
                try {
                    InputStream libResourceStream = (InputStream)closeable;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)libResourceStream, (String)"libResourceStream");
                    path = $this$loadLibrariesFromResources_u24lambda_u242.unpackLibrary(osLibName, libResourceStream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                Path libFile = path;
                System.load(((Object)libFile.toAbsolutePath()).toString());
            }
        }
        finally {
            unpacker$iv.cleanup();
        }
    }

    private final String osSpecificLibraryName(NativeLibraryLoader $this$osSpecificLibraryName, String libName) {
        return libName + $this$osSpecificLibraryName.getOsLibraryExt();
    }

    private final String resolveLibraryResourceName(NativeLibraryLoader $this$resolveLibraryResourceName, String libName) {
        StringBuilder stringBuilder = new StringBuilder().append("lib/");
        String string = $this$resolveLibraryResourceName.getOsName().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        StringBuilder stringBuilder2 = stringBuilder.append(string).append('/');
        String string2 = $this$resolveLibraryResourceName.getArchName().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append('/');
        String string3 = $this$resolveLibraryResourceName.getLibraryDir().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        return stringBuilder3.append(string3).append('/').append(this.osSpecificLibraryName($this$resolveLibraryResourceName, libName)).toString();
    }

    private final URL findResource(String resourceName) {
        return NativeLibraryLoaderUtils.class.getClassLoader().getResource(resourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void withLibraryUnpacker(Function1<? super TmpDirLibraryUnpacker, Unit> body) {
        boolean $i$f$withLibraryUnpacker = false;
        TmpDirLibraryUnpacker unpacker = new TmpDirLibraryUnpacker();
        try {
            body.invoke((Object)unpacker);
        }
        finally {
            InlineMarker.finallyStart((int)1);
            unpacker.cleanup();
            InlineMarker.finallyEnd((int)1);
        }
    }

    static {
        Object[] objectArray = new String[]{"amd64", "x86_64", "aarch64"};
        supportedArchs = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\u0004H\u0002J\b\u0010\r\u001a\u00020\u0004H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u0016\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0017\u0010\u0016\u001a\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0018H\u0082\bJ\f\u0010\u0019\u001a\u00020\u000f*\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/ksmt/utils/library/NativeLibraryLoaderUtils$TmpDirLibraryUnpacker;", "", "()V", "libUnpackDirectory", "Ljava/nio/file/Path;", "tmpDirectoryRoot", "unpackedFiles", "", "unpackedLibrariesRoot", "cleanup", "", "cleanupStaledDirectories", "skipMarker", "markUnpackDirectoryAsStaled", "tryDeleteStaledDirectory", "", "directory", "unpackLibrary", "name", "", "libraryData", "Ljava/io/InputStream;", "withNoFileExceptions", "block", "Lkotlin/Function0;", "safeDeleteFile", "ksmt-core"})
    private static final class TmpDirLibraryUnpacker {
        @NotNull
        private final Path tmpDirectoryRoot;
        @NotNull
        private final Path unpackedLibrariesRoot;
        @NotNull
        private final Path libUnpackDirectory;
        @NotNull
        private final List<Path> unpackedFiles;

        /*
         * WARNING - void declaration
         */
        public TmpDirLibraryUnpacker() {
            void $this$unpackedLibrariesRoot_u24lambda_u240;
            Path path;
            String string = System.getProperty("java.io.tmpdir", ".");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"java.io.tmpdir\", \".\")");
            Path path2 = Paths.get(string, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(path)");
            this.tmpDirectoryRoot = path2;
            Path path3 = this.tmpDirectoryRoot.resolve("ksmt-unpacked-libraries");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"this.resolve(other)");
            Path path4 = path = path3;
            TmpDirLibraryUnpacker tmpDirLibraryUnpacker = this;
            boolean bl = false;
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)$this$unpackedLibrariesRoot_u24lambda_u240, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(this, *attributes)");
            tmpDirLibraryUnpacker.unpackedLibrariesRoot = path;
            this.libUnpackDirectory = PathsKt.createTempDirectory((Path)this.unpackedLibrariesRoot, (String)"ksmt", (FileAttribute[])new FileAttribute[0]);
            this.unpackedFiles = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Path unpackLibrary(@NotNull String name, @NotNull InputStream libraryData) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)libraryData, (String)"libraryData");
            Path path = this.libUnpackDirectory.resolve(name);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.resolve(other)");
            Object object = path;
            Path it = object;
            boolean bl = false;
            this.unpackedFiles.add(it);
            Path libFile = object;
            OpenOption[] openOptionArray = new OpenOption[]{};
            OutputStream outputStream = Files.newOutputStream(libFile, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(this, *options)");
            object = outputStream;
            Throwable throwable = null;
            try {
                OutputStream it2 = (OutputStream)object;
                boolean bl2 = false;
                long l = ByteStreamsKt.copyTo$default((InputStream)libraryData, (OutputStream)it2, (int)0, (int)2, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            return libFile;
        }

        /*
         * WARNING - void declaration
         */
        public final void cleanup() {
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = this.unpackedFiles;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Path it = (Path)element$iv$iv;
                boolean bl = false;
                if (this.safeDeleteFile(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List notDeletedFiles = (List)destination$iv$iv;
            Path staledDirMarker = null;
            if (!((Collection)notDeletedFiles).isEmpty() || !this.safeDeleteFile(this.libUnpackDirectory)) {
                staledDirMarker = this.markUnpackDirectoryAsStaled();
            }
            this.cleanupStaledDirectories(staledDirMarker);
        }

        private final Path markUnpackDirectoryAsStaled() {
            String markerName = this.libUnpackDirectory.getFileName() + NativeLibraryLoaderUtils.STALED_DIRECTORY_SUFFIX;
            Path markerFile = this.libUnpackDirectory.resolveSibling(markerName);
            Intrinsics.checkNotNullExpressionValue((Object)markerFile, (String)"markerFile");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(markerFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(markerFile, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createFile(this, *attributes)");
            }
            return markerFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void cleanupStaledDirectories(Path skipMarker) {
            Path path = this.unpackedLibrariesRoot;
            Closeable closeable = Files.newDirectoryStream(path, "*.ksmt-staled");
            Throwable throwable = null;
            try {
                DirectoryStream directoryStream = (DirectoryStream)closeable;
                Intrinsics.checkNotNullExpressionValue((Object)directoryStream, (String)"it");
                Iterable iterable = directoryStream;
                for (Path marker : iterable) {
                    boolean bl;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)marker, (Object)skipMarker)) continue;
                    String staledDirectoryName = StringsKt.removeSuffix((String)((Object)marker.getFileName()).toString(), (CharSequence)NativeLibraryLoaderUtils.STALED_DIRECTORY_SUFFIX);
                    Path staledDirectory = marker.resolveSibling(staledDirectoryName);
                    Intrinsics.checkNotNullExpressionValue((Object)staledDirectory, (String)"staledDirectory");
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (!Files.notExists(staledDirectory, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && !this.tryDeleteStaledDirectory(staledDirectory)) continue;
                    TmpDirLibraryUnpacker this_$iv = this;
                    boolean $i$f$withNoFileExceptions = false;
                    try {
                        boolean bl3 = false;
                        bl = Files.deleteIfExists(marker);
                    }
                    catch (SecurityException ex$iv) {
                        bl = false;
                    }
                    catch (IOException ex$iv) {
                        bl = false;
                    }
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean tryDeleteStaledDirectory(Path directory) {
            boolean bl;
            TmpDirLibraryUnpacker this_$iv = this;
            boolean $i$f$withNoFileExceptions = false;
            try {
                boolean bl2 = false;
                Path path = directory;
                Closeable closeable = Files.newDirectoryStream(path, "*");
                Throwable throwable = null;
                try {
                    DirectoryStream directoryStream = (DirectoryStream)closeable;
                    Intrinsics.checkNotNullExpressionValue((Object)directoryStream, (String)"it");
                    Iterable iterable = directoryStream;
                    for (Path it : iterable) {
                        boolean bl3 = false;
                        if (this.safeDeleteFile(it)) continue;
                        boolean bl4 = false;
                        return bl4;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return this.safeDeleteFile(directory);
            }
            catch (SecurityException ex$iv) {
                bl = false;
            }
            catch (IOException ex$iv) {
                bl = false;
            }
            return bl;
        }

        private final boolean safeDeleteFile(Path $this$safeDeleteFile) {
            boolean bl;
            TmpDirLibraryUnpacker this_$iv = this;
            boolean $i$f$withNoFileExceptions = false;
            try {
                boolean bl2 = false;
                bl = $this$safeDeleteFile.toFile().delete();
            }
            catch (SecurityException ex$iv) {
                bl = false;
            }
            catch (IOException ex$iv) {
                bl = false;
            }
            return bl;
        }

        private final boolean withNoFileExceptions(Function0<Boolean> block) {
            boolean bl;
            boolean $i$f$withNoFileExceptions = false;
            try {
                bl = (Boolean)block.invoke();
            }
            catch (SecurityException ex) {
                bl = false;
            }
            catch (IOException ex) {
                bl = false;
            }
            return bl;
        }
    }
}

