/*
 * Decompiled with CFR 0.152.
 */
package io.github.cvc5;

import io.github.cvc5.CVC5ApiException;
import java.util.HashMap;
import java.util.Map;

public enum RoundingMode {
    ROUND_NEAREST_TIES_TO_EVEN(0),
    ROUND_TOWARD_POSITIVE(1),
    ROUND_TOWARD_NEGATIVE(2),
    ROUND_TOWARD_ZERO(3),
    ROUND_NEAREST_TIES_TO_AWAY(4);

    private int value;
    private static int minValue;
    private static int maxValue;
    private static Map<Integer, RoundingMode> enumMap;

    private RoundingMode(int n2) {
        this.value = n2;
    }

    public static RoundingMode fromInt(int n) throws CVC5ApiException {
        if (n < minValue || n > maxValue) {
            throw new CVC5ApiException("RoundingMode value " + n + " is outside the valid range [" + minValue + "," + maxValue + "]");
        }
        return enumMap.get(n);
    }

    public int getValue() {
        return this.value;
    }

    static {
        minValue = 0;
        maxValue = 0;
        enumMap = new HashMap<Integer, RoundingMode>();
        boolean bl = true;
        for (RoundingMode roundingMode : RoundingMode.values()) {
            int n = roundingMode.getValue();
            if (bl) {
                minValue = n;
                maxValue = n;
                bl = false;
            }
            minValue = Math.min(minValue, n);
            maxValue = Math.max(maxValue, n);
            enumMap.put(n, roundingMode);
        }
    }
}

