/*
 * Decompiled with CFR 0.152.
 */
package io.github.cvc5;

import io.github.cvc5.CVC5ApiException;
import java.util.HashMap;
import java.util.Map;

public enum SkolemId {
    INTERNAL(0),
    PURIFY(1),
    GROUND_TERM(2),
    ARRAY_DEQ_DIFF(3),
    DIV_BY_ZERO(4),
    INT_DIV_BY_ZERO(5),
    MOD_BY_ZERO(6),
    TRANSCENDENTAL_PURIFY(7),
    TRANSCENDENTAL_PURIFY_ARG(8),
    SHARED_SELECTOR(9),
    QUANTIFIERS_SKOLEMIZE(10),
    STRINGS_NUM_OCCUR(11),
    STRINGS_OCCUR_INDEX(12),
    STRINGS_NUM_OCCUR_RE(13),
    STRINGS_OCCUR_INDEX_RE(14),
    STRINGS_OCCUR_LEN_RE(15),
    STRINGS_DEQ_DIFF(16),
    STRINGS_REPLACE_ALL_RESULT(17),
    STRINGS_ITOS_RESULT(18),
    STRINGS_STOI_RESULT(19),
    STRINGS_STOI_NON_DIGIT(20),
    RE_FIRST_MATCH_PRE(21),
    RE_FIRST_MATCH(22),
    RE_FIRST_MATCH_POST(23),
    RE_UNFOLD_POS_COMPONENT(24),
    BAGS_CARD_COMBINE(25),
    BAGS_DISTINCT_ELEMENTS_UNION_DISJOINT(26),
    BAGS_FOLD_CARD(27),
    BAGS_FOLD_COMBINE(28),
    BAGS_FOLD_ELEMENTS(29),
    BAGS_FOLD_UNION_DISJOINT(30),
    BAGS_CHOOSE(31),
    BAGS_DISTINCT_ELEMENTS(32),
    BAGS_DISTINCT_ELEMENTS_SIZE(33),
    BAGS_MAP_PREIMAGE_INJECTIVE(34),
    BAGS_MAP_INDEX(35),
    BAGS_MAP_SUM(36),
    BAGS_DEQ_DIFF(37),
    TABLES_GROUP_PART(38),
    TABLES_GROUP_PART_ELEMENT(39),
    RELATIONS_GROUP_PART(40),
    RELATIONS_GROUP_PART_ELEMENT(41),
    SETS_CHOOSE(42),
    SETS_DEQ_DIFF(43),
    SETS_FOLD_CARD(44),
    SETS_FOLD_COMBINE(45),
    SETS_FOLD_ELEMENTS(46),
    SETS_FOLD_UNION(47),
    SETS_MAP_DOWN_ELEMENT(48),
    FP_MIN_ZERO(49),
    FP_MAX_ZERO(50),
    FP_TO_UBV(51),
    FP_TO_SBV(52),
    FP_TO_REAL(53),
    NONE(54);

    private int value;
    private static int minValue;
    private static int maxValue;
    private static Map<Integer, SkolemId> enumMap;

    private SkolemId(int n2) {
        this.value = n2;
    }

    public static SkolemId fromInt(int n) throws CVC5ApiException {
        if (n < minValue || n > maxValue) {
            throw new CVC5ApiException("SkolemId value " + n + " is outside the valid range [" + minValue + "," + maxValue + "]");
        }
        return enumMap.get(n);
    }

    public int getValue() {
        return this.value;
    }

    static {
        minValue = 0;
        maxValue = 0;
        enumMap = new HashMap<Integer, SkolemId>();
        boolean bl = true;
        for (SkolemId skolemId : SkolemId.values()) {
            int n = skolemId.getValue();
            if (bl) {
                minValue = n;
                maxValue = n;
                bl = false;
            }
            minValue = Math.min(minValue, n);
            maxValue = Math.max(maxValue, n);
            enumMap.put(n, skolemId);
        }
    }
}

