/*
 * Decompiled with CFR 0.152.
 */
package io.github.cvc5.modes;

import io.github.cvc5.CVC5ApiException;
import java.util.HashMap;
import java.util.Map;

public enum ProofComponent {
    RAW_PREPROCESS(0),
    PREPROCESS(1),
    SAT(2),
    THEORY_LEMMAS(3),
    FULL(4);

    private int value;
    private static int minValue;
    private static int maxValue;
    private static Map<Integer, ProofComponent> enumMap;

    private ProofComponent(int n2) {
        this.value = n2;
    }

    public static ProofComponent fromInt(int n) throws CVC5ApiException {
        if (n < minValue || n > maxValue) {
            throw new CVC5ApiException("ProofComponent value " + n + " is outside the valid range [" + minValue + "," + maxValue + "]");
        }
        return enumMap.get(n);
    }

    public int getValue() {
        return this.value;
    }

    static {
        minValue = 0;
        maxValue = 0;
        enumMap = new HashMap<Integer, ProofComponent>();
        boolean bl = true;
        for (ProofComponent proofComponent : ProofComponent.values()) {
            int n = proofComponent.getValue();
            if (bl) {
                minValue = n;
                maxValue = n;
                bl = false;
            }
            minValue = Math.min(minValue, n);
            maxValue = Math.max(maxValue, n);
            enumMap.put(n, proofComponent);
        }
    }
}

