/*
 * Decompiled with CFR 0.152.
 */
package io.github.cvc5.modes;

import io.github.cvc5.CVC5ApiException;
import java.util.HashMap;
import java.util.Map;

public enum ProofFormat {
    NONE(0),
    DOT(1),
    LFSC(2),
    ALETHE(3),
    ALF(4),
    DEFAULT(5);

    private int value;
    private static int minValue;
    private static int maxValue;
    private static Map<Integer, ProofFormat> enumMap;

    private ProofFormat(int n2) {
        this.value = n2;
    }

    public static ProofFormat fromInt(int n) throws CVC5ApiException {
        if (n < minValue || n > maxValue) {
            throw new CVC5ApiException("ProofFormat value " + n + " is outside the valid range [" + minValue + "," + maxValue + "]");
        }
        return enumMap.get(n);
    }

    public int getValue() {
        return this.value;
    }

    static {
        minValue = 0;
        maxValue = 0;
        enumMap = new HashMap<Integer, ProofFormat>();
        boolean bl = true;
        for (ProofFormat proofFormat : ProofFormat.values()) {
            int n = proofFormat.getValue();
            if (bl) {
                minValue = n;
                maxValue = n;
                bl = false;
            }
            minValue = Math.min(minValue, n);
            maxValue = Math.max(maxValue, n);
            enumMap.put(n, proofFormat);
        }
    }
}

