/*
 * Decompiled with CFR 0.152.
 */
package io.ksmt.runner.core.process;

import io.ksmt.runner.core.process.ProcessWrapper;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/ksmt/runner/core/process/NormalProcess;", "Lio/ksmt/runner/core/process/ProcessWrapper;", "process", "Ljava/lang/Process;", "(Ljava/lang/Process;)V", "isAlive", "", "()Z", "destroyForcibly", "", "Companion", "ksmt-runner"})
public final class NormalProcess
implements ProcessWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Process process;

    private NormalProcess(Process process) {
        this.process = process;
    }

    @Override
    public boolean isAlive() {
        return this.process.isAlive();
    }

    @Override
    public void destroyForcibly() {
        this.process.destroyForcibly();
    }

    public /* synthetic */ NormalProcess(Process process, DefaultConstructorMarker $constructor_marker) {
        this(process);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bJ \u0010\u000b\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a8\u0006\f"}, d2={"Lio/ksmt/runner/core/process/NormalProcess$Companion;", "", "()V", "start", "Lio/ksmt/runner/core/process/ProcessWrapper;", "entrypoint", "Lkotlin/reflect/KClass;", "args", "", "", "jvmArgs", "startWithDebugger", "ksmt-runner"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProcessWrapper start(@NotNull KClass<?> entrypoint, @NotNull List<String> args, @NotNull List<String> jvmArgs) {
            Intrinsics.checkNotNullParameter(entrypoint, (String)"entrypoint");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            Intrinsics.checkNotNullParameter(jvmArgs, (String)"jvmArgs");
            String string = System.getProperty("java.class.path");
            if (string == null) {
                throw new IllegalStateException("No class path".toString());
            }
            String classPath = string;
            String string2 = entrypoint.getQualifiedName();
            if (string2 == null) {
                throw new IllegalStateException("Entrypoint class name is not available".toString());
            }
            String entrypointClassName = string2;
            String javaHome = System.getProperty("java.home");
            Intrinsics.checkNotNullExpressionValue((Object)javaHome, (String)"javaHome");
            Path path = Paths.get(javaHome, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(path)");
            Path javaExecutable = path.resolve("bin").resolve("java");
            Object[] objectArray = new String[]{"-classpath", classPath};
            List workerCommand = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)((Object)javaExecutable.toAbsolutePath()).toString()), (Iterable)jvmArgs), (Iterable)CollectionsKt.listOf((Object[])objectArray)), (Iterable)CollectionsKt.listOf((Object)entrypointClassName)), (Iterable)args);
            ProcessBuilder pb = new ProcessBuilder(workerCommand).inheritIO();
            Process process = pb.start();
            Intrinsics.checkNotNullExpressionValue((Object)process, (String)"process");
            return new NormalProcess(process, null);
        }

        public static /* synthetic */ ProcessWrapper start$default(Companion companion, KClass kClass, List list, List list2, int n, Object object) {
            if ((n & 4) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            return companion.start(kClass, list, list2);
        }

        @NotNull
        public final ProcessWrapper startWithDebugger(@NotNull KClass<?> entrypoint, @NotNull List<String> args) {
            Intrinsics.checkNotNullParameter(entrypoint, (String)"entrypoint");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            return this.start(entrypoint, args, CollectionsKt.listOf((Object)"-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,quiet=n,address=*:5008"));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

