/*
 * Decompiled with CFR 0.152.
 */
package io.ksmt.symfpu.operations;

import io.ksmt.KContext;
import io.ksmt.expr.KExpr;
import io.ksmt.sort.KBoolSort;
import io.ksmt.sort.KBvSort;
import io.ksmt.sort.KFpSort;
import io.ksmt.symfpu.operations.PackedFp;
import io.ksmt.symfpu.operations.UnpackedFp;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\u001a8\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\"\b\b\u0000\u0010\u0003*\u00020\u0004*\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00030\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0007H\u0000\u001a8\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\"\b\b\u0000\u0010\u0003*\u00020\u0004*\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00030\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0007H\u0000\u001a8\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\"\b\b\u0000\u0010\u0003*\u00020\u0004*\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00030\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0007H\u0000\u001a8\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\"\b\b\u0000\u0010\u0003*\u00020\u0004*\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00030\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0007H\u0000\u001ax\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\"\b\b\u0000\u0010\u0003*\u00020\u0004*\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00030\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00030\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001a8\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\"\b\b\u0000\u0010\u0003*\u00020\u0004*\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00030\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0007H\u0000\u001a8\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0001\"\b\b\u0000\u0010\u0003*\u00020\u0004*\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00030\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0007H\u0000\u001a8\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0001\"\b\b\u0000\u0010\u0003*\u00020\u0004*\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00030\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00030\u0007H\u0000\u00a8\u0006\u0016"}, d2={"equal", "Lio/ksmt/expr/KExpr;", "Lio/ksmt/sort/KBoolSort;", "Fp", "Lio/ksmt/sort/KFpSort;", "Lio/ksmt/KContext;", "left", "Lio/ksmt/symfpu/operations/UnpackedFp;", "right", "greater", "greaterOrEqual", "less", "lessHelper", "infCase", "zeroCase", "packedExists", "", "positiveCaseSignificandComparison", "negativeCaseSignificandComparison", "lessOrEqual", "max", "min", "ksmt-symfpu"})
public final class CompareKt {
    @NotNull
    public static final <Fp extends KFpSort> KExpr<KBoolSort> less(@NotNull KContext $this$less, @NotNull UnpackedFp<Fp> left, @NotNull UnpackedFp<Fp> right) {
        Intrinsics.checkNotNullParameter((Object)$this$less, (String)"<this>");
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        KExpr infCase = $this$less.or($this$less.and(left.isNegativeInfinity(), $this$less.not(right.isNegativeInfinity())), $this$less.and($this$less.not(left.isPositiveInfinity()), right.isPositiveInfinity()));
        KExpr zeroCase = $this$less.or($this$less.and($this$less.and(left.isZero(), $this$less.not(right.isZero())), $this$less.not(right.isNegative())), $this$less.and($this$less.and($this$less.not(left.isZero()), left.isNegative()), right.isZero()));
        boolean packedExists = left.getPackedFp().hasPackedFp() && right.getPackedFp().hasPackedFp();
        return CompareKt.lessHelper($this$less, left, right, (KExpr<KBoolSort>)infCase, (KExpr<KBoolSort>)zeroCase, packedExists, (KExpr<KBoolSort>)$this$less.mkBvUnsignedLessExpr(left.getSignificand(packedExists), right.getSignificand(packedExists)), (KExpr<KBoolSort>)$this$less.mkBvUnsignedLessExpr(right.getSignificand(packedExists), left.getSignificand(packedExists)));
    }

    @NotNull
    public static final <Fp extends KFpSort> KExpr<KBoolSort> lessOrEqual(@NotNull KContext $this$lessOrEqual, @NotNull UnpackedFp<Fp> left, @NotNull UnpackedFp<Fp> right) {
        Intrinsics.checkNotNullParameter((Object)$this$lessOrEqual, (String)"<this>");
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        KExpr infCase = $this$lessOrEqual.or($this$lessOrEqual.or($this$lessOrEqual.and($this$lessOrEqual.and(left.isInf(), right.isInf()), $this$lessOrEqual.eq(left.isNegative(), right.isNegative())), left.isNegativeInfinity()), right.isPositiveInfinity());
        KExpr zeroCase = $this$lessOrEqual.or($this$lessOrEqual.or($this$lessOrEqual.and(left.isZero(), right.isZero()), $this$lessOrEqual.and(left.isZero(), $this$lessOrEqual.not(right.isNegative()))), $this$lessOrEqual.and(left.isNegative(), right.isZero()));
        boolean packedExists = left.getPackedFp().hasPackedFp() && right.getPackedFp().hasPackedFp();
        return CompareKt.lessHelper($this$lessOrEqual, left, right, (KExpr<KBoolSort>)infCase, (KExpr<KBoolSort>)zeroCase, packedExists, (KExpr<KBoolSort>)$this$lessOrEqual.mkBvUnsignedLessOrEqualExpr(left.getSignificand(packedExists), right.getSignificand(packedExists)), (KExpr<KBoolSort>)$this$lessOrEqual.mkBvUnsignedLessOrEqualExpr(right.getSignificand(packedExists), left.getSignificand(packedExists)));
    }

    private static final <Fp extends KFpSort> KExpr<KBoolSort> lessHelper(KContext $this$lessHelper, UnpackedFp<Fp> left, UnpackedFp<Fp> right, KExpr<KBoolSort> infCase, KExpr<KBoolSort> zeroCase, boolean packedExists, KExpr<KBoolSort> positiveCaseSignificandComparison, KExpr<KBoolSort> negativeCaseSignificandComparison) {
        KExpr neitherNan = $this$lessHelper.and($this$lessHelper.not(left.isNaN()), $this$lessHelper.not(right.isNaN()));
        KExpr eitherInf = $this$lessHelper.or(left.isInf(), right.isInf());
        KExpr eitherZero = $this$lessHelper.or(left.isZero(), right.isZero());
        Function2 exponentLessExpr2 = (Function2)new Function2<KExpr<KBvSort>, KExpr<KBvSort>, KExpr<KBoolSort>>(packedExists, $this$lessHelper){
            final /* synthetic */ boolean $packedExists;
            final /* synthetic */ KContext $this_lessHelper;
            {
                this.$packedExists = $packedExists;
                this.$this_lessHelper = $receiver;
                super(2);
            }

            @NotNull
            public final KExpr<KBoolSort> invoke(@NotNull KExpr<KBvSort> a, @NotNull KExpr<KBvSort> b) {
                Intrinsics.checkNotNullParameter(a, (String)"a");
                Intrinsics.checkNotNullParameter(b, (String)"b");
                return this.$packedExists ? this.$this_lessHelper.mkBvUnsignedLessExpr(a, b) : this.$this_lessHelper.mkBvSignedLessExpr(a, b);
            }
        };
        KExpr negativeLessThanPositive = $this$lessHelper.and(left.isNegative(), $this$lessHelper.not(right.isNegative()));
        KExpr exponentEqual = $this$lessHelper.eq(left.getExponent(packedExists), right.getExponent(packedExists));
        KExpr leftExponentLess = (KExpr)exponentLessExpr2.invoke(left.getExponent(packedExists), right.getExponent(packedExists));
        KExpr positiveCase = $this$lessHelper.and($this$lessHelper.and($this$lessHelper.not(left.isNegative()), $this$lessHelper.not(right.isNegative())), $this$lessHelper.or(leftExponentLess, $this$lessHelper.and(exponentEqual, positiveCaseSignificandComparison)));
        KExpr rightExponentLess = (KExpr)exponentLessExpr2.invoke(right.getExponent(packedExists), left.getExponent(packedExists));
        KExpr negativeCase = $this$lessHelper.and($this$lessHelper.and(left.isNegative(), right.isNegative()), $this$lessHelper.or(rightExponentLess, $this$lessHelper.and(exponentEqual, negativeCaseSignificandComparison)));
        return $this$lessHelper.and(neitherNan, $this$lessHelper.mkIte(eitherInf, infCase, $this$lessHelper.mkIte(eitherZero, zeroCase, $this$lessHelper.or($this$lessHelper.or(negativeLessThanPositive, positiveCase), negativeCase))));
    }

    @NotNull
    public static final <Fp extends KFpSort> KExpr<KBoolSort> greater(@NotNull KContext $this$greater, @NotNull UnpackedFp<Fp> left, @NotNull UnpackedFp<Fp> right) {
        Intrinsics.checkNotNullParameter((Object)$this$greater, (String)"<this>");
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        return CompareKt.less($this$greater, right, left);
    }

    @NotNull
    public static final <Fp extends KFpSort> KExpr<KBoolSort> greaterOrEqual(@NotNull KContext $this$greaterOrEqual, @NotNull UnpackedFp<Fp> left, @NotNull UnpackedFp<Fp> right) {
        Intrinsics.checkNotNullParameter((Object)$this$greaterOrEqual, (String)"<this>");
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        return CompareKt.lessOrEqual($this$greaterOrEqual, right, left);
    }

    @NotNull
    public static final <Fp extends KFpSort> KExpr<KBoolSort> equal(@NotNull KContext $this$equal, @NotNull UnpackedFp<Fp> left, @NotNull UnpackedFp<Fp> right) {
        Intrinsics.checkNotNullParameter((Object)$this$equal, (String)"<this>");
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        KExpr neitherNan = $this$equal.and($this$equal.not(left.isNaN()), $this$equal.not(right.isNaN()));
        KExpr bothZero = $this$equal.and(left.isZero(), right.isZero());
        KExpr neitherZero = $this$equal.and($this$equal.not(left.isZero()), $this$equal.not(right.isZero()));
        KExpr flagsAndExponent = $this$equal.and(neitherNan, $this$equal.or(bothZero, $this$equal.and(neitherZero, $this$equal.and($this$equal.and($this$equal.eq(left.isInf(), right.isInf()), $this$equal.eq(left.getSign(), right.getSign())), $this$equal.eq(left.getUnbiasedExponent(), right.getUnbiasedExponent())))));
        if (left.getPackedFp() instanceof PackedFp && right.getPackedFp() instanceof PackedFp) {
            return $this$equal.and(neitherNan, $this$equal.or(bothZero, ((PackedFp)left.getPackedFp()).eq((PackedFp)right.getPackedFp())));
        }
        return $this$equal.and(flagsAndExponent, $this$equal.eq(left.getNormalizedSignificand(), right.getNormalizedSignificand()));
    }

    @NotNull
    public static final <Fp extends KFpSort> KExpr<Fp> min(@NotNull KContext $this$min, @NotNull UnpackedFp<Fp> left, @NotNull UnpackedFp<Fp> right) {
        Intrinsics.checkNotNullParameter((Object)$this$min, (String)"<this>");
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        return UnpackedFp.Companion.iteOp($this$min, (KExpr<KBoolSort>)$this$min.or(right.isNaN(), CompareKt.less($this$min, left, right)), left, right);
    }

    @NotNull
    public static final <Fp extends KFpSort> KExpr<Fp> max(@NotNull KContext $this$max, @NotNull UnpackedFp<Fp> left, @NotNull UnpackedFp<Fp> right) {
        Intrinsics.checkNotNullParameter((Object)$this$max, (String)"<this>");
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        return UnpackedFp.Companion.iteOp($this$max, (KExpr<KBoolSort>)$this$max.or(right.isNaN(), CompareKt.greater($this$max, left, right)), left, right);
    }
}

