/*
 * Decompiled with CFR 0.152.
 */
package io.ksmt.symfpu.operations;

import io.ksmt.KContext;
import io.ksmt.expr.KBitVecValue;
import io.ksmt.expr.KExpr;
import io.ksmt.sort.KBoolSort;
import io.ksmt.sort.KBvSort;
import io.ksmt.sort.KFpRoundingModeSort;
import io.ksmt.sort.KFpSort;
import io.ksmt.symfpu.operations.PackedKt;
import io.ksmt.symfpu.operations.RoundKt;
import io.ksmt.symfpu.operations.SignificandRounderResult;
import io.ksmt.symfpu.operations.UnpackedFp;
import io.ksmt.symfpu.operations.UnpackedFpKt;
import io.ksmt.symfpu.operations.UtilsKt;
import io.ksmt.utils.BvUtils;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u001aG\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\t\u001a\u0002H\u00022\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\f\u001a6\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b\u001a*\u0010\u0010\u001a\u00020\u00112\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001aI\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003\"\b\b\u0001\u0010\u0013*\u00020\u00032\u0006\u0010\t\u001a\u0002H\u00022\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0001\u00a2\u0006\u0002\u0010\u0014\u001a2\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\u001a.\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0005*\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u0002\u00a8\u0006\u001a"}, d2={"bvToFp", "Lio/ksmt/symfpu/operations/UnpackedFp;", "T", "Lio/ksmt/sort/KFpSort;", "roundingMode", "Lio/ksmt/expr/KExpr;", "Lio/ksmt/sort/KFpRoundingModeSort;", "input", "Lio/ksmt/sort/KBvSort;", "targetFormat", "signed", "", "(Lio/ksmt/expr/KExpr;Lio/ksmt/expr/KExpr;Lio/ksmt/sort/KFpSort;Z)Lio/ksmt/symfpu/operations/UnpackedFp;", "fpToBv", "targetWidth", "", "fpToBvCommon", "Lio/ksmt/symfpu/operations/SignificandRounderResult;", "fpToFp", "S", "(Lio/ksmt/sort/KFpSort;Lio/ksmt/expr/KExpr;Lio/ksmt/symfpu/operations/UnpackedFp;)Lio/ksmt/symfpu/operations/UnpackedFp;", "roundToIntegral", "expandingAdd", "Lio/ksmt/KContext;", "left", "right", "ksmt-symfpu"})
public final class ConvertKt {
    @NotNull
    public static final <T extends KFpSort> UnpackedFp<T> bvToFp(@NotNull KExpr<KFpRoundingModeSort> roundingMode, @NotNull KExpr<KBvSort> input, @NotNull T targetFormat, boolean signed) {
        Intrinsics.checkNotNullParameter(roundingMode, (String)"roundingMode");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Intrinsics.checkNotNullParameter(targetFormat, (String)"targetFormat");
        KContext $this$bvToFp_u24lambda_u241 = input.getCtx();
        boolean bl = false;
        KExpr<KBvSort> inputBv = ((KBvSort)input.getSort()).getSizeBits-pVg5ArA() == 1 ? UnpackedFpKt.extendUnsigned(input, 1) : input;
        int inputWidth = ((KBvSort)inputBv.getSort()).getSizeBits-pVg5ArA();
        if (signed) {
            int initialExponentWidth = UtilsKt.bitsToRepresent(inputWidth) + 1;
            KFpSort initialFormat = $this$bvToFp_u24lambda_u241.mkFpSort-feOb9K0(UInt.constructor-impl((int)initialExponentWidth), UInt.constructor-impl((int)(inputWidth + 1)));
            int actualExponentWidth = UInt.constructor-impl((int)UtilsKt.unpackedExponentWidth(initialFormat));
            KExpr negative = $this$bvToFp_u24lambda_u241.mkBvSignedLessExpr(inputBv, (KExpr)$this$bvToFp_u24lambda_u241.mkBv-Qn1smSk(0, inputWidth));
            KExpr it = $this$bvToFp_u24lambda_u241.mkBvSignExtensionExpr(1, inputBv);
            boolean bl2 = false;
            KExpr significand = $this$bvToFp_u24lambda_u241.mkIte(negative, $this$bvToFp_u24lambda_u241.mkBvNegationExpr(it), it);
            UnpackedFp initial = new UnpackedFp($this$bvToFp_u24lambda_u241, initialFormat, negative, (KExpr)$this$bvToFp_u24lambda_u241.mkBv-Qn1smSk(inputWidth, actualExponentWidth), significand, null, 32, null);
            UnpackedFp normalised = initial.normaliseUpDetectZero();
            return ConvertKt.fpToFp(targetFormat, roundingMode, normalised);
        }
        int initialExponentWidth = UtilsKt.bitsToRepresent(inputWidth) + 1;
        KFpSort initialFormat = $this$bvToFp_u24lambda_u241.mkFpSort-feOb9K0(UInt.constructor-impl((int)initialExponentWidth), inputWidth);
        int actualExponentWidth = UInt.constructor-impl((int)UtilsKt.unpackedExponentWidth(initialFormat));
        UnpackedFp initial = new UnpackedFp($this$bvToFp_u24lambda_u241, initialFormat, (KExpr)$this$bvToFp_u24lambda_u241.getFalseExpr(), (KExpr)$this$bvToFp_u24lambda_u241.mkBv-Qn1smSk(inputWidth - 1, actualExponentWidth), inputBv, null, 32, null);
        UnpackedFp normalised = initial.normaliseUpDetectZero();
        return ConvertKt.fpToFp(targetFormat, roundingMode, normalised);
    }

    @NotNull
    public static final <T extends KFpSort, S extends KFpSort> UnpackedFp<T> fpToFp(@NotNull T targetFormat, @NotNull KExpr<KFpRoundingModeSort> roundingMode, @NotNull UnpackedFp<S> input) {
        UnpackedFp<T> unpackedFp;
        Intrinsics.checkNotNullParameter(targetFormat, (String)"targetFormat");
        Intrinsics.checkNotNullParameter(roundingMode, (String)"roundingMode");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        KContext $this$fpToFp_u24lambda_u242 = input.getCtx();
        boolean bl = false;
        S sourceFormat = input.getSort();
        boolean exponentIncreased = UtilsKt.unpackedExponentWidth(sourceFormat) <= UtilsKt.unpackedExponentWidth(targetFormat);
        boolean significandIncreased = UtilsKt.unpackedSignificandWidth(sourceFormat) <= UtilsKt.unpackedSignificandWidth(targetFormat);
        int expExpression = Math.max(0, UtilsKt.unpackedExponentWidth(targetFormat) - UtilsKt.unpackedExponentWidth(sourceFormat));
        int sigExpression = Math.max(0, UtilsKt.unpackedSignificandWidth(targetFormat) - UtilsKt.unpackedSignificandWidth(sourceFormat));
        UnpackedFp<T> extended = input.extend(expExpression, sigExpression, targetFormat);
        if (exponentIncreased && significandIncreased) {
            unpackedFp = extended;
        } else {
            UnpackedFp rounded = RoundKt.round$default($this$fpToFp_u24lambda_u242, extended, roundingMode, targetFormat, null, 8, null);
            unpackedFp = UnpackedFp.Companion.iteOp($this$fpToFp_u24lambda_u242, input.isNaN(), UnpackedFp.Companion.makeNaN($this$fpToFp_u24lambda_u242, targetFormat), UnpackedFp.Companion.iteOp($this$fpToFp_u24lambda_u242, input.isInf(), UnpackedFp.Companion.makeInf($this$fpToFp_u24lambda_u242, targetFormat, input.getSign()), UnpackedFp.Companion.iteOp($this$fpToFp_u24lambda_u242, input.isZero(), UnpackedFp.Companion.makeZero($this$fpToFp_u24lambda_u242, targetFormat, input.getSign()), rounded)));
        }
        return unpackedFp;
    }

    @NotNull
    public static final <T extends KFpSort> UnpackedFp<T> roundToIntegral(@NotNull KExpr<KFpRoundingModeSort> roundingMode, @NotNull UnpackedFp<T> input) {
        Intrinsics.checkNotNullParameter(roundingMode, (String)"roundingMode");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        KContext $this$roundToIntegral_u24lambda_u243 = input.getCtx();
        boolean bl = false;
        KExpr exponent = UnpackedFp.getExponent$default(input, false, 1, null);
        int exponentWidth = input.exponentWidth-pVg5ArA();
        KBitVecValue packedSigWidth = $this$roundToIntegral_u24lambda_u243.mkBv-Qn1smSk(input.getSort().getSignificandBits-pVg5ArA() - 1, exponentWidth);
        KBitVecValue unpackedSigWidth = $this$roundToIntegral_u24lambda_u243.mkBv-Qn1smSk(input.significandWidth-pVg5ArA(), exponentWidth);
        KExpr isIntegral = $this$roundToIntegral_u24lambda_u243.mkBvSignedGreaterOrEqualExpr(exponent, (KExpr)packedSigWidth);
        KExpr[] kExprArray = new KExpr[]{input.isNaN(), input.isInf(), input.isZero()};
        KExpr isSpecial = $this$roundToIntegral_u24lambda_u243.mkOr(kExprArray);
        KExpr isID = $this$roundToIntegral_u24lambda_u243.or(isIntegral, isSpecial);
        KExpr<KBvSort> initialRoundingPoint = UtilsKt.expandingSubtractSigned($this$roundToIntegral_u24lambda_u243, (KExpr<KBvSort>)((KExpr)packedSigWidth), (KExpr<KBvSort>)exponent);
        KExpr<KBvSort> collaredRoundingPoint = RoundKt.collar($this$roundToIntegral_u24lambda_u243, initialRoundingPoint, (KExpr<KBvSort>)((KExpr)$this$roundToIntegral_u24lambda_u243.mkBv-Qn1smSk(0, UInt.constructor-impl((int)(exponentWidth + 1)))), RoundKt.increment($this$roundToIntegral_u24lambda_u243, (KExpr<KBvSort>)$this$roundToIntegral_u24lambda_u243.mkBvSignExtensionExpr(1, (KExpr)unpackedSigWidth)));
        KExpr significand = UnpackedFp.getSignificand$default(input, false, 1, null);
        int significandWidth = input.significandWidth-pVg5ArA();
        KExpr roundingPoint = Integer.compareUnsigned(UInt.constructor-impl((int)significandWidth), exponentWidth) >= 0 ? PackedKt.matchWidthUnsigned(collaredRoundingPoint, (KExpr<KBvSort>)significand) : $this$roundToIntegral_u24lambda_u243.mkBvExtractExpr(significandWidth - 1, 0, collaredRoundingPoint);
        SignificandRounderResult roundedResult = RoundKt.variablePositionRound($this$roundToIntegral_u24lambda_u243, roundingMode, input.getSign(), (KExpr<KBvSort>)significand, (KExpr<KBvSort>)roundingPoint, $this$roundToIntegral_u24lambda_u243.mkFalse(), (KExpr<KBoolSort>)isID);
        UnpackedFp reconstructed = new UnpackedFp($this$roundToIntegral_u24lambda_u243, (KFpSort)input.getSort(), (KExpr)input.getSign(), (KExpr)UtilsKt.max($this$roundToIntegral_u24lambda_u243, UtilsKt.conditionalIncrement($this$roundToIntegral_u24lambda_u243, roundedResult.getIncrementExponent(), (KExpr<KBvSort>)exponent), (KExpr<KBvSort>)((KExpr)$this$roundToIntegral_u24lambda_u243.mkBv-Qn1smSk(0, exponentWidth))), (KExpr)roundedResult.getSignificand(), null, 32, null);
        return UnpackedFp.Companion.iteOp($this$roundToIntegral_u24lambda_u243, (KExpr<KBoolSort>)isID, input, UnpackedFp.Companion.iteOp($this$roundToIntegral_u24lambda_u243, UtilsKt.isAllZeros($this$roundToIntegral_u24lambda_u243, roundedResult.getSignificand()), UnpackedFp.Companion.makeZero($this$roundToIntegral_u24lambda_u243, input.getSort(), input.getSign()), reconstructed));
    }

    @NotNull
    public static final KExpr<KBvSort> fpToBv(@NotNull KExpr<KFpRoundingModeSort> roundingMode, @NotNull UnpackedFp<?> input, int targetWidth, boolean signed) {
        KExpr kExpr;
        Intrinsics.checkNotNullParameter(roundingMode, (String)"roundingMode");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        KContext $this$fpToBv_u24lambda_u244 = input.getCtx();
        boolean bl = false;
        KExpr specialValue = $this$fpToBv_u24lambda_u244.or(input.isInf(), input.isNaN());
        int maxExponentBits = UtilsKt.bitsToRepresent(targetWidth) + 1;
        int exponentWidth = input.exponentWidth-pVg5ArA();
        int workingExponentWidth = Math.max(exponentWidth, maxExponentBits);
        KBitVecValue maxExponent = $this$fpToBv_u24lambda_u244.mkBv-Qn1smSk(targetWidth, UInt.constructor-impl((int)workingExponentWidth));
        KExpr<KBvSort> exponent = PackedKt.matchWidthSigned((KExpr<KBvSort>)UnpackedFp.getExponent$default(input, false, 1, null), $this$fpToBv_u24lambda_u244, (KExpr<KBvSort>)((KExpr)maxExponent));
        KExpr tooLarge = $this$fpToBv_u24lambda_u244.mkBvSignedGreaterOrEqualExpr(exponent, (KExpr)maxExponent);
        SignificandRounderResult rounded = ConvertKt.fpToBvCommon(roundingMode, input, targetWidth);
        KBitVecValue unspecified = $this$fpToBv_u24lambda_u244.mkBv-Qn1smSk(-1, UInt.constructor-impl((int)targetWidth));
        if (signed) {
            KExpr earlyUndefinedResult = $this$fpToBv_u24lambda_u244.or(specialValue, tooLarge);
            int roundSigWidth = ((KBvSort)rounded.getSignificand().getSort()).getSizeBits-pVg5ArA();
            KExpr<KBoolSort> lastRoundBitSet = UtilsKt.isAllOnes($this$fpToBv_u24lambda_u244, (KExpr<KBvSort>)$this$fpToBv_u24lambda_u244.mkBvExtractExpr(roundSigWidth - 1, roundSigWidth - 1, rounded.getSignificand()));
            KExpr anyRoundBitSet = $this$fpToBv_u24lambda_u244.not(UtilsKt.isAllZeros($this$fpToBv_u24lambda_u244, (KExpr<KBvSort>)$this$fpToBv_u24lambda_u244.mkBvExtractExpr(roundSigWidth - 2, 0, rounded.getSignificand())));
            KExpr undefinedResult = $this$fpToBv_u24lambda_u244.or($this$fpToBv_u24lambda_u244.or(earlyUndefinedResult, rounded.getIncrementExponent()), $this$fpToBv_u24lambda_u244.and($this$fpToBv_u24lambda_u244.and(lastRoundBitSet, $this$fpToBv_u24lambda_u244.not(input.getSign())), anyRoundBitSet));
            kExpr = $this$fpToBv_u24lambda_u244.mkIte(undefinedResult, (KExpr)unspecified, UtilsKt.conditionalNegate($this$fpToBv_u24lambda_u244, input.getSign(), rounded.getSignificand()));
        } else {
            KExpr tooNegative = $this$fpToBv_u24lambda_u244.and($this$fpToBv_u24lambda_u244.and(input.getSign(), $this$fpToBv_u24lambda_u244.not(input.isZero())), $this$fpToBv_u24lambda_u244.mkBvSignedLessOrEqualExpr((KExpr)BvUtils.bvZero-Qn1smSk((KContext)$this$fpToBv_u24lambda_u244, (int)UInt.constructor-impl((int)workingExponentWidth)), exponent));
            KExpr earlyUndefinedResult = $this$fpToBv_u24lambda_u244.or($this$fpToBv_u24lambda_u244.or(specialValue, tooLarge), tooNegative);
            KExpr undefinedResult = $this$fpToBv_u24lambda_u244.or($this$fpToBv_u24lambda_u244.or(earlyUndefinedResult, rounded.getIncrementExponent()), $this$fpToBv_u24lambda_u244.and(input.getSign(), $this$fpToBv_u24lambda_u244.not(UtilsKt.isAllZeros($this$fpToBv_u24lambda_u244, rounded.getSignificand()))));
            kExpr = $this$fpToBv_u24lambda_u244.mkIte(undefinedResult, (KExpr)unspecified, rounded.getSignificand());
        }
        return kExpr;
    }

    private static final SignificandRounderResult fpToBvCommon(KExpr<KFpRoundingModeSort> roundingMode, UnpackedFp<?> input, int targetWidth) {
        KExpr kExpr;
        KContext $this$fpToBvCommon_u24lambda_u245 = input.getCtx();
        boolean bl = false;
        int maxShift = targetWidth + 1;
        int maxShiftBits = UtilsKt.bitsToRepresent(maxShift) + 1;
        int exponentWidth = input.exponentWidth-pVg5ArA();
        int workingExponentWidth = exponentWidth >= maxShiftBits ? exponentWidth : maxShiftBits;
        KBitVecValue maxShiftAmount = $this$fpToBvCommon_u24lambda_u245.mkBv-Qn1smSk(maxShift, UInt.constructor-impl((int)workingExponentWidth));
        KExpr<KBvSort> exponent = PackedKt.matchWidthSigned((KExpr<KBvSort>)UnpackedFp.getExponent$default(input, false, 1, null), $this$fpToBvCommon_u24lambda_u245, (KExpr<KBvSort>)((KExpr)maxShiftAmount));
        KExpr inputSignificand = UnpackedFp.getSignificand$default(input, false, 1, null);
        int inputSignificandWidth = input.significandWidth-pVg5ArA();
        if (targetWidth + 2 < inputSignificandWidth) {
            KExpr dataAndGuard = $this$fpToBvCommon_u24lambda_u245.mkBvExtractExpr(inputSignificandWidth - 1, inputSignificandWidth - targetWidth - 1, inputSignificand);
            KExpr sticky = $this$fpToBvCommon_u24lambda_u245.not(UtilsKt.isAllZeros($this$fpToBvCommon_u24lambda_u245, (KExpr<KBvSort>)$this$fpToBvCommon_u24lambda_u245.mkBvExtractExpr(inputSignificandWidth - targetWidth - 2, 0, inputSignificand)));
            kExpr = $this$fpToBvCommon_u24lambda_u245.mkBvConcatExpr(dataAndGuard, UtilsKt.boolToBv($this$fpToBvCommon_u24lambda_u245, (KExpr<KBoolSort>)sticky));
        } else {
            kExpr = inputSignificand;
        }
        KExpr significand = kExpr;
        int significandWidth = ((KBvSort)significand.getSort()).getSizeBits-pVg5ArA();
        KExpr zeroedSignificand = $this$fpToBvCommon_u24lambda_u245.mkBvAndExpr(significand, $this$fpToBvCommon_u24lambda_u245.mkIte(input.isZero(), (KExpr)$this$fpToBvCommon_u24lambda_u245.mkBv-Qn1smSk(0, significandWidth), (KExpr)UtilsKt.ones-Qn1smSk($this$fpToBvCommon_u24lambda_u245, significandWidth)));
        KExpr expandedSignificand = $this$fpToBvCommon_u24lambda_u245.mkBvZeroExtensionExpr(maxShift, zeroedSignificand);
        KExpr<KBvSort> shiftAmount = RoundKt.collar($this$fpToBvCommon_u24lambda_u245, ConvertKt.expandingAdd($this$fpToBvCommon_u24lambda_u245, exponent, (KExpr<KBvSort>)((KExpr)$this$fpToBvCommon_u24lambda_u245.mkBv-Qn1smSk(2, UInt.constructor-impl((int)workingExponentWidth)))), (KExpr<KBvSort>)((KExpr)$this$fpToBvCommon_u24lambda_u245.mkBv-Qn1smSk(0, UInt.constructor-impl((int)(UInt.constructor-impl((int)workingExponentWidth) + 1)))), (KExpr<KBvSort>)$this$fpToBvCommon_u24lambda_u245.mkBvSignExtensionExpr(1, (KExpr)maxShiftAmount));
        KExpr<KBvSort> convertedShiftAmount = PackedKt.matchWidthUnsigned(UnpackedFpKt.resizeSigned-Qn1smSk(shiftAmount, UInt.constructor-impl((int)(UInt.constructor-impl((int)UtilsKt.bitsToRepresent(maxShift)) + 1))), (KExpr<KBvSort>)expandedSignificand);
        KExpr aligned = $this$fpToBvCommon_u24lambda_u245.mkBvShiftLeftExpr(expandedSignificand, convertedShiftAmount);
        return RoundKt.fixedPositionRound($this$fpToBvCommon_u24lambda_u245, roundingMode, input.getSign(), (KExpr<KBvSort>)aligned, targetWidth, $this$fpToBvCommon_u24lambda_u245.mkFalse(), (KExpr<KBoolSort>)((KExpr)$this$fpToBvCommon_u24lambda_u245.mkFalse()));
    }

    private static final KExpr<KBvSort> expandingAdd(KContext $this$expandingAdd, KExpr<KBvSort> left, KExpr<KBvSort> right) {
        KExpr x = $this$expandingAdd.mkBvSignExtensionExpr(1, left);
        KExpr y = $this$expandingAdd.mkBvSignExtensionExpr(1, right);
        return $this$expandingAdd.mkBvAddExpr(x, y);
    }
}

