/*
 * Decompiled with CFR 0.152.
 */
package io.ksmt.symfpu.operations;

import io.ksmt.KContext;
import io.ksmt.expr.KExpr;
import io.ksmt.sort.KBoolSort;
import io.ksmt.sort.KBvSort;
import io.ksmt.sort.KFpRoundingModeSort;
import io.ksmt.sort.KFpSort;
import io.ksmt.symfpu.operations.MultiplyKt;
import io.ksmt.symfpu.operations.ResultWithRemainderBit;
import io.ksmt.symfpu.operations.RoundKt;
import io.ksmt.symfpu.operations.UnpackedFp;
import io.ksmt.symfpu.operations.UtilsKt;
import io.ksmt.utils.BvUtils;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aR\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\u001a6\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\u001aD\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\b\u001a(\u0010\u000f\u001a\u00020\u0010*\u00020\u00042\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\bH\u0002\u00a8\u0006\u0014"}, d2={"addDivideSpecialCases", "Lio/ksmt/symfpu/operations/UnpackedFp;", "T", "Lio/ksmt/sort/KFpSort;", "Lio/ksmt/KContext;", "left", "right", "sign", "Lio/ksmt/expr/KExpr;", "Lio/ksmt/sort/KBoolSort;", "divideResult", "arithmeticDivide", "divide", "roundingMode", "Lio/ksmt/sort/KFpRoundingModeSort;", "fixedPointDivide", "Lio/ksmt/symfpu/operations/ResultWithRemainderBit;", "x", "Lio/ksmt/sort/KBvSort;", "y", "ksmt-symfpu"})
public final class DivideKt {
    @NotNull
    public static final <T extends KFpSort> UnpackedFp<T> divide(@NotNull KContext $this$divide, @NotNull UnpackedFp<T> left, @NotNull UnpackedFp<T> right, @NotNull KExpr<KFpRoundingModeSort> roundingMode) {
        Intrinsics.checkNotNullParameter((Object)$this$divide, (String)"<this>");
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        Intrinsics.checkNotNullParameter(roundingMode, (String)"roundingMode");
        UnpackedFp<KFpSort> divideResult = DivideKt.arithmeticDivide($this$divide, left, right);
        UnpackedFp roundedDivideResult = RoundKt.round$default($this$divide, divideResult, roundingMode, left.getSort(), null, 8, null);
        return DivideKt.addDivideSpecialCases($this$divide, left, right, roundedDivideResult.getSign(), roundedDivideResult);
    }

    @NotNull
    public static final <T extends KFpSort> UnpackedFp<T> addDivideSpecialCases(@NotNull KContext $this$addDivideSpecialCases, @NotNull UnpackedFp<T> left, @NotNull UnpackedFp<T> right, @NotNull KExpr<KBoolSort> sign, @NotNull UnpackedFp<T> divideResult) {
        Intrinsics.checkNotNullParameter((Object)$this$addDivideSpecialCases, (String)"<this>");
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        Intrinsics.checkNotNullParameter(sign, (String)"sign");
        Intrinsics.checkNotNullParameter(divideResult, (String)"divideResult");
        T format = left.getSort();
        KExpr eitherArgumentNaN = $this$addDivideSpecialCases.or(left.isNaN(), right.isNaN());
        KExpr generateNaN = $this$addDivideSpecialCases.or($this$addDivideSpecialCases.and(left.isInf(), right.isInf()), $this$addDivideSpecialCases.and(left.isZero(), right.isZero()));
        KExpr isNaN = $this$addDivideSpecialCases.or(eitherArgumentNaN, generateNaN);
        KExpr isInf = $this$addDivideSpecialCases.or($this$addDivideSpecialCases.and($this$addDivideSpecialCases.not(left.isZero()), right.isZero()), $this$addDivideSpecialCases.and(left.isInf(), $this$addDivideSpecialCases.not(right.isInf())));
        KExpr isZero = $this$addDivideSpecialCases.or($this$addDivideSpecialCases.and($this$addDivideSpecialCases.not(left.isInf()), right.isInf()), $this$addDivideSpecialCases.and(left.isZero(), $this$addDivideSpecialCases.not(right.isZero())));
        return UnpackedFp.Companion.iteOp($this$addDivideSpecialCases, (KExpr<KBoolSort>)isNaN, UnpackedFp.Companion.makeNaN($this$addDivideSpecialCases, format), UnpackedFp.Companion.iteOp($this$addDivideSpecialCases, (KExpr<KBoolSort>)isInf, UnpackedFp.Companion.makeInf($this$addDivideSpecialCases, format, sign), UnpackedFp.Companion.iteOp($this$addDivideSpecialCases, (KExpr<KBoolSort>)isZero, UnpackedFp.Companion.makeZero($this$addDivideSpecialCases, format, sign), divideResult)));
    }

    @NotNull
    public static final <T extends KFpSort> UnpackedFp<KFpSort> arithmeticDivide(@NotNull KContext $this$arithmeticDivide, @NotNull UnpackedFp<T> left, @NotNull UnpackedFp<T> right) {
        Intrinsics.checkNotNullParameter((Object)$this$arithmeticDivide, (String)"<this>");
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        T format = left.getSort();
        KExpr divideSign = $this$arithmeticDivide.xor(left.getSign(), right.getSign());
        KExpr<KBvSort> exponentDiff = UtilsKt.expandingSubtractSigned($this$arithmeticDivide, (KExpr<KBvSort>)UnpackedFp.getExponent$default(left, false, 1, null), (KExpr<KBvSort>)UnpackedFp.getExponent$default(right, false, 1, null));
        KExpr extendedNumerator = $this$arithmeticDivide.mkBvConcatExpr(UnpackedFp.getSignificand$default(left, false, 1, null), (KExpr)BvUtils.bvZero-Qn1smSk((KContext)$this$arithmeticDivide, (int)2));
        KExpr extendedDenominator = $this$arithmeticDivide.mkBvConcatExpr(UnpackedFp.getSignificand$default(right, false, 1, null), (KExpr)BvUtils.bvZero-Qn1smSk((KContext)$this$arithmeticDivide, (int)2));
        ResultWithRemainderBit divided = DivideKt.fixedPointDivide($this$arithmeticDivide, (KExpr<KBvSort>)extendedNumerator, (KExpr<KBvSort>)extendedDenominator);
        int resWidth = ((KBvSort)divided.getResult().getSort()).getSizeBits-pVg5ArA();
        KExpr topBit = $this$arithmeticDivide.mkBvExtractExpr(resWidth - 1, resWidth - 1, divided.getResult());
        KExpr<KBoolSort> topBitSet = UtilsKt.isAllOnes($this$arithmeticDivide, (KExpr<KBvSort>)topBit);
        KExpr<KBvSort> alignedExponent = UtilsKt.conditionalDecrement($this$arithmeticDivide, (KExpr<KBoolSort>)$this$arithmeticDivide.not(topBitSet), exponentDiff);
        KExpr<KBvSort> alignedSignificand = MultiplyKt.conditionalLeftShiftOne($this$arithmeticDivide, (KExpr<KBoolSort>)$this$arithmeticDivide.not(topBitSet), divided.getResult());
        KExpr finishedSignificand = $this$arithmeticDivide.mkBvOrExpr(alignedSignificand, $this$arithmeticDivide.mkBvZeroExtensionExpr(resWidth - 1, UtilsKt.boolToBv($this$arithmeticDivide, divided.getRemainderBit())));
        KFpSort extendedFormat = $this$arithmeticDivide.mkFpSort-feOb9K0(UInt.constructor-impl((int)(format.getExponentBits-pVg5ArA() + 1)), UInt.constructor-impl((int)(format.getSignificandBits-pVg5ArA() + 2)));
        return new UnpackedFp<KFpSort>($this$arithmeticDivide, extendedFormat, divideSign, alignedExponent, finishedSignificand, null, 32, null);
    }

    private static final ResultWithRemainderBit fixedPointDivide(KContext $this$fixedPointDivide, KExpr<KBvSort> x, KExpr<KBvSort> y) {
        int w = ((KBvSort)x.getSort()).getSizeBits-pVg5ArA();
        if (!(((KBvSort)y.getSort()).getSizeBits-pVg5ArA() == w)) {
            boolean $i$a$-check-DivideKt$fixedPointDivide$22 = false;
            String $i$a$-check-DivideKt$fixedPointDivide$22 = "Divisor must have same width as dividend";
            throw new IllegalStateException($i$a$-check-DivideKt$fixedPointDivide$22.toString());
        }
        KExpr ex = $this$fixedPointDivide.mkBvConcatExpr(x, (KExpr)BvUtils.bvZero-Qn1smSk((KContext)$this$fixedPointDivide, (int)UInt.constructor-impl((int)(w - 1))));
        KExpr ey = $this$fixedPointDivide.mkBvZeroExtensionExpr(w - 1, y);
        KExpr div = $this$fixedPointDivide.mkBvUnsignedDivExpr(ex, ey);
        KExpr rem = $this$fixedPointDivide.mkBvUnsignedRemExpr(ex, ey);
        return new ResultWithRemainderBit((KExpr<KBvSort>)$this$fixedPointDivide.mkBvExtractExpr(w - 1, 0, div), (KExpr<KBoolSort>)$this$fixedPointDivide.not(UtilsKt.isAllZeros($this$fixedPointDivide, (KExpr<KBvSort>)rem)));
    }
}

