/*
 * Decompiled with CFR 0.152.
 */
package io.ksmt.symfpu.operations;

import io.ksmt.KContext;
import io.ksmt.expr.KExpr;
import io.ksmt.sort.KBoolSort;
import io.ksmt.sort.KBvSort;
import io.ksmt.sort.KFpRoundingModeSort;
import io.ksmt.sort.KFpSort;
import io.ksmt.symfpu.operations.RoundKt;
import io.ksmt.symfpu.operations.UnpackedFp;
import io.ksmt.symfpu.operations.UtilsKt;
import io.ksmt.utils.BvUtils;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u001aN\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003\"\b\b\u0001\u0010\u0004*\u00020\u0003*\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00040\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0001\u001a6\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u00020\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\u001a,\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b*\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u001a,\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000b*\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u001a<\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b*\u00020\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bH\u0002\u001a,\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u000b*\u00020\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u001aF\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00020\u000b\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u00020\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000bH\u0000\u00a8\u0006\u0017"}, d2={"addMultSpecialCases", "Lio/ksmt/symfpu/operations/UnpackedFp;", "Fp", "Lio/ksmt/sort/KFpSort;", "T", "Lio/ksmt/KContext;", "multiplyResult", "left", "right", "arithmeticMultiply", "conditionalLeftShiftOne", "Lio/ksmt/expr/KExpr;", "Lio/ksmt/sort/KBvSort;", "condition", "Lio/ksmt/sort/KBoolSort;", "expr", "conditionalRightShiftOne", "expandingAddWithCarryIn", "carry", "expandingMultiply", "multiply", "roundingMode", "Lio/ksmt/sort/KFpRoundingModeSort;", "ksmt-symfpu"})
public final class MultiplyKt {
    @NotNull
    public static final <Fp extends KFpSort> KExpr<Fp> multiply(@NotNull KContext $this$multiply, @NotNull UnpackedFp<Fp> left, @NotNull UnpackedFp<Fp> right, @NotNull KExpr<KFpRoundingModeSort> roundingMode) {
        Intrinsics.checkNotNullParameter((Object)$this$multiply, (String)"<this>");
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        Intrinsics.checkNotNullParameter(roundingMode, (String)"roundingMode");
        UnpackedFp<KFpSort> multiplyResult = MultiplyKt.arithmeticMultiply($this$multiply, left, right);
        UnpackedFp rounded = RoundKt.round$default($this$multiply, multiplyResult, roundingMode, left.getSort(), null, 8, null);
        return MultiplyKt.addMultSpecialCases($this$multiply, rounded, left, right);
    }

    @NotNull
    public static final <Fp extends KFpSort, T extends KFpSort> UnpackedFp<Fp> addMultSpecialCases(@NotNull KContext $this$addMultSpecialCases, @NotNull UnpackedFp<Fp> multiplyResult, @NotNull UnpackedFp<T> left, @NotNull UnpackedFp<T> right) {
        Intrinsics.checkNotNullParameter((Object)$this$addMultSpecialCases, (String)"<this>");
        Intrinsics.checkNotNullParameter(multiplyResult, (String)"multiplyResult");
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        KExpr eitherArgumentNan = $this$addMultSpecialCases.or(left.isNaN(), right.isNaN());
        KExpr generateNan = $this$addMultSpecialCases.or($this$addMultSpecialCases.and(left.isInf(), right.isZero()), $this$addMultSpecialCases.and(left.isZero(), right.isInf()));
        KExpr isNan = $this$addMultSpecialCases.or(eitherArgumentNan, generateNan);
        KExpr isInf = $this$addMultSpecialCases.or(left.isInf(), right.isInf());
        KExpr isZero = $this$addMultSpecialCases.or(left.isZero(), right.isZero());
        return UnpackedFp.Companion.iteOp($this$addMultSpecialCases, (KExpr<KBoolSort>)isNan, UnpackedFp.Companion.makeNaN($this$addMultSpecialCases, multiplyResult.getSort()), UnpackedFp.Companion.iteOp($this$addMultSpecialCases, (KExpr<KBoolSort>)isInf, UnpackedFp.Companion.makeInf($this$addMultSpecialCases, multiplyResult.getSort(), multiplyResult.getSign()), UnpackedFp.Companion.iteOp($this$addMultSpecialCases, (KExpr<KBoolSort>)isZero, UnpackedFp.Companion.makeZero($this$addMultSpecialCases, multiplyResult.getSort(), multiplyResult.getSign()), multiplyResult)));
    }

    @NotNull
    public static final KExpr<KBvSort> expandingMultiply(@NotNull KContext $this$expandingMultiply, @NotNull KExpr<KBvSort> left, @NotNull KExpr<KBvSort> right) {
        Intrinsics.checkNotNullParameter((Object)$this$expandingMultiply, (String)"<this>");
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        int width = ((KBvSort)left.getSort()).getSizeBits-pVg5ArA();
        KExpr x = $this$expandingMultiply.mkBvZeroExtensionExpr(width, left);
        KExpr y = $this$expandingMultiply.mkBvZeroExtensionExpr(width, right);
        return $this$expandingMultiply.mkBvMulExpr(x, y);
    }

    private static final KExpr<KBvSort> expandingAddWithCarryIn(KContext $this$expandingAddWithCarryIn, KExpr<KBvSort> left, KExpr<KBvSort> right, KExpr<KBoolSort> carry) {
        KExpr x = $this$expandingAddWithCarryIn.mkBvSignExtensionExpr(1, left);
        KExpr y = $this$expandingAddWithCarryIn.mkBvSignExtensionExpr(1, right);
        KExpr sum = $this$expandingAddWithCarryIn.mkBvAddExpr(x, y);
        KExpr carryBv = $this$expandingAddWithCarryIn.mkIte(carry, (KExpr)$this$expandingAddWithCarryIn.mkBv(1, (KBvSort)sum.getSort()), (KExpr)$this$expandingAddWithCarryIn.mkBv(0, (KBvSort)sum.getSort()));
        return $this$expandingAddWithCarryIn.mkBvAddExpr(sum, carryBv);
    }

    @NotNull
    public static final <Fp extends KFpSort> UnpackedFp<KFpSort> arithmeticMultiply(@NotNull KContext $this$arithmeticMultiply, @NotNull UnpackedFp<Fp> left, @NotNull UnpackedFp<Fp> right) {
        Intrinsics.checkNotNullParameter((Object)$this$arithmeticMultiply, (String)"<this>");
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        KExpr multiplySign = $this$arithmeticMultiply.xor(left.getSign(), right.getSign());
        KExpr<KBvSort> significandProduct = MultiplyKt.expandingMultiply($this$arithmeticMultiply, left.getNormalizedSignificand(), right.getNormalizedSignificand());
        int spWidth = ((KBvSort)significandProduct.getSort()).getSizeBits-pVg5ArA();
        KExpr topBit = $this$arithmeticMultiply.mkBvExtractExpr(spWidth - 1, spWidth - 1, significandProduct);
        KExpr<KBoolSort> topBitSet = UtilsKt.isAllOnes($this$arithmeticMultiply, (KExpr<KBvSort>)topBit);
        KExpr<KBvSort> alignedSignificand = MultiplyKt.conditionalLeftShiftOne($this$arithmeticMultiply, (KExpr<KBoolSort>)$this$arithmeticMultiply.not(topBitSet), significandProduct);
        KExpr<KBvSort> alignedExponent = MultiplyKt.expandingAddWithCarryIn($this$arithmeticMultiply, left.getUnbiasedExponent(), right.getUnbiasedExponent(), topBitSet);
        KFpSort sort = $this$arithmeticMultiply.mkFpSort-feOb9K0(UInt.constructor-impl((int)(left.getSort().getExponentBits-pVg5ArA() + 1)), UInt.constructor-impl((int)(left.getSort().getSignificandBits-pVg5ArA() * 2)));
        return new UnpackedFp<KFpSort>($this$arithmeticMultiply, sort, multiplySign, alignedExponent, alignedSignificand, null, 32, null);
    }

    @NotNull
    public static final KExpr<KBvSort> conditionalLeftShiftOne(@NotNull KContext $this$conditionalLeftShiftOne, @NotNull KExpr<KBoolSort> condition, @NotNull KExpr<KBvSort> expr) {
        Intrinsics.checkNotNullParameter((Object)$this$conditionalLeftShiftOne, (String)"<this>");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        return $this$conditionalLeftShiftOne.mkIte(condition, $this$conditionalLeftShiftOne.mkBvShiftLeftExpr(expr, (KExpr)BvUtils.bvOne-Qn1smSk((KContext)$this$conditionalLeftShiftOne, (int)((KBvSort)expr.getSort()).getSizeBits-pVg5ArA())), expr);
    }

    @NotNull
    public static final KExpr<KBvSort> conditionalRightShiftOne(@NotNull KContext $this$conditionalRightShiftOne, @NotNull KExpr<KBoolSort> condition, @NotNull KExpr<KBvSort> expr) {
        Intrinsics.checkNotNullParameter((Object)$this$conditionalRightShiftOne, (String)"<this>");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        return $this$conditionalRightShiftOne.mkIte(condition, $this$conditionalRightShiftOne.mkBvLogicalShiftRightExpr(expr, (KExpr)BvUtils.bvOne-Qn1smSk((KContext)$this$conditionalRightShiftOne, (int)((KBvSort)expr.getSort()).getSizeBits-pVg5ArA())), expr);
    }
}

