/*
 * Decompiled with CFR 0.152.
 */
package io.ksmt.symfpu.operations;

import io.ksmt.KContext;
import io.ksmt.expr.KBitVecValue;
import io.ksmt.expr.KExpr;
import io.ksmt.expr.rewrite.simplify.BvSimplificationKt;
import io.ksmt.expr.rewrite.simplify.FpSimplificationKt;
import io.ksmt.sort.KBoolSort;
import io.ksmt.sort.KBvSort;
import io.ksmt.sort.KFpSort;
import io.ksmt.symfpu.operations.NoPackedFp;
import io.ksmt.symfpu.operations.OptionalPackedFp;
import io.ksmt.symfpu.operations.PackedFp;
import io.ksmt.symfpu.operations.UnpackedFp;
import io.ksmt.symfpu.operations.UtilsKt;
import io.ksmt.utils.BvUtils;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a,\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a$\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a5\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\b0\u0001\"\b\b\u0000\u0010\b*\u00020\t*\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u000b\u001a\u0002H\b\u00a2\u0006\u0002\u0010\f\u001a(\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\"\b\b\u0000\u0010\b*\u00020\t*\u00020\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\b0\u000f\u001aY\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\b0\u000f\"\b\b\u0000\u0010\b*\u00020\t*\u00020\u00042\u0006\u0010\u000b\u001a\u0002H\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017\u001a=\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\b0\u000f\"\b\b\u0000\u0010\b*\u00020\t*\u00020\u00042\u0006\u0010\u000b\u001a\u0002H\b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0019\u00a8\u0006\u001a"}, d2={"matchWidthSigned", "Lio/ksmt/expr/KExpr;", "Lio/ksmt/sort/KBvSort;", "ctx", "Lio/ksmt/KContext;", "expr", "matchWidthUnsigned", "pack", "Fp", "Lio/ksmt/sort/KFpSort;", "packed", "sort", "(Lio/ksmt/KContext;Lio/ksmt/expr/KExpr;Lio/ksmt/sort/KFpSort;)Lio/ksmt/expr/KExpr;", "packToBv", "uf", "Lio/ksmt/symfpu/operations/UnpackedFp;", "unpack", "sign", "Lio/ksmt/sort/KBoolSort;", "packedExponent", "packedSignificand", "packedBvOptimization", "", "(Lio/ksmt/KContext;Lio/ksmt/sort/KFpSort;Lio/ksmt/expr/KExpr;Lio/ksmt/expr/KExpr;Lio/ksmt/expr/KExpr;Z)Lio/ksmt/symfpu/operations/UnpackedFp;", "packedFloat", "(Lio/ksmt/KContext;Lio/ksmt/sort/KFpSort;Lio/ksmt/expr/KExpr;Z)Lio/ksmt/symfpu/operations/UnpackedFp;", "ksmt-symfpu"})
public final class PackedKt {
    @NotNull
    public static final <Fp extends KFpSort> UnpackedFp<Fp> unpack(@NotNull KContext $this$unpack, @NotNull Fp sort, @NotNull KExpr<KBvSort> packedFloat, boolean packedBvOptimization) {
        Intrinsics.checkNotNullParameter((Object)$this$unpack, (String)"<this>");
        Intrinsics.checkNotNullParameter(sort, (String)"sort");
        Intrinsics.checkNotNullParameter(packedFloat, (String)"packedFloat");
        int pWidth = ((KBvSort)packedFloat.getSort()).getSizeBits-pVg5ArA();
        int exWidth = sort.getExponentBits-pVg5ArA();
        KExpr packedSignificand = $this$unpack.mkBvExtractExpr(pWidth - exWidth - 2, 0, packedFloat);
        KExpr packedExponent = $this$unpack.mkBvExtractExpr(pWidth - 2, pWidth - exWidth - 1, packedFloat);
        KExpr<KBoolSort> sign = UtilsKt.bvToBool($this$unpack, (KExpr<KBvSort>)$this$unpack.mkBvExtractExpr(pWidth - 1, pWidth - 1, packedFloat));
        return PackedKt.unpack($this$unpack, sort, sign, (KExpr<KBvSort>)packedExponent, (KExpr<KBvSort>)packedSignificand, packedBvOptimization);
    }

    @NotNull
    public static final <Fp extends KFpSort> UnpackedFp<Fp> unpack(@NotNull KContext $this$unpack, @NotNull Fp sort, @NotNull KExpr<KBoolSort> sign, @NotNull KExpr<KBvSort> packedExponent, @NotNull KExpr<KBvSort> packedSignificand, boolean packedBvOptimization) {
        Intrinsics.checkNotNullParameter((Object)$this$unpack, (String)"<this>");
        Intrinsics.checkNotNullParameter(sort, (String)"sort");
        Intrinsics.checkNotNullParameter(sign, (String)"sign");
        Intrinsics.checkNotNullParameter(packedExponent, (String)"packedExponent");
        Intrinsics.checkNotNullParameter(packedSignificand, (String)"packedSignificand");
        int unpackedExWidth = UtilsKt.unpackedExponentWidth(sort);
        KExpr exponent = $this$unpack.mkBvSubExpr($this$unpack.mkBvZeroExtensionExpr(unpackedExWidth - sort.getExponentBits-pVg5ArA(), packedExponent), (KExpr)$this$unpack.mkBv-Qn1smSk(sort.exponentShiftSize(), UInt.constructor-impl((int)unpackedExWidth)));
        KExpr significandWithLeadingZero = $this$unpack.mkBvConcatExpr((KExpr)UtilsKt.bvZero($this$unpack), packedSignificand);
        KExpr significandWithLeadingOne = $this$unpack.mkBvConcatExpr((KExpr)UtilsKt.bvOne($this$unpack), packedSignificand);
        OptionalPackedFp packedFp = packedBvOptimization ? (OptionalPackedFp)new PackedFp(sign, packedExponent, packedSignificand) : (OptionalPackedFp)NoPackedFp.INSTANCE;
        UnpackedFp<Fp> ufNormal = new UnpackedFp<Fp>($this$unpack, sort, sign, (KExpr<KBvSort>)exponent, (KExpr<KBvSort>)significandWithLeadingOne, packedFp);
        UnpackedFp<Fp> ufSubnormalBase = new UnpackedFp<Fp>($this$unpack, sort, sign, (KExpr<KBvSort>)((KExpr)UtilsKt.minNormalExponent($this$unpack, sort)), (KExpr<KBvSort>)significandWithLeadingZero, packedFp);
        KExpr<KBoolSort> zeroExponent = UtilsKt.isAllZeros($this$unpack, packedExponent);
        KExpr<KBoolSort> onesExponent = UtilsKt.isAllOnes($this$unpack, packedExponent);
        KExpr<KBoolSort> zeroSignificand = UtilsKt.isAllZeros($this$unpack, packedSignificand);
        KExpr isZero = $this$unpack.and(zeroExponent, zeroSignificand);
        KExpr isSubnormal = $this$unpack.and(zeroExponent, $this$unpack.not(zeroSignificand));
        KExpr isInf = $this$unpack.and(onesExponent, zeroSignificand);
        KExpr isNaN = $this$unpack.and(onesExponent, $this$unpack.not(zeroSignificand));
        return UnpackedFp.Companion.iteOp($this$unpack, (KExpr<KBoolSort>)isNaN, UnpackedFp.Companion.makeNaN($this$unpack, sort), UnpackedFp.Companion.iteOp($this$unpack, (KExpr<KBoolSort>)isInf, UnpackedFp.Companion.makeInf($this$unpack, sort, sign), UnpackedFp.Companion.iteOp($this$unpack, (KExpr<KBoolSort>)isZero, UnpackedFp.Companion.makeZero($this$unpack, sort, sign), UnpackedFp.Companion.iteOp($this$unpack, (KExpr<KBoolSort>)$this$unpack.not(isSubnormal), ufNormal, ufSubnormalBase.normaliseUp()))));
    }

    @NotNull
    public static final <Fp extends KFpSort> KExpr<KBvSort> packToBv(@NotNull KContext $this$packToBv, @NotNull UnpackedFp<Fp> uf) {
        Intrinsics.checkNotNullParameter((Object)$this$packToBv, (String)"<this>");
        Intrinsics.checkNotNullParameter(uf, (String)"uf");
        if (uf.getPackedFp() instanceof PackedFp) {
            return ((PackedFp)uf.getPackedFp()).toIEEEBv();
        }
        KExpr<KBvSort> packedSign = uf.signBv();
        int packedExWidth = uf.getSort().getExponentBits-pVg5ArA();
        KExpr<KBoolSort> inNormalRange = uf.inNormalRange();
        KExpr inSubnormalRange = $this$packToBv.not(inNormalRange);
        KExpr biasedExp = $this$packToBv.mkBvAddExpr(uf.getUnbiasedExponent(), (KExpr)UtilsKt.bias($this$packToBv, uf.getSort()));
        KExpr packedBiasedExp = $this$packToBv.mkBvExtractExpr(packedExWidth - 1, 0, biasedExp);
        KBitVecValue<KBvSort> maxExp = UtilsKt.ones-Qn1smSk($this$packToBv, UInt.constructor-impl((int)packedExWidth));
        KBitVecValue minExp = BvUtils.bvZero-Qn1smSk((KContext)$this$packToBv, (int)UInt.constructor-impl((int)packedExWidth));
        KExpr hasMaxExp = $this$packToBv.or(uf.isNaN(), uf.isInf());
        KExpr hasMinExp = $this$packToBv.or(uf.isZero(), inSubnormalRange);
        KExpr hasFixedExp = $this$packToBv.or(hasMaxExp, hasMinExp);
        KExpr packedExp = $this$packToBv.mkIte(hasFixedExp, $this$packToBv.mkIte(hasMaxExp, (KExpr)maxExp, (KExpr)minExp), packedBiasedExp);
        int packedSigWidth = uf.getSort().getSignificandBits-pVg5ArA() - 1;
        KExpr<KBvSort> unpackedSignificand = uf.getNormalizedSignificand();
        int unpackedSignificandWidth = ((KBvSort)uf.getNormalizedSignificand().getSort()).getSizeBits-pVg5ArA();
        if (!(packedSigWidth == unpackedSignificandWidth - 1)) {
            boolean $i$a$-check-PackedKt$packToBv$22 = false;
            String $i$a$-check-PackedKt$packToBv$22 = "Significand width mismatch: " + packedSigWidth + " != " + unpackedSignificandWidth;
            throw new IllegalStateException($i$a$-check-PackedKt$packToBv$22.toString());
        }
        KExpr dropLeadingOne = $this$packToBv.mkBvExtractExpr(packedSigWidth - 1, 0, unpackedSignificand);
        KExpr<KBvSort> subnormalShiftAmount = UtilsKt.max($this$packToBv, (KExpr<KBvSort>)$this$packToBv.mkBvSubExpr((KExpr)UtilsKt.minNormalExponent($this$packToBv, uf.getSort()), uf.getUnbiasedExponent()), (KExpr<KBvSort>)((KExpr)BvUtils.bvZero-Qn1smSk((KContext)$this$packToBv, (int)((KBvSort)uf.getUnbiasedExponent().getSort()).getSizeBits-pVg5ArA())));
        KExpr shiftAmount = ((KBvSort)subnormalShiftAmount.getSort()).getSizeBits-pVg5ArA() <= unpackedSignificandWidth ? PackedKt.matchWidthUnsigned(subnormalShiftAmount, unpackedSignificand) : $this$packToBv.mkBvExtractExpr(unpackedSignificandWidth - 1, 0, subnormalShiftAmount);
        KExpr correctedSubnormal = $this$packToBv.mkBvExtractExpr(packedSigWidth - 1, 0, $this$packToBv.mkBvLogicalShiftRightExpr(unpackedSignificand, shiftAmount));
        KExpr hasFixedSignificand = $this$packToBv.or($this$packToBv.or(uf.isNaN(), uf.isInf()), uf.isZero());
        KExpr<KBvSort> nanBv = OptionalPackedFp.Companion.makeBvNaN($this$packToBv, (KFpSort)uf.getSort()).getSignificand();
        KExpr packedSig = $this$packToBv.mkIte(hasFixedSignificand, $this$packToBv.mkIte(uf.isNaN(), nanBv, (KExpr)BvUtils.bvZero-Qn1smSk((KContext)$this$packToBv, (int)UInt.constructor-impl((int)packedSigWidth))), $this$packToBv.mkIte(inNormalRange, dropLeadingOne, correctedSubnormal));
        return UtilsKt.mkBvConcatExpr($this$packToBv, packedSign, packedExp, packedSig);
    }

    @NotNull
    public static final <Fp extends KFpSort> KExpr<Fp> pack(@NotNull KContext $this$pack, @NotNull KExpr<KBvSort> packed, @NotNull Fp sort) {
        Intrinsics.checkNotNullParameter((Object)$this$pack, (String)"<this>");
        Intrinsics.checkNotNullParameter(packed, (String)"packed");
        Intrinsics.checkNotNullParameter(sort, (String)"sort");
        if (!(((KBvSort)packed.getSort()).getSizeBits-pVg5ArA() == UInt.constructor-impl((int)(sort.getExponentBits-pVg5ArA() + sort.getSignificandBits-pVg5ArA())))) {
            boolean $i$a$-check-PackedKt$pack$22 = false;
            String $i$a$-check-PackedKt$pack$22 = "Packed expression sort size (" + UInt.toString-impl((int)((KBvSort)packed.getSort()).getSizeBits-pVg5ArA()) + ") does not match the sort size (" + UInt.toString-impl((int)sort.getExponentBits-pVg5ArA()) + " + " + UInt.toString-impl((int)sort.getSignificandBits-pVg5ArA()) + ')';
            throw new IllegalStateException($i$a$-check-PackedKt$pack$22.toString());
        }
        int pWidth = ((KBvSort)packed.getSort()).getSizeBits-pVg5ArA();
        int exWidth = sort.getExponentBits-pVg5ArA();
        KExpr packedSignificand = BvSimplificationKt.simplifyBvExtractExpr((KContext)$this$pack, (int)(pWidth - exWidth - 2), (int)0, packed);
        KExpr packedExponent = BvSimplificationKt.simplifyBvExtractExpr((KContext)$this$pack, (int)(pWidth - 2), (int)(pWidth - exWidth - 1), packed);
        KExpr $this$uncheckedCast$iv = BvSimplificationKt.simplifyBvExtractExpr((KContext)$this$pack, (int)(pWidth - 1), (int)(pWidth - 1), packed);
        boolean $i$f$uncheckedCast = false;
        KExpr sign = $this$uncheckedCast$iv;
        return FpSimplificationKt.simplifyFpFromBvExpr((KContext)$this$pack, (KExpr)sign, (KExpr)packedExponent, (KExpr)packedSignificand);
    }

    @NotNull
    public static final KExpr<KBvSort> matchWidthUnsigned(@NotNull KExpr<KBvSort> $this$matchWidthUnsigned, @NotNull KExpr<KBvSort> expr) {
        Intrinsics.checkNotNullParameter($this$matchWidthUnsigned, (String)"<this>");
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        if (!(((KBvSort)$this$matchWidthUnsigned.getSort()).getSizeBits-pVg5ArA() <= ((KBvSort)expr.getSort()).getSizeBits-pVg5ArA())) {
            boolean bl = false;
            String string = "Width mismatch: " + UInt.toString-impl((int)((KBvSort)$this$matchWidthUnsigned.getSort()).getSizeBits-pVg5ArA()) + " <= " + UInt.toString-impl((int)((KBvSort)expr.getSort()).getSizeBits-pVg5ArA());
            throw new IllegalStateException(string.toString());
        }
        if (((KBvSort)$this$matchWidthUnsigned.getSort()).getSizeBits-pVg5ArA() == ((KBvSort)expr.getSort()).getSizeBits-pVg5ArA()) {
            return $this$matchWidthUnsigned;
        }
        return expr.getCtx().mkBvZeroExtensionExpr(((KBvSort)expr.getSort()).getSizeBits-pVg5ArA() - ((KBvSort)$this$matchWidthUnsigned.getSort()).getSizeBits-pVg5ArA(), $this$matchWidthUnsigned);
    }

    @NotNull
    public static final KExpr<KBvSort> matchWidthSigned(@NotNull KExpr<KBvSort> $this$matchWidthSigned, @NotNull KContext ctx, @NotNull KExpr<KBvSort> expr) {
        Intrinsics.checkNotNullParameter($this$matchWidthSigned, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        if (!(((KBvSort)$this$matchWidthSigned.getSort()).getSizeBits-pVg5ArA() <= ((KBvSort)expr.getSort()).getSizeBits-pVg5ArA())) {
            boolean bl = false;
            String string = "Width mismatch: " + UInt.toString-impl((int)((KBvSort)$this$matchWidthSigned.getSort()).getSizeBits-pVg5ArA()) + " <= " + UInt.toString-impl((int)((KBvSort)expr.getSort()).getSizeBits-pVg5ArA());
            throw new IllegalStateException(string.toString());
        }
        if (((KBvSort)$this$matchWidthSigned.getSort()).getSizeBits-pVg5ArA() == ((KBvSort)expr.getSort()).getSizeBits-pVg5ArA()) {
            return $this$matchWidthSigned;
        }
        return ctx.mkBvSignExtensionExpr(((KBvSort)expr.getSort()).getSizeBits-pVg5ArA() - ((KBvSort)$this$matchWidthSigned.getSort()).getSizeBits-pVg5ArA(), $this$matchWidthSigned);
    }
}

