/*
 * Decompiled with CFR 0.152.
 */
package io.ksmt.symfpu.operations;

import io.ksmt.KContext;
import io.ksmt.expr.KExpr;
import io.ksmt.expr.KFpRoundingMode;
import io.ksmt.sort.KBoolSort;
import io.ksmt.sort.KBvSort;
import io.ksmt.sort.KFpRoundingModeSort;
import io.ksmt.sort.KFpSort;
import io.ksmt.symfpu.operations.AddKt;
import io.ksmt.symfpu.operations.ResultWithRemainderBit;
import io.ksmt.symfpu.operations.RoundKt;
import io.ksmt.symfpu.operations.UnpackedFp;
import io.ksmt.symfpu.operations.UnpackedFpKt;
import io.ksmt.symfpu.operations.UtilsKt;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001d\u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\u0006\u0010\u0004\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u0005\u001a4\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0007\"\b\b\u0000\u0010\u0002*\u00020\u00032\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0007H\u0000\u001aB\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0007\"\b\b\u0000\u0010\u0002*\u00020\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0007H\u0000\u001aF\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0007\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u00020\u000f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0007H\u0002\u001aD\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0007\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u00020\u000f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0007\u001a(\u0010\u0012\u001a\u00020\u0013*\u00020\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\fH\u0002\u00a8\u0006\u0017"}, d2={"maximumExponentDifference", "Ljava/math/BigInteger;", "Fp", "Lio/ksmt/sort/KFpSort;", "sort", "(Lio/ksmt/sort/KFpSort;)Ljava/math/BigInteger;", "remainder", "Lio/ksmt/symfpu/operations/UnpackedFp;", "left", "right", "remainderWithRounding", "roundingMode", "Lio/ksmt/expr/KExpr;", "Lio/ksmt/sort/KFpRoundingModeSort;", "addRemainderSpecialCases", "Lio/ksmt/KContext;", "remainderResult", "arithmeticRemainder", "divideStep", "Lio/ksmt/symfpu/operations/ResultWithRemainderBit;", "x", "Lio/ksmt/sort/KBvSort;", "y", "ksmt-symfpu"})
public final class RemainderKt {
    @NotNull
    public static final <Fp extends KFpSort> UnpackedFp<Fp> remainder(@NotNull UnpackedFp<Fp> left, @NotNull UnpackedFp<Fp> right) {
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        KContext $this$remainder_u24lambda_u240 = left.getCtx();
        boolean bl = false;
        return RemainderKt.remainderWithRounding((KExpr<KFpRoundingModeSort>)((KExpr)$this$remainder_u24lambda_u240.mkFpRoundingModeExpr(KFpRoundingMode.RoundNearestTiesToEven)), left, right);
    }

    @NotNull
    public static final <Fp extends KFpSort> UnpackedFp<Fp> remainderWithRounding(@NotNull KExpr<KFpRoundingModeSort> roundingMode, @NotNull UnpackedFp<Fp> left, @NotNull UnpackedFp<Fp> right) {
        Intrinsics.checkNotNullParameter(roundingMode, (String)"roundingMode");
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        KContext $this$remainderWithRounding_u24lambda_u241 = left.getCtx();
        boolean bl = false;
        UnpackedFp<Fp> remainderResult = RemainderKt.arithmeticRemainder($this$remainderWithRounding_u24lambda_u241, roundingMode, left, right);
        return RemainderKt.addRemainderSpecialCases($this$remainderWithRounding_u24lambda_u241, left, right, remainderResult);
    }

    private static final <Fp extends KFpSort> UnpackedFp<Fp> addRemainderSpecialCases(KContext $this$addRemainderSpecialCases, UnpackedFp<Fp> left, UnpackedFp<Fp> right, UnpackedFp<Fp> remainderResult) {
        KExpr eitherArgumentNan = $this$addRemainderSpecialCases.or(left.isNaN(), right.isNaN());
        KExpr generateNan = $this$addRemainderSpecialCases.or(left.isInf(), right.isZero());
        KExpr isNan = $this$addRemainderSpecialCases.or(eitherArgumentNan, generateNan);
        KExpr passThrough = $this$addRemainderSpecialCases.or($this$addRemainderSpecialCases.and($this$addRemainderSpecialCases.not($this$addRemainderSpecialCases.or(left.isInf(), left.isNaN())), right.isInf()), left.isZero());
        return UnpackedFp.Companion.iteOp($this$addRemainderSpecialCases, (KExpr<KBoolSort>)isNan, UnpackedFp.Companion.makeNaN($this$addRemainderSpecialCases, left.getSort()), UnpackedFp.Companion.iteOp($this$addRemainderSpecialCases, (KExpr<KBoolSort>)passThrough, left, remainderResult));
    }

    @NotNull
    public static final <Fp extends KFpSort> UnpackedFp<Fp> arithmeticRemainder(@NotNull KContext $this$arithmeticRemainder, @NotNull KExpr<KFpRoundingModeSort> roundingMode, @NotNull UnpackedFp<Fp> left, @NotNull UnpackedFp<Fp> right) {
        BigInteger maxDifference;
        Intrinsics.checkNotNullParameter((Object)$this$arithmeticRemainder, (String)"<this>");
        Intrinsics.checkNotNullParameter(roundingMode, (String)"roundingMode");
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        KExpr<KBoolSort> remainderSign = left.getSign();
        KExpr<KBvSort> exponentDifference = UtilsKt.expandingSubtractSigned($this$arithmeticRemainder, (KExpr<KBvSort>)UnpackedFp.getExponent$default(left, false, 1, null), (KExpr<KBvSort>)UnpackedFp.getExponent$default(right, false, 1, null));
        int edWidth = ((KBvSort)exponentDifference.getSort()).getSizeBits-pVg5ArA();
        KExpr<KBvSort> lsig = UnpackedFpKt.extendUnsigned((KExpr<KBvSort>)UnpackedFp.getSignificand$default(left, false, 1, null), 1);
        KExpr<KBvSort> rsig = UnpackedFpKt.extendUnsigned((KExpr<KBvSort>)UnpackedFp.getSignificand$default(right, false, 1, null), 1);
        KExpr<KBvSort> running = RemainderKt.divideStep($this$arithmeticRemainder, lsig, rsig).getResult();
        BigInteger bigInteger = maxDifference = RemainderKt.maximumExponentDifference(left.getSort());
        BigInteger bigInteger2 = BigInteger.ONE;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"ONE");
        BigInteger bigInteger3 = bigInteger.subtract(bigInteger2);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"this.subtract(other)");
        BigInteger i = bigInteger3;
        while (i.compareTo(BigInteger.valueOf(0L)) > 0) {
            KExpr needPrevious = $this$arithmeticRemainder.mkBvSignedGreaterExpr(exponentDifference, (KExpr)$this$arithmeticRemainder.mkBv-Qn1smSk(i, edWidth));
            KExpr r = $this$arithmeticRemainder.mkIte(needPrevious, running, lsig);
            running = RemainderKt.divideStep($this$arithmeticRemainder, (KExpr<KBvSort>)r, rsig).getResult();
            BigInteger bigInteger4 = i;
            BigInteger bigInteger5 = BigInteger.ONE;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"ONE");
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger4.subtract(bigInteger5), (String)"this.subtract(other)");
        }
        KExpr lsbRoundActive = $this$arithmeticRemainder.mkBvSignedGreaterExpr(exponentDifference, $this$arithmeticRemainder.mkBvNegationExpr((KExpr)$this$arithmeticRemainder.mkBv-Qn1smSk(1, edWidth)));
        KExpr needPrevious = $this$arithmeticRemainder.mkBvSignedGreaterExpr(exponentDifference, (KExpr)$this$arithmeticRemainder.mkBv-Qn1smSk(0, edWidth));
        KExpr r0 = $this$arithmeticRemainder.mkIte(needPrevious, running, lsig);
        ResultWithRemainderBit dsr = RemainderKt.divideStep($this$arithmeticRemainder, (KExpr<KBvSort>)r0, rsig);
        KExpr integerEven = $this$arithmeticRemainder.or($this$arithmeticRemainder.not(lsbRoundActive), $this$arithmeticRemainder.not(dsr.getRemainderBit()));
        KExpr guardRoundActive = $this$arithmeticRemainder.mkBvSignedGreaterExpr(exponentDifference, $this$arithmeticRemainder.mkBvNegationExpr((KExpr)$this$arithmeticRemainder.mkBv-Qn1smSk(2, edWidth)));
        KExpr rm1 = $this$arithmeticRemainder.mkIte(lsbRoundActive, dsr.getResult(), lsig);
        ResultWithRemainderBit dsrg = RemainderKt.divideStep($this$arithmeticRemainder, (KExpr<KBvSort>)rm1, rsig);
        KExpr guardBit = $this$arithmeticRemainder.and(guardRoundActive, dsrg.getRemainderBit());
        KExpr stickyBit = $this$arithmeticRemainder.not(UtilsKt.isAllZeros($this$arithmeticRemainder, (KExpr<KBvSort>)$this$arithmeticRemainder.mkIte(guardRoundActive, dsrg.getResult(), lsig)));
        UnpackedFp reconstruct = new UnpackedFp($this$arithmeticRemainder, (KFpSort)left.getSort(), (KExpr)remainderSign, UnpackedFp.getExponent$default(right, false, 1, null), $this$arithmeticRemainder.mkBvExtractExpr(((KBvSort)lsig.getSort()).getSizeBits-pVg5ArA() - 1, 1, dsr.getResult()), null, 32, null);
        UnpackedFp candidateResult = UnpackedFp.Companion.iteOp($this$arithmeticRemainder, (KExpr<KBoolSort>)lsbRoundActive, reconstruct.normaliseUpDetectZero(), left);
        KExpr<KBoolSort> bonusSubtract = RoundKt.roundingDecision($this$arithmeticRemainder, roundingMode, remainderSign, (KExpr<KBoolSort>)integerEven, (KExpr<KBoolSort>)guardBit, (KExpr<KBoolSort>)stickyBit, (KExpr<KBoolSort>)((KExpr)$this$arithmeticRemainder.getFalseExpr()));
        UnpackedFp<Fp> signCorrectedRight = right.setSign(left.getSign());
        return UnpackedFp.Companion.iteOp($this$arithmeticRemainder, bonusSubtract, AddKt.sub($this$arithmeticRemainder, candidateResult, signCorrectedRight, roundingMode), candidateResult);
    }

    @NotNull
    public static final <Fp extends KFpSort> BigInteger maximumExponentDifference(@NotNull Fp sort) {
        Intrinsics.checkNotNullParameter(sort, (String)"sort");
        BigInteger bigInteger = BigInteger.ONE;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"ONE");
        BigInteger bigInteger2 = bigInteger;
        int n = UInt.constructor-impl((int)(sort.getExponentBits-pVg5ArA() - 1));
        BigInteger bigInteger3 = bigInteger2.shiftLeft(n);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"this.shiftLeft(n)");
        bigInteger2 = bigInteger3;
        BigInteger bigInteger4 = BigInteger.ONE;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"ONE");
        BigInteger bigInteger5 = bigInteger2.subtract(bigInteger4);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"this.subtract(other)");
        BigInteger maxNormalExp = bigInteger5;
        BigInteger bigInteger6 = maxNormalExp.negate();
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger6, (String)"this.negate()");
        BigInteger bigInteger7 = bigInteger6;
        BigInteger bigInteger8 = BigInteger.valueOf((long)UInt.constructor-impl((int)(sort.getSignificandBits-pVg5ArA() - 2)) & 0xFFFFFFFFL);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger8, (String)"valueOf((sort.significandBits - 2u).toLong())");
        BigInteger bigInteger9 = bigInteger7.subtract(bigInteger8);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger9, (String)"this.subtract(other)");
        BigInteger minSubnormalExp = bigInteger9;
        BigInteger bigInteger10 = maxNormalExp.subtract(minSubnormalExp);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger10, (String)"this.subtract(other)");
        return bigInteger10;
    }

    private static final ResultWithRemainderBit divideStep(KContext $this$divideStep, KExpr<KBvSort> x, KExpr<KBvSort> y) {
        int yWidth;
        int xWidth = ((KBvSort)x.getSort()).getSizeBits-pVg5ArA();
        if (!(xWidth == (yWidth = ((KBvSort)y.getSort()).getSizeBits-pVg5ArA()))) {
            boolean $i$a$-check-RemainderKt$divideStep$32 = false;
            String $i$a$-check-RemainderKt$divideStep$32 = "Divide step requires equal width arguments " + UInt.toString-impl((int)xWidth) + " != " + UInt.toString-impl((int)yWidth);
            throw new IllegalStateException($i$a$-check-RemainderKt$divideStep$32.toString());
        }
        if (!(Integer.compareUnsigned(yWidth, 2) >= 0)) {
            boolean $i$a$-check-RemainderKt$divideStep$42 = false;
            String $i$a$-check-RemainderKt$divideStep$42 = "Divide step requires at least 2 bits width";
            throw new IllegalStateException($i$a$-check-RemainderKt$divideStep$42.toString());
        }
        KExpr canSubtract = $this$divideStep.mkBvUnsignedGreaterOrEqualExpr(x, y);
        KExpr sub = $this$divideStep.mkBvAddExpr(x, $this$divideStep.mkBvNegationExpr(y));
        KExpr step = $this$divideStep.mkIte(canSubtract, sub, x);
        return new ResultWithRemainderBit((KExpr<KBvSort>)$this$divideStep.mkBvShiftLeftExpr(step, (KExpr)$this$divideStep.mkBv-Qn1smSk(1, xWidth)), (KExpr<KBoolSort>)canSubtract);
    }
}

