/*
 * Decompiled with CFR 0.152.
 */
package io.ksmt.symfpu.operations;

import io.ksmt.KContext;
import io.ksmt.expr.KBitVecValue;
import io.ksmt.expr.KExpr;
import io.ksmt.expr.KFpRoundingMode;
import io.ksmt.sort.KBoolSort;
import io.ksmt.sort.KBvSort;
import io.ksmt.sort.KFpRoundingModeSort;
import io.ksmt.sort.KFpSort;
import io.ksmt.symfpu.operations.CustomRounderInfo;
import io.ksmt.symfpu.operations.MultiplyKt;
import io.ksmt.symfpu.operations.ResultWithRemainderBit;
import io.ksmt.symfpu.operations.RoundKt;
import io.ksmt.symfpu.operations.UnpackedFp;
import io.ksmt.symfpu.operations.UtilsKt;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.UnsignedKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001aF\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00020\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001H\u0002\u001a*\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001H\u0002\u001a\u001a\u0010\u000b\u001a\u00020\f*\u00020\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007H\u0002\u001a8\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u00020\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00072\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001H\u0000\u00a8\u0006\u0012"}, d2={"addSqrtSpecialCases", "Lio/ksmt/symfpu/operations/UnpackedFp;", "Fp", "Lio/ksmt/sort/KFpSort;", "Lio/ksmt/KContext;", "uf", "sign", "Lio/ksmt/expr/KExpr;", "Lio/ksmt/sort/KBoolSort;", "sqrtResult", "arithmeticSqrt", "fixedPointSqrt", "Lio/ksmt/symfpu/operations/ResultWithRemainderBit;", "x", "Lio/ksmt/sort/KBvSort;", "sqrt", "roundingMode", "Lio/ksmt/sort/KFpRoundingModeSort;", "ksmt-symfpu"})
public final class SqrtKt {
    private static final ResultWithRemainderBit fixedPointSqrt(KContext $this$fixedPointSqrt, KExpr<KBvSort> x) {
        int inputWidth = ((KBvSort)x.getSort()).getSizeBits-pVg5ArA();
        int outputWidth = UInt.constructor-impl((int)(inputWidth - 1));
        KExpr xcomp = $this$fixedPointSqrt.mkBvConcatExpr(x, (KExpr)$this$fixedPointSqrt.mkBv-Qn1smSk(0, UInt.constructor-impl((int)(inputWidth - 2))));
        KExpr working = $this$fixedPointSqrt.mkBvConcatExpr((KExpr)$this$fixedPointSqrt.mkBv-Qn1smSk(1, 1), (KExpr)$this$fixedPointSqrt.mkBv-Qn1smSk(0, UInt.constructor-impl((int)(outputWidth - 1))));
        int n = UInt.constructor-impl((int)(outputWidth - 1));
        if (UnsignedKt.uintCompare((int)1, (int)n) <= 0) {
            int location;
            do {
                location = n--;
                KBitVecValue shift = $this$fixedPointSqrt.mkBv-Qn1smSk(location - 1, outputWidth);
                KExpr candidate = $this$fixedPointSqrt.mkBvOrExpr(working, $this$fixedPointSqrt.mkBvShiftLeftExpr((KExpr)$this$fixedPointSqrt.mkBv-Qn1smSk(1, outputWidth), (KExpr)shift));
                KExpr addBit = $this$fixedPointSqrt.mkBvUnsignedLessOrEqualExpr(MultiplyKt.expandingMultiply($this$fixedPointSqrt, (KExpr<KBvSort>)candidate, (KExpr<KBvSort>)candidate), xcomp);
                working = $this$fixedPointSqrt.mkBvOrExpr(working, $this$fixedPointSqrt.mkBvShiftLeftExpr($this$fixedPointSqrt.mkBvZeroExtensionExpr(outputWidth - 1, UtilsKt.boolToBv($this$fixedPointSqrt, (KExpr<KBoolSort>)addBit)), (KExpr)shift));
            } while (location != 1);
        }
        return new ResultWithRemainderBit((KExpr<KBvSort>)working, (KExpr<KBoolSort>)$this$fixedPointSqrt.neq(MultiplyKt.expandingMultiply($this$fixedPointSqrt, (KExpr<KBvSort>)working, (KExpr<KBvSort>)working), xcomp));
    }

    private static final <Fp extends KFpSort> UnpackedFp<KFpSort> arithmeticSqrt(KContext $this$arithmeticSqrt, UnpackedFp<Fp> uf) {
        KExpr exponent = UnpackedFp.getExponent$default(uf, false, 1, null);
        int exponentWidth = uf.exponentWidth-pVg5ArA();
        KExpr<KBoolSort> exponentEven = UtilsKt.isAllZeros($this$arithmeticSqrt, (KExpr<KBvSort>)$this$arithmeticSqrt.mkBvAndExpr(exponent, (KExpr)$this$arithmeticSqrt.mkBv-Qn1smSk(1, exponentWidth)));
        KExpr exponentHalved = $this$arithmeticSqrt.mkBvArithShiftRightExpr(exponent, (KExpr)$this$arithmeticSqrt.mkBv-Qn1smSk(1, exponentWidth));
        KExpr<KBvSort> alignedSignificand = MultiplyKt.conditionalLeftShiftOne($this$arithmeticSqrt, (KExpr<KBoolSort>)$this$arithmeticSqrt.not(exponentEven), UtilsKt.mkBvConcatExpr($this$arithmeticSqrt, (KExpr)$this$arithmeticSqrt.mkBv-Qn1smSk(0, 1), UnpackedFp.getSignificand$default(uf, false, 1, null), (KExpr)$this$arithmeticSqrt.mkBv-Qn1smSk(0, 1)));
        ResultWithRemainderBit sqrtd = SqrtKt.fixedPointSqrt($this$arithmeticSqrt, alignedSignificand);
        KExpr finishedSignificand = $this$arithmeticSqrt.mkBvConcatExpr(sqrtd.getResult(), UtilsKt.boolToBv($this$arithmeticSqrt, sqrtd.getRemainderBit()));
        KFpSort extendedFormat = $this$arithmeticSqrt.mkFpSort-feOb9K0(uf.getSort().getExponentBits-pVg5ArA(), UInt.constructor-impl((int)(uf.getSort().getSignificandBits-pVg5ArA() + 2)));
        return new UnpackedFp<KFpSort>($this$arithmeticSqrt, extendedFormat, uf.getSign(), exponentHalved, finishedSignificand, null, 32, null);
    }

    @NotNull
    public static final <Fp extends KFpSort> UnpackedFp<Fp> sqrt(@NotNull KContext $this$sqrt, @NotNull KExpr<KFpRoundingModeSort> roundingMode, @NotNull UnpackedFp<Fp> uf) {
        Intrinsics.checkNotNullParameter((Object)$this$sqrt, (String)"<this>");
        Intrinsics.checkNotNullParameter(roundingMode, (String)"roundingMode");
        Intrinsics.checkNotNullParameter(uf, (String)"uf");
        UnpackedFp<KFpSort> sqrtResult = SqrtKt.arithmeticSqrt($this$sqrt, uf);
        KExpr rtp = $this$sqrt.and(RoundKt.roundingEq($this$sqrt, roundingMode, KFpRoundingMode.RoundTowardPositive), $this$sqrt.not(sqrtResult.getSign()));
        KExpr rtn = $this$sqrt.and(RoundKt.roundingEq($this$sqrt, roundingMode, KFpRoundingMode.RoundTowardNegative), sqrtResult.getSign());
        CustomRounderInfo cri = new CustomRounderInfo((KExpr<KBoolSort>)((KExpr)$this$sqrt.getTrueExpr()), (KExpr<KBoolSort>)((KExpr)$this$sqrt.getTrueExpr()), (KExpr<KBoolSort>)((KExpr)$this$sqrt.getFalseExpr()), (KExpr<KBoolSort>)((KExpr)$this$sqrt.getTrueExpr()), (KExpr<KBoolSort>)$this$sqrt.not($this$sqrt.or(rtp, rtn)));
        UnpackedFp<Fp> roundedSqrtResult = RoundKt.round($this$sqrt, sqrtResult, roundingMode, uf.getSort(), cri);
        return SqrtKt.addSqrtSpecialCases($this$sqrt, uf, roundedSqrtResult.getSign(), roundedSqrtResult);
    }

    private static final <Fp extends KFpSort> UnpackedFp<Fp> addSqrtSpecialCases(KContext $this$addSqrtSpecialCases, UnpackedFp<Fp> uf, KExpr<KBoolSort> sign, UnpackedFp<Fp> sqrtResult) {
        KExpr generateNaN = $this$addSqrtSpecialCases.and(uf.getSign(), $this$addSqrtSpecialCases.not(uf.isZero()));
        KExpr isNaN = $this$addSqrtSpecialCases.or(uf.isNaN(), generateNaN);
        KExpr isInf = $this$addSqrtSpecialCases.and(uf.isInf(), $this$addSqrtSpecialCases.not(uf.getSign()));
        KExpr<KBoolSort> isZero = uf.isZero();
        return UnpackedFp.Companion.iteOp($this$addSqrtSpecialCases, (KExpr<KBoolSort>)isNaN, UnpackedFp.Companion.makeNaN($this$addSqrtSpecialCases, uf.getSort()), UnpackedFp.Companion.iteOp($this$addSqrtSpecialCases, (KExpr<KBoolSort>)isInf, UnpackedFp.Companion.makeInf($this$addSqrtSpecialCases, uf.getSort(), (KExpr<KBoolSort>)((KExpr)$this$addSqrtSpecialCases.getFalseExpr())), UnpackedFp.Companion.iteOp($this$addSqrtSpecialCases, isZero, UnpackedFp.Companion.makeZero($this$addSqrtSpecialCases, uf.getSort(), sign), sqrtResult)));
    }
}

