/*
 * Decompiled with CFR 0.152.
 */
package io.ksmt.symfpu.solver;

import io.ksmt.KContext;
import io.ksmt.expr.KExpr;
import io.ksmt.solver.KModel;
import io.ksmt.solver.KSolver;
import io.ksmt.solver.KSolverConfiguration;
import io.ksmt.solver.KSolverStatus;
import io.ksmt.sort.KBoolSort;
import io.ksmt.symfpu.solver.FpToBvTransformer;
import io.ksmt.symfpu.solver.KSymFpuModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B%\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u001c\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u0018H\u0016J\u0016\u0010\u0019\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u001d\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001e\u0010\u001fJ1\u0010 \u001a\u00020\u001b2\u0012\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\"\u0010#J\b\u0010$\u001a\u00020\u0015H\u0016J!\u0010%\u001a\u00020\u00152\u0017\u0010&\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00150'\u00a2\u0006\u0002\b(H\u0016J\b\u0010)\u001a\u00020\u0015H\u0016J\b\u0010*\u001a\u00020+H\u0016J\u001d\u0010,\u001a\u00020\u00152\u0006\u0010-\u001a\u00020.H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b/\u00100J\b\u00101\u001a\u00020\u0015H\u0016J\b\u00102\u001a\u000203H\u0016J\u0014\u00104\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u0018H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR&\u0010\f\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u00065"}, d2={"Lio/ksmt/symfpu/solver/KSymFpuSolver;", "Config", "Lio/ksmt/solver/KSolverConfiguration;", "Lio/ksmt/solver/KSolver;", "solver", "ctx", "Lio/ksmt/KContext;", "packedBvOptimizationEnabled", "", "(Lio/ksmt/solver/KSolver;Lio/ksmt/KContext;Z)V", "getCtx", "()Lio/ksmt/KContext;", "mapTransformedToOriginalAssertions", "", "Lio/ksmt/expr/KExpr;", "Lio/ksmt/sort/KBoolSort;", "getSolver", "()Lio/ksmt/solver/KSolver;", "transformer", "Lio/ksmt/symfpu/solver/FpToBvTransformer;", "assert", "", "expr", "exprs", "", "assertAndTrack", "check", "Lio/ksmt/solver/KSolverStatus;", "timeout", "Lkotlin/time/Duration;", "check-LRDsOJo", "(J)Lio/ksmt/solver/KSolverStatus;", "checkWithAssumptions", "assumptions", "checkWithAssumptions-HG0u8IE", "(Ljava/util/List;J)Lio/ksmt/solver/KSolverStatus;", "close", "configure", "configurator", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "interrupt", "model", "Lio/ksmt/solver/KModel;", "pop", "n", "Lkotlin/UInt;", "pop-WZ4Q5Ns", "(I)V", "push", "reasonOfUnknown", "", "unsatCore", "ksmt-symfpu"})
public class KSymFpuSolver<Config extends KSolverConfiguration>
implements KSolver<Config> {
    @NotNull
    private final KSolver<Config> solver;
    @NotNull
    private final KContext ctx;
    @NotNull
    private final FpToBvTransformer transformer;
    @NotNull
    private final Map<KExpr<KBoolSort>, KExpr<KBoolSort>> mapTransformedToOriginalAssertions;

    public KSymFpuSolver(@NotNull KSolver<Config> solver, @NotNull KContext ctx, boolean packedBvOptimizationEnabled) {
        Intrinsics.checkNotNullParameter(solver, (String)"solver");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.solver = solver;
        this.ctx = ctx;
        this.transformer = new FpToBvTransformer(this.ctx, packedBvOptimizationEnabled);
        this.mapTransformedToOriginalAssertions = new LinkedHashMap();
    }

    public /* synthetic */ KSymFpuSolver(KSolver kSolver, KContext kContext, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(kSolver, kContext, bl);
    }

    @NotNull
    public final KSolver<Config> getSolver() {
        return this.solver;
    }

    @NotNull
    public final KContext getCtx() {
        return this.ctx;
    }

    public void assert(@NotNull KExpr<KBoolSort> expr) {
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        this.solver.assertExpr(this.transformer.applyAndGetExpr(expr));
    }

    /*
     * WARNING - void declaration
     */
    public void assert(@NotNull List<? extends KExpr<KBoolSort>> exprs) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(exprs, (String)"exprs");
        Iterable iterable = exprs;
        KSolver<Config> kSolver = this.solver;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KExpr kExpr = (KExpr)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.transformer.applyAndGetExpr(it));
        }
        kSolver.assertExprs((List)destination$iv$iv);
    }

    public void assertAndTrack(@NotNull KExpr<KBoolSort> expr) {
        KExpr<KBoolSort> kExpr;
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        KExpr<KBoolSort> it = kExpr = this.transformer.applyAndGetExpr(expr);
        boolean bl = false;
        this.mapTransformedToOriginalAssertions.put(it, expr);
        KExpr<KBoolSort> transformedExpr = kExpr;
        this.solver.assertAndTrack(transformedExpr);
    }

    @NotNull
    public KSolverStatus check-LRDsOJo(long timeout) {
        return this.solver.check(timeout);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public KSolverStatus checkWithAssumptions-HG0u8IE(@NotNull List<? extends KExpr<KBoolSort>> assumptions, long timeout) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(assumptions, (String)"assumptions");
        Iterable iterable = assumptions;
        KSolver<Config> kSolver = this.solver;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void expr;
            KExpr kExpr;
            KExpr kExpr2 = (KExpr)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            KExpr it = kExpr = this.transformer.applyAndGetExpr(expr);
            boolean bl2 = false;
            this.mapTransformedToOriginalAssertions.put(it, (KExpr<KBoolSort>)expr);
            collection.add(kExpr);
        }
        return kSolver.checkWithAssumptions((List)destination$iv$iv, timeout);
    }

    @NotNull
    public KModel model() {
        return new KSymFpuModel(this.solver.model(), this.ctx, this.transformer);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<KExpr<KBoolSort>> unsatCore() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.solver.unsatCore();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KExpr kExpr = (KExpr)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            KExpr<KBoolSort> kExpr2 = this.mapTransformedToOriginalAssertions.get(it);
            if (kExpr2 == null) {
                throw new IllegalStateException("Unsat core contains an expression that was not transformed".toString());
            }
            collection.add(kExpr2);
        }
        return (List)destination$iv$iv;
    }

    public void push() {
        this.solver.push();
    }

    public void pop-WZ4Q5Ns(int n) {
        this.solver.pop(n);
    }

    public void configure(@NotNull Function1<? super Config, Unit> configurator) {
        Intrinsics.checkNotNullParameter(configurator, (String)"configurator");
        this.solver.configure(configurator);
    }

    @NotNull
    public String reasonOfUnknown() {
        return this.solver.reasonOfUnknown();
    }

    public void interrupt() {
        this.solver.interrupt();
    }

    public void close() {
        this.solver.close();
    }
}

