/*
 * Decompiled with CFR 0.152.
 */
package com.sri.yices;

import com.sri.yices.BigRational;
import com.sri.yices.VectorValue;
import com.sri.yices.YVal;
import com.sri.yices.Yices;
import com.sri.yices.YicesException;
import java.math.BigInteger;

public class Model
implements AutoCloseable {
    private long ptr;
    private static long population = 0L;

    public Model() throws RuntimeException {
        this.ptr = Yices.newModel();
        if (this.ptr == 0L) {
            RuntimeException runtimeException = YicesException.checkVersion(2, 6, 4);
            if (runtimeException == null) {
                runtimeException = new RuntimeException("Out of memory");
            }
            throw runtimeException;
        }
        ++population;
    }

    protected Model(long l) {
        this.ptr = l;
        ++population;
    }

    protected long getPtr() {
        return this.ptr;
    }

    public static long getCensus() {
        return population;
    }

    public Model(int[] nArray, int[] nArray2) throws YicesException {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("var and map must have the same length");
        }
        long l = Yices.modelFromMap(nArray, nArray2);
        if (l == 0L) {
            throw new YicesException();
        }
        this.ptr = l;
        ++population;
    }

    @Override
    public void close() {
        if (this.ptr != 0L) {
            Yices.freeModel(this.ptr);
            this.ptr = 0L;
            --population;
        }
    }

    public String toString() {
        return Yices.modelToString(this.ptr);
    }

    public String toString(int n, int n2) {
        return Yices.modelToString(this.ptr, n, n2);
    }

    public boolean boolValue(int n) throws YicesException {
        int n2 = Yices.getBoolValue(this.ptr, n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2 != 0;
    }

    public long integerValue(int n) throws YicesException {
        long[] lArray = new long[1];
        int n2 = Yices.getIntegerValue(this.ptr, n, lArray);
        if (n2 < 0) {
            throw new YicesException();
        }
        return lArray[0];
    }

    public double doubleValue(int n) throws YicesException {
        double[] dArray = new double[1];
        int n2 = Yices.getDoubleValue(this.ptr, n, dArray);
        if (n2 < 0) {
            throw new YicesException();
        }
        return dArray[0];
    }

    public void rationalValue(int n, long[] lArray) throws YicesException {
        if (lArray.length < 2) {
            throw new IllegalArgumentException("array too small");
        }
        int n2 = Yices.getRationalValue(this.ptr, n, lArray);
        if (n2 < 0) {
            throw new YicesException();
        }
    }

    public BigInteger bigIntegerValue(int n) throws YicesException {
        BigInteger bigInteger = Yices.getIntegerValue(this.ptr, n);
        if (bigInteger == null) {
            throw new YicesException();
        }
        return bigInteger;
    }

    public BigRational bigRationalValue(int n) throws YicesException {
        BigRational bigRational = Yices.getRationalValue(this.ptr, n);
        if (bigRational == null) {
            throw new YicesException();
        }
        return bigRational;
    }

    public boolean[] bvValue(int n) throws YicesException {
        boolean[] blArray = Yices.getBvValue(this.ptr, n);
        if (blArray == null) {
            throw new YicesException();
        }
        return blArray;
    }

    public int scalarValue(int n) throws YicesException {
        int n2 = Yices.getScalarValue(this.ptr, n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public int valueAsTerm(int n) throws YicesException {
        int n2 = Yices.valueAsTerm(this.ptr, n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public int[] valuesAsTerms(int[] nArray) throws YicesException {
        if (nArray == null) {
            throw new IllegalArgumentException();
        }
        int[] nArray2 = new int[nArray.length];
        int n = Yices.valuesAsTerms(this.ptr, nArray, nArray2);
        if (n < 0) {
            throw new YicesException();
        }
        return nArray2;
    }

    public void setBoolean(int n, boolean bl) throws YicesException {
        int n2 = Yices.modelSetBool(this.ptr, n, bl ? 1 : 0);
        if (n2 < 0) {
            YicesException yicesException = YicesException.checkVersion(2, 6, 4);
            if (yicesException == null) {
                yicesException = new YicesException();
            }
            throw yicesException;
        }
    }

    public void setInteger(int n, long l) throws YicesException {
        int n2 = Yices.modelSetInteger(this.ptr, n, l);
        if (n2 < 0) {
            YicesException yicesException = YicesException.checkVersion(2, 6, 4);
            if (yicesException == null) {
                yicesException = new YicesException();
            }
            throw yicesException;
        }
    }

    public void setRational(int n, long l, long l2) throws YicesException {
        int n2 = Yices.modelSetRational(this.ptr, n, l, l2);
        if (n2 < 0) {
            YicesException yicesException = YicesException.checkVersion(2, 6, 4);
            if (yicesException == null) {
                yicesException = new YicesException();
            }
            throw yicesException;
        }
    }

    public void setBVInteger(int n, long l) throws YicesException {
        int n2 = Yices.modelSetBVInteger(this.ptr, n, l);
        if (n2 < 0) {
            YicesException yicesException = YicesException.checkVersion(2, 6, 4);
            if (yicesException == null) {
                yicesException = new YicesException();
            }
            throw yicesException;
        }
    }

    public void setBVFromArray(int n, int[] nArray) throws YicesException {
        int n2 = Yices.modelSetBVFromArray(this.ptr, n, nArray);
        if (n2 < 0) {
            YicesException yicesException = YicesException.checkVersion(2, 6, 4);
            if (yicesException == null) {
                yicesException = new YicesException();
            }
            throw yicesException;
        }
    }

    public int[] collectDefinedTerms() {
        int[] nArray = Yices.modelCollectDefinedTerms(this.ptr);
        if (nArray == null) {
            YicesException yicesException = YicesException.checkVersion(2, 6, 4);
            if (yicesException == null) {
                yicesException = new YicesException();
            }
            throw yicesException;
        }
        return nArray;
    }

    public int[] implicant(int n) {
        return Yices.implicantForFormula(this.ptr, n);
    }

    public int[] implicant(int[] nArray) {
        return Yices.implicantForFormulas(this.ptr, nArray);
    }

    public int[] support(int n) throws YicesException {
        int[] nArray = Yices.getSupport(this.ptr, n);
        if (nArray == null) {
            throw new YicesException();
        }
        return nArray;
    }

    public int[] support(int[] nArray) throws YicesException {
        int[] nArray2 = Yices.getSupport(this.ptr, nArray);
        if (nArray2 == null) {
            throw new YicesException();
        }
        return nArray2;
    }

    public YVal getValue(int n) {
        return Yices.getValue(this.ptr, n);
    }

    public boolean isInt(YVal yVal) {
        return Yices.valIsInt(this.ptr, yVal.tag.ordinal(), yVal.id);
    }

    public boolean isLong(YVal yVal) {
        return Yices.valIsLong(this.ptr, yVal.tag.ordinal(), yVal.id);
    }

    public boolean isInteger(YVal yVal) {
        return Yices.valIsLong(this.ptr, yVal.tag.ordinal(), yVal.id);
    }

    public int bitSize(YVal yVal) {
        return Yices.valBitSize(this.ptr, yVal.tag.ordinal(), yVal.id);
    }

    public int tupleArity(YVal yVal) {
        return Yices.valTupleArity(this.ptr, yVal.tag.ordinal(), yVal.id);
    }

    public int mappingArity(YVal yVal) {
        return Yices.valMappingArity(this.ptr, yVal.tag.ordinal(), yVal.id);
    }

    public int functionArity(YVal yVal) {
        return Yices.valFunctionArity(this.ptr, yVal.tag.ordinal(), yVal.id);
    }

    public int functionType(YVal yVal) {
        return Yices.valFunctionType(this.ptr, yVal.tag.ordinal(), yVal.id);
    }

    public boolean boolValue(YVal yVal) throws YicesException {
        int n = Yices.valGetBool(this.ptr, yVal.tag.ordinal(), yVal.id);
        if (n < 0) {
            throw new YicesException();
        }
        return n == 1;
    }

    public long integerValue(YVal yVal) throws YicesException {
        long[] lArray = new long[1];
        int n = Yices.valGetInteger(this.ptr, yVal.tag.ordinal(), yVal.id, lArray);
        if (n < 0) {
            throw new YicesException();
        }
        return lArray[0];
    }

    public double doubleValue(YVal yVal) throws YicesException {
        double[] dArray = new double[1];
        int n = Yices.valGetDouble(this.ptr, yVal.tag.ordinal(), yVal.id, dArray);
        if (n < 0) {
            throw new YicesException();
        }
        return dArray[0];
    }

    public void rationalValue(YVal yVal, long[] lArray) throws YicesException {
        if (lArray.length < 2) {
            throw new IllegalArgumentException("array too small");
        }
        int n = Yices.valGetRational(this.ptr, yVal.tag.ordinal(), yVal.id, lArray);
        if (n < 0) {
            throw new YicesException();
        }
    }

    public BigInteger bigIntegerValue(YVal yVal) throws YicesException {
        BigInteger bigInteger = Yices.valGetInteger(this.ptr, yVal.tag.ordinal(), yVal.id);
        if (bigInteger == null) {
            throw new YicesException();
        }
        return bigInteger;
    }

    public BigRational bigRationalValue(YVal yVal) throws YicesException {
        BigRational bigRational = Yices.valGetRational(this.ptr, yVal.tag.ordinal(), yVal.id);
        if (bigRational == null) {
            throw new YicesException();
        }
        return bigRational;
    }

    public boolean[] bvValue(YVal yVal) throws YicesException {
        boolean[] blArray = Yices.valGetBV(this.ptr, yVal.tag.ordinal(), yVal.id);
        if (blArray == null) {
            throw new YicesException();
        }
        return blArray;
    }

    public int[] scalarValue(YVal yVal) throws YicesException {
        int[] nArray = new int[2];
        int n = Yices.valGetScalar(this.ptr, yVal.tag.ordinal(), yVal.id, nArray);
        if (n < 0) {
            throw new YicesException();
        }
        return nArray;
    }

    public YVal[] expandTuple(YVal yVal) throws YicesException {
        YVal[] yValArray = null;
        int n = this.tupleArity(yVal);
        if (n > 0) {
            yValArray = new YVal[n];
            int n2 = Yices.valExpandTuple(this.ptr, yVal.tag.ordinal(), yVal.id, yValArray);
            if (n2 < 0) {
                throw new YicesException();
            }
        } else {
            throw new YicesException();
        }
        return yValArray;
    }

    public VectorValue expandFunction(YVal yVal) throws YicesException {
        int n = Yices.valFunctionCardinality(this.ptr, yVal.tag.ordinal(), yVal.id);
        if (n < 0) {
            throw new YicesException();
        }
        YVal[] yValArray = new YVal[n];
        YVal[] yValArray2 = new YVal[1];
        int n2 = Yices.valExpandFunction(this.ptr, yVal.tag.ordinal(), yVal.id, yValArray2, yValArray);
        if (n2 < 0) {
            throw new YicesException();
        }
        return new VectorValue(yValArray, yValArray2[0]);
    }

    public VectorValue expandMapping(YVal yVal) throws YicesException {
        YVal[] yValArray = new YVal[1];
        int n = this.mappingArity(yVal);
        if (n <= 0) {
            throw new YicesException();
        }
        YVal[] yValArray2 = new YVal[n];
        int n2 = Yices.valExpandMapping(this.ptr, yVal.tag.ordinal(), yVal.id, yValArray2, yValArray);
        if (n2 < 0) {
            throw new YicesException();
        }
        return new VectorValue(yValArray2, yValArray[0]);
    }
}

