/*
 * Decompiled with CFR 0.152.
 */
package com.sri.yices;

import com.sri.yices.Config;
import com.sri.yices.Model;
import com.sri.yices.Parameters;
import com.sri.yices.Profiler;
import com.sri.yices.Status;
import com.sri.yices.Yices;
import com.sri.yices.YicesException;
import java.util.Collection;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class Context
implements AutoCloseable {
    private long ptr;
    private static long population = 0L;
    private static final int ERROR_STATUS = Status.ERROR.ordinal();

    public static long getCensus() {
        return population;
    }

    public Context() {
        this.ptr = Yices.newContext(0L);
        ++population;
    }

    public Context(Config config) throws YicesException {
        long l = Yices.newContext(config.getPtr());
        if (l == 0L) {
            throw new YicesException();
        }
        this.ptr = l;
        ++population;
    }

    public Context(String string) throws YicesException {
        long l = Yices.newConfig();
        int n = Yices.defaultConfigForLogic(l, string);
        if (n < 0) {
            Yices.freeConfig(l);
            throw new YicesException();
        }
        long l2 = Yices.newContext(l);
        if (l2 == 0L) {
            Yices.freeConfig(l);
            throw new YicesException();
        }
        Yices.freeConfig(l);
        this.ptr = l2;
        ++population;
    }

    public Context(String string, String string2) throws YicesException {
        long l = Yices.newConfig();
        int n = Yices.defaultConfigForLogic(l, string);
        if (n >= 0) {
            n = Yices.setConfig(l, "mode", string2);
        }
        if (n < 0) {
            Yices.freeConfig(l);
            throw new YicesException();
        }
        long l2 = Yices.newContext(l);
        if (l2 == 0L) {
            Yices.freeConfig(l);
            throw new YicesException();
        }
        Yices.freeConfig(l);
        this.ptr = l2;
        ++population;
    }

    protected long getPtr() {
        return this.ptr;
    }

    @Override
    public void close() {
        if (this.ptr != 0L) {
            if (Profiler.enabled) {
                long l = System.nanoTime();
                Yices.freeContext(this.ptr);
                long l2 = System.nanoTime();
                Profiler.delta("Yices.freeContext", l, l2);
            } else {
                Yices.freeContext(this.ptr);
            }
            this.ptr = 0L;
            --population;
        }
    }

    public void enableOption(String string) throws YicesException {
        int n = Yices.contextEnableOption(this.ptr, string);
        if (n < 0) {
            throw new YicesException();
        }
    }

    public void disableOption(String string) throws YicesException {
        int n = Yices.contextDisableOption(this.ptr, string);
        if (n < 0) {
            throw new YicesException();
        }
    }

    public Status getStatus() {
        return Status.idToStatus(Yices.contextStatus(this.ptr));
    }

    public void reset() {
        Yices.resetContext(this.ptr);
    }

    public void push() throws YicesException {
        int n = Yices.push(this.ptr);
        if (n < 0) {
            throw new YicesException();
        }
    }

    public void pop() throws YicesException {
        int n = Yices.pop(this.ptr);
        if (n < 0) {
            throw new YicesException();
        }
    }

    public void stopSearch() {
        Yices.stopSearch(this.ptr);
    }

    public Model getModel() throws YicesException {
        long l = 0L;
        if (Profiler.enabled) {
            long l2 = System.nanoTime();
            l = Yices.getModel(this.ptr, 1);
            long l3 = System.nanoTime();
            Profiler.delta("Yices.getModel", l2, l3);
        } else {
            l = Yices.getModel(this.ptr, 1);
        }
        if (l == 0L) {
            throw new YicesException();
        }
        return new Model(l);
    }

    public void assertFormula(int n) throws YicesException {
        int n2;
        if (Profiler.enabled) {
            long l = System.nanoTime();
            n2 = Yices.assertFormula(this.ptr, n);
            long l2 = System.nanoTime();
            Profiler.delta("Yices.assertFormula", l, l2, true);
        } else {
            n2 = Yices.assertFormula(this.ptr, n);
        }
        if (n2 < 0) {
            throw new YicesException();
        }
    }

    public void assertFormulas(int[] nArray) throws YicesException {
        int n;
        if (Profiler.enabled) {
            long l = System.nanoTime();
            n = Yices.assertFormulas(this.ptr, nArray);
            long l2 = System.nanoTime();
            Profiler.delta("Yices.assertFormulas", l, l2, true);
        } else {
            n = Yices.assertFormulas(this.ptr, nArray);
        }
        if (n < 0) {
            throw new YicesException();
        }
    }

    public void assertFormulas(List<Integer> list) throws YicesException {
        int[] nArray = list.stream().mapToInt(Integer::intValue).toArray();
        this.assertFormulas(nArray);
    }

    public void assertFormulas(Collection<Integer> collection) throws YicesException {
        int[] nArray = collection.stream().mapToInt(Integer::intValue).toArray();
        this.assertFormulas(nArray);
    }

    public void assertBlockingClause() throws YicesException {
        int n = Yices.assertBlockingClause(this.ptr);
        if (n < 0) {
            throw new YicesException();
        }
    }

    private static int doCheck(long l, long l2) throws YicesException {
        int n;
        if (Profiler.enabled) {
            long l3 = System.nanoTime();
            n = Yices.checkContext(l, l2);
            long l4 = System.nanoTime();
            Profiler.delta("Yices.checkContext", l3, l4);
        } else {
            n = Yices.checkContext(l, l2);
        }
        return n;
    }

    private int doCheck(long l) throws YicesException {
        int n = Context.doCheck(this.ptr, l);
        if (n == ERROR_STATUS) {
            throw new YicesException();
        }
        return n;
    }

    public Status check() throws YicesException {
        return this.check(null);
    }

    public Status check(Parameters parameters) throws YicesException {
        int n = this.doCheck(parameters == null ? 0L : parameters.getPtr());
        return Status.idToStatus(n);
    }

    public Status check(int n) throws YicesException {
        return this.doCheckWithTimer(0L, n);
    }

    public Status check(Parameters parameters, int n) throws YicesException {
        return this.doCheckWithTimer(parameters.getPtr(), n);
    }

    private Status doCheckWithTimer(long l, int n) throws YicesException {
        Timer timer = new Timer();
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                Yices.stopSearch(Context.this.ptr);
            }
        };
        long l2 = n < 1 ? 1000L : 1000L * (long)n;
        timer.schedule(timerTask, l2);
        int n2 = Context.doCheck(this.ptr, l);
        timer.cancel();
        if (n2 < 0) {
            throw new YicesException();
        }
        return Status.idToStatus(n2);
    }

    public int getModelInterpolant() {
        int n = Yices.getModelInterpolant(this.ptr);
        if (n < 0) {
            YicesException yicesException = YicesException.checkVersion(2, 6, 4);
            if (yicesException == null) {
                yicesException = new YicesException();
            }
            throw yicesException;
        }
        return n;
    }

    public Status checkWithAssumptions(Parameters parameters, int[] nArray) {
        int n = Yices.checkContextWithAssumptions(this.ptr, parameters.getPtr(), nArray);
        if (n < 0) {
            throw new YicesException();
        }
        return Status.idToStatus(n);
    }

    public Status checkWithAssumptions(int[] nArray) {
        int n = Yices.checkContextWithAssumptions(this.ptr, 0L, nArray);
        if (n < 0) {
            throw new YicesException();
        }
        return Status.idToStatus(n);
    }

    public Status checkWithModel(Parameters parameters, Model model, int[] nArray) {
        int n = Yices.checkContextWithModel(this.ptr, parameters.getPtr(), model.getPtr(), nArray);
        if (n < 0) {
            YicesException yicesException = YicesException.checkVersion(2, 6, 4);
            if (yicesException == null) {
                yicesException = new YicesException();
            }
            throw yicesException;
        }
        return Status.idToStatus(n);
    }

    public int[] getUnsatCore() {
        int[] nArray = Yices.getUnsatCore(this.ptr);
        if (nArray == null) {
            YicesException yicesException = YicesException.checkVersion(2, 6, 4);
            if (yicesException == null) {
                yicesException = new YicesException();
            }
            throw yicesException;
        }
        return nArray;
    }
}

