/*
 * Decompiled with CFR 0.152.
 */
package io.ksmt.solver.yices;

import com.sri.yices.Config;
import io.ksmt.solver.KSolverUnsupportedFeatureException;
import io.ksmt.solver.KTheory;
import io.ksmt.solver.KTheoryKt;
import io.ksmt.solver.yices.KYicesSolverConfiguration;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/ksmt/solver/yices/KYicesSolverConfigurationImpl;", "Lio/ksmt/solver/yices/KYicesSolverConfiguration;", "config", "Lcom/sri/yices/Config;", "(Lcom/sri/yices/Config;)V", "optimizeForTheories", "", "theories", "", "Lio/ksmt/solver/KTheory;", "quantifiersAllowed", "", "setYicesOption", "option", "", "value", "ksmt-yices-core"})
public final class KYicesSolverConfigurationImpl
implements KYicesSolverConfiguration {
    @NotNull
    private final Config config;

    public KYicesSolverConfigurationImpl(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    public void optimizeForTheories(@Nullable Set<? extends KTheory> theories, boolean quantifiersAllowed) {
        Object[] objectArray = (Object[])theories;
        if (objectArray == null || objectArray.isEmpty()) {
            return;
        }
        if (theories.contains(KTheory.FP)) {
            throw new KSolverUnsupportedFeatureException("Unsupported theory " + KTheory.FP);
        }
        objectArray = new KTheory[]{KTheory.LIA, KTheory.LRA, KTheory.NIA, KTheory.NRA};
        if (!((Collection)CollectionsKt.intersect((Iterable)SetsKt.setOf((Object[])objectArray), (Iterable)theories)).isEmpty()) {
            return;
        }
        String theoryStr = KTheoryKt.smtLib2String(theories, (boolean)quantifiersAllowed);
        this.config.defaultConfigForLogic(theoryStr);
    }

    @Override
    public void setYicesOption(@NotNull String option, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.config.set(option, value);
    }

    @Override
    public void setStringParameter(@NotNull String param, @NotNull String value) {
        KYicesSolverConfiguration.DefaultImpls.setStringParameter(this, param, value);
    }

    @Override
    public void setBoolParameter(@NotNull String param, boolean value) {
        KYicesSolverConfiguration.DefaultImpls.setBoolParameter(this, param, value);
    }

    @Override
    public void setIntParameter(@NotNull String param, int value) {
        KYicesSolverConfiguration.DefaultImpls.setIntParameter(this, param, value);
    }

    @Override
    public void setDoubleParameter(@NotNull String param, double value) {
        KYicesSolverConfiguration.DefaultImpls.setDoubleParameter(this, param, value);
    }
}

