/*
 * Decompiled with CFR 0.152.
 */
package io.kstuff.text;

import io.jstuff.util.IntOutput;
import io.kstuff.text.CharMapResult;
import io.kstuff.text.MapResult;
import io.kstuff.text.StringMapper;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0012\u001a\u00020\u000e*\u00020\u000eJ\n\u0010\u0013\u001a\u00020\u000e*\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000f\u0010\u0003R\u0014\u0010\u0010\u001a\u00020\u000eX\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0011\u0010\u0003\u00a8\u0006\u0014"}, d2={"Lio/kstuff/text/JSONStringMapper;", "", "<init>", "()V", "backSlash", "Lio/kstuff/text/CharMapResult;", "doubleQuote", "slash", "backSpace", "formFeed", "newLine", "carriageReturn", "tab", "illegalMessage", "", "getIllegalMessage$annotations", "incompleteMessage", "getIncompleteMessage$annotations", "encodeJSON", "decodeJSON", "string-mapper"})
public final class JSONStringMapper {
    @NotNull
    public static final JSONStringMapper INSTANCE = new JSONStringMapper();
    @NotNull
    private static final CharMapResult backSlash = new CharMapResult(2, '\\');
    @NotNull
    private static final CharMapResult doubleQuote = new CharMapResult(2, '\"');
    @NotNull
    private static final CharMapResult slash = new CharMapResult(2, '/');
    @NotNull
    private static final CharMapResult backSpace = new CharMapResult(2, '\b');
    @NotNull
    private static final CharMapResult formFeed = new CharMapResult(2, '\f');
    @NotNull
    private static final CharMapResult newLine = new CharMapResult(2, '\n');
    @NotNull
    private static final CharMapResult carriageReturn = new CharMapResult(2, '\r');
    @NotNull
    private static final CharMapResult tab = new CharMapResult(2, '\t');
    @NotNull
    private static final String illegalMessage = "Illegal JSON escape sequence";
    @NotNull
    private static final String incompleteMessage = "Incomplete JSON escape sequence";

    private JSONStringMapper() {
    }

    private static /* synthetic */ void getIllegalMessage$annotations() {
    }

    private static /* synthetic */ void getIncompleteMessage$annotations() {
    }

    @NotNull
    public final String encodeJSON(@NotNull String $this$encodeJSON) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeJSON, (String)"<this>");
        return StringMapper.INSTANCE.mapCharacters($this$encodeJSON, (Function1<? super Character, ? extends CharSequence>)((Function1)JSONStringMapper::encodeJSON$lambda$1));
    }

    @NotNull
    public final String decodeJSON(@NotNull String $this$decodeJSON) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeJSON, (String)"<this>");
        return StringMapper.INSTANCE.mapSubstrings($this$decodeJSON, (Function1<? super Integer, ? extends MapResult>)((Function1)arg_0 -> JSONStringMapper.decodeJSON$lambda$3($this$decodeJSON, arg_0)));
    }

    private static final CharSequence encodeJSON$lambda$1(char it) {
        CharSequence charSequence;
        char c = it;
        if (c == '\\') {
            charSequence = "\\\\";
        } else if (c == '\"') {
            charSequence = "\\\"";
        } else {
            boolean bl = ' ' <= c ? c < '\u007f' : false;
            if (bl) {
                charSequence = null;
            } else if (c == '\b') {
                charSequence = "\\b";
            } else if (c == '\f') {
                charSequence = "\\f";
            } else if (c == '\n') {
                charSequence = "\\n";
            } else if (c == '\r') {
                charSequence = "\\r";
            } else if (c == '\t') {
                charSequence = "\\t";
            } else {
                StringBuilder stringBuilder;
                StringBuilder $this$encodeJSON_u24lambda_u241_u24lambda_u240 = stringBuilder = new StringBuilder();
                boolean bl2 = false;
                $this$encodeJSON_u24lambda_u241_u24lambda_u240.append('\\');
                $this$encodeJSON_u24lambda_u241_u24lambda_u240.append('u');
                IntOutput.append4HexLC((Appendable)$this$encodeJSON_u24lambda_u241_u24lambda_u240, (int)it);
                String string = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                charSequence = string;
            }
        }
        return charSequence;
    }

    private static final int decodeJSON$lambda$3$lambda$2(String $this_decodeJSON, int $it) {
        int n;
        try {
            n = StringMapper.INSTANCE.fromHexDigit($this_decodeJSON.charAt($it + 2)) << 12 | StringMapper.INSTANCE.fromHexDigit($this_decodeJSON.charAt($it + 3)) << 8 | StringMapper.INSTANCE.fromHexDigit($this_decodeJSON.charAt($it + 4)) << 4 | StringMapper.INSTANCE.fromHexDigit($this_decodeJSON.charAt($it + 5));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(illegalMessage);
        }
        return n;
    }

    private static final MapResult decodeJSON$lambda$3(String $this_decodeJSON, int it) {
        MapResult mapResult;
        block12: {
            block11: {
                if ($this_decodeJSON.charAt(it) != '\\') break block11;
                switch ($this_decodeJSON.charAt(it + 1)) {
                    case '\\': {
                        mapResult = backSlash;
                        break block12;
                    }
                    case '\"': {
                        mapResult = doubleQuote;
                        break block12;
                    }
                    case '/': {
                        mapResult = slash;
                        break block12;
                    }
                    case 'b': {
                        mapResult = backSpace;
                        break block12;
                    }
                    case 'f': {
                        mapResult = formFeed;
                        break block12;
                    }
                    case 'n': {
                        mapResult = newLine;
                        break block12;
                    }
                    case 'r': {
                        mapResult = carriageReturn;
                        break block12;
                    }
                    case 't': {
                        mapResult = tab;
                        break block12;
                    }
                    case 'u': {
                        mapResult = StringMapper.INSTANCE.buildResult($this_decodeJSON, it, 6, incompleteMessage, (Function0<Integer>)((Function0)() -> JSONStringMapper.decodeJSON$lambda$3$lambda$2($this_decodeJSON, it)));
                        break block12;
                    }
                    default: {
                        throw new IllegalArgumentException(illegalMessage);
                    }
                }
            }
            mapResult = null;
        }
        return mapResult;
    }
}

