/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.auth.jwt;

import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.Payload;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001c\u001a\u00020\u0007H\u0086\u0002J-\u0010\u001d\u001a\u0004\u0018\u0001H\u001e\"\b\b\u0000\u0010\u001e*\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u00072\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001e0 \u00a2\u0006\u0002\u0010!J,\u0010\"\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u0006\"\b\b\u0000\u0010\u001e*\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u00072\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001e0 R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0012\u00a8\u0006#"}, d2={"Lio/ktor/auth/jwt/JWTPayloadHolder;", "", "payload", "Lcom/auth0/jwt/interfaces/Payload;", "(Lcom/auth0/jwt/interfaces/Payload;)V", "audience", "", "", "getAudience", "()Ljava/util/List;", "expiresAt", "Ljava/util/Date;", "getExpiresAt", "()Ljava/util/Date;", "issuedAt", "getIssuedAt", "issuer", "getIssuer", "()Ljava/lang/String;", "jwtId", "getJwtId", "notBefore", "getNotBefore", "getPayload", "()Lcom/auth0/jwt/interfaces/Payload;", "subject", "getSubject", "get", "name", "getClaim", "T", "clazz", "Lkotlin/reflect/KClass;", "(Ljava/lang/String;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "getListClaim", "ktor-auth-jwt"})
public abstract class JWTPayloadHolder {
    @NotNull
    private final Payload payload;

    public JWTPayloadHolder(@NotNull Payload payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        this.payload = payload;
    }

    @NotNull
    public final Payload getPayload() {
        return this.payload;
    }

    @Nullable
    public final String getIssuer() {
        return this.payload.getIssuer();
    }

    @Nullable
    public final String getSubject() {
        return this.payload.getSubject();
    }

    @NotNull
    public final List<String> getAudience() {
        List list = this.payload.getAudience();
        return list == null ? CollectionsKt.emptyList() : list;
    }

    @Nullable
    public final Date getExpiresAt() {
        return this.payload.getExpiresAt();
    }

    @Nullable
    public final Date getNotBefore() {
        return this.payload.getNotBefore();
    }

    @Nullable
    public final Date getIssuedAt() {
        return this.payload.getIssuedAt();
    }

    @Nullable
    public final String getJwtId() {
        return this.payload.getId();
    }

    @Nullable
    public final String get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.payload.getClaim(name).asString();
    }

    @Nullable
    public final <T> T getClaim(@NotNull String name, @NotNull KClass<T> clazz) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        try {
            object = this.payload.getClaim(name).as(JvmClassMappingKt.getJavaObjectType(clazz));
        }
        catch (JWTDecodeException ex) {
            object = null;
        }
        return (T)object;
    }

    @NotNull
    public final <T> List<T> getListClaim(@NotNull String name, @NotNull KClass<T> clazz) {
        List list;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        try {
            list = this.payload.getClaim(name).asList(JvmClassMappingKt.getJavaObjectType(clazz));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"{\n            payload.ge\u2026javaObjectType)\n        }");
        }
        catch (JWTDecodeException ex) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

