/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.auth.jwt;

import com.auth0.jwk.Jwk;
import com.auth0.jwt.algorithms.Algorithm;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u00a8\u0006\u0003"}, d2={"makeAlgorithm", "Lcom/auth0/jwt/algorithms/Algorithm;", "Lcom/auth0/jwk/Jwk;", "ktor-auth-jwt"})
public final class JWTUtilsKt {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final Algorithm makeAlgorithm(@NotNull Jwk $this$makeAlgorithm) {
        Algorithm algorithm;
        Intrinsics.checkNotNullParameter((Object)$this$makeAlgorithm, (String)"<this>");
        String string = $this$makeAlgorithm.getAlgorithm();
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case 66246401: {
                    if (!string.equals("ES384")) break;
                    n = 1;
                    break;
                }
                case 78252174: {
                    if (!string.equals("RS384")) break;
                    n = 2;
                    break;
                }
                case 66245349: {
                    if (!string.equals("ES256")) break;
                    n = 3;
                    break;
                }
                case 78251122: {
                    if (!string.equals("RS256")) break;
                    n = 4;
                    break;
                }
                case 66248104: {
                    if (!string.equals("ES512")) break;
                    n = 5;
                    break;
                }
                case 78253877: {
                    if (!string.equals("RS512")) break;
                    n = 6;
                    break;
                }
            }
            switch (n) {
                case 4: {
                    PublicKey publicKey = $this$makeAlgorithm.getPublicKey();
                    if (publicKey == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
                    }
                    Algorithm algorithm2 = Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)publicKey), null);
                    Intrinsics.checkNotNullExpressionValue((Object)algorithm2, (String)"RSA256(publicKey as RSAPublicKey, null)");
                    algorithm = algorithm2;
                    return algorithm;
                }
                case 2: {
                    PublicKey publicKey = $this$makeAlgorithm.getPublicKey();
                    if (publicKey == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
                    }
                    Algorithm algorithm3 = Algorithm.RSA384((RSAPublicKey)((RSAPublicKey)publicKey), null);
                    Intrinsics.checkNotNullExpressionValue((Object)algorithm3, (String)"RSA384(publicKey as RSAPublicKey, null)");
                    algorithm = algorithm3;
                    return algorithm;
                }
                case 6: {
                    PublicKey publicKey = $this$makeAlgorithm.getPublicKey();
                    if (publicKey == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
                    }
                    Algorithm algorithm4 = Algorithm.RSA512((RSAPublicKey)((RSAPublicKey)publicKey), null);
                    Intrinsics.checkNotNullExpressionValue((Object)algorithm4, (String)"RSA512(publicKey as RSAPublicKey, null)");
                    algorithm = algorithm4;
                    return algorithm;
                }
                case 3: {
                    PublicKey publicKey = $this$makeAlgorithm.getPublicKey();
                    if (publicKey == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
                    }
                    Algorithm algorithm5 = Algorithm.ECDSA256((ECPublicKey)((ECPublicKey)publicKey), null);
                    Intrinsics.checkNotNullExpressionValue((Object)algorithm5, (String)"ECDSA256(publicKey as ECPublicKey, null)");
                    algorithm = algorithm5;
                    return algorithm;
                }
                case 1: {
                    PublicKey publicKey = $this$makeAlgorithm.getPublicKey();
                    if (publicKey == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
                    }
                    Algorithm algorithm6 = Algorithm.ECDSA384((ECPublicKey)((ECPublicKey)publicKey), null);
                    Intrinsics.checkNotNullExpressionValue((Object)algorithm6, (String)"ECDSA384(publicKey as ECPublicKey, null)");
                    algorithm = algorithm6;
                    return algorithm;
                }
                case 5: {
                    PublicKey publicKey = $this$makeAlgorithm.getPublicKey();
                    if (publicKey == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
                    }
                    Algorithm algorithm7 = Algorithm.ECDSA512((ECPublicKey)((ECPublicKey)publicKey), null);
                    Intrinsics.checkNotNullExpressionValue((Object)algorithm7, (String)"ECDSA512(publicKey as ECPublicKey, null)");
                    algorithm = algorithm7;
                    return algorithm;
                }
                default: {
                    throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Unsupported algorithm ", (Object)$this$makeAlgorithm.getAlgorithm()));
                }
            }
        }
        PublicKey publicKey = $this$makeAlgorithm.getPublicKey();
        if (publicKey == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
        }
        Algorithm algorithm8 = Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)publicKey), null);
        Intrinsics.checkNotNullExpressionValue((Object)algorithm8, (String)"RSA256(publicKey as RSAPublicKey, null)");
        algorithm = algorithm8;
        return algorithm;
    }
}

