/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.engine.android;

import io.ktor.client.engine.HttpClientEngineCapability;
import io.ktor.client.engine.android.AndroidURLConnectionUtilsKt;
import io.ktor.client.network.sockets.TimeoutExceptionsCommonKt;
import io.ktor.client.plugins.HttpTimeout;
import io.ktor.client.plugins.HttpTimeoutKt;
import io.ktor.client.request.HttpRequestData;
import io.ktor.util.cio.ByteBufferPoolKt;
import io.ktor.utils.io.ByteReadChannel;
import io.ktor.utils.io.jvm.javaio.ReadingKt;
import io.ktor.utils.io.pool.ObjectPool;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.YieldKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0002\u001a\u0014\u0010\n\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0014\u0010\u000e\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0006H\u0000\u001a7\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u0011*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u00110\u0013H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0015"}, d2={"content", "Lio/ktor/utils/io/ByteReadChannel;", "Ljava/net/HttpURLConnection;", "callContext", "Lkotlin/coroutines/CoroutineContext;", "request", "Lio/ktor/client/request/HttpRequestData;", "isTimeoutException", "", "", "setupRequestTimeoutAttributes", "", "timeoutAttributes", "Lio/ktor/client/plugins/HttpTimeout$HttpTimeoutCapabilityConfiguration;", "setupTimeoutAttributes", "requestData", "timeoutAwareConnection", "T", "block", "Lkotlin/Function1;", "(Ljava/net/HttpURLConnection;Lio/ktor/client/request/HttpRequestData;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ktor-client-android"})
public final class AndroidURLConnectionUtilsKt {
    public static final void setupTimeoutAttributes(@NotNull HttpURLConnection $this$setupTimeoutAttributes, @NotNull HttpRequestData requestData) {
        block2: {
            long it;
            Intrinsics.checkNotNullParameter((Object)$this$setupTimeoutAttributes, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)requestData, (String)"requestData");
            HttpTimeout.HttpTimeoutCapabilityConfiguration httpTimeoutCapabilityConfiguration = (HttpTimeout.HttpTimeoutCapabilityConfiguration)requestData.getCapabilityOrNull((HttpClientEngineCapability)HttpTimeout.Plugin);
            if (httpTimeoutCapabilityConfiguration == null) break block2;
            HttpTimeout.HttpTimeoutCapabilityConfiguration timeoutAttributes = httpTimeoutCapabilityConfiguration;
            boolean bl = false;
            Long l = timeoutAttributes.getConnectTimeoutMillis();
            if (l != null) {
                it = ((Number)l).longValue();
                boolean bl2 = false;
                $this$setupTimeoutAttributes.setConnectTimeout(HttpTimeoutKt.convertLongTimeoutToIntWithInfiniteAsZero((long)it));
            }
            Long l2 = timeoutAttributes.getSocketTimeoutMillis();
            if (l2 != null) {
                it = ((Number)l2).longValue();
                boolean bl3 = false;
                $this$setupTimeoutAttributes.setReadTimeout(HttpTimeoutKt.convertLongTimeoutToIntWithInfiniteAsZero((long)it));
            }
            AndroidURLConnectionUtilsKt.setupRequestTimeoutAttributes($this$setupTimeoutAttributes, timeoutAttributes);
        }
    }

    private static final void setupRequestTimeoutAttributes(HttpURLConnection $this$setupRequestTimeoutAttributes, HttpTimeout.HttpTimeoutCapabilityConfiguration timeoutAttributes) {
        block1: {
            Long l = timeoutAttributes.getRequestTimeoutMillis();
            if (l == null) break block1;
            long requestTimeout = ((Number)l).longValue();
            boolean bl = false;
            if (requestTimeout != Long.MAX_VALUE && ($this$setupRequestTimeoutAttributes.getConnectTimeout() == 0 || (long)$this$setupRequestTimeoutAttributes.getConnectTimeout() > requestTimeout)) {
                $this$setupRequestTimeoutAttributes.setConnectTimeout(HttpTimeoutKt.convertLongTimeoutToIntWithInfiniteAsZero((long)requestTimeout));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final <T> Object timeoutAwareConnection(@NotNull HttpURLConnection var0, @NotNull HttpRequestData var1_1, @NotNull Function1<? super HttpURLConnection, ? extends T> var2_2, @NotNull Continuation<? super T> var3_3) {
        if (!(var3_3 instanceof timeoutAwareConnection.1)) ** GOTO lbl-1000
        var6_4 = var3_3;
        if ((var6_4.label & -2147483648) != 0) {
            var6_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var3_3){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AndroidURLConnectionUtilsKt.timeoutAwareConnection(null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                try {
                    return block.invoke((Object)$this$timeoutAwareConnection);
                }
                catch (Throwable cause) {
                    $continuation.L$0 = request;
                    $continuation.L$1 = cause;
                    $continuation.label = 1;
                    v0 = YieldKt.yield($continuation);
                    if (v0 == var7_6) {
                        return var7_6;
                    }
                    ** GOTO lbl28
                }
            }
            case 1: {
                cause = (Throwable)$continuation.L$1;
                request = (HttpRequestData)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                throw AndroidURLConnectionUtilsKt.isTimeoutException(cause) != false ? (Throwable)HttpTimeoutKt.ConnectTimeoutException((HttpRequestData)request, (Throwable)cause) : cause;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static final ByteReadChannel content(@NotNull HttpURLConnection $this$content, @NotNull CoroutineContext callContext, @NotNull HttpRequestData request) {
        Object object;
        BufferedInputStream bufferedInputStream;
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)$this$content, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)callContext, (String)"callContext");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            BufferedInputStream bufferedInputStream2;
            InputStream inputStream2 = $this$content.getInputStream();
            if (inputStream2 != null) {
                inputStream = inputStream2;
                int n = 8192;
                bufferedInputStream2 = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n);
            } else {
                bufferedInputStream2 = null;
            }
            bufferedInputStream = bufferedInputStream2;
        }
        catch (IOException _) {
            BufferedInputStream bufferedInputStream3;
            InputStream inputStream3 = $this$content.getErrorStream();
            if (inputStream3 != null) {
                InputStream inputStream4 = inputStream3;
                int n = 8192;
                bufferedInputStream3 = inputStream4 instanceof BufferedInputStream ? (BufferedInputStream)inputStream4 : new BufferedInputStream(inputStream4, n);
            } else {
                bufferedInputStream3 = null;
            }
            bufferedInputStream = bufferedInputStream3;
        }
        BufferedInputStream bufferedInputStream4 = bufferedInputStream;
        if (bufferedInputStream4 != null && (bufferedInputStream = ReadingKt.toByteReadChannel((InputStream)bufferedInputStream4, (CoroutineContext)callContext, (ObjectPool)ByteBufferPoolKt.getKtorDefaultPool())) != null) {
            BufferedInputStream it = bufferedInputStream;
            boolean bl = false;
            inputStream = TimeoutExceptionsCommonKt.mapEngineExceptions((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)callContext), (ByteReadChannel)it, (HttpRequestData)request);
            if (inputStream != null) {
                object = inputStream;
                return object;
            }
        }
        object = ByteReadChannel.Companion.getEmpty();
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isTimeoutException(Throwable $this$isTimeoutException) {
        if ($this$isTimeoutException instanceof SocketTimeoutException) return true;
        if (!($this$isTimeoutException instanceof ConnectException)) return false;
        String string = $this$isTimeoutException.getMessage();
        if (string == null) return false;
        boolean bl = StringsKt.contains$default((CharSequence)string, (CharSequence)"timed out", (boolean)false, (int)2, null);
        if (!bl) return false;
        return true;
    }
}

