/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.engine.android;

import io.ktor.client.engine.HttpClientEngineCapability;
import io.ktor.client.engine.android.AndroidURLConnectionUtilsKt;
import io.ktor.client.plugins.HttpTimeoutCapability;
import io.ktor.client.plugins.HttpTimeoutConfig;
import io.ktor.client.plugins.HttpTimeoutKt;
import io.ktor.client.request.HttpRequestData;
import io.ktor.http.HttpStatusCode;
import io.ktor.util.cio.ByteBufferPoolKt;
import io.ktor.utils.io.ByteReadChannel;
import io.ktor.utils.io.jvm.javaio.ReadingKt;
import io.ktor.utils.io.pool.ObjectPool;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.YieldKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u001b\u0010\u0004\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u001b\u0010\b\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\b\u0010\t\u001a6\u0010\u000e\u001a\u00028\u0000\"\u0004\b\u0000\u0010\n*\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00028\u00000\fH\u0080@\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a#\u0010\u0015\u001a\u00020\u0014*\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001a\u0013\u0010\u0019\u001a\u00020\u0018*\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Ljava/net/HttpURLConnection;", "Lio/ktor/client/request/HttpRequestData;", "requestData", "", "setupTimeoutAttributes", "(Ljava/net/HttpURLConnection;Lio/ktor/client/request/HttpRequestData;)V", "Lio/ktor/client/plugins/HttpTimeoutConfig;", "timeoutAttributes", "setupRequestTimeoutAttributes", "(Ljava/net/HttpURLConnection;Lio/ktor/client/plugins/HttpTimeoutConfig;)V", "T", "request", "Lkotlin/Function1;", "block", "timeoutAwareConnection", "(Ljava/net/HttpURLConnection;Lio/ktor/client/request/HttpRequestData;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "status", "Lkotlin/coroutines/CoroutineContext;", "callContext", "Lio/ktor/utils/io/ByteReadChannel;", "content", "(Ljava/net/HttpURLConnection;ILkotlin/coroutines/CoroutineContext;)Lio/ktor/utils/io/ByteReadChannel;", "", "", "isTimeoutException", "(Ljava/lang/Throwable;)Z", "ktor-client-android"})
@SourceDebugExtension(value={"SMAP\nAndroidURLConnectionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidURLConnectionUtils.kt\nio/ktor/client/engine/android/AndroidURLConnectionUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1#2:93\n*E\n"})
public final class AndroidURLConnectionUtilsKt {
    public static final void setupTimeoutAttributes(@NotNull HttpURLConnection $this$setupTimeoutAttributes, @NotNull HttpRequestData requestData) {
        block2: {
            long it;
            Intrinsics.checkNotNullParameter((Object)$this$setupTimeoutAttributes, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)requestData, (String)"requestData");
            HttpTimeoutConfig httpTimeoutConfig = (HttpTimeoutConfig)requestData.getCapabilityOrNull((HttpClientEngineCapability)HttpTimeoutCapability.INSTANCE);
            if (httpTimeoutConfig == null) break block2;
            HttpTimeoutConfig timeoutAttributes = httpTimeoutConfig;
            boolean bl = false;
            Long l = timeoutAttributes.getConnectTimeoutMillis();
            if (l != null) {
                it = ((Number)l).longValue();
                boolean bl2 = false;
                $this$setupTimeoutAttributes.setConnectTimeout(HttpTimeoutKt.convertLongTimeoutToIntWithInfiniteAsZero((long)it));
            }
            Long l2 = timeoutAttributes.getSocketTimeoutMillis();
            if (l2 != null) {
                it = ((Number)l2).longValue();
                boolean bl3 = false;
                $this$setupTimeoutAttributes.setReadTimeout(HttpTimeoutKt.convertLongTimeoutToIntWithInfiniteAsZero((long)it));
            }
            AndroidURLConnectionUtilsKt.setupRequestTimeoutAttributes($this$setupTimeoutAttributes, timeoutAttributes);
        }
    }

    private static final void setupRequestTimeoutAttributes(HttpURLConnection $this$setupRequestTimeoutAttributes, HttpTimeoutConfig timeoutAttributes) {
        block1: {
            Long l = timeoutAttributes.getRequestTimeoutMillis();
            if (l == null) break block1;
            long requestTimeout = ((Number)l).longValue();
            boolean bl = false;
            if (requestTimeout != Long.MAX_VALUE && ($this$setupRequestTimeoutAttributes.getConnectTimeout() == 0 || (long)$this$setupRequestTimeoutAttributes.getConnectTimeout() > requestTimeout)) {
                $this$setupRequestTimeoutAttributes.setConnectTimeout(HttpTimeoutKt.convertLongTimeoutToIntWithInfiniteAsZero((long)requestTimeout));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final <T> Object timeoutAwareConnection(@NotNull HttpURLConnection var0, @NotNull HttpRequestData var1_1, @NotNull Function1<? super HttpURLConnection, ? extends T> var2_2, @NotNull Continuation<? super T> $completion) {
        if (!($completion instanceof timeoutAwareConnection.1)) ** GOTO lbl-1000
        var6_4 = $completion;
        if ((var6_4.label & -2147483648) != 0) {
            var6_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AndroidURLConnectionUtilsKt.timeoutAwareConnection(null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                try {
                    return block.invoke((Object)$this$timeoutAwareConnection);
                }
                catch (Throwable cause) {
                    $continuation.L$0 = request;
                    $continuation.L$1 = cause;
                    $continuation.label = 1;
                    v0 = YieldKt.yield($continuation);
                    if (v0 == var7_6) {
                        return var7_6;
                    }
                    ** GOTO lbl28
                }
            }
            case 1: {
                cause = (Throwable)$continuation.L$1;
                request = (HttpRequestData)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                throw AndroidURLConnectionUtilsKt.isTimeoutException(cause) != false ? (Throwable)HttpTimeoutKt.ConnectTimeoutException((HttpRequestData)request, (Throwable)cause) : cause;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public static final ByteReadChannel content(@NotNull HttpURLConnection $this$content, int status, @NotNull CoroutineContext callContext) {
        BufferedInputStream bufferedInputStream;
        Intrinsics.checkNotNullParameter((Object)$this$content, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)callContext, (String)"callContext");
        Object[] objectArray = new Integer[]{HttpStatusCode.Companion.getNotModified().getValue(), HttpStatusCode.Companion.getNoContent().getValue()};
        if (CollectionsKt.listOf((Object[])objectArray).contains(status)) {
            return ByteReadChannel.Companion.getEmpty();
        }
        try {
            BufferedInputStream bufferedInputStream2;
            InputStream inputStream = $this$content.getInputStream();
            if (inputStream != null) {
                InputStream inputStream2 = inputStream;
                int n = 8192;
                bufferedInputStream2 = inputStream2 instanceof BufferedInputStream ? (BufferedInputStream)inputStream2 : new BufferedInputStream(inputStream2, n);
            } else {
                bufferedInputStream2 = null;
            }
            bufferedInputStream = bufferedInputStream2;
        }
        catch (IOException iOException) {
            BufferedInputStream bufferedInputStream3;
            InputStream inputStream = $this$content.getErrorStream();
            if (inputStream != null) {
                InputStream inputStream3 = inputStream;
                int n = 8192;
                bufferedInputStream3 = inputStream3 instanceof BufferedInputStream ? (BufferedInputStream)inputStream3 : new BufferedInputStream(inputStream3, n);
            } else {
                bufferedInputStream3 = null;
            }
            bufferedInputStream = bufferedInputStream3;
        }
        objectArray = bufferedInputStream;
        return objectArray != null && (bufferedInputStream = ReadingKt.toByteReadChannel((InputStream)((InputStream)objectArray), (CoroutineContext)callContext, (ObjectPool)ByteBufferPoolKt.getKtorDefaultPool())) != null ? bufferedInputStream : ByteReadChannel.Companion.getEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isTimeoutException(Throwable $this$isTimeoutException) {
        if ($this$isTimeoutException instanceof SocketTimeoutException) return true;
        if (!($this$isTimeoutException instanceof ConnectException)) return false;
        String string = $this$isTimeoutException.getMessage();
        if (string == null) return false;
        boolean bl = StringsKt.contains$default((CharSequence)string, (CharSequence)"timed out", (boolean)false, (int)2, null);
        if (!bl) return false;
        return true;
    }
}

