/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.features.auth.providers;

import io.ktor.client.features.auth.AuthProvider;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.http.HttpHeaders;
import io.ktor.http.auth.HttpAuthHeader;
import io.ktor.util.Base64Kt;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.io.charsets.CharsetJVMKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0013"}, d2={"Lio/ktor/client/features/auth/providers/BasicAuthProvider;", "Lio/ktor/client/features/auth/AuthProvider;", "username", "", "password", "realm", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "defaultCharset", "Ljava/nio/charset/Charset;", "addRequestHeaders", "", "request", "Lio/ktor/client/request/HttpRequestBuilder;", "(Lio/ktor/client/request/HttpRequestBuilder;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "constructBasicAuthValue", "isApplicable", "", "auth", "Lio/ktor/http/auth/HttpAuthHeader;", "ktor-client-auth"})
public final class BasicAuthProvider
implements AuthProvider {
    private final Charset defaultCharset;
    private final String username;
    private final String password;
    private final String realm;

    @Override
    public boolean isApplicable(@NotNull HttpAuthHeader auth) {
        Intrinsics.checkParameterIsNotNull((Object)auth, (String)"auth");
        if (Intrinsics.areEqual((Object)auth.getAuthScheme(), (Object)"Basic") ^ true) {
            return false;
        }
        if (this.realm != null) {
            if (!(auth instanceof HttpAuthHeader.Parameterized)) {
                return false;
            }
            return Intrinsics.areEqual((Object)((HttpAuthHeader.Parameterized)auth).parameter("realm"), (Object)this.realm);
        }
        return true;
    }

    @Override
    @Nullable
    public Object addRequestHeaders(@NotNull HttpRequestBuilder request, @NotNull Continuation<? super Unit> $completion) {
        request.getHeaders().set(HttpHeaders.INSTANCE.getAuthorization(), this.constructBasicAuthValue(this.username, this.password));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final String constructBasicAuthValue(String username, String password) {
        void $this$toByteArray$iv;
        String authString;
        String string = authString = username + ':' + password;
        Charset charset$iv = this.defaultCharset;
        boolean $i$f$toByteArray = false;
        CharsetEncoder charsetEncoder = charset$iv.newEncoder();
        Intrinsics.checkExpressionValueIsNotNull((Object)charsetEncoder, (String)"charset.newEncoder()");
        String authBuf = Base64Kt.encodeBase64((byte[])CharsetJVMKt.encodeToByteArray((CharsetEncoder)charsetEncoder, (CharSequence)((CharSequence)$this$toByteArray$iv), (int)0, (int)$this$toByteArray$iv.length()));
        return "Basic " + authBuf;
    }

    public BasicAuthProvider(@NotNull String username, @NotNull String password, @Nullable String realm) {
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        this.username = username;
        this.password = password;
        this.realm = realm;
        this.defaultCharset = Charsets.UTF_8;
    }
}

