/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.plugins.compression;

import io.ktor.util.CaseInsensitiveMap;
import io.ktor.util.ContentEncoder;
import io.ktor.util.DeflateEncoder;
import io.ktor.util.GZipEncoder;
import io.ktor.util.IdentityEncoder;
import io.ktor.utils.io.KtorDsl;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KtorDsl
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00062\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0016J\u0017\u0010\u0017\u001a\u00020\u00132\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0018J\u0017\u0010\u0019\u001a\u00020\u00132\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\u00132\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0018R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00100\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\b\u00a8\u0006\u001c"}, d2={"Lio/ktor/client/plugins/compression/ContentEncodingConfig;", "", "()V", "encoders", "", "", "Lio/ktor/util/ContentEncoder;", "getEncoders$ktor_client_encoding", "()Ljava/util/Map;", "mode", "Lio/ktor/client/plugins/compression/ContentEncodingConfig$Mode;", "getMode", "()Lio/ktor/client/plugins/compression/ContentEncodingConfig$Mode;", "setMode", "(Lio/ktor/client/plugins/compression/ContentEncodingConfig$Mode;)V", "qualityValues", "", "getQualityValues$ktor_client_encoding", "customEncoder", "", "encoder", "quality", "(Lio/ktor/util/ContentEncoder;Ljava/lang/Float;)V", "deflate", "(Ljava/lang/Float;)V", "gzip", "identity", "Mode", "ktor-client-encoding"})
public final class ContentEncodingConfig {
    @NotNull
    private final Map<String, ContentEncoder> encoders = (Map)new CaseInsensitiveMap();
    @NotNull
    private final Map<String, Float> qualityValues = (Map)new CaseInsensitiveMap();
    @NotNull
    private Mode mode = Mode.DecompressResponse;

    @NotNull
    public final Map<String, ContentEncoder> getEncoders$ktor_client_encoding() {
        return this.encoders;
    }

    @NotNull
    public final Map<String, Float> getQualityValues$ktor_client_encoding() {
        return this.qualityValues;
    }

    @NotNull
    public final Mode getMode() {
        return this.mode;
    }

    public final void setMode(@NotNull Mode mode) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"<set-?>");
        this.mode = mode;
    }

    public final void gzip(@Nullable Float quality) {
        this.customEncoder((ContentEncoder)GZipEncoder.INSTANCE, quality);
    }

    public static /* synthetic */ void gzip$default(ContentEncodingConfig contentEncodingConfig, Float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = null;
        }
        contentEncodingConfig.gzip(f);
    }

    public final void deflate(@Nullable Float quality) {
        this.customEncoder((ContentEncoder)DeflateEncoder.INSTANCE, quality);
    }

    public static /* synthetic */ void deflate$default(ContentEncodingConfig contentEncodingConfig, Float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = null;
        }
        contentEncodingConfig.deflate(f);
    }

    public final void identity(@Nullable Float quality) {
        this.customEncoder((ContentEncoder)IdentityEncoder.INSTANCE, quality);
    }

    public static /* synthetic */ void identity$default(ContentEncodingConfig contentEncodingConfig, Float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = null;
        }
        contentEncodingConfig.identity(f);
    }

    public final void customEncoder(@NotNull ContentEncoder encoder, @Nullable Float quality) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        String name = encoder.getName();
        String string = name.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        this.encoders.put(string, encoder);
        if (quality == null) {
            this.qualityValues.remove(name);
        } else {
            this.qualityValues.put(name, quality);
        }
    }

    public static /* synthetic */ void customEncoder$default(ContentEncodingConfig contentEncodingConfig, ContentEncoder contentEncoder, Float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = null;
        }
        contentEncodingConfig.customEncoder(contentEncoder, f);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0004\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lio/ktor/client/plugins/compression/ContentEncodingConfig$Mode;", "", "request", "", "response", "(Ljava/lang/String;IZZ)V", "getRequest$ktor_client_encoding", "()Z", "getResponse$ktor_client_encoding", "CompressRequest", "DecompressResponse", "All", "ktor-client-encoding"})
    public static final class Mode
    extends Enum<Mode> {
        private final boolean request;
        private final boolean response;
        public static final /* enum */ Mode CompressRequest = new Mode(true, false);
        public static final /* enum */ Mode DecompressResponse = new Mode(false, true);
        public static final /* enum */ Mode All = new Mode(true, true);
        private static final /* synthetic */ Mode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Mode(boolean request, boolean response) {
            this.request = request;
            this.response = response;
        }

        public final boolean getRequest$ktor_client_encoding() {
            return this.request;
        }

        public final boolean getResponse$ktor_client_encoding() {
            return this.response;
        }

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        @NotNull
        public static EnumEntries<Mode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.CompressRequest, Mode.DecompressResponse, Mode.All};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

