/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.engine.mock;

import io.ktor.client.engine.HttpClientEngine;
import io.ktor.client.engine.HttpClientEngineBase;
import io.ktor.client.engine.HttpClientEngineCapability;
import io.ktor.client.engine.HttpClientEngineFactory;
import io.ktor.client.engine.UtilsKt;
import io.ktor.client.engine.mock.MockEngine;
import io.ktor.client.engine.mock.MockEngineConfig;
import io.ktor.client.engine.mock.MockRequestHandleScope;
import io.ktor.client.plugins.HttpTimeoutCapability;
import io.ktor.client.plugins.websocket.WebSocketCapability;
import io.ktor.client.plugins.websocket.WebSocketExtensionsCapability;
import io.ktor.client.request.HttpRequestData;
import io.ktor.client.request.HttpResponseData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\b\b\u0016\u0018\u0000 .2\u00020\u0001:\u0002/.B\u0019\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0096@\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R(\u0010\u0017\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u00150\u00148\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u0018\u0010\u001c\u001a\u00060\u0016j\u0002`\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001f\u001a\u00020\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000b0!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010#R\u0016\u0010&\u001a\u00020%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0017\u0010+\u001a\b\u0012\u0004\u0012\u00020\t0(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0017\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000b0(8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010*\u00a8\u00060"}, d2={"Lio/ktor/client/engine/mock/MockEngine;", "Lio/ktor/client/engine/HttpClientEngineBase;", "Lio/ktor/client/engine/mock/MockEngineConfig;", "config", "", "throwIfEmptyConfig", "<init>", "(Lio/ktor/client/engine/mock/MockEngineConfig;Z)V", "(Lio/ktor/client/engine/mock/MockEngineConfig;)V", "Lio/ktor/client/request/HttpRequestData;", "data", "Lio/ktor/client/request/HttpResponseData;", "execute", "(Lio/ktor/client/request/HttpRequestData;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "close", "()V", "Lio/ktor/client/engine/mock/MockEngineConfig;", "getConfig", "()Lio/ktor/client/engine/mock/MockEngineConfig;", "", "Lio/ktor/client/engine/HttpClientEngineCapability;", "", "supportedCapabilities", "Ljava/util/Set;", "getSupportedCapabilities", "()Ljava/util/Set;", "Lkotlinx/atomicfu/locks/SynchronizedObject;", "mutex", "Ljava/lang/Object;", "Lkotlinx/coroutines/CompletableJob;", "contextState", "Lkotlinx/coroutines/CompletableJob;", "", "_requestHistory", "Ljava/util/List;", "_responseHistory", "", "invocationCount", "I", "", "getRequestHistory", "()Ljava/util/List;", "requestHistory", "getResponseHistory", "responseHistory", "Companion", "Queue", "ktor-client-mock"})
public class MockEngine
extends HttpClientEngineBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MockEngineConfig config;
    @NotNull
    private final Set<HttpClientEngineCapability<? extends Object>> supportedCapabilities;
    @NotNull
    private final Object mutex;
    @NotNull
    private final CompletableJob contextState;
    @NotNull
    private final List<HttpRequestData> _requestHistory;
    @NotNull
    private final List<HttpResponseData> _responseHistory;
    private int invocationCount;

    public MockEngine(@NotNull MockEngineConfig config, boolean throwIfEmptyConfig) {
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        super("ktor-mock");
        this.config = config;
        Object[] objectArray = new HttpClientEngineCapability[]{HttpTimeoutCapability.INSTANCE, WebSocketCapability.INSTANCE, WebSocketExtensionsCapability.INSTANCE};
        this.supportedCapabilities = SetsKt.setOf((Object[])objectArray);
        this.mutex = new Object();
        this.contextState = JobKt.Job$default(null, (int)1, null);
        this._requestHistory = new ArrayList();
        this._responseHistory = new ArrayList();
        if (throwIfEmptyConfig && !(!((Collection)this.getConfig().getRequestHandlers()).isEmpty())) {
            boolean bl = false;
            String string = "No request handler provided in [MockEngineConfig], please provide at least one.";
            throw new IllegalStateException(string.toString());
        }
    }

    @NotNull
    public MockEngineConfig getConfig() {
        return this.config;
    }

    public MockEngine(@NotNull MockEngineConfig config) {
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        this(config, true);
    }

    @NotNull
    public Set<HttpClientEngineCapability<? extends Object>> getSupportedCapabilities() {
        return this.supportedCapabilities;
    }

    @NotNull
    public final List<HttpRequestData> getRequestHistory() {
        return this._requestHistory;
    }

    @NotNull
    public final List<HttpResponseData> getResponseHistory() {
        return this._responseHistory;
    }

    @Nullable
    public Object execute(@NotNull HttpRequestData data, @NotNull Continuation<? super HttpResponseData> $completion) {
        return MockEngine.execute$suspendImpl(this, data, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static /* synthetic */ Object execute$suspendImpl(MockEngine var0, HttpRequestData var1_1, Continuation<? super HttpResponseData> $completion) {
        if (!($completion instanceof execute.1)) ** GOTO lbl-1000
        var11_3 = $completion;
        if ((var11_3.label & -2147483648) != 0) {
            var11_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ MockEngine this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return MockEngine.execute$suspendImpl(this.this$0, null, (Continuation<? super HttpResponseData>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = $this;
                $continuation.L$1 = data;
                $continuation.label = 1;
                v0 = UtilsKt.callContext((Continuation)$continuation);
                if (v0 == var12_5) {
                    return var12_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                data = (HttpRequestData)$continuation.L$1;
                $this = (MockEngine)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                callContext = (CoroutineContext)v0;
                var6_7 = $this.mutex;
                synchronized (var6_7) {
                    $i$a$-synchronized-MockEngine$execute$handler$1 = false;
                    if ($this.invocationCount >= $this.getConfig().getRequestHandlers().size()) {
                        throw new IllegalStateException(("Unhandled " + data.getUrl()).toString());
                    }
                    handler = $this.getConfig().getRequestHandlers().get($this.invocationCount);
                    ++$this.invocationCount;
                    if ($this.getConfig().getReuseHandlers()) {
                        $this.invocationCount %= $this.getConfig().getRequestHandlers().size();
                    }
                    var7_9 = handler;
                }
                handler = var7_9;
                $continuation.L$0 = $this;
                $continuation.L$1 = data;
                $continuation.label = 2;
                v1 = BuildersKt.withContext((CoroutineContext)$this.getDispatcher().plus(callContext), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super HttpResponseData>, Object>(handler, callContext, data, null){
                    int label;
                    final /* synthetic */ Function3<MockRequestHandleScope, HttpRequestData, Continuation<? super HttpResponseData>, Object> $handler;
                    final /* synthetic */ CoroutineContext $callContext;
                    final /* synthetic */ HttpRequestData $data;
                    {
                        this.$handler = $handler;
                        this.$callContext = $callContext;
                        this.$data = $data;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = this.$handler.invoke((Object)new MockRequestHandleScope(this.$callContext), (Object)this.$data, (Object)((Object)this));
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super HttpResponseData> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var12_5) {
                    return var12_5;
                }
                ** GOTO lbl53
            }
            case 2: {
                data = (HttpRequestData)$continuation.L$1;
                $this = (MockEngine)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl53:
                // 2 sources

                response = (HttpResponseData)v1;
                var7_9 = $this.mutex;
                synchronized (var7_9) {
                    $i$a$-synchronized-MockEngine$execute$2 = false;
                    $this._requestHistory.add(data);
                    var8_12 = $this._responseHistory.add(response);
                }
                return response;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public void close() {
        super.close();
        CoroutineContext.Element element = this.getCoroutineContext().get((CoroutineContext.Key)Job.Key);
        Intrinsics.checkNotNull((Object)element);
        ((Job)element).invokeOnCompletion(arg_0 -> MockEngine.close$lambda$3(this, arg_0));
    }

    private static final Unit close$lambda$3(MockEngine this$0, Throwable it) {
        this$0.contextState.complete();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J(\u0010\n\u001a\u00020\t2\u0017\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\b\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJR\u0010\u0018\u001a\u00020\u00172@\u0010\u0016\u001a<\b\u0001\u0012\u0004\u0012\u00020\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00140\fj\u0002`\u0015\u00a2\u0006\u0002\b\u0007H\u0086\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lio/ktor/client/engine/mock/MockEngine$Companion;", "Lio/ktor/client/engine/HttpClientEngineFactory;", "Lio/ktor/client/engine/mock/MockEngineConfig;", "<init>", "()V", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "block", "Lio/ktor/client/engine/HttpClientEngine;", "create", "(Lkotlin/jvm/functions/Function1;)Lio/ktor/client/engine/HttpClientEngine;", "Lkotlin/Function3;", "Lio/ktor/client/engine/mock/MockRequestHandleScope;", "Lio/ktor/client/request/HttpRequestData;", "Lkotlin/ParameterName;", "name", "request", "Lkotlin/coroutines/Continuation;", "Lio/ktor/client/request/HttpResponseData;", "", "Lio/ktor/client/engine/mock/MockRequestHandler;", "handler", "Lio/ktor/client/engine/mock/MockEngine;", "invoke", "(Lkotlin/jvm/functions/Function3;)Lio/ktor/client/engine/mock/MockEngine;", "ktor-client-mock"})
    public static final class Companion
    implements HttpClientEngineFactory<MockEngineConfig> {
        private Companion() {
        }

        @NotNull
        public HttpClientEngine create(@NotNull Function1<? super MockEngineConfig, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            MockEngineConfig mockEngineConfig = new MockEngineConfig();
            block.invoke((Object)mockEngineConfig);
            return (HttpClientEngine)new MockEngine(mockEngineConfig);
        }

        @NotNull
        public final MockEngine invoke(@NotNull Function3<? super MockRequestHandleScope, ? super HttpRequestData, ? super Continuation<? super HttpResponseData>, ? extends Object> handler) {
            MockEngineConfig mockEngineConfig;
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            MockEngineConfig $this$invoke_u24lambda_u240 = mockEngineConfig = new MockEngineConfig();
            boolean bl = false;
            $this$invoke_u24lambda_u240.getRequestHandlers().add(handler);
            MockEngineConfig mockEngineConfig2 = mockEngineConfig;
            return new MockEngine(mockEngineConfig2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005JO\u0010\u0013\u001a\u00020\u00122@\u0010\u0011\u001a<\b\u0001\u0012\u0004\u0012\u00020\u0007\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u0006j\u0002`\u000f\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014JR\u0010\u0016\u001a\u00020\u00152@\u0010\u0011\u001a<\b\u0001\u0012\u0004\u0012\u00020\u0007\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u0006j\u0002`\u000f\u00a2\u0006\u0002\b\u0010H\u0086\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lio/ktor/client/engine/mock/MockEngine$Queue;", "Lio/ktor/client/engine/mock/MockEngine;", "Lio/ktor/client/engine/mock/MockEngineConfig;", "config", "<init>", "(Lio/ktor/client/engine/mock/MockEngineConfig;)V", "Lkotlin/Function3;", "Lio/ktor/client/engine/mock/MockRequestHandleScope;", "Lio/ktor/client/request/HttpRequestData;", "Lkotlin/ParameterName;", "name", "request", "Lkotlin/coroutines/Continuation;", "Lio/ktor/client/request/HttpResponseData;", "", "Lio/ktor/client/engine/mock/MockRequestHandler;", "Lkotlin/ExtensionFunctionType;", "handler", "", "enqueue", "(Lkotlin/jvm/functions/Function3;)Z", "", "plusAssign", "(Lkotlin/jvm/functions/Function3;)V", "Lio/ktor/client/engine/mock/MockEngineConfig;", "getConfig", "()Lio/ktor/client/engine/mock/MockEngineConfig;", "ktor-client-mock"})
    public static final class Queue
    extends MockEngine {
        @NotNull
        private final MockEngineConfig config;

        public Queue(@NotNull MockEngineConfig config) {
            Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
            super(config, false);
            this.config = config;
        }

        public /* synthetic */ Queue(MockEngineConfig mockEngineConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                MockEngineConfig mockEngineConfig2;
                MockEngineConfig $this$_init__u24lambda_u240 = mockEngineConfig2 = new MockEngineConfig();
                boolean bl = false;
                $this$_init__u24lambda_u240.setReuseHandlers(false);
                mockEngineConfig = mockEngineConfig2;
            }
            this(mockEngineConfig);
        }

        @Override
        @NotNull
        public MockEngineConfig getConfig() {
            return this.config;
        }

        public final boolean enqueue(@NotNull Function3<? super MockRequestHandleScope, ? super HttpRequestData, ? super Continuation<? super HttpResponseData>, ? extends Object> handler) {
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            return this.getConfig().getRequestHandlers().add(handler);
        }

        public final void plusAssign(@NotNull Function3<? super MockRequestHandleScope, ? super HttpRequestData, ? super Continuation<? super HttpResponseData>, ? extends Object> handler) {
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            this.enqueue(handler);
        }

        public Queue() {
            this(null, 1, null);
        }
    }
}

