/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.engine.okhttp;

import io.ktor.client.call.HttpClientCall;
import io.ktor.client.engine.okhttp.OkHttpResponseKt;
import io.ktor.client.response.HttpResponse;
import io.ktor.http.Headers;
import io.ktor.http.HttpProtocolVersion;
import io.ktor.http.HttpStatusCode;
import io.ktor.util.date.DateJvmKt;
import io.ktor.util.date.GMTDate;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.io.ByteReadChannel;
import okhttp3.Protocol;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lio/ktor/client/engine/okhttp/OkHttpResponse;", "Lio/ktor/client/response/HttpResponse;", "response", "Lokhttp3/Response;", "call", "Lio/ktor/client/call/HttpClientCall;", "requestTime", "Lio/ktor/util/date/GMTDate;", "content", "Lkotlinx/coroutines/io/ByteReadChannel;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "(Lokhttp3/Response;Lio/ktor/client/call/HttpClientCall;Lio/ktor/util/date/GMTDate;Lkotlinx/coroutines/io/ByteReadChannel;Lkotlin/coroutines/CoroutineContext;)V", "getCall", "()Lio/ktor/client/call/HttpClientCall;", "getContent", "()Lkotlinx/coroutines/io/ByteReadChannel;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "headers", "Lio/ktor/http/Headers;", "getHeaders", "()Lio/ktor/http/Headers;", "getRequestTime", "()Lio/ktor/util/date/GMTDate;", "responseTime", "getResponseTime", "status", "Lio/ktor/http/HttpStatusCode;", "getStatus", "()Lio/ktor/http/HttpStatusCode;", "version", "Lio/ktor/http/HttpProtocolVersion;", "getVersion", "()Lio/ktor/http/HttpProtocolVersion;", "ktor-client-okhttp"})
public final class OkHttpResponse
implements HttpResponse {
    @NotNull
    private final Headers headers;
    @NotNull
    private final HttpStatusCode status;
    @NotNull
    private final HttpProtocolVersion version;
    @NotNull
    private final GMTDate responseTime;
    private final Response response;
    @NotNull
    private final HttpClientCall call;
    @NotNull
    private final GMTDate requestTime;
    @NotNull
    private final ByteReadChannel content;
    @NotNull
    private final CoroutineContext coroutineContext;

    @NotNull
    public Headers getHeaders() {
        return this.headers;
    }

    @NotNull
    public HttpStatusCode getStatus() {
        return this.status;
    }

    @NotNull
    public HttpProtocolVersion getVersion() {
        return this.version;
    }

    @NotNull
    public GMTDate getResponseTime() {
        return this.responseTime;
    }

    @NotNull
    public HttpClientCall getCall() {
        return this.call;
    }

    @NotNull
    public GMTDate getRequestTime() {
        return this.requestTime;
    }

    @NotNull
    public ByteReadChannel getContent() {
        return this.content;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    public OkHttpResponse(@NotNull Response response, @NotNull HttpClientCall call, @NotNull GMTDate requestTime, @NotNull ByteReadChannel content, @NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        Intrinsics.checkParameterIsNotNull((Object)requestTime, (String)"requestTime");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)coroutineContext, (String)"coroutineContext");
        this.response = response;
        this.call = call;
        this.requestTime = requestTime;
        this.content = content;
        this.coroutineContext = coroutineContext;
        this.headers = new Headers(this){
            private final boolean caseInsensitiveName;
            private final okhttp3.Headers instance;
            final /* synthetic */ OkHttpResponse this$0;

            public boolean getCaseInsensitiveName() {
                return this.caseInsensitiveName;
            }

            @Nullable
            public List<String> getAll(@NotNull String name) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                return this.instance.values(name);
            }

            @NotNull
            public Set<String> names() {
                Set set = this.instance.names();
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"instance.names()");
                return set;
            }

            @NotNull
            public Set<Map.Entry<String, List<String>>> entries() {
                return this.instance.toMultimap().entrySet();
            }

            public boolean isEmpty() {
                return this.instance.size() == 0;
            }
            {
                this.this$0 = $outer;
                okhttp3.Headers headers2 = OkHttpResponse.access$getResponse$p($outer).headers();
                if (headers2 == null) {
                    Intrinsics.throwNpe();
                }
                this.instance = headers2;
            }

            public boolean contains(@NotNull String name) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                return Headers.DefaultImpls.contains((Headers)this, (String)name);
            }

            public boolean contains(@NotNull String name, @NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                return Headers.DefaultImpls.contains((Headers)this, (String)name, (String)value);
            }

            public void forEach(@NotNull Function2<? super String, ? super List<String>, Unit> body) {
                Intrinsics.checkParameterIsNotNull(body, (String)"body");
                Headers.DefaultImpls.forEach((Headers)this, body);
            }

            @Nullable
            public String get(@NotNull String name) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                return Headers.DefaultImpls.get((Headers)this, (String)name);
            }
        };
        int n = this.response.code();
        String string = this.response.message();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"response.message()");
        this.status = new HttpStatusCode(n, string);
        Protocol protocol = this.response.protocol();
        Intrinsics.checkExpressionValueIsNotNull((Object)protocol, (String)"response.protocol()");
        this.version = OkHttpResponseKt.access$fromOkHttp(protocol);
        this.responseTime = DateJvmKt.GMTDate$default(null, (int)1, null);
    }

    @NotNull
    public Job getExecutionContext() {
        return HttpResponse.DefaultImpls.getExecutionContext((HttpResponse)this);
    }

    public void close() {
        HttpResponse.DefaultImpls.close((HttpResponse)this);
    }

    @NotNull
    public static final /* synthetic */ Response access$getResponse$p(OkHttpResponse $this) {
        return $this.response;
    }
}

