/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.tests.utils;

import io.ktor.client.HttpClientEngineContainer;
import io.ktor.client.engine.HttpClientEngineConfig;
import io.ktor.client.tests.utils.ClientLoaderJvmKt;
import io.ktor.client.tests.utils.CommonClientTestUtilsKt;
import io.ktor.client.tests.utils.TestClientBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.ServiceLoader;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.debug.DebugProbes;
import kotlinx.coroutines.debug.junit4.CoroutinesTimeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Rule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b'\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JV\u0010\u0011\u001a\u00020\u00122\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00152-\u0010\u0017\u001a)\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0018\u00a2\u0006\u0002\b\u001c\u00a2\u0006\u0002\u0010\u001dJ\u0006\u0010\u001e\u001a\u00020\u0012J\u0006\u0010\u001f\u001a\u00020\u0012R\u001e\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u00020\f8WX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006!"}, d2={"Lio/ktor/client/tests/utils/ClientLoader;", "", "timeoutSeconds", "", "(I)V", "engine", "Lio/ktor/client/HttpClientEngineContainer;", "getEngine", "()Lio/ktor/client/HttpClientEngineContainer;", "setEngine", "(Lio/ktor/client/HttpClientEngineContainer;)V", "timeout", "Lkotlinx/coroutines/debug/junit4/CoroutinesTimeout;", "getTimeout", "()Lkotlinx/coroutines/debug/junit4/CoroutinesTimeout;", "getTimeoutSeconds", "()I", "clientTests", "", "skipEngines", "", "", "onlyWithEngine", "block", "Lkotlin/Function2;", "Lio/ktor/client/tests/utils/TestClientBuilder;", "Lio/ktor/client/engine/HttpClientEngineConfig;", "Lkotlin/coroutines/Continuation;", "Lkotlin/ExtensionFunctionType;", "(Ljava/util/List;Ljava/lang/String;Lkotlin/jvm/functions/Function2;)V", "dumpCoroutines", "waitForAllCoroutines", "Companion", "ktor-client-tests"})
@SourceDebugExtension(value={"SMAP\nClientLoaderJvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientLoaderJvm.kt\nio/ktor/client/tests/utils/ClientLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n1549#2:128\n1620#2,3:129\n*S KotlinDebug\n*F\n+ 1 ClientLoaderJvm.kt\nio/ktor/client/tests/utils/ClientLoader\n*L\n61#1:128\n61#1:129,3\n*E\n"})
public abstract class ClientLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int timeoutSeconds;
    @Parameterized.Parameter
    public HttpClientEngineContainer engine;
    @NotNull
    private final CoroutinesTimeout timeout;

    public ClientLoader(int timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        this.timeout = CoroutinesTimeout.Companion.seconds$default((CoroutinesTimeout.Companion)CoroutinesTimeout.Companion, (int)this.timeoutSeconds, (boolean)false, (boolean)false, (int)6, null);
    }

    public /* synthetic */ ClientLoader(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 60;
        }
        this(n);
    }

    public final int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    @NotNull
    public final HttpClientEngineContainer getEngine() {
        HttpClientEngineContainer httpClientEngineContainer = this.engine;
        if (httpClientEngineContainer != null) {
            return httpClientEngineContainer;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"engine");
        return null;
    }

    public final void setEngine(@NotNull HttpClientEngineContainer httpClientEngineContainer) {
        Intrinsics.checkNotNullParameter((Object)httpClientEngineContainer, (String)"<set-?>");
        this.engine = httpClientEngineContainer;
    }

    @Rule
    @NotNull
    public CoroutinesTimeout getTimeout() {
        return this.timeout;
    }

    /*
     * WARNING - void declaration
     */
    public final void clientTests(@NotNull List<String> skipEngines, @Nullable String onlyWithEngine, @NotNull Function2<? super TestClientBuilder<? extends HttpClientEngineConfig>, ? super Continuation<? super Unit>, ? extends Object> block2) {
        void $this$mapTo$iv$iv;
        String[] stringArray;
        Intrinsics.checkNotNullParameter(skipEngines, (String)"skipEngines");
        Intrinsics.checkNotNullParameter(block2, (String)"block");
        Locale locale = Locale.getDefault();
        String string = this.getEngine().toString();
        Intrinsics.checkNotNull((Object)locale);
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String engineName = string2;
        for (String skipEngine : skipEngines) {
            boolean engineShouldBeSkipped;
            String[] stringArray2;
            String string3 = skipEngine.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            stringArray = new String[]{":"};
            List skipEngineArray = StringsKt.split$default((CharSequence)string3, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            switch (skipEngineArray.size()) {
                case 2: {
                    stringArray2 = TuplesKt.to(skipEngineArray.get(0), skipEngineArray.get(1));
                    break;
                }
                case 1: {
                    stringArray2 = TuplesKt.to((Object)"*", skipEngineArray.get(0));
                    break;
                }
                default: {
                    throw new IllegalStateException("Wrong skip engine format, expected 'engine' or 'platform:engine'");
                }
            }
            stringArray = stringArray2;
            String platform = (String)stringArray.component1();
            String skipEngineName = (String)stringArray.component2();
            boolean platformShouldBeSkipped = Intrinsics.areEqual((Object)"*", (Object)platform) || Intrinsics.areEqual((Object)ClientLoaderJvmKt.access$getOS_NAME(), (Object)platform);
            boolean bl = engineShouldBeSkipped = Intrinsics.areEqual((Object)"*", (Object)skipEngineName) || Intrinsics.areEqual((Object)engineName, (Object)skipEngineName);
            if (platformShouldBeSkipped && engineShouldBeSkipped) {
                return;
            }
            if (onlyWithEngine == null || Intrinsics.areEqual((Object)engineName, (Object)onlyWithEngine)) continue;
            return;
        }
        String[] $this$map$iv = (String[])skipEngines;
        boolean $i$f$map = false;
        stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string4 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string5 = it.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
            collection.add(string5);
        }
        List enginesToSkip = (List)destination$iv$iv;
        if (enginesToSkip.contains(engineName)) {
            return;
        }
        CommonClientTestUtilsKt.testWithEngine(this.getEngine().getFactory(), this, (long)this.timeoutSeconds * 1000L, block2);
    }

    public static /* synthetic */ void clientTests$default(ClientLoader clientLoader, List list, String string, Function2 function2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: clientTests");
        }
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            string = null;
        }
        clientLoader.clientTests(list, string, (Function2<? super TestClientBuilder<? extends HttpClientEngineConfig>, ? super Continuation<? super Unit>, ? extends Object>)function2);
    }

    public final void dumpCoroutines() {
        DebugProbes.dumpCoroutines$default((DebugProbes)DebugProbes.INSTANCE, null, (int)1, null);
    }

    public final void waitForAllCoroutines() {
        StringBuilder stringBuilder;
        if (!DebugProbes.INSTANCE.isInstalled()) {
            boolean $i$a$-check-ClientLoader$waitForAllCoroutines$22 = false;
            String $i$a$-check-ClientLoader$waitForAllCoroutines$22 = "Debug probes isn't installed.";
            throw new IllegalStateException($i$a$-check-ClientLoader$waitForAllCoroutines$22.toString());
        }
        List info = DebugProbes.INSTANCE.dumpCoroutinesInfo();
        if (info.isEmpty()) {
            return;
        }
        StringBuilder $this$waitForAllCoroutines_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$waitForAllCoroutines_u24lambda_u242.append("Test failed. There are running coroutines");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder3 = $this$waitForAllCoroutines_u24lambda_u242.append(ClientLoaderJvmKt.access$dump(info));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String message = string;
        throw new IllegalStateException(message.toString());
    }

    public ClientLoader() {
        this(0, 1, null);
    }

    @JvmStatic
    @Parameterized.Parameters(name="{0}")
    @NotNull
    public static final List<HttpClientEngineContainer> engines() {
        return Companion.engines();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007\u00a8\u0006\u0006"}, d2={"Lio/ktor/client/tests/utils/ClientLoader$Companion;", "", "()V", "engines", "", "Lio/ktor/client/HttpClientEngineContainer;", "ktor-client-tests"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Parameterized.Parameters(name="{0}")
        @NotNull
        public final List<HttpClientEngineContainer> engines() {
            Class<HttpClientEngineContainer> it = HttpClientEngineContainer.class;
            boolean bl = false;
            ServiceLoader<HttpClientEngineContainer> serviceLoader = ServiceLoader.load(it, it.getClassLoader());
            Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(...)");
            return CollectionsKt.toList((Iterable)serviceLoader);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

