/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.cio.websocket;

import io.ktor.http.cio.websocket.Frame;
import io.ktor.http.cio.websocket.UtilsKt;
import io.ktor.http.cio.websocket.WebSocketInternalAPI;
import io.ktor.util.CryptoKt;
import io.ktor.util.NIOKt;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.concurrent.ArrayBlockingQueue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@WebSocketInternalAPI
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0010J\u0018\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\u000e\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0004J \u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\u0010\u0010 \u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J\f\u0010!\u001a\u00020\u0004*\u00020\u0004H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lio/ktor/http/cio/websocket/Serializer;", "", "()V", "frameBody", "Ljava/nio/ByteBuffer;", "hasOutstandingBytes", "", "getHasOutstandingBytes", "()Z", "maskBuffer", "masking", "getMasking", "setMasking", "(Z)V", "messages", "Ljava/util/concurrent/ArrayBlockingQueue;", "Lio/ktor/http/cio/websocket/Frame;", "remainingCapacity", "", "getRemainingCapacity", "()I", "enqueue", "", "f", "estimateFrameHeaderSize", "mask", "maskSize", "serialize", "buffer", "serializeHeader", "frame", "setMaskBuffer", "writeCurrentPayload", "maskedIfNeeded", "ktor-http-cio"})
public final class Serializer {
    private final ArrayBlockingQueue<Frame> messages = new ArrayBlockingQueue(1024);
    private ByteBuffer frameBody;
    private ByteBuffer maskBuffer;
    private boolean masking;

    public final boolean getMasking() {
        return this.masking;
    }

    public final void setMasking(boolean bl) {
        this.masking = bl;
    }

    public final boolean getHasOutstandingBytes() {
        Collection collection = this.messages;
        boolean bl = false;
        return !collection.isEmpty() || this.frameBody != null;
    }

    public final int getRemainingCapacity() {
        return this.messages.remainingCapacity();
    }

    public final void enqueue(@NotNull Frame f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        this.messages.put(f);
    }

    public final void serialize(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        while (this.writeCurrentPayload(buffer)) {
            Frame frame;
            if (this.messages.peek() == null) {
                break;
            }
            boolean mask = this.masking;
            this.setMaskBuffer(mask);
            int headerSize = this.estimateFrameHeaderSize(frame, mask);
            if (buffer.remaining() < headerSize) break;
            this.serializeHeader(frame, buffer, mask);
            this.messages.remove();
            this.frameBody = this.maskedIfNeeded(frame.getBuffer());
        }
    }

    private final void serializeHeader(Frame frame, ByteBuffer buffer, boolean mask) {
        block3: {
            ByteBuffer byteBuffer;
            boolean $this$flagAt$iv;
            int size2 = frame.getBuffer().remaining();
            int length1 = size2 < 126 ? size2 : (size2 <= 65535 ? 126 : 127);
            boolean bl = frame.getFin();
            int at$iv = 7;
            boolean $i$f$flagAt = false;
            buffer.put((byte)(($this$flagAt$iv ? 1 << at$iv : 0) | frame.getFrameType().getOpcode()));
            $this$flagAt$iv = mask;
            at$iv = 7;
            $i$f$flagAt = false;
            buffer.put((byte)(($this$flagAt$iv ? 1 << at$iv : 0) | length1));
            if (length1 == 126) {
                buffer.putShort((short)frame.getBuffer().remaining());
            } else if (length1 == 127) {
                buffer.putLong(frame.getBuffer().remaining());
            }
            if ((byteBuffer = this.maskBuffer) == null || (byteBuffer = byteBuffer.duplicate()) == null) break block3;
            NIOKt.moveTo$default((ByteBuffer)byteBuffer, (ByteBuffer)buffer, (int)0, (int)2, null);
        }
    }

    private final int estimateFrameHeaderSize(Frame f, boolean mask) {
        int size2 = f.getBuffer().remaining();
        return (size2 < 126 ? 2 : (size2 <= Short.MAX_VALUE ? 4 : 10)) + this.maskSize(mask);
    }

    private final boolean writeCurrentPayload(ByteBuffer buffer) {
        ByteBuffer byteBuffer = this.frameBody;
        if (byteBuffer == null) {
            return true;
        }
        ByteBuffer frame = byteBuffer;
        NIOKt.moveTo$default((ByteBuffer)frame, (ByteBuffer)buffer, (int)0, (int)2, null);
        if (!frame.hasRemaining()) {
            this.frameBody = null;
            return true;
        }
        return false;
    }

    private final int maskSize(boolean mask) {
        return mask ? 4 : 0;
    }

    private final ByteBuffer maskedIfNeeded(ByteBuffer $this$maskedIfNeeded) {
        ByteBuffer byteBuffer;
        block3: {
            block2: {
                byteBuffer = this.maskBuffer;
                if (byteBuffer == null) break block2;
                ByteBuffer byteBuffer2 = byteBuffer;
                boolean bl = false;
                boolean bl2 = false;
                ByteBuffer mask = byteBuffer2;
                boolean bl3 = false;
                ByteBuffer byteBuffer3 = NIOKt.copy$default((ByteBuffer)$this$maskedIfNeeded, (int)0, (int)1, null);
                boolean bl4 = false;
                boolean bl5 = false;
                ByteBuffer $this$apply = byteBuffer3;
                boolean bl6 = false;
                UtilsKt.xor($this$apply, mask);
                byteBuffer = byteBuffer3;
                if (byteBuffer != null) break block3;
            }
            byteBuffer = $this$maskedIfNeeded;
        }
        return byteBuffer;
    }

    /*
     * WARNING - void declaration
     */
    private final void setMaskBuffer(boolean mask) {
        if (mask) {
            void $this$apply;
            ByteBuffer byteBuffer = ByteBuffer.allocate(4);
            boolean bl = false;
            boolean bl2 = false;
            ByteBuffer byteBuffer2 = byteBuffer;
            Serializer serializer = this;
            boolean bl3 = false;
            $this$apply.putInt(CryptoKt.generateNonce().hashCode());
            $this$apply.clear();
            Unit unit = Unit.INSTANCE;
            serializer.maskBuffer = byteBuffer;
        } else {
            this.maskBuffer = null;
        }
    }
}

