/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.cio.internals;

import io.ktor.http.cio.internals.CharArrayBuilder;
import io.ktor.http.cio.internals.MutableRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a \u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0001H\u0000\u00a8\u0006\r"}, d2={"findSpaceOrEnd", "", "text", "", "range", "Lio/ktor/http/cio/internals/MutableRange;", "nextToken", "skipSpaces", "", "skipSpacesAndHorizontalTabs", "Lio/ktor/http/cio/internals/CharArrayBuilder;", "start", "end", "ktor-http-cio"})
public final class TokenizerKt {
    @NotNull
    public static final CharSequence nextToken(@NotNull CharSequence text, @NotNull MutableRange range) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        int spaceOrEnd = TokenizerKt.findSpaceOrEnd(text, range);
        CharSequence s = text.subSequence(range.getStart(), spaceOrEnd);
        range.setStart(spaceOrEnd);
        return s;
    }

    public static final int skipSpacesAndHorizontalTabs(@NotNull CharArrayBuilder text, int start2, int end) {
        char ch;
        int index;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        for (index = start2; index < end && (CharsKt.isWhitespace((char)(ch = text.charAt(index))) || ch == '\t'); ++index) {
        }
        return index;
    }

    public static final void skipSpaces(@NotNull CharSequence text, @NotNull MutableRange range) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        int idx = range.getStart();
        int end = range.getEnd();
        if (idx >= end || !CharsKt.isWhitespace((char)text.charAt(idx))) {
            return;
        }
        ++idx;
        while (idx < end && CharsKt.isWhitespace((char)text.charAt(idx))) {
            ++idx;
        }
        range.setStart(idx);
    }

    public static final int findSpaceOrEnd(@NotNull CharSequence text, @NotNull MutableRange range) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        int idx = range.getStart();
        int end = range.getEnd();
        if (idx >= end || CharsKt.isWhitespace((char)text.charAt(idx))) {
            return idx;
        }
        ++idx;
        while (idx < end) {
            if (CharsKt.isWhitespace((char)text.charAt(idx))) {
                return idx;
            }
            ++idx;
        }
        return idx;
    }
}

