/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.cio.internals;

import io.ktor.http.cio.internals.CharBufferPoolKt;
import io.ktor.util.InternalAPI;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.pool.ObjectPool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalAPI
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0010\u0001\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00060\u0002j\u0002`\u0003:\u00015B\u0015\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\u0018\u001a\u00060\u0002j\u0002`\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0001H\u0016J$\u0010\u0018\u001a\u00060\u0002j\u0002`\u00032\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\fH\u0016J)\u0010\u0018\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u0006H\u0082\u0010J\b\u0010 \u001a\u00020\u0006H\u0002J\u0010\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\fH\u0002J\u0018\u0010#\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020\fH\u0002J\u0013\u0010&\u001a\u00020\u00152\b\u0010'\u001a\u0004\u0018\u00010(H\u0096\u0002J\u0011\u0010)\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\fH\u0096\u0002J\u0010\u0010*\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\fH\u0002J\b\u0010+\u001a\u00020\fH\u0016J\u0018\u0010,\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\fH\u0002J\b\u0010-\u001a\u00020\u0006H\u0002J(\u0010.\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010'\u001a\u00020\u00012\u0006\u0010/\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0006\u00100\u001a\u00020\u001eJ\u0018\u00101\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020\fH\u0016J\u0010\u00102\u001a\u0002032\u0006\u0010\"\u001a\u00020\fH\u0002J\b\u00104\u001a\u00020\u0017H\u0016R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@RX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lio/ktor/http/cio/internals/CharBufferBuilder;", "", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "pool", "Lkotlinx/io/pool/ObjectPool;", "Ljava/nio/CharBuffer;", "(Lkotlinx/io/pool/ObjectPool;)V", "buffers", "", "current", "<set-?>", "", "length", "getLength", "()I", "setLength", "(I)V", "getPool", "()Lkotlinx/io/pool/ObjectPool;", "released", "", "stringified", "", "append", "c", "", "csq", "start", "end", "", "buffer", "appendNewBuffer", "bufferForIndex", "index", "copy", "startIndex", "endIndex", "equals", "other", "", "get", "getImpl", "hashCode", "hashCodeImpl", "nonFullBuffer", "rangeEqualsImpl", "otherStart", "release", "subSequence", "throwSingleBuffer", "", "toString", "SubSequenceImpl", "ktor-http-cio"})
public final class CharBufferBuilder
implements CharSequence,
Appendable {
    private List<CharBuffer> buffers;
    private CharBuffer current;
    private String stringified;
    private boolean released;
    private int length;
    @NotNull
    private final ObjectPool<CharBuffer> pool;

    public int getLength() {
        return this.length;
    }

    private void setLength(int n) {
        this.length = n;
    }

    public char get(int index) {
        boolean bl;
        boolean bl2 = bl = index >= 0;
        if (!bl) {
            String string = "index is negative: " + index;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        boolean bl3 = bl = index < this.length();
        if (!bl) {
            String string = "index " + index + " is not in range [0, " + this.length() + ')';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return this.getImpl(index);
    }

    private final char getImpl(int index) {
        return this.bufferForIndex(index).get(index % 2048);
    }

    @Override
    @NotNull
    public CharSequence subSequence(int startIndex, int endIndex) {
        boolean bl;
        boolean bl2 = bl = startIndex <= endIndex;
        if (!bl) {
            String string = "startIndex (" + startIndex + ") should be less or equal to endIndex (" + endIndex + ')';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        boolean bl3 = bl = startIndex >= 0;
        if (!bl) {
            String string = "startIndex is negative: " + startIndex;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        boolean bl4 = bl = endIndex <= this.length();
        if (!bl) {
            String string = "endIndex (" + endIndex + ") is greater than length (" + this.length() + ')';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        return new SubSequenceImpl(startIndex, endIndex);
    }

    @Override
    @NotNull
    public String toString() {
        String string = this.stringified;
        if (string == null) {
            String string2;
            String it;
            this.stringified = it = (string2 = ((Object)this.copy(0, this.length())).toString());
            string = string2;
        }
        return string;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof CharSequence)) {
            return false;
        }
        if (this.length() != ((CharSequence)other).length()) {
            return false;
        }
        return this.rangeEqualsImpl(0, (CharSequence)other, 0, this.length());
    }

    public int hashCode() {
        String string = this.stringified;
        return string != null ? string.hashCode() : this.hashCodeImpl(0, this.length());
    }

    @Override
    @NotNull
    public Appendable append(char c) {
        this.nonFullBuffer().put(c);
        this.stringified = null;
        CharBufferBuilder charBufferBuilder = this;
        int n = charBufferBuilder.length();
        charBufferBuilder.setLength(n + 1);
        return this;
    }

    @Override
    @NotNull
    public Appendable append(@NotNull CharSequence csq, int start2, int end) {
        Intrinsics.checkParameterIsNotNull((Object)csq, (String)"csq");
        this.append(csq, start2, end, this.nonFullBuffer());
        this.stringified = null;
        CharBufferBuilder charBufferBuilder = this;
        charBufferBuilder.setLength(charBufferBuilder.length() + (end - start2));
        return this;
    }

    @Override
    @NotNull
    public Appendable append(@NotNull CharSequence csq) {
        Intrinsics.checkParameterIsNotNull((Object)csq, (String)"csq");
        this.append(csq, 0, csq.length(), this.nonFullBuffer());
        this.stringified = null;
        CharBufferBuilder charBufferBuilder = this;
        charBufferBuilder.setLength(charBufferBuilder.length() + csq.length());
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final void release() {
        this.setLength(0);
        List<CharBuffer> list = this.buffers;
        this.buffers = null;
        this.released = true;
        if (list != null) {
            this.current = null;
            int n = 0;
            int n2 = list.size();
            while (n < n2) {
                void i;
                this.pool.recycle((Object)list.get((int)i));
                ++i;
            }
        } else {
            CharBuffer charBuffer = this.current;
            if (charBuffer != null) {
                CharBuffer charBuffer2;
                CharBuffer it = charBuffer2 = charBuffer;
                this.pool.recycle((Object)it);
            }
            this.current = null;
        }
        this.stringified = null;
    }

    /*
     * WARNING - void declaration
     */
    private final CharSequence copy(int startIndex, int endIndex) {
        if (startIndex == endIndex) {
            return "";
        }
        StringBuilder builder = new StringBuilder(endIndex - startIndex);
        for (int base = startIndex - startIndex % 2048; base < endIndex; base += 2048) {
            CharBuffer buffer = this.bufferForIndex(base);
            int n = 0;
            int n2 = startIndex - base;
            int innerStartIndex = Math.max(n, n2);
            n2 = endIndex - base;
            int n3 = 2048;
            int innerEndIndex = Math.min(n2, n3);
            n2 = innerStartIndex;
            n3 = innerEndIndex;
            while (n2 < n3) {
                void innerIndex;
                builder.append(buffer.get((int)innerIndex));
                ++innerIndex;
            }
        }
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    private final void append(CharSequence csq, int start2, int end, CharBuffer buffer) {
        while (true) {
            int n = start2 + buffer.remaining();
            int limitedEnd = Math.min(end, n);
            n = start2;
            int n2 = limitedEnd;
            while (n < n2) {
                void i;
                buffer.put(csq.charAt((int)i));
                ++i;
            }
            if (limitedEnd >= end) break;
            buffer = this.appendNewBuffer();
            start2 = limitedEnd;
        }
    }

    private final CharBuffer bufferForIndex(int index) {
        List<CharBuffer> list = this.buffers;
        if (list == null) {
            if (index >= 2048) {
                Void void_ = this.throwSingleBuffer(index);
                throw null;
            }
            CharBuffer charBuffer = this.current;
            if (charBuffer == null) {
                Void void_ = this.throwSingleBuffer(index);
                throw null;
            }
            return charBuffer;
        }
        return list.get(index / 2048);
    }

    private final Void throwSingleBuffer(int index) {
        if (this.released) {
            throw (Throwable)new IllegalStateException("Buffer is already released");
        }
        CharBuffer charBuffer = this.current;
        throw (Throwable)new IndexOutOfBoundsException(index + " is not in range [0; " + (charBuffer != null ? charBuffer.position() : 0) + ')');
    }

    private final CharBuffer nonFullBuffer() {
        CharBuffer charBuffer;
        CharBuffer it;
        CharBuffer charBuffer2 = this.current;
        if (charBuffer2 == null || (charBuffer2 = (it = (charBuffer = charBuffer2)).hasRemaining() ? charBuffer : null) == null) {
            charBuffer2 = this.appendNewBuffer();
        }
        return charBuffer2;
    }

    private final CharBuffer appendNewBuffer() {
        CharBuffer newBuffer = (CharBuffer)this.pool.borrow();
        CharBuffer existing = this.current;
        this.current = newBuffer;
        this.released = false;
        if (existing != null) {
            List list = this.buffers;
            if (list == null) {
                ArrayList<CharBuffer> arrayList;
                ArrayList<CharBuffer> it = arrayList = new ArrayList<CharBuffer>();
                this.buffers = it;
                it.add(existing);
                list = arrayList;
            }
            List list2 = list;
            list2.add((CharBuffer)newBuffer);
        }
        return newBuffer;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean rangeEqualsImpl(int start2, CharSequence other, int otherStart, int length) {
        int n = 0;
        int n2 = length;
        while (n < n2) {
            void i;
            if (this.getImpl(start2 + i) != other.charAt(otherStart + i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final int hashCodeImpl(int start2, int end) {
        int hc = 0;
        int n = start2;
        int n2 = end;
        while (n < n2) {
            void i;
            hc = 31 * hc + this.getImpl((int)i);
            ++i;
        }
        return hc;
    }

    @NotNull
    public final ObjectPool<CharBuffer> getPool() {
        return this.pool;
    }

    public CharBufferBuilder(@NotNull ObjectPool<CharBuffer> pool) {
        Intrinsics.checkParameterIsNotNull(pool, (String)"pool");
        this.pool = pool;
    }

    public /* synthetic */ CharBufferBuilder(ObjectPool objectPool, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            objectPool = CharBufferPoolKt.getCharBufferPool();
        }
        this(objectPool);
    }

    public CharBufferBuilder() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\f\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\u0011\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\u0018\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\b\u0010\u0018\u001a\u00020\fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/ktor/http/cio/internals/CharBufferBuilder$SubSequenceImpl;", "", "start", "", "end", "(Lio/ktor/http/cio/internals/CharBufferBuilder;II)V", "getEnd", "()I", "length", "getLength", "getStart", "stringified", "", "equals", "", "other", "", "get", "", "index", "hashCode", "subSequence", "startIndex", "endIndex", "toString", "ktor-http-cio"})
    private final class SubSequenceImpl
    implements CharSequence {
        private String stringified;
        private final int start;
        private final int end;

        public int getLength() {
            return this.end - this.start;
        }

        public char get(int index) {
            boolean bl;
            int withOffset = index + this.start;
            boolean bl2 = bl = index >= 0;
            if (!bl) {
                String string = "index is negative: " + index;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            boolean bl3 = bl = withOffset < this.end;
            if (!bl) {
                String string = "index (" + index + ") should be less than length (" + this.length() + ')';
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            return CharBufferBuilder.this.getImpl(withOffset);
        }

        @Override
        @NotNull
        public CharSequence subSequence(int startIndex, int endIndex) {
            boolean bl;
            boolean bl2 = bl = startIndex >= 0;
            if (!bl) {
                String string = "start is negative: " + startIndex;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            boolean bl3 = bl = startIndex <= endIndex;
            if (!bl) {
                String string = "start (" + startIndex + ") should be less or equal to end (" + endIndex + ')';
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            boolean bl4 = bl = endIndex <= this.end - this.start;
            if (!bl) {
                String string = "end should be less than length (" + this.length() + ')';
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            if (startIndex == endIndex) {
                return "";
            }
            return new SubSequenceImpl(this.start + startIndex, this.start + endIndex);
        }

        @Override
        @NotNull
        public String toString() {
            String string = this.stringified;
            if (string == null) {
                String string2;
                String it;
                this.stringified = it = (string2 = ((Object)CharBufferBuilder.this.copy(this.start, this.end)).toString());
                string = string2;
            }
            return string;
        }

        public boolean equals(@Nullable Object other) {
            if (!(other instanceof CharSequence)) {
                return false;
            }
            if (((CharSequence)other).length() != this.length()) {
                return false;
            }
            return CharBufferBuilder.this.rangeEqualsImpl(this.start, (CharSequence)other, 0, this.length());
        }

        public int hashCode() {
            String string = this.stringified;
            return string != null ? string.hashCode() : CharBufferBuilder.this.hashCodeImpl(this.start, this.end);
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        public SubSequenceImpl(int start2, int end) {
            this.start = start2;
            this.end = end;
        }
    }
}

