/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.cio.websocket;

import io.ktor.http.cio.websocket.FrameParser$WhenMappings;
import io.ktor.http.cio.websocket.FrameType;
import io.ktor.http.cio.websocket.WebSocketInternalAPI;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@WebSocketInternalAPI
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u00010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010'\u001a\u00020(J\u0011\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020+H\u0086\u0010J\u0010\u0010,\u001a\u00020\u00042\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010-\u001a\u00020\u00042\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010.\u001a\u00020\u00042\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010/\u001a\u00020\u00042\u0006\u0010*\u001a\u00020+H\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R$\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u0006\"\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0006\"\u0004\b\u001b\u0010\u000bR*\u0010\u001c\u001a\u0004\u0018\u00010\u00112\b\u0010\u0007\u001a\u0004\u0018\u00010\u0011@BX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010!\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010\"\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010#\u001a\u0010\u0012\f\u0012\n &*\u0004\u0018\u00010%0%0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lio/ktor/http/cio/websocket/FrameParser;", "", "()V", "bodyReady", "", "getBodyReady", "()Z", "<set-?>", "fin", "getFin", "setFin", "(Z)V", "frameType", "Lio/ktor/http/cio/websocket/FrameType;", "getFrameType", "()Lio/ktor/http/cio/websocket/FrameType;", "lastOpcode", "", "", "length", "getLength", "()J", "setLength", "(J)V", "lengthLength", "mask", "getMask", "setMask", "maskKey", "getMaskKey", "()Ljava/lang/Integer;", "setMaskKey", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "opcode", "state", "Ljava/util/concurrent/atomic/AtomicReference;", "Lio/ktor/http/cio/websocket/FrameParser$State;", "kotlin.jvm.PlatformType", "bodyComplete", "", "frame", "bb", "Ljava/nio/ByteBuffer;", "handleStep", "parseHeader1", "parseLength", "parseMaskKey", "State", "ktor-http-cio"})
public final class FrameParser {
    private final AtomicReference<State> state = new AtomicReference<State>(State.HEADER0);
    private boolean fin;
    private boolean mask;
    private int opcode;
    private int lastOpcode;
    private int lengthLength;
    private long length;
    @Nullable
    private Integer maskKey;

    public final boolean getFin() {
        return this.fin;
    }

    private final void setFin(boolean bl) {
        this.fin = bl;
    }

    public final boolean getMask() {
        return this.mask;
    }

    private final void setMask(boolean bl) {
        this.mask = bl;
    }

    public final long getLength() {
        return this.length;
    }

    private final void setLength(long l) {
        this.length = l;
    }

    @Nullable
    public final Integer getMaskKey() {
        return this.maskKey;
    }

    private final void setMaskKey(Integer n) {
        this.maskKey = n;
    }

    @NotNull
    public final FrameType getFrameType() {
        FrameType frameType = FrameType.Companion.get(this.opcode);
        if (frameType == null) {
            throw (Throwable)new IllegalStateException("Unsupported opcode " + Integer.toHexString(this.opcode));
        }
        return frameType;
    }

    public final boolean getBodyReady() {
        return this.state.get() == State.BODY;
    }

    public final void bodyComplete() {
        if (!this.state.compareAndSet(State.BODY, State.HEADER0)) {
            throw (Throwable)new IllegalStateException("It should be state BODY but it is " + (Object)((Object)this.state.get()));
        }
        this.opcode = 0;
        this.length = 0L;
        this.lengthLength = 0;
        this.maskKey = null;
    }

    public final void frame(@NotNull ByteBuffer bb) {
        do {
            Intrinsics.checkParameterIsNotNull((Object)bb, (String)"bb");
            boolean bl = Intrinsics.areEqual((Object)bb.order(), (Object)ByteOrder.BIG_ENDIAN);
            if (bl) continue;
            String string = "Buffer order should be BIG_ENDIAN but it is " + bb.order();
            throw (Throwable)new IllegalArgumentException(string.toString());
        } while (this.handleStep(bb));
    }

    private final boolean handleStep(ByteBuffer bb) {
        boolean bl;
        State state = this.state.get();
        if (state == null) {
            Intrinsics.throwNpe();
        }
        switch (FrameParser$WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
            case 1: {
                bl = this.parseHeader1(bb);
                break;
            }
            case 2: {
                bl = this.parseLength(bb);
                break;
            }
            case 3: {
                bl = this.parseMaskKey(bb);
                break;
            }
            case 4: {
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private final boolean parseHeader1(ByteBuffer bb) {
        if (bb.remaining() >= 2) {
            int n;
            int n2;
            byte flagsAndOpcode = bb.get();
            byte maskAndLength1 = bb.get();
            this.fin = (flagsAndOpcode & 0x80) != 0;
            int n3 = flagsAndOpcode & 0xF;
            FrameParser frameParser = this;
            int n4 = n3;
            frameParser.opcode = n2 = n4 == 0 ? this.lastOpcode : n4;
            if (!this.getFrameType().getControlFrame()) {
                this.lastOpcode = this.opcode;
            }
            this.mask = (maskAndLength1 & 0x80) != 0;
            int length1 = maskAndLength1 & 0x7F;
            switch (length1) {
                case 126: {
                    n = 2;
                    break;
                }
                case 127: {
                    n = 8;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            this.lengthLength = n;
            long l = this.length = this.lengthLength == 0 ? (long)length1 : 0L;
            if (this.lengthLength > 0) {
                this.state.set(State.LENGTH);
            } else if (this.mask) {
                this.state.set(State.MASK_KEY);
            } else {
                this.state.set(State.BODY);
            }
            return true;
        }
        return false;
    }

    private final boolean parseLength(ByteBuffer bb) {
        if (bb.remaining() >= this.lengthLength) {
            long l;
            switch (this.lengthLength) {
                case 2: {
                    l = (long)bb.getShort() & 0xFFFFL;
                    break;
                }
                case 8: {
                    l = bb.getLong();
                    break;
                }
                default: {
                    throw (Throwable)new IllegalStateException();
                }
            }
            this.length = l;
            if (this.mask) {
                this.state.set(State.MASK_KEY);
            } else {
                this.state.set(State.BODY);
            }
            return true;
        }
        return false;
    }

    private final boolean parseMaskKey(ByteBuffer bb) {
        if (bb.remaining() >= 4) {
            this.maskKey = bb.getInt();
            this.state.set(State.BODY);
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lio/ktor/http/cio/websocket/FrameParser$State;", "", "(Ljava/lang/String;I)V", "HEADER0", "LENGTH", "MASK_KEY", "BODY", "ktor-http-cio"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State HEADER0;
        public static final /* enum */ State LENGTH;
        public static final /* enum */ State MASK_KEY;
        public static final /* enum */ State BODY;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[4];
            State[] stateArray2 = stateArray;
            stateArray[0] = HEADER0 = new State();
            stateArray[1] = LENGTH = new State();
            stateArray[2] = MASK_KEY = new State();
            stateArray[3] = BODY = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }
}

