/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.cio.websocket;

import io.ktor.http.cio.websocket.CloseReason;
import io.ktor.http.cio.websocket.Frame;
import io.ktor.util.NIOKt;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u0005\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\b\u00a8\u0006\t"}, d2={"readBytes", "", "Lio/ktor/http/cio/websocket/Frame;", "readReason", "Lio/ktor/http/cio/websocket/CloseReason;", "Lio/ktor/http/cio/websocket/Frame$Close;", "readText", "", "Lio/ktor/http/cio/websocket/Frame$Text;", "ktor-http-cio"})
public final class FrameKt {
    @NotNull
    public static final String readText(@NotNull Frame.Text $this$readText) {
        Intrinsics.checkParameterIsNotNull((Object)$this$readText, (String)"$this$readText");
        boolean bl = $this$readText.getFin();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Text could be only extracted from non-fragmented frame";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String string = Charsets.UTF_8.decode($this$readText.getBuffer().duplicate()).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Charsets.UTF_8.decode(bu\u2026r.duplicate()).toString()");
        return string;
    }

    @NotNull
    public static final byte[] readBytes(@NotNull Frame $this$readBytes) {
        Intrinsics.checkParameterIsNotNull((Object)$this$readBytes, (String)"$this$readBytes");
        ByteBuffer byteBuffer = $this$readBytes.getBuffer().duplicate();
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer.duplicate()");
        return NIOKt.moveToByteArray((ByteBuffer)byteBuffer);
    }

    @Nullable
    public static final CloseReason readReason(@NotNull Frame.Close $this$readReason) {
        Intrinsics.checkParameterIsNotNull((Object)$this$readReason, (String)"$this$readReason");
        if ($this$readReason.getBuffer().remaining() < 2) {
            return null;
        }
        $this$readReason.getBuffer().mark();
        short code = $this$readReason.getBuffer().getShort();
        String message = NIOKt.decodeString((ByteBuffer)$this$readReason.getBuffer(), (Charset)Charsets.UTF_8);
        $this$readReason.getBuffer().reset();
        return new CloseReason(code, message);
    }
}

