/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ContentType;
import io.ktor.http.ContentTypesKt;
import io.ktor.http.Cookie;
import io.ktor.http.CookieKt;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMessage;
import io.ktor.http.HttpMessageBuilder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u001a\u0012\u0010\u0000\u001a\n\u0018\u00010\u0001j\u0004\u0018\u0001`\u0002*\u00020\u0003\u001a\u0012\u0010\u0000\u001a\n\u0018\u00010\u0001j\u0004\u0018\u0001`\u0002*\u00020\u0004\u001a\u001f\u0010\u0000\u001a\u0004\u0018\u00010\u0005*\u00020\u00042\n\u0010\u0000\u001a\u00060\u0001j\u0002`\u0002H\u0007\u00a2\u0006\u0002\u0010\u0006\u001a\u0011\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u0003\u00a2\u0006\u0002\u0010\t\u001a\u0011\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u0004\u00a2\u0006\u0002\u0010\n\u001a\u0014\u0010\u0007\u001a\u00020\u0005*\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007\u001a\f\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u0003\u001a\f\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u0004\u001a\u0012\u0010\r\u001a\u00020\u0005*\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u000e\u001a\u0010\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011*\u00020\u0004\u001a\f\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u0003\u001a\f\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u0004\u001a\u0012\u0010\u0015\u001a\u00020\u0005*\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0014\u001a\u0012\u0010\u0017\u001a\u00020\u0005*\u00020\u00042\u0006\u0010\u0018\u001a\u00020\f\u001a\u0010\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011*\u00020\u0003\u001a\u0012\u0010\u001a\u001a\u00020\u0005*\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0014\u001a\u0012\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0011*\u00020\u0003\u001a\u0012\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0011*\u00020\u0004\u00a8\u0006\u001d"}, d2={"charset", "Ljava/nio/charset/Charset;", "Lkotlinx/io/charsets/Charset;", "Lio/ktor/http/HttpMessage;", "Lio/ktor/http/HttpMessageBuilder;", "", "(Lio/ktor/http/HttpMessageBuilder;Ljava/nio/charset/Charset;)Lkotlin/Unit;", "contentLength", "", "(Lio/ktor/http/HttpMessage;)Ljava/lang/Long;", "(Lio/ktor/http/HttpMessageBuilder;)Ljava/lang/Long;", "length", "", "contentType", "Lio/ktor/http/ContentType;", "type", "cookies", "", "Lio/ktor/http/Cookie;", "etag", "", "ifNoneMatch", "value", "maxAge", "seconds", "setCookie", "userAgent", "content", "vary", "ktor-http-jvm"})
public final class HttpMessagePropertiesKt {
    public static final void contentType(@NotNull HttpMessageBuilder $receiver, @NotNull ContentType type) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        $receiver.getHeaders().set(HttpHeaders.INSTANCE.getContentType(), type.toString());
    }

    @Deprecated(message="Content-Length is controlled by underlying engine. Don't specify it explicitly.")
    public static final void contentLength(@NotNull HttpMessageBuilder $receiver, int length) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        $receiver.getHeaders().set(HttpHeaders.INSTANCE.getContentLength(), String.valueOf(length));
    }

    @Deprecated(message="Use content with particular content type and charset instead")
    @Nullable
    public static final Unit charset(@NotNull HttpMessageBuilder $receiver, @NotNull Charset charset) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        ContentType contentType2 = HttpMessagePropertiesKt.contentType($receiver);
        if (contentType2 != null) {
            ContentType contentType3;
            ContentType it = contentType3 = contentType2;
            HttpMessagePropertiesKt.contentType($receiver, ContentTypesKt.withCharset(it, charset));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    public static final void maxAge(@NotNull HttpMessageBuilder $receiver, int seconds) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        $receiver.getHeaders().append(HttpHeaders.INSTANCE.getCacheControl(), "max-age:" + seconds);
    }

    public static final void ifNoneMatch(@NotNull HttpMessageBuilder $receiver, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        $receiver.getHeaders().set(HttpHeaders.INSTANCE.getIfNoneMatch(), value);
    }

    public static final void userAgent(@NotNull HttpMessageBuilder $receiver, @NotNull String content) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        $receiver.getHeaders().set(HttpHeaders.INSTANCE.getUserAgent(), content);
    }

    @Nullable
    public static final ContentType contentType(@NotNull HttpMessageBuilder $receiver) {
        ContentType contentType2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String string = $receiver.getHeaders().get(HttpHeaders.INSTANCE.getContentType());
        if (string != null) {
            String string2;
            String it = string2 = string;
            contentType2 = ContentType.Companion.parse(it);
        } else {
            contentType2 = null;
        }
        return contentType2;
    }

    @Nullable
    public static final Charset charset(@NotNull HttpMessageBuilder $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ContentType contentType2 = HttpMessagePropertiesKt.contentType($receiver);
        return contentType2 != null ? ContentTypesKt.charset(contentType2) : null;
    }

    @Nullable
    public static final String etag(@NotNull HttpMessageBuilder $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return $receiver.getHeaders().get(HttpHeaders.INSTANCE.getETag());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final List<String> vary(@NotNull HttpMessageBuilder $receiver) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Object object = $receiver.getHeaders().get(HttpHeaders.INSTANCE.getVary());
        if (object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null)) != null) {
            void var3_3;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)object;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                void var7_7;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                void v1 = var7_7 = it;
                if (v1 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String string2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)v1))).toString();
                collection.add(string2);
            }
            list = (List)var3_3;
        } else {
            list = null;
        }
        return list;
    }

    @Nullable
    public static final Long contentLength(@NotNull HttpMessageBuilder $receiver) {
        Long l;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String string = $receiver.getHeaders().get(HttpHeaders.INSTANCE.getContentLength());
        if (string != null) {
            String string2 = string;
            l = Long.parseLong(string2);
        } else {
            l = null;
        }
        return l;
    }

    @Nullable
    public static final ContentType contentType(@NotNull HttpMessage $receiver) {
        ContentType contentType2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String string = $receiver.getHeaders().get(HttpHeaders.INSTANCE.getContentType());
        if (string != null) {
            String string2;
            String it = string2 = string;
            contentType2 = ContentType.Companion.parse(it);
        } else {
            contentType2 = null;
        }
        return contentType2;
    }

    @Nullable
    public static final Charset charset(@NotNull HttpMessage $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ContentType contentType2 = HttpMessagePropertiesKt.contentType($receiver);
        return contentType2 != null ? ContentTypesKt.charset(contentType2) : null;
    }

    @Nullable
    public static final String etag(@NotNull HttpMessage $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return $receiver.getHeaders().get(HttpHeaders.INSTANCE.getETag());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final List<String> vary(@NotNull HttpMessage $receiver) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Object object = $receiver.getHeaders().get(HttpHeaders.INSTANCE.getVary());
        if (object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null)) != null) {
            void var3_3;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)object;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                void var7_7;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                void v1 = var7_7 = it;
                if (v1 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String string2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)v1))).toString();
                collection.add(string2);
            }
            list = (List)var3_3;
        } else {
            list = null;
        }
        return list;
    }

    @Nullable
    public static final Long contentLength(@NotNull HttpMessage $receiver) {
        Long l;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String string = $receiver.getHeaders().get(HttpHeaders.INSTANCE.getContentLength());
        if (string != null) {
            String string2 = string;
            l = Long.parseLong(string2);
        } else {
            l = null;
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Cookie> setCookie(@NotNull HttpMessage $receiver) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        List list2 = $receiver.getHeaders().getAll(HttpHeaders.INSTANCE.getSetCookie());
        if (list2 != null) {
            void var3_3;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)list2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                Cookie cookie = CookieKt.parseServerSetCookieHeader((String)it);
                collection.add(cookie);
            }
            list = (List)var3_3;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Cookie> cookies(@NotNull HttpMessageBuilder $receiver) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        List list2 = $receiver.getHeaders().getAll(HttpHeaders.INSTANCE.getSetCookie());
        if (list2 != null) {
            void var3_3;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)list2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                Cookie cookie = CookieKt.parseServerSetCookieHeader((String)it);
                collection.add(cookie);
            }
            list = (List)var3_3;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

