/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.content;

import io.ktor.http.ContentType;
import io.ktor.http.content.LastModifiedVersion;
import io.ktor.http.content.OutgoingContent;
import io.ktor.http.content.VersionsKt;
import io.ktor.util.cio.ByteBufferPoolKt;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.Collection;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import kotlinx.coroutines.io.ByteReadChannel;
import kotlinx.coroutines.io.jvm.javaio.ReadingKt;
import kotlinx.io.pool.ObjectPool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001d\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\b\u0010#\u001a\u00020$H\u0016R\u0016\u0010\f\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R#\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0017\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006%"}, d2={"Lio/ktor/http/content/JarFileContent;", "Lio/ktor/http/content/OutgoingContent$ReadChannelContent;", "zipFilePath", "Ljava/nio/file/Path;", "resourcePath", "", "contentType", "Lio/ktor/http/ContentType;", "(Ljava/nio/file/Path;Ljava/lang/String;Lio/ktor/http/ContentType;)V", "jarFile", "Ljava/io/File;", "(Ljava/io/File;Ljava/lang/String;Lio/ktor/http/ContentType;)V", "contentLength", "", "getContentLength", "()Ljava/lang/Long;", "getContentType", "()Lio/ktor/http/ContentType;", "jar", "Ljava/util/jar/JarFile;", "getJar", "()Ljava/util/jar/JarFile;", "jar$delegate", "Lkotlin/Lazy;", "jarEntry", "Ljava/util/jar/JarEntry;", "kotlin.jvm.PlatformType", "getJarEntry", "()Ljava/util/jar/JarEntry;", "jarEntry$delegate", "getJarFile", "()Ljava/io/File;", "normalized", "getResourcePath", "()Ljava/lang/String;", "readFrom", "Lkotlinx/coroutines/io/ByteReadChannel;", "ktor-http-jvm"})
public final class JarFileContent
extends OutgoingContent.ReadChannelContent {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final String normalized;
    private final Lazy jarEntry$delegate;
    private final Lazy jar$delegate;
    @NotNull
    private final File jarFile;
    @NotNull
    private final String resourcePath;
    @NotNull
    private final ContentType contentType;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(JarFileContent.class), "jarEntry", "getJarEntry()Ljava/util/jar/JarEntry;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(JarFileContent.class), "jar", "getJar()Ljava/util/jar/JarFile;"))};
    }

    private final JarEntry getJarEntry() {
        Lazy lazy = this.jarEntry$delegate;
        JarFileContent jarFileContent = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (JarEntry)lazy.getValue();
    }

    private final JarFile getJar() {
        Lazy lazy = this.jar$delegate;
        JarFileContent jarFileContent = this;
        KProperty kProperty = $$delegatedProperties[1];
        return (JarFile)lazy.getValue();
    }

    @Override
    @Nullable
    public Long getContentLength() {
        JarEntry jarEntry2 = this.getJarEntry();
        return jarEntry2 != null ? Long.valueOf(jarEntry2.getSize()) : null;
    }

    @Override
    @NotNull
    public ByteReadChannel readFrom() {
        InputStream inputStream = this.getJar().getInputStream(this.getJarEntry());
        if (inputStream == null || (inputStream = ReadingKt.toByteReadChannel$default((InputStream)inputStream, null, (ObjectPool)ByteBufferPoolKt.getKtorDefaultPool(), (int)1, null)) == null) {
            throw (Throwable)new IOException("Resource " + this.normalized + " not found");
        }
        return inputStream;
    }

    @NotNull
    public final File getJarFile() {
        return this.jarFile;
    }

    @NotNull
    public final String getResourcePath() {
        return this.resourcePath;
    }

    @Override
    @NotNull
    public ContentType getContentType() {
        return this.contentType;
    }

    public JarFileContent(@NotNull File jarFile, @NotNull String resourcePath, @NotNull ContentType contentType2) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)jarFile, (String)"jarFile");
        Intrinsics.checkParameterIsNotNull((Object)resourcePath, (String)"resourcePath");
        Intrinsics.checkParameterIsNotNull((Object)contentType2, (String)"contentType");
        this.jarFile = jarFile;
        this.resourcePath = resourcePath;
        this.contentType = contentType2;
        this.normalized = StringsKt.replace$default((String)((Object)Paths.get(this.resourcePath, new String[0]).normalize()).toString(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
        this.jarEntry$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<JarEntry>(this){
            final /* synthetic */ JarFileContent this$0;

            public final JarEntry invoke() {
                return JarFileContent.access$getJar$p(this.this$0).getJarEntry(this.this$0.getResourcePath());
            }
            {
                this.this$0 = jarFileContent;
                super(0);
            }
        }));
        this.jar$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<JarFile>(this){
            final /* synthetic */ JarFileContent this$0;

            @NotNull
            public final JarFile invoke() {
                return new JarFile(this.this$0.getJarFile());
            }
            {
                this.this$0 = jarFileContent;
                super(0);
            }
        }));
        boolean bl2 = bl = !StringsKt.startsWith$default((String)this.normalized, (String)"..", (boolean)false, (int)2, null);
        if (!bl) {
            String string = "Bad resource relative path " + this.resourcePath;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        JarFileContent jarFileContent = this;
        Collection collection = VersionsKt.getVersions(jarFileContent);
        JarEntry jarEntry2 = this.getJarEntry();
        Intrinsics.checkExpressionValueIsNotNull((Object)jarEntry2, (String)"jarEntry");
        FileTime fileTime = jarEntry2.getLastModifiedTime();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileTime, (String)"jarEntry.lastModifiedTime");
        VersionsKt.setVersions(jarFileContent, CollectionsKt.plus((Collection)collection, (Object)new LastModifiedVersion(fileTime)));
    }

    public JarFileContent(@NotNull Path zipFilePath, @NotNull String resourcePath, @NotNull ContentType contentType2) {
        Intrinsics.checkParameterIsNotNull((Object)zipFilePath, (String)"zipFilePath");
        Intrinsics.checkParameterIsNotNull((Object)resourcePath, (String)"resourcePath");
        Intrinsics.checkParameterIsNotNull((Object)contentType2, (String)"contentType");
        File file = zipFilePath.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"zipFilePath.toFile()");
        this(file, resourcePath, contentType2);
    }

    @NotNull
    public static final /* synthetic */ JarFile access$getJar$p(JarFileContent $this) {
        return $this.getJar();
    }
}

