/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.util.KtorExperimentalAPI;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\u001a\f\u0010\b\u001a\u00020\t*\u00020\nH\u0007\u001a\n\u0010\u000b\u001a\u00020\n*\u00020\f\u001a\f\u0010\u000b\u001a\u00020\n*\u00020\rH\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"GreenwichMeanTime", "Ljava/time/ZoneId;", "httpDateFormat", "Ljava/time/format/DateTimeFormatter;", "httpDateFormat$annotations", "()V", "getHttpDateFormat", "()Ljava/time/format/DateTimeFormatter;", "fromHttpDateString", "Ljava/time/ZonedDateTime;", "", "toHttpDateString", "Ljava/time/temporal/Temporal;", "", "ktor-http"})
public final class HttpDateKt {
    private static final ZoneId GreenwichMeanTime;
    @NotNull
    private static final DateTimeFormatter httpDateFormat;

    @KtorExperimentalAPI
    @NotNull
    public static final String toHttpDateString(long $this$toHttpDateString) {
        Instant instant = Instant.ofEpochMilli($this$toHttpDateString);
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"Instant.ofEpochMilli(this)");
        return HttpDateKt.toHttpDateString(instant);
    }

    @NotNull
    public static final String toHttpDateString(@NotNull Temporal $this$toHttpDateString) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toHttpDateString, (String)"$this$toHttpDateString");
        String string = httpDateFormat.format($this$toHttpDateString);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"httpDateFormat.format(this)");
        return string;
    }

    @KtorExperimentalAPI
    @NotNull
    public static final ZonedDateTime fromHttpDateString(@NotNull String $this$fromHttpDateString) {
        Intrinsics.checkParameterIsNotNull((Object)$this$fromHttpDateString, (String)"$this$fromHttpDateString");
        ZonedDateTime zonedDateTime = ZonedDateTime.parse($this$fromHttpDateString, httpDateFormat);
        Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime, (String)"ZonedDateTime.parse(this, httpDateFormat)");
        return zonedDateTime;
    }

    @KtorExperimentalAPI
    public static /* synthetic */ void httpDateFormat$annotations() {
    }

    @NotNull
    public static final DateTimeFormatter getHttpDateFormat() {
        return httpDateFormat;
    }

    static {
        ZoneId zoneId = ZoneId.of("GMT");
        Intrinsics.checkExpressionValueIsNotNull((Object)zoneId, (String)"ZoneId.of(\"GMT\")");
        GreenwichMeanTime = zoneId;
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss z").withLocale(Locale.US).withZone(GreenwichMeanTime);
        if (dateTimeFormatter == null) {
            Intrinsics.throwNpe();
        }
        httpDateFormat = dateTimeFormatter;
    }
}

