/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ContentType;
import io.ktor.http.HeaderValue;
import io.ktor.http.HeaderValueParam;
import io.ktor.http.HttpHeaderValueParserKt;
import io.ktor.util.KtorExperimentalAPI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u001a \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tH\u0007\u001a>\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u001c\u0010\r\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00020\u000fj\b\u0012\u0004\u0012\u00020\u0002`\u00100\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a6\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u001c\u0010\u0012\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00130\u000fj\b\u0012\u0004\u0012\u00020\u0013`\u00100\u000eH\u0002\u001a$\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000bH\u0002\u001a$\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000bH\u0002\u001a\u001c\u0010\u0018\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000bH\u0002\u001a$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u0001*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00150\u001bH\u0007\u001a$\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u0001\"\u0004\b\u0000\u0010\u001d*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001d0\u00010\u000eH\u0002\u00a8\u0006\u001e"}, d2={"parseAndSortContentTypeHeader", "", "Lio/ktor/http/HeaderValue;", "header", "", "parseAndSortHeader", "parseHeaderValue", "text", "parametersOnly", "", "parseHeaderValueItem", "", "start", "items", "Lkotlin/Lazy;", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "parseHeaderValueParameter", "parameters", "Lio/ktor/http/HeaderValueParam;", "parseHeaderValueParameterValue", "Lkotlin/Pair;", "value", "parseHeaderValueParameterValueQuoted", "subtrim", "end", "toHeaderParamsList", "", "valueOrEmpty", "T", "ktor-http"})
public final class HttpHeaderValueParserKt {
    @NotNull
    public static final List<HeaderValue> parseAndSortHeader(@Nullable String header) {
        Iterable $this$sortedByDescending$iv = HttpHeaderValueParserKt.parseHeaderValue(header);
        boolean $i$f$sortedByDescending = false;
        Iterable iterable = $this$sortedByDescending$iv;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                HeaderValue it = (HeaderValue)b;
                boolean bl2 = false;
                Comparable comparable = Double.valueOf(it.getQuality());
                it = (HeaderValue)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Double d = it.getQuality();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
            }
        };
        return CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
    }

    @NotNull
    public static final List<HeaderValue> parseAndSortContentTypeHeader(@Nullable String header) {
        Comparator comparator;
        Iterable iterable = HttpHeaderValueParserKt.parseHeaderValue(header);
        boolean bl = false;
        Comparator comparator2 = comparator = (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                HeaderValue it = (HeaderValue)b;
                boolean bl2 = false;
                Comparable comparable = Double.valueOf(it.getQuality());
                it = (HeaderValue)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Double d = it.getQuality();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
            }
        };
        boolean bl2 = false;
        comparator2 = comparator = (Comparator)new Comparator<T>(comparator2){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = comparator;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    boolean bl = false;
                    HeaderValue it = (HeaderValue)a;
                    boolean bl2 = false;
                    ContentType contentType2 = ContentType.Companion.parse(it.getValue());
                    int asterisks = 0;
                    if (Intrinsics.areEqual((Object)contentType2.getContentType(), (Object)"*")) {
                        asterisks += 2;
                    }
                    if (Intrinsics.areEqual((Object)contentType2.getContentSubtype(), (Object)"*")) {
                        ++asterisks;
                    }
                    it = (HeaderValue)b;
                    Comparable comparable = Integer.valueOf(asterisks);
                    bl2 = false;
                    contentType2 = ContentType.Companion.parse(it.getValue());
                    asterisks = 0;
                    if (Intrinsics.areEqual((Object)contentType2.getContentType(), (Object)"*")) {
                        asterisks += 2;
                    }
                    if (Intrinsics.areEqual((Object)contentType2.getContentSubtype(), (Object)"*")) {
                        ++asterisks;
                    }
                    Integer n2 = asterisks;
                    n = ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n2);
                }
                return n;
            }
        };
        bl2 = false;
        comparator = new Comparator<T>(comparator2){
            final /* synthetic */ Comparator $this_thenByDescending;
            {
                this.$this_thenByDescending = comparator;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenByDescending.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    boolean bl = false;
                    HeaderValue it = (HeaderValue)b;
                    boolean bl2 = false;
                    Comparable comparable = Integer.valueOf(it.getParams().size());
                    it = (HeaderValue)a;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Integer n2 = it.getParams().size();
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n2);
                }
                return n;
            }
        };
        return CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
    }

    @NotNull
    public static final List<HeaderValue> parseHeaderValue(@Nullable String text) {
        return HttpHeaderValueParserKt.parseHeaderValue(text, false);
    }

    @KtorExperimentalAPI
    @NotNull
    public static final List<HeaderValue> parseHeaderValue(@Nullable String text, boolean parametersOnly) {
        if (text == null) {
            return CollectionsKt.emptyList();
        }
        int pos = 0;
        Lazy items2 = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)parseHeaderValue.items.1.INSTANCE);
        while (pos <= StringsKt.getLastIndex((CharSequence)text)) {
            pos = HttpHeaderValueParserKt.parseHeaderValueItem(text, pos, (Lazy<? extends ArrayList<HeaderValue>>)items2, parametersOnly);
        }
        return HttpHeaderValueParserKt.valueOrEmpty(items2);
    }

    /*
     * WARNING - void declaration
     */
    @KtorExperimentalAPI
    @NotNull
    public static final List<HeaderValueParam> toHeaderParamsList(@NotNull Iterable<Pair<String, String>> $this$toHeaderParamsList) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull($this$toHeaderParamsList, (String)"$this$toHeaderParamsList");
        Iterable<Pair<String, String>> $this$map$iv = $this$toHeaderParamsList;
        boolean $i$f$map = false;
        Iterable<Pair<String, String>> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            HeaderValueParam headerValueParam = new HeaderValueParam((String)it.getFirst(), (String)it.getSecond());
            collection.add(headerValueParam);
        }
        return (List)destination$iv$iv;
    }

    private static final <T> List<T> valueOrEmpty(@NotNull Lazy<? extends List<? extends T>> $this$valueOrEmpty) {
        return $this$valueOrEmpty.isInitialized() ? (List)$this$valueOrEmpty.getValue() : CollectionsKt.emptyList();
    }

    private static final String subtrim(@NotNull String $this$subtrim, int start, int end) {
        String string = $this$subtrim;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(start, end);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        string = string3;
        bl = false;
        String string4 = string;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string4)).toString();
    }

    private static final int parseHeaderValueItem(String text, int start, Lazy<? extends ArrayList<HeaderValue>> items2, boolean parametersOnly) {
        Integer valueEnd;
        int pos = start;
        Lazy parameters2 = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)parseHeaderValueItem.parameters.1.INSTANCE);
        Integer n = valueEnd = parametersOnly ? Integer.valueOf(pos) : null;
        block4: while (pos <= StringsKt.getLastIndex((CharSequence)text)) {
            switch (text.charAt(pos)) {
                case ',': {
                    Integer n2 = valueEnd;
                    ((ArrayList)items2.getValue()).add(new HeaderValue(HttpHeaderValueParserKt.subtrim(text, start, n2 != null ? n2 : pos), HttpHeaderValueParserKt.valueOrEmpty(parameters2)));
                    return pos + 1;
                }
                case ';': {
                    if (valueEnd == null) {
                        valueEnd = pos;
                    }
                    pos = HttpHeaderValueParserKt.parseHeaderValueParameter(text, pos + 1, (Lazy<? extends ArrayList<HeaderValueParam>>)parameters2);
                    continue block4;
                }
            }
            pos = parametersOnly ? HttpHeaderValueParserKt.parseHeaderValueParameter(text, pos, (Lazy<? extends ArrayList<HeaderValueParam>>)parameters2) : pos + 1;
        }
        Integer n3 = valueEnd;
        ((ArrayList)items2.getValue()).add(new HeaderValue(HttpHeaderValueParserKt.subtrim(text, start, n3 != null ? n3 : pos), HttpHeaderValueParserKt.valueOrEmpty(parameters2)));
        return pos;
    }

    /*
     * WARNING - void declaration
     */
    private static final int parseHeaderValueParameter(String text, int start, Lazy<? extends ArrayList<HeaderValueParam>> parameters2) {
        int pos;
        Function4<String, Integer, Integer, String, Unit> $fun$addParam$1 = new Function4<String, Integer, Integer, String, Unit>(parameters2){
            final /* synthetic */ Lazy $parameters;

            public final void invoke(@NotNull String text, int start, int end, @NotNull String value) {
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
                String name = HttpHeaderValueParserKt.access$subtrim(text, start, end);
                CharSequence charSequence = name;
                boolean bl = false;
                if (charSequence.length() == 0) {
                    return;
                }
                ((ArrayList)this.$parameters.getValue()).add(new HeaderValueParam(name, value));
            }
            {
                this.$parameters = lazy;
                super(4);
            }
        };
        for (pos = start; pos <= StringsKt.getLastIndex((CharSequence)text); ++pos) {
            switch (text.charAt(pos)) {
                case '=': {
                    void paramEnd;
                    Pair<Integer, String> pair = HttpHeaderValueParserKt.parseHeaderValueParameterValue(text, pos + 1);
                    int n = ((Number)pair.component1()).intValue();
                    String paramValue = (String)pair.component2();
                    $fun$addParam$1.invoke(text, start, pos, paramValue);
                    return (int)paramEnd;
                }
                case ',': 
                case ';': {
                    $fun$addParam$1.invoke(text, start, pos, "");
                    return pos;
                }
            }
        }
        $fun$addParam$1.invoke(text, start, pos, "");
        return pos;
    }

    private static final Pair<Integer, String> parseHeaderValueParameterValue(String value, int start) {
        int pos;
        for (pos = start; pos <= StringsKt.getLastIndex((CharSequence)value); ++pos) {
            switch (value.charAt(pos)) {
                case '\"': {
                    return HttpHeaderValueParserKt.parseHeaderValueParameterValueQuoted(value, pos + 1);
                }
                case ',': 
                case ';': {
                    return TuplesKt.to((Object)pos, (Object)HttpHeaderValueParserKt.subtrim(value, start, pos));
                }
            }
        }
        return TuplesKt.to((Object)pos, (Object)HttpHeaderValueParserKt.subtrim(value, start, pos));
    }

    private static final Pair<Integer, String> parseHeaderValueParameterValueQuoted(String value, int start) {
        int pos = start;
        StringBuilder sb = new StringBuilder();
        block4: while (pos <= StringsKt.getLastIndex((CharSequence)value)) {
            char c = value.charAt(pos);
            switch (c) {
                case '\"': {
                    return TuplesKt.to((Object)(pos + 1), (Object)sb.toString());
                }
                case '\\': {
                    if (pos < StringsKt.getLastIndex((CharSequence)value) - 2) {
                        sb.append(value.charAt(pos + 1));
                        pos += 2;
                        continue block4;
                    }
                    sb.append(c);
                    ++pos;
                    continue block4;
                }
            }
            sb.append(c);
            ++pos;
        }
        return TuplesKt.to((Object)pos, (Object)sb.toString());
    }

    public static final /* synthetic */ String access$subtrim(String $this$access_u24subtrim, int start, int end) {
        return HttpHeaderValueParserKt.subtrim($this$access_u24subtrim, start, end);
    }
}

