/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.HttpHeadersKt;
import io.ktor.http.IllegalHeaderNameException;
import io.ktor.http.IllegalHeaderValueException;
import io.ktor.util.KtorExperimentalAPI;
import java.util.Arrays;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0003\b\u00a7\u0001\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u001d\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u00d0\u0001\u001a\u00030\u00d1\u00012\u0007\u0010\u00d2\u0001\u001a\u00020\u0004H\u0007J\u0013\u0010\u00d3\u0001\u001a\u00030\u00d1\u00012\u0007\u0010\u00d4\u0001\u001a\u00020\u0004H\u0007J\u0011\u0010\u00d5\u0001\u001a\u00030\u00d6\u00012\u0007\u0010\u00d7\u0001\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0014\u0010\u0013\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0014\u0010\u0015\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0014\u0010\u0017\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0014\u0010\u0019\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R\u0014\u0010\u001b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0006R\u0014\u0010\u001d\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0006R\u0014\u0010\u001f\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0006R\u0014\u0010!\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0006R\u0014\u0010#\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0006R\u0014\u0010%\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0006R\u0014\u0010'\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0006R\u0014\u0010)\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0006R\u0014\u0010+\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0006R\u0014\u0010-\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0006R\u0014\u0010/\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0006R\u0014\u00101\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u0006R\u0014\u00103\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u0006R\u0014\u00105\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\u0006R\u0014\u00107\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\u0006R\u0014\u00109\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010\u0006R\u0014\u0010;\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010\u0006R\u0014\u0010=\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010\u0006R\u0014\u0010?\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010\u0006R\u0014\u0010A\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010\u0006R\u0014\u0010C\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010\u0006R\u0014\u0010E\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010\u0006R\u0014\u0010G\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010\u0006R\u0014\u0010I\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010\u0006R\u0014\u0010K\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010\u0006R\u0014\u0010M\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u0010\u0006R\u0014\u0010O\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bP\u0010\u0006R\u0014\u0010Q\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010\u0006R\u0014\u0010S\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bT\u0010\u0006R\u0014\u0010U\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bV\u0010\u0006R\u0014\u0010W\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bX\u0010\u0006R\u0014\u0010Y\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bZ\u0010\u0006R\u0014\u0010[\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\\\u0010\u0006R\u0014\u0010]\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b^\u0010\u0006R\u0014\u0010_\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b`\u0010\u0006R\u0014\u0010a\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bb\u0010\u0006R\u0014\u0010c\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bd\u0010\u0006R\u0014\u0010e\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bf\u0010\u0006R\u0014\u0010g\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bh\u0010\u0006R\u0014\u0010i\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bj\u0010\u0006R\u0014\u0010k\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bl\u0010\u0006R\u0014\u0010m\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bn\u0010\u0006R\u0014\u0010o\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bp\u0010\u0006R\u0014\u0010q\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\br\u0010\u0006R\u0014\u0010s\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bt\u0010\u0006R\u0014\u0010u\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bv\u0010\u0006R\u0014\u0010w\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bx\u0010\u0006R\u0014\u0010y\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bz\u0010\u0006R\u0014\u0010{\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b|\u0010\u0006R\u0014\u0010}\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b~\u0010\u0006R\u0015\u0010\u007f\u001a\u00020\u0004X\u0086D\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0080\u0001\u0010\u0006R\u0016\u0010\u0081\u0001\u001a\u00020\u0004X\u0086D\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0082\u0001\u0010\u0006R\u0016\u0010\u0083\u0001\u001a\u00020\u0004X\u0086D\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0084\u0001\u0010\u0006R\u0016\u0010\u0085\u0001\u001a\u00020\u0004X\u0086D\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0086\u0001\u0010\u0006R\u0016\u0010\u0087\u0001\u001a\u00020\u0004X\u0086D\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0088\u0001\u0010\u0006R\u0016\u0010\u0089\u0001\u001a\u00020\u0004X\u0086D\u00a2\u0006\t\n\u0000\u001a\u0005\b\u008a\u0001\u0010\u0006R\u0016\u0010\u008b\u0001\u001a\u00020\u0004X\u0086D\u00a2\u0006\t\n\u0000\u001a\u0005\b\u008c\u0001\u0010\u0006R\u0016\u0010\u008d\u0001\u001a\u00020\u0004X\u0086D\u00a2\u0006\t\n\u0000\u001a\u0005\b\u008e\u0001\u0010\u0006R\u0016\u0010\u008f\u0001\u001a\u00020\u0004X\u0086D\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0090\u0001\u0010\u0006R\u0016\u0010\u0091\u0001\u001a\u00020\u0004X\u0086D\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0092\u0001\u0010\u0006R\u0016\u0010\u0093\u0001\u001a\u00020\u0004X\u0086D\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0094\u0001\u0010\u0006R\u0016\u0010\u0095\u0001\u001a\u00020\u0004X\u0086D\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0096\u0001\u0010\u0006R\u0016\u0010\u0097\u0001\u001a\u00020\u0004X\u0086D\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0098\u0001\u0010\u0006R\u0016\u0010\u0099\u0001\u001a\u00020\u0004X\u0086D\u00a2\u0006\t\n\u0000\u001a\u0005\b\u009a\u0001\u0010\u0006R\u0016\u0010\u009b\u0001\u001a\u00020\u0004X\u0086D\u00a2\u0006\t\n\u0000\u001a\u0005\b\u009c\u0001\u0010\u0006R\u0016\u0010\u009d\u0001\u001a\u00020\u0004X\u0086D\u00a2\u0006\t\n\u0000\u001a\u0005\b\u009e\u0001\u0010\u0006R\u0016\u0010\u009f\u0001\u001a\u00020\u0004X\u0086D\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00a0\u0001\u0010\u0006R\u0016\u0010\u00a1\u0001\u001a\u00020\u0004X\u0086D\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00a2\u0001\u0010\u0006R\u0016\u0010\u00a3\u0001\u001a\u00020\u0004X\u0086D\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00a4\u0001\u0010\u0006R\u0016\u0010\u00a5\u0001\u001a\u00020\u0004X\u0086D\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00a6\u0001\u0010\u0006R\u0016\u0010\u00a7\u0001\u001a\u00020\u0004X\u0086D\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00a8\u0001\u0010\u0006R\u0016\u0010\u00a9\u0001\u001a\u00020\u0004X\u0086D\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00aa\u0001\u0010\u0006R%\u0010\u00ab\u0001\u001a\t\u0012\u0004\u0012\u00020\u00040\u00ac\u00018FX\u0087\u0004\u00a2\u0006\u000f\u0012\u0005\b\u00ad\u0001\u0010\u0002\u001a\u0006\b\u00ae\u0001\u0010\u00af\u0001R\u0019\u0010\u00b0\u0001\u001a\t\u0012\u0004\u0012\u00020\u00040\u00ac\u0001X\u0082\u0004\u00a2\u0006\u0005\n\u0003\u0010\u00b1\u0001R\u001b\u0010\u00b2\u0001\u001a\t\u0012\u0004\u0012\u00020\u00040\u00b3\u0001\u00a2\u0006\n\n\u0000\u001a\u0006\b\u00b4\u0001\u0010\u00b5\u0001R\u0016\u0010\u00b6\u0001\u001a\u00020\u0004X\u0086D\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00b7\u0001\u0010\u0006R\u0016\u0010\u00b8\u0001\u001a\u00020\u0004X\u0086D\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00b9\u0001\u0010\u0006R\u0016\u0010\u00ba\u0001\u001a\u00020\u0004X\u0086D\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00bb\u0001\u0010\u0006R\u0016\u0010\u00bc\u0001\u001a\u00020\u0004X\u0086D\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00bd\u0001\u0010\u0006R\u0016\u0010\u00be\u0001\u001a\u00020\u0004X\u0086D\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00bf\u0001\u0010\u0006R\u0016\u0010\u00c0\u0001\u001a\u00020\u0004X\u0086D\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00c1\u0001\u0010\u0006R\u0016\u0010\u00c2\u0001\u001a\u00020\u0004X\u0086D\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00c3\u0001\u0010\u0006R\u0016\u0010\u00c4\u0001\u001a\u00020\u0004X\u0086D\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00c5\u0001\u0010\u0006R\u0016\u0010\u00c6\u0001\u001a\u00020\u0004X\u0086D\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00c7\u0001\u0010\u0006R\u0016\u0010\u00c8\u0001\u001a\u00020\u0004X\u0086D\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00c9\u0001\u0010\u0006R\u0016\u0010\u00ca\u0001\u001a\u00020\u0004X\u0086D\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00cb\u0001\u0010\u0006R\u0016\u0010\u00cc\u0001\u001a\u00020\u0004X\u0086D\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00cd\u0001\u0010\u0006R\u0016\u0010\u00ce\u0001\u001a\u00020\u0004X\u0086D\u00a2\u0006\t\n\u0000\u001a\u0005\b\u00cf\u0001\u0010\u0006\u00a8\u0006\u00d8\u0001"}, d2={"Lio/ktor/http/HttpHeaders;", "", "()V", "ALPN", "", "getALPN", "()Ljava/lang/String;", "Accept", "getAccept", "AcceptCharset", "getAcceptCharset", "AcceptEncoding", "getAcceptEncoding", "AcceptLanguage", "getAcceptLanguage", "AcceptRanges", "getAcceptRanges", "AccessControlAllowCredentials", "getAccessControlAllowCredentials", "AccessControlAllowHeaders", "getAccessControlAllowHeaders", "AccessControlAllowMethods", "getAccessControlAllowMethods", "AccessControlAllowOrigin", "getAccessControlAllowOrigin", "AccessControlExposeHeaders", "getAccessControlExposeHeaders", "AccessControlMaxAge", "getAccessControlMaxAge", "AccessControlRequestHeaders", "getAccessControlRequestHeaders", "AccessControlRequestMethod", "getAccessControlRequestMethod", "Age", "getAge", "Allow", "getAllow", "AuthenticationInfo", "getAuthenticationInfo", "Authorization", "getAuthorization", "CacheControl", "getCacheControl", "Connection", "getConnection", "ContentDisposition", "getContentDisposition", "ContentEncoding", "getContentEncoding", "ContentLanguage", "getContentLanguage", "ContentLength", "getContentLength", "ContentLocation", "getContentLocation", "ContentRange", "getContentRange", "ContentType", "getContentType", "Cookie", "getCookie", "DASL", "getDASL", "DAV", "getDAV", "Date", "getDate", "Depth", "getDepth", "Destination", "getDestination", "ETag", "getETag", "Expect", "getExpect", "Expires", "getExpires", "Forwarded", "getForwarded", "From", "getFrom", "HTTP2Settings", "getHTTP2Settings", "Host", "getHost", "If", "getIf", "IfMatch", "getIfMatch", "IfModifiedSince", "getIfModifiedSince", "IfNoneMatch", "getIfNoneMatch", "IfRange", "getIfRange", "IfScheduleTagMatch", "getIfScheduleTagMatch", "IfUnmodifiedSince", "getIfUnmodifiedSince", "LastModified", "getLastModified", "Link", "getLink", "Location", "getLocation", "LockToken", "getLockToken", "MIMEVersion", "getMIMEVersion", "MaxForwards", "getMaxForwards", "OrderingType", "getOrderingType", "Origin", "getOrigin", "Overwrite", "getOverwrite", "Position", "getPosition", "Pragma", "getPragma", "Prefer", "getPrefer", "PreferenceApplied", "getPreferenceApplied", "ProxyAuthenticate", "getProxyAuthenticate", "ProxyAuthenticationInfo", "getProxyAuthenticationInfo", "ProxyAuthorization", "getProxyAuthorization", "PublicKeyPins", "getPublicKeyPins", "PublicKeyPinsReportOnly", "getPublicKeyPinsReportOnly", "Range", "getRange", "Referrer", "getReferrer", "RetryAfter", "getRetryAfter", "SLUG", "getSLUG", "ScheduleReply", "getScheduleReply", "ScheduleTag", "getScheduleTag", "SecWebSocketAccept", "getSecWebSocketAccept", "SecWebSocketExtensions", "getSecWebSocketExtensions", "SecWebSocketKey", "getSecWebSocketKey", "SecWebSocketProtocol", "getSecWebSocketProtocol", "SecWebSocketVersion", "getSecWebSocketVersion", "Server", "getServer", "SetCookie", "getSetCookie", "StrictTransportSecurity", "getStrictTransportSecurity", "TE", "getTE", "Timeout", "getTimeout", "Trailer", "getTrailer", "TransferEncoding", "getTransferEncoding", "UnsafeHeaders", "", "UnsafeHeaders$annotations", "getUnsafeHeaders", "()[Ljava/lang/String;", "UnsafeHeadersArray", "[Ljava/lang/String;", "UnsafeHeadersList", "", "getUnsafeHeadersList", "()Ljava/util/List;", "Upgrade", "getUpgrade", "UserAgent", "getUserAgent", "Vary", "getVary", "Via", "getVia", "WWWAuthenticate", "getWWWAuthenticate", "Warning", "getWarning", "XCorrelationId", "getXCorrelationId", "XForwardedFor", "getXForwardedFor", "XForwardedHost", "getXForwardedHost", "XForwardedProto", "getXForwardedProto", "XForwardedServer", "getXForwardedServer", "XHttpMethodOverride", "getXHttpMethodOverride", "XRequestId", "getXRequestId", "checkHeaderName", "", "name", "checkHeaderValue", "value", "isUnsafe", "", "header", "ktor-http"})
public final class HttpHeaders {
    @NotNull
    private static final String Accept;
    @NotNull
    private static final String AcceptCharset;
    @NotNull
    private static final String AcceptEncoding;
    @NotNull
    private static final String AcceptLanguage;
    @NotNull
    private static final String AcceptRanges;
    @NotNull
    private static final String Age;
    @NotNull
    private static final String Allow;
    @NotNull
    private static final String ALPN;
    @NotNull
    private static final String AuthenticationInfo;
    @NotNull
    private static final String Authorization;
    @NotNull
    private static final String CacheControl;
    @NotNull
    private static final String Connection;
    @NotNull
    private static final String ContentDisposition;
    @NotNull
    private static final String ContentEncoding;
    @NotNull
    private static final String ContentLanguage;
    @NotNull
    private static final String ContentLength;
    @NotNull
    private static final String ContentLocation;
    @NotNull
    private static final String ContentRange;
    @NotNull
    private static final String ContentType;
    @NotNull
    private static final String Cookie;
    @NotNull
    private static final String DASL;
    @NotNull
    private static final String Date;
    @NotNull
    private static final String DAV;
    @NotNull
    private static final String Depth;
    @NotNull
    private static final String Destination;
    @NotNull
    private static final String ETag;
    @NotNull
    private static final String Expect;
    @NotNull
    private static final String Expires;
    @NotNull
    private static final String From;
    @NotNull
    private static final String Forwarded;
    @NotNull
    private static final String Host;
    @NotNull
    private static final String HTTP2Settings;
    @NotNull
    private static final String If;
    @NotNull
    private static final String IfMatch;
    @NotNull
    private static final String IfModifiedSince;
    @NotNull
    private static final String IfNoneMatch;
    @NotNull
    private static final String IfRange;
    @NotNull
    private static final String IfScheduleTagMatch;
    @NotNull
    private static final String IfUnmodifiedSince;
    @NotNull
    private static final String LastModified;
    @NotNull
    private static final String Location;
    @NotNull
    private static final String LockToken;
    @NotNull
    private static final String Link;
    @NotNull
    private static final String MaxForwards;
    @NotNull
    private static final String MIMEVersion;
    @NotNull
    private static final String OrderingType;
    @NotNull
    private static final String Origin;
    @NotNull
    private static final String Overwrite;
    @NotNull
    private static final String Position;
    @NotNull
    private static final String Pragma;
    @NotNull
    private static final String Prefer;
    @NotNull
    private static final String PreferenceApplied;
    @NotNull
    private static final String ProxyAuthenticate;
    @NotNull
    private static final String ProxyAuthenticationInfo;
    @NotNull
    private static final String ProxyAuthorization;
    @NotNull
    private static final String PublicKeyPins;
    @NotNull
    private static final String PublicKeyPinsReportOnly;
    @NotNull
    private static final String Range;
    @NotNull
    private static final String Referrer;
    @NotNull
    private static final String RetryAfter;
    @NotNull
    private static final String ScheduleReply;
    @NotNull
    private static final String ScheduleTag;
    @NotNull
    private static final String SecWebSocketAccept;
    @NotNull
    private static final String SecWebSocketExtensions;
    @NotNull
    private static final String SecWebSocketKey;
    @NotNull
    private static final String SecWebSocketProtocol;
    @NotNull
    private static final String SecWebSocketVersion;
    @NotNull
    private static final String Server;
    @NotNull
    private static final String SetCookie;
    @NotNull
    private static final String SLUG;
    @NotNull
    private static final String StrictTransportSecurity;
    @NotNull
    private static final String TE;
    @NotNull
    private static final String Timeout;
    @NotNull
    private static final String Trailer;
    @NotNull
    private static final String TransferEncoding;
    @NotNull
    private static final String Upgrade;
    @NotNull
    private static final String UserAgent;
    @NotNull
    private static final String Vary;
    @NotNull
    private static final String Via;
    @NotNull
    private static final String Warning;
    @NotNull
    private static final String WWWAuthenticate;
    @NotNull
    private static final String AccessControlAllowOrigin;
    @NotNull
    private static final String AccessControlAllowMethods;
    @NotNull
    private static final String AccessControlAllowCredentials;
    @NotNull
    private static final String AccessControlAllowHeaders;
    @NotNull
    private static final String AccessControlRequestMethod;
    @NotNull
    private static final String AccessControlRequestHeaders;
    @NotNull
    private static final String AccessControlExposeHeaders;
    @NotNull
    private static final String AccessControlMaxAge;
    @NotNull
    private static final String XHttpMethodOverride;
    @NotNull
    private static final String XForwardedHost;
    @NotNull
    private static final String XForwardedServer;
    @NotNull
    private static final String XForwardedProto;
    @NotNull
    private static final String XForwardedFor;
    @NotNull
    private static final String XRequestId;
    @NotNull
    private static final String XCorrelationId;
    private static final String[] UnsafeHeadersArray;
    @NotNull
    private static final List<String> UnsafeHeadersList;
    public static final HttpHeaders INSTANCE;

    @NotNull
    public final String getAccept() {
        return Accept;
    }

    @NotNull
    public final String getAcceptCharset() {
        return AcceptCharset;
    }

    @NotNull
    public final String getAcceptEncoding() {
        return AcceptEncoding;
    }

    @NotNull
    public final String getAcceptLanguage() {
        return AcceptLanguage;
    }

    @NotNull
    public final String getAcceptRanges() {
        return AcceptRanges;
    }

    @NotNull
    public final String getAge() {
        return Age;
    }

    @NotNull
    public final String getAllow() {
        return Allow;
    }

    @NotNull
    public final String getALPN() {
        return ALPN;
    }

    @NotNull
    public final String getAuthenticationInfo() {
        return AuthenticationInfo;
    }

    @NotNull
    public final String getAuthorization() {
        return Authorization;
    }

    @NotNull
    public final String getCacheControl() {
        return CacheControl;
    }

    @NotNull
    public final String getConnection() {
        return Connection;
    }

    @NotNull
    public final String getContentDisposition() {
        return ContentDisposition;
    }

    @NotNull
    public final String getContentEncoding() {
        return ContentEncoding;
    }

    @NotNull
    public final String getContentLanguage() {
        return ContentLanguage;
    }

    @NotNull
    public final String getContentLength() {
        return ContentLength;
    }

    @NotNull
    public final String getContentLocation() {
        return ContentLocation;
    }

    @NotNull
    public final String getContentRange() {
        return ContentRange;
    }

    @NotNull
    public final String getContentType() {
        return ContentType;
    }

    @NotNull
    public final String getCookie() {
        return Cookie;
    }

    @NotNull
    public final String getDASL() {
        return DASL;
    }

    @NotNull
    public final String getDate() {
        return Date;
    }

    @NotNull
    public final String getDAV() {
        return DAV;
    }

    @NotNull
    public final String getDepth() {
        return Depth;
    }

    @NotNull
    public final String getDestination() {
        return Destination;
    }

    @NotNull
    public final String getETag() {
        return ETag;
    }

    @NotNull
    public final String getExpect() {
        return Expect;
    }

    @NotNull
    public final String getExpires() {
        return Expires;
    }

    @NotNull
    public final String getFrom() {
        return From;
    }

    @NotNull
    public final String getForwarded() {
        return Forwarded;
    }

    @NotNull
    public final String getHost() {
        return Host;
    }

    @NotNull
    public final String getHTTP2Settings() {
        return HTTP2Settings;
    }

    @NotNull
    public final String getIf() {
        return If;
    }

    @NotNull
    public final String getIfMatch() {
        return IfMatch;
    }

    @NotNull
    public final String getIfModifiedSince() {
        return IfModifiedSince;
    }

    @NotNull
    public final String getIfNoneMatch() {
        return IfNoneMatch;
    }

    @NotNull
    public final String getIfRange() {
        return IfRange;
    }

    @NotNull
    public final String getIfScheduleTagMatch() {
        return IfScheduleTagMatch;
    }

    @NotNull
    public final String getIfUnmodifiedSince() {
        return IfUnmodifiedSince;
    }

    @NotNull
    public final String getLastModified() {
        return LastModified;
    }

    @NotNull
    public final String getLocation() {
        return Location;
    }

    @NotNull
    public final String getLockToken() {
        return LockToken;
    }

    @NotNull
    public final String getLink() {
        return Link;
    }

    @NotNull
    public final String getMaxForwards() {
        return MaxForwards;
    }

    @NotNull
    public final String getMIMEVersion() {
        return MIMEVersion;
    }

    @NotNull
    public final String getOrderingType() {
        return OrderingType;
    }

    @NotNull
    public final String getOrigin() {
        return Origin;
    }

    @NotNull
    public final String getOverwrite() {
        return Overwrite;
    }

    @NotNull
    public final String getPosition() {
        return Position;
    }

    @NotNull
    public final String getPragma() {
        return Pragma;
    }

    @NotNull
    public final String getPrefer() {
        return Prefer;
    }

    @NotNull
    public final String getPreferenceApplied() {
        return PreferenceApplied;
    }

    @NotNull
    public final String getProxyAuthenticate() {
        return ProxyAuthenticate;
    }

    @NotNull
    public final String getProxyAuthenticationInfo() {
        return ProxyAuthenticationInfo;
    }

    @NotNull
    public final String getProxyAuthorization() {
        return ProxyAuthorization;
    }

    @NotNull
    public final String getPublicKeyPins() {
        return PublicKeyPins;
    }

    @NotNull
    public final String getPublicKeyPinsReportOnly() {
        return PublicKeyPinsReportOnly;
    }

    @NotNull
    public final String getRange() {
        return Range;
    }

    @NotNull
    public final String getReferrer() {
        return Referrer;
    }

    @NotNull
    public final String getRetryAfter() {
        return RetryAfter;
    }

    @NotNull
    public final String getScheduleReply() {
        return ScheduleReply;
    }

    @NotNull
    public final String getScheduleTag() {
        return ScheduleTag;
    }

    @NotNull
    public final String getSecWebSocketAccept() {
        return SecWebSocketAccept;
    }

    @NotNull
    public final String getSecWebSocketExtensions() {
        return SecWebSocketExtensions;
    }

    @NotNull
    public final String getSecWebSocketKey() {
        return SecWebSocketKey;
    }

    @NotNull
    public final String getSecWebSocketProtocol() {
        return SecWebSocketProtocol;
    }

    @NotNull
    public final String getSecWebSocketVersion() {
        return SecWebSocketVersion;
    }

    @NotNull
    public final String getServer() {
        return Server;
    }

    @NotNull
    public final String getSetCookie() {
        return SetCookie;
    }

    @NotNull
    public final String getSLUG() {
        return SLUG;
    }

    @NotNull
    public final String getStrictTransportSecurity() {
        return StrictTransportSecurity;
    }

    @NotNull
    public final String getTE() {
        return TE;
    }

    @NotNull
    public final String getTimeout() {
        return Timeout;
    }

    @NotNull
    public final String getTrailer() {
        return Trailer;
    }

    @NotNull
    public final String getTransferEncoding() {
        return TransferEncoding;
    }

    @NotNull
    public final String getUpgrade() {
        return Upgrade;
    }

    @NotNull
    public final String getUserAgent() {
        return UserAgent;
    }

    @NotNull
    public final String getVary() {
        return Vary;
    }

    @NotNull
    public final String getVia() {
        return Via;
    }

    @NotNull
    public final String getWarning() {
        return Warning;
    }

    @NotNull
    public final String getWWWAuthenticate() {
        return WWWAuthenticate;
    }

    @NotNull
    public final String getAccessControlAllowOrigin() {
        return AccessControlAllowOrigin;
    }

    @NotNull
    public final String getAccessControlAllowMethods() {
        return AccessControlAllowMethods;
    }

    @NotNull
    public final String getAccessControlAllowCredentials() {
        return AccessControlAllowCredentials;
    }

    @NotNull
    public final String getAccessControlAllowHeaders() {
        return AccessControlAllowHeaders;
    }

    @NotNull
    public final String getAccessControlRequestMethod() {
        return AccessControlRequestMethod;
    }

    @NotNull
    public final String getAccessControlRequestHeaders() {
        return AccessControlRequestHeaders;
    }

    @NotNull
    public final String getAccessControlExposeHeaders() {
        return AccessControlExposeHeaders;
    }

    @NotNull
    public final String getAccessControlMaxAge() {
        return AccessControlMaxAge;
    }

    @NotNull
    public final String getXHttpMethodOverride() {
        return XHttpMethodOverride;
    }

    @NotNull
    public final String getXForwardedHost() {
        return XForwardedHost;
    }

    @NotNull
    public final String getXForwardedServer() {
        return XForwardedServer;
    }

    @NotNull
    public final String getXForwardedProto() {
        return XForwardedProto;
    }

    @NotNull
    public final String getXForwardedFor() {
        return XForwardedFor;
    }

    @NotNull
    public final String getXRequestId() {
        return XRequestId;
    }

    @NotNull
    public final String getXCorrelationId() {
        return XCorrelationId;
    }

    public final boolean isUnsafe(@NotNull String header) {
        boolean bl;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)header, (String)"header");
            String[] $this$any$iv = UnsafeHeadersArray;
            boolean $i$f$any = false;
            String[] stringArray = $this$any$iv;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = stringArray[i];
                boolean bl2 = false;
                if (!StringsKt.equals((String)it, (String)header, (boolean)true)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @Deprecated(message="Use UnsafeHeadersList instead.", replaceWith=@ReplaceWith(imports={}, expression="HttpHeaders.UnsafeHeadersList"))
    public static /* synthetic */ void UnsafeHeaders$annotations() {
    }

    @NotNull
    public final String[] getUnsafeHeaders() {
        String[] stringArray = UnsafeHeadersArray;
        boolean bl = false;
        String[] stringArray2 = Arrays.copyOf(stringArray, stringArray.length);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringArray2, (String)"java.util.Arrays.copyOf(this, size)");
        return stringArray2;
    }

    @NotNull
    public final List<String> getUnsafeHeadersList() {
        return UnsafeHeadersList;
    }

    /*
     * WARNING - void declaration
     */
    @KtorExperimentalAPI
    public final void checkHeaderName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        CharSequence $this$forEachIndexed$iv = name;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        CharSequence charSequence = $this$forEachIndexed$iv;
        for (int i = 0; i < charSequence.length(); ++i) {
            void ch;
            char item$iv = charSequence.charAt(i);
            int n = index$iv++;
            char c = item$iv;
            int index = n;
            boolean bl = false;
            if (Intrinsics.compare((int)ch, (int)32) > 0 && !HttpHeadersKt.access$isDelimiter((char)ch)) continue;
            throw (Throwable)new IllegalHeaderNameException(name, index);
        }
    }

    /*
     * WARNING - void declaration
     */
    @KtorExperimentalAPI
    public final void checkHeaderValue(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        CharSequence $this$forEachIndexed$iv = value;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        CharSequence charSequence = $this$forEachIndexed$iv;
        for (int i = 0; i < charSequence.length(); ++i) {
            void ch;
            char item$iv = charSequence.charAt(i);
            int n = index$iv++;
            char c = item$iv;
            int index = n;
            boolean bl = false;
            if (ch == 32 || ch == 9 || Intrinsics.compare((int)ch, (int)32) >= 0) continue;
            throw (Throwable)new IllegalHeaderValueException(value, index);
        }
    }

    private HttpHeaders() {
    }

    static {
        HttpHeaders httpHeaders;
        INSTANCE = httpHeaders = new HttpHeaders();
        Accept = "Accept";
        AcceptCharset = "Accept-Charset";
        AcceptEncoding = "Accept-Encoding";
        AcceptLanguage = "Accept-Language";
        AcceptRanges = "Accept-Ranges";
        Age = "Age";
        Allow = "Allow";
        ALPN = "ALPN";
        AuthenticationInfo = "Authentication-Info";
        Authorization = "Authorization";
        CacheControl = "Cache-Control";
        Connection = "Connection";
        ContentDisposition = "Content-Disposition";
        ContentEncoding = "Content-Encoding";
        ContentLanguage = "Content-Language";
        ContentLength = "Content-Length";
        ContentLocation = "Content-Location";
        ContentRange = "Content-Range";
        ContentType = "Content-Type";
        Cookie = "Cookie";
        DASL = "DASL";
        Date = "Date";
        DAV = "DAV";
        Depth = "Depth";
        Destination = "Destination";
        ETag = "ETag";
        Expect = "Expect";
        Expires = "Expires";
        From = "From";
        Forwarded = "Forwarded";
        Host = "Host";
        HTTP2Settings = "HTTP2-Settings";
        If = "If";
        IfMatch = "If-Match";
        IfModifiedSince = "If-Modified-Since";
        IfNoneMatch = "If-None-Match";
        IfRange = "If-Range";
        IfScheduleTagMatch = "If-Schedule-Tag-Match";
        IfUnmodifiedSince = "If-Unmodified-Since";
        LastModified = "Last-Modified";
        Location = "Location";
        LockToken = "Lock-Token";
        Link = "Link";
        MaxForwards = "Max-Forwards";
        MIMEVersion = "MIME-Version";
        OrderingType = "Ordering-Type";
        Origin = "Origin";
        Overwrite = "Overwrite";
        Position = "Position";
        Pragma = "Pragma";
        Prefer = "Prefer";
        PreferenceApplied = "Preference-Applied";
        ProxyAuthenticate = "Proxy-Authenticate";
        ProxyAuthenticationInfo = "Proxy-Authentication-Info";
        ProxyAuthorization = "Proxy-Authorization";
        PublicKeyPins = "Public-Key-Pins";
        PublicKeyPinsReportOnly = "Public-Key-Pins-Report-Only";
        Range = "Range";
        Referrer = "Referer";
        RetryAfter = "Retry-After";
        ScheduleReply = "Schedule-Reply";
        ScheduleTag = "Schedule-Tag";
        SecWebSocketAccept = "Sec-WebSocket-Accept";
        SecWebSocketExtensions = "Sec-WebSocket-Extensions";
        SecWebSocketKey = "Sec-WebSocket-Key";
        SecWebSocketProtocol = "Sec-WebSocket-Protocol";
        SecWebSocketVersion = "Sec-WebSocket-Version";
        Server = "Server";
        SetCookie = "Set-Cookie";
        SLUG = "SLUG";
        StrictTransportSecurity = "Strict-Transport-Security";
        TE = "TE";
        Timeout = "Timeout";
        Trailer = "Trailer";
        TransferEncoding = "Transfer-Encoding";
        Upgrade = "Upgrade";
        UserAgent = "User-Agent";
        Vary = "Vary";
        Via = "Via";
        Warning = "Warning";
        WWWAuthenticate = "WWW-Authenticate";
        AccessControlAllowOrigin = "Access-Control-Allow-Origin";
        AccessControlAllowMethods = "Access-Control-Allow-Methods";
        AccessControlAllowCredentials = "Access-Control-Allow-Credentials";
        AccessControlAllowHeaders = "Access-Control-Allow-Headers";
        AccessControlRequestMethod = "Access-Control-Request-Method";
        AccessControlRequestHeaders = "Access-Control-Request-Headers";
        AccessControlExposeHeaders = "Access-Control-Expose-Headers";
        AccessControlMaxAge = "Access-Control-Max-Age";
        XHttpMethodOverride = "X-Http-Method-Override";
        XForwardedHost = "X-Forwarded-Host";
        XForwardedServer = "X-Forwarded-Server";
        XForwardedProto = "X-Forwarded-Proto";
        XForwardedFor = "X-Forwarded-For";
        XRequestId = "X-Request-ID";
        XCorrelationId = "X-Correlation-ID";
        UnsafeHeadersArray = new String[]{ContentLength, ContentType, TransferEncoding, Upgrade};
        UnsafeHeadersList = ArraysKt.asList((Object[])UnsafeHeadersArray);
    }
}

