/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.content;

import io.ktor.http.ApplicationResponsePropertiesKt;
import io.ktor.http.Headers;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.HttpHeaders;
import io.ktor.http.content.Version;
import io.ktor.http.content.VersionCheckResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\u0012\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u0019*\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lio/ktor/http/content/EntityTagVersion;", "Lio/ktor/http/content/Version;", "etag", "", "(Ljava/lang/String;)V", "getEtag", "()Ljava/lang/String;", "appendHeadersTo", "", "builder", "Lio/ktor/http/HeadersBuilder;", "check", "Lio/ktor/http/content/VersionCheckResult;", "requestHeaders", "Lio/ktor/http/Headers;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "parseMatchTag", "", "ktor-http"})
public final class EntityTagVersion
implements Version {
    @NotNull
    private final String etag;

    @Override
    @NotNull
    public VersionCheckResult check(@NotNull Headers requestHeaders) {
        Set<String> givenMatchEtags;
        Intrinsics.checkParameterIsNotNull((Object)requestHeaders, (String)"requestHeaders");
        String string = requestHeaders.get(HttpHeaders.INSTANCE.getIfNoneMatch());
        Set<String> givenNoneMatchEtags = string != null ? this.parseMatchTag(string) : null;
        String string2 = requestHeaders.get(HttpHeaders.INSTANCE.getIfMatch());
        Set<String> set = givenMatchEtags = string2 != null ? this.parseMatchTag(string2) : null;
        if (givenNoneMatchEtags != null && givenNoneMatchEtags.contains(this.etag) && !givenNoneMatchEtags.contains("*")) {
            return VersionCheckResult.NOT_MODIFIED;
        }
        if (givenMatchEtags != null) {
            Collection collection = givenMatchEtags;
            boolean bl = false;
            if (!collection.isEmpty() && !givenMatchEtags.contains(this.etag) && !givenMatchEtags.contains("*")) {
                return VersionCheckResult.PRECONDITION_FAILED;
            }
        }
        return VersionCheckResult.OK;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> parseMatchTag(@NotNull String $this$parseMatchTag) {
        void $this$filterTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        CharSequence charSequence = $this$parseMatchTag;
        String string = "\\s*,\\s*";
        int n = 0;
        string = new Regex(string);
        n = 0;
        boolean bl = false;
        Iterable $this$map$iv = string.split(charSequence, n);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            String string3 = StringsKt.removePrefix((String)it, (CharSequence)"W/");
            collection.add(string3);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl3 = false;
            CharSequence charSequence2 = it;
            boolean bl4 = false;
            if (!(charSequence2.length() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Override
    public void appendHeadersTo(@NotNull HeadersBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)builder), (String)"builder");
        ApplicationResponsePropertiesKt.etag(builder, this.etag);
    }

    @NotNull
    public final String getEtag() {
        return this.etag;
    }

    public EntityTagVersion(@NotNull String etag) {
        Intrinsics.checkParameterIsNotNull((Object)etag, (String)"etag");
        this.etag = etag;
    }

    @NotNull
    public final String component1() {
        return this.etag;
    }

    @NotNull
    public final EntityTagVersion copy(@NotNull String etag) {
        Intrinsics.checkParameterIsNotNull((Object)etag, (String)"etag");
        return new EntityTagVersion(etag);
    }

    public static /* synthetic */ EntityTagVersion copy$default(EntityTagVersion entityTagVersion, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = entityTagVersion.etag;
        }
        return entityTagVersion.copy(string);
    }

    @NotNull
    public String toString() {
        return "EntityTagVersion(etag=" + this.etag + ")";
    }

    public int hashCode() {
        String string = this.etag;
        return string != null ? string.hashCode() : 0;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof EntityTagVersion)) break block3;
                EntityTagVersion entityTagVersion = (EntityTagVersion)object;
                if (!Intrinsics.areEqual((Object)this.etag, (Object)entityTagVersion.etag)) break block3;
            }
            return true;
        }
        return false;
    }
}

