/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.CookieDateParser;
import io.ktor.http.InvalidCookieDateException;
import io.ktor.util.KtorExperimentalAPI;
import io.ktor.util.date.GMTDate;
import io.ktor.util.date.GMTDateParser;
import io.ktor.util.date.InvalidDateStringException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0002H\u0007\u001a\n\u0010\u0005\u001a\u00020\u0004*\u00020\u0002\u001a\u0014\u0010\u0006\u001a\u00020\u0002*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u001a\n\u0010\t\u001a\u00020\u0002*\u00020\u0004\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"HTTP_DATE_FORMATS", "", "", "fromCookieToGmtDate", "Lio/ktor/util/date/GMTDate;", "fromHttpToGmtDate", "padZero", "", "length", "toHttpDate", "ktor-http"})
public final class DateUtilsKt {
    private static final List<String> HTTP_DATE_FORMATS = CollectionsKt.listOf((Object[])new String[]{"***, dd MMM YYYY hh:mm:ss zzz", "****, dd-MMM-YYYY hh:mm:ss zzz", "*** MMM d hh:mm:ss YYYY", "***, dd-MMM-YYYY hh:mm:ss zzz", "***, dd-MMM-YYYY hh-mm-ss zzz", "***, dd MMM YYYY hh:mm:ss zzz", "*** dd-MMM-YYYY hh:mm:ss zzz", "*** dd MMM YYYY hh:mm:ss zzz", "*** dd-MMM-YYYY hh-mm-ss zzz", "***,dd-MMM-YYYY hh:mm:ss zzz", "*** MMM d YYYY hh:mm:ss zzz"});

    @NotNull
    public static final GMTDate fromHttpToGmtDate(@NotNull String $this$fromHttpToGmtDate) {
        Intrinsics.checkParameterIsNotNull((Object)$this$fromHttpToGmtDate, (String)"$this$fromHttpToGmtDate");
        String string = $this$fromHttpToGmtDate;
        boolean bl = false;
        string = ((Object)StringsKt.trim((CharSequence)string)).toString();
        bl = false;
        boolean bl2 = false;
        String $this$with = string;
        boolean bl3 = false;
        for (String format : HTTP_DATE_FORMATS) {
            try {
                GMTDateParser parser = new GMTDateParser(format);
                return parser.parse($this$fromHttpToGmtDate);
            }
            catch (InvalidDateStringException invalidDateStringException) {
            }
        }
        String string2 = "Failed to parse date: " + $this$with;
        boolean bl4 = false;
        throw (Throwable)new IllegalStateException(string2.toString());
    }

    @KtorExperimentalAPI
    @NotNull
    public static final GMTDate fromCookieToGmtDate(@NotNull String $this$fromCookieToGmtDate) {
        Intrinsics.checkParameterIsNotNull((Object)$this$fromCookieToGmtDate, (String)"$this$fromCookieToGmtDate");
        String string = $this$fromCookieToGmtDate;
        boolean bl = false;
        string = ((Object)StringsKt.trim((CharSequence)string)).toString();
        bl = false;
        boolean bl2 = false;
        String $this$with = string;
        boolean bl3 = false;
        try {
            CookieDateParser parser = new CookieDateParser();
            return parser.parse($this$with);
        }
        catch (InvalidCookieDateException invalidCookieDateException) {
            return DateUtilsKt.fromHttpToGmtDate($this$with);
        }
    }

    @NotNull
    public static final String toHttpDate(@NotNull GMTDate $this$toHttpDate) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toHttpDate, (String)"$this$toHttpDate");
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl4 = false;
        $this$buildString.append($this$toHttpDate.getDayOfWeek().getValue() + ", ");
        $this$buildString.append(DateUtilsKt.padZero($this$toHttpDate.getDayOfMonth(), 2) + ' ');
        $this$buildString.append($this$toHttpDate.getMonth().getValue() + ' ');
        $this$buildString.append(DateUtilsKt.padZero($this$toHttpDate.getYear(), 4));
        $this$buildString.append(' ' + DateUtilsKt.padZero($this$toHttpDate.getHours(), 2) + ':' + DateUtilsKt.padZero($this$toHttpDate.getMinutes(), 2) + ':' + DateUtilsKt.padZero($this$toHttpDate.getSeconds(), 2) + ' ');
        $this$buildString.append("GMT");
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private static final String padZero(int $this$padZero, int length) {
        return StringsKt.padStart((String)String.valueOf($this$padZero), (int)length, (char)'0');
    }
}

