/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.util.CharsetKt;
import io.ktor.util.TextKt;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lio/ktor/http/URLProtocol;", "", "name", "", "defaultPort", "", "(Ljava/lang/String;I)V", "getDefaultPort", "()I", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "ktor-http"})
public final class URLProtocol {
    @NotNull
    private final String name;
    private final int defaultPort;
    @NotNull
    private static final URLProtocol HTTP;
    @NotNull
    private static final URLProtocol HTTPS;
    @NotNull
    private static final URLProtocol WS;
    @NotNull
    private static final URLProtocol WSS;
    @NotNull
    private static final URLProtocol SOCKS;
    @NotNull
    private static final Map<String, URLProtocol> byName;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getDefaultPort() {
        return this.defaultPort;
    }

    public URLProtocol(@NotNull String name, int defaultPort) {
        boolean bl;
        block2: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.defaultPort = defaultPort;
            CharSequence $this$all$iv = this.name;
            boolean $i$f$all = false;
            CharSequence charSequence = $this$all$iv;
            for (int i = 0; i < charSequence.length(); ++i) {
                char element$iv;
                char it = element$iv = charSequence.charAt(i);
                boolean bl2 = false;
                if (CharsetKt.isLowerCase((char)it)) continue;
                bl = false;
                break block2;
            }
            bl = true;
        }
        boolean bl3 = bl;
        boolean bl4 = false;
        boolean bl5 = false;
        if (!bl3) {
            boolean bl6 = false;
            String string = "All characters should be lower case";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateByTo$iv$iv;
        Companion = new Companion(null);
        HTTP = new URLProtocol("http", 80);
        HTTPS = new URLProtocol("https", 443);
        WS = new URLProtocol("ws", 80);
        WSS = new URLProtocol("wss", 443);
        SOCKS = new URLProtocol("socks", 1080);
        Iterable $this$associateBy$iv = CollectionsKt.listOf((Object[])new URLProtocol[]{HTTP, HTTPS, WS, WSS, SOCKS});
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            URLProtocol uRLProtocol = (URLProtocol)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            String string = it.name;
            map.put(string, element$iv$iv);
        }
        byName = destination$iv$iv;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    public final int component2() {
        return this.defaultPort;
    }

    @NotNull
    public final URLProtocol copy(@NotNull String name, int defaultPort) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new URLProtocol(name, defaultPort);
    }

    public static /* synthetic */ URLProtocol copy$default(URLProtocol uRLProtocol, String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = uRLProtocol.name;
        }
        if ((n2 & 2) != 0) {
            n = uRLProtocol.defaultPort;
        }
        return uRLProtocol.copy(string, n);
    }

    @NotNull
    public String toString() {
        return "URLProtocol(name=" + this.name + ", defaultPort=" + this.defaultPort + ")";
    }

    public int hashCode() {
        String string = this.name;
        return (string != null ? string.hashCode() : 0) * 31 + this.defaultPort;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof URLProtocol)) break block3;
                URLProtocol uRLProtocol = (URLProtocol)object;
                if (!Intrinsics.areEqual((Object)this.name, (Object)uRLProtocol.name) || this.defaultPort != uRLProtocol.defaultPort) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00040\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lio/ktor/http/URLProtocol$Companion;", "", "()V", "HTTP", "Lio/ktor/http/URLProtocol;", "getHTTP", "()Lio/ktor/http/URLProtocol;", "HTTPS", "getHTTPS", "SOCKS", "getSOCKS", "WS", "getWS", "WSS", "getWSS", "byName", "", "", "getByName", "()Ljava/util/Map;", "createOrDefault", "name", "ktor-http"})
    public static final class Companion {
        @NotNull
        public final URLProtocol getHTTP() {
            return HTTP;
        }

        @NotNull
        public final URLProtocol getHTTPS() {
            return HTTPS;
        }

        @NotNull
        public final URLProtocol getWS() {
            return WS;
        }

        @NotNull
        public final URLProtocol getWSS() {
            return WSS;
        }

        @NotNull
        public final URLProtocol getSOCKS() {
            return SOCKS;
        }

        @NotNull
        public final Map<String, URLProtocol> getByName() {
            return byName;
        }

        @NotNull
        public final URLProtocol createOrDefault(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            String string = TextKt.toLowerCasePreservingASCIIRules((String)name);
            boolean bl = false;
            boolean bl2 = false;
            String it = string;
            boolean bl3 = false;
            URLProtocol uRLProtocol = Companion.getByName().get(it);
            if (uRLProtocol == null) {
                uRLProtocol = new URLProtocol(it, 0);
            }
            return uRLProtocol;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

