/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.ContentType;
import io.ktor.http.HeaderValue;
import io.ktor.http.HeaderValueParam;
import io.ktor.http.HttpHeaderValueParserKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u001a\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\t\u001a>\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u001c\u0010\r\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00020\u000fj\b\u0012\u0004\u0012\u00020\u0002`\u00100\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a6\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u001c\u0010\u0012\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00130\u000fj\b\u0012\u0004\u0012\u00020\u0013`\u00100\u000eH\u0002\u001a$\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000bH\u0002\u001a$\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000bH\u0002\u001a\u0014\u0010\u0018\u001a\u00020\t*\u00020\u00042\u0006\u0010\f\u001a\u00020\u000bH\u0002\u001a\u001c\u0010\u0019\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002\u001a\"\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u0001*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00150\u001c\u001a$\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u0001\"\u0004\b\u0000\u0010\u001e*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001e0\u00010\u000eH\u0002\u00a8\u0006\u001f"}, d2={"parseAndSortContentTypeHeader", "", "Lio/ktor/http/HeaderValue;", "header", "", "parseAndSortHeader", "parseHeaderValue", "text", "parametersOnly", "", "parseHeaderValueItem", "", "start", "items", "Lkotlin/Lazy;", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "parseHeaderValueParameter", "parameters", "Lio/ktor/http/HeaderValueParam;", "parseHeaderValueParameterValue", "Lkotlin/Pair;", "value", "parseHeaderValueParameterValueQuoted", "nextIsSemicolonOrEnd", "subtrim", "end", "toHeaderParamsList", "", "valueOrEmpty", "T", "ktor-http"})
public final class HttpHeaderValueParserKt {
    @NotNull
    public static final List<HeaderValue> parseAndSortHeader(@Nullable String header) {
        Iterable $this$sortedByDescending$iv = HttpHeaderValueParserKt.parseHeaderValue(header);
        boolean $i$f$sortedByDescending = false;
        boolean bl = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                HeaderValue it = (HeaderValue)b;
                boolean bl2 = false;
                Comparable comparable = Double.valueOf(it.getQuality());
                it = (HeaderValue)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Double d = it.getQuality();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
            }
        });
    }

    @NotNull
    public static final List<HeaderValue> parseAndSortContentTypeHeader(@Nullable String header) {
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                HeaderValue it = (HeaderValue)b;
                boolean bl2 = false;
                Comparable comparable = Double.valueOf(it.getQuality());
                it = (HeaderValue)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Comparable comparable3 = Double.valueOf(it.getQuality());
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
            }
        };
        boolean bl2 = false;
        comparator = new Comparator<T>(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = comparator;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    int n2;
                    boolean bl = false;
                    HeaderValue it = (HeaderValue)a;
                    boolean bl2 = false;
                    ContentType contentType2 = ContentType.Companion.parse(it.getValue());
                    int asterisks = 0;
                    if (Intrinsics.areEqual((Object)contentType2.getContentType(), (Object)"*")) {
                        asterisks += 2;
                    }
                    if (Intrinsics.areEqual((Object)contentType2.getContentSubtype(), (Object)"*")) {
                        n2 = asterisks;
                        asterisks = n2 + 1;
                    }
                    it = (HeaderValue)b;
                    Comparable comparable = Integer.valueOf(asterisks);
                    bl2 = false;
                    contentType2 = ContentType.Companion.parse(it.getValue());
                    asterisks = 0;
                    if (Intrinsics.areEqual((Object)contentType2.getContentType(), (Object)"*")) {
                        asterisks += 2;
                    }
                    if (Intrinsics.areEqual((Object)contentType2.getContentSubtype(), (Object)"*")) {
                        n2 = asterisks;
                        asterisks = n2 + 1;
                    }
                    Comparable comparable2 = Integer.valueOf(asterisks);
                    n = ComparisonsKt.compareValues((Comparable)comparable, (Comparable)comparable2);
                }
                return n;
            }
        };
        bl2 = false;
        return CollectionsKt.sortedWith((Iterable)HttpHeaderValueParserKt.parseHeaderValue(header), (Comparator)new Comparator<T>(comparator){
            final /* synthetic */ Comparator $this_thenByDescending;
            {
                this.$this_thenByDescending = comparator;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenByDescending.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    boolean bl = false;
                    HeaderValue it = (HeaderValue)b;
                    boolean bl2 = false;
                    Comparable comparable = Integer.valueOf(it.getParams().size());
                    it = (HeaderValue)a;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Comparable comparable3 = Integer.valueOf(it.getParams().size());
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
                }
                return n;
            }
        });
    }

    @NotNull
    public static final List<HeaderValue> parseHeaderValue(@Nullable String text) {
        return HttpHeaderValueParserKt.parseHeaderValue(text, false);
    }

    @NotNull
    public static final List<HeaderValue> parseHeaderValue(@Nullable String text, boolean parametersOnly) {
        if (text == null) {
            return CollectionsKt.emptyList();
        }
        int position = 0;
        Lazy items2 = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)parseHeaderValue.items.1.INSTANCE);
        while (position <= StringsKt.getLastIndex((CharSequence)text)) {
            position = HttpHeaderValueParserKt.parseHeaderValueItem(text, position, (Lazy<? extends ArrayList<HeaderValue>>)items2, parametersOnly);
        }
        return HttpHeaderValueParserKt.valueOrEmpty(items2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<HeaderValueParam> toHeaderParamsList(@NotNull Iterable<Pair<String, String>> $this$toHeaderParamsList) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toHeaderParamsList, (String)"<this>");
        Iterable<Pair<String, String>> $this$map$iv = $this$toHeaderParamsList;
        boolean $i$f$map = false;
        Iterable<Pair<String, String>> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            HeaderValueParam headerValueParam = new HeaderValueParam((String)it.getFirst(), (String)it.getSecond());
            collection.add(headerValueParam);
        }
        return (List)destination$iv$iv;
    }

    private static final <T> List<T> valueOrEmpty(Lazy<? extends List<? extends T>> $this$valueOrEmpty) {
        return $this$valueOrEmpty.isInitialized() ? (List)$this$valueOrEmpty.getValue() : CollectionsKt.emptyList();
    }

    private static final String subtrim(String $this$subtrim, int start, int end) {
        String string = $this$subtrim;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(start, end);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        string = string3;
        bl = false;
        String string4 = string;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string4)).toString();
    }

    private static final int parseHeaderValueItem(String text, int start, Lazy<? extends ArrayList<HeaderValue>> items2, boolean parametersOnly) {
        Integer n;
        Integer valueEnd;
        int position = start;
        Lazy parameters2 = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)parseHeaderValueItem.parameters.1.INSTANCE);
        Integer n2 = valueEnd = parametersOnly ? Integer.valueOf(position) : null;
        while (position <= StringsKt.getLastIndex((CharSequence)text)) {
            char c = text.charAt(position);
            if (c == ',') {
                Integer n3;
                ((ArrayList)items2.getValue()).add(new HeaderValue(HttpHeaderValueParserKt.subtrim(text, start, (n3 = valueEnd) == null ? position : n3), HttpHeaderValueParserKt.valueOrEmpty(parameters2)));
                return position + 1;
            }
            if (c == ';') {
                if (valueEnd == null) {
                    valueEnd = position;
                }
                position = HttpHeaderValueParserKt.parseHeaderValueParameter(text, position + 1, (Lazy<? extends ArrayList<HeaderValueParam>>)parameters2);
                continue;
            }
            position = parametersOnly ? HttpHeaderValueParserKt.parseHeaderValueParameter(text, position, (Lazy<? extends ArrayList<HeaderValueParam>>)parameters2) : position + 1;
        }
        ((ArrayList)items2.getValue()).add(new HeaderValue(HttpHeaderValueParserKt.subtrim(text, start, (n = valueEnd) == null ? position : n), HttpHeaderValueParserKt.valueOrEmpty(parameters2)));
        return position;
    }

    private static final int parseHeaderValueParameter(String text, int start, Lazy<? extends ArrayList<HeaderValueParam>> parameters2) {
        int position = start;
        while (position <= StringsKt.getLastIndex((CharSequence)text)) {
            char c = text.charAt(position);
            if (c == '=') {
                Pair<Integer, String> pair = HttpHeaderValueParserKt.parseHeaderValueParameterValue(text, position + 1);
                int paramEnd = ((Number)pair.component1()).intValue();
                String paramValue = (String)pair.component2();
                HttpHeaderValueParserKt.parseHeaderValueParameter$addParam(parameters2, text, start, position, paramValue);
                return paramEnd;
            }
            if (c == ';' ? true : c == ',') {
                HttpHeaderValueParserKt.parseHeaderValueParameter$addParam(parameters2, text, start, position, "");
                return position;
            }
            int n = position;
            position = n + 1;
        }
        HttpHeaderValueParserKt.parseHeaderValueParameter$addParam(parameters2, text, start, position, "");
        return position;
    }

    private static final Pair<Integer, String> parseHeaderValueParameterValue(String value, int start) {
        if (value.length() == start) {
            return TuplesKt.to((Object)start, (Object)"");
        }
        int position = start;
        if (value.charAt(start) == '\"') {
            return HttpHeaderValueParserKt.parseHeaderValueParameterValueQuoted(value, position + 1);
        }
        while (position <= StringsKt.getLastIndex((CharSequence)value)) {
            char c = value.charAt(position);
            if (c == ';' ? true : c == ',') {
                return TuplesKt.to((Object)position, (Object)HttpHeaderValueParserKt.subtrim(value, start, position));
            }
            int n = position;
            position = n + 1;
        }
        return TuplesKt.to((Object)position, (Object)HttpHeaderValueParserKt.subtrim(value, start, position));
    }

    private static final Pair<Integer, String> parseHeaderValueParameterValueQuoted(String value, int start) {
        int position = start;
        StringBuilder builder = new StringBuilder();
        while (position <= StringsKt.getLastIndex((CharSequence)value)) {
            char currentChar = value.charAt(position);
            if (currentChar == '\"' && HttpHeaderValueParserKt.nextIsSemicolonOrEnd(value, position)) {
                Integer n = position + 1;
                String string = builder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
                return TuplesKt.to((Object)n, (Object)string);
            }
            if (currentChar == '\\' && position < StringsKt.getLastIndex((CharSequence)value) - 2) {
                builder.append(value.charAt(position + 1));
                position += 2;
                continue;
            }
            builder.append(currentChar);
            int n = position;
            position = n + 1;
        }
        Integer n = position;
        char c = '\"';
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        boolean bl = false;
        return TuplesKt.to((Object)n, (Object)(String.valueOf(c) + string));
    }

    private static final boolean nextIsSemicolonOrEnd(String $this$nextIsSemicolonOrEnd, int start) {
        int position;
        for (position = start + 1; position < $this$nextIsSemicolonOrEnd.length() && $this$nextIsSemicolonOrEnd.charAt(position) == ' '; ++position) {
        }
        return position == $this$nextIsSemicolonOrEnd.length() || $this$nextIsSemicolonOrEnd.charAt(position) == ';';
    }

    private static final void parseHeaderValueParameter$addParam(Lazy<? extends ArrayList<HeaderValueParam>> $parameters, String text, int start, int end, String value) {
        String name = HttpHeaderValueParserKt.subtrim(text, start, end);
        CharSequence charSequence = name;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return;
        }
        ((ArrayList)$parameters.getValue()).add(new HeaderValueParam(name, value));
    }
}

