/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.HeaderValueWithParameters;
import io.ktor.util.StringValuesBuilder;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\"\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\u001a\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\n\u0010\n\u001a\u00020\u0007*\u00020\u0007\u001a\u0019\u0010\u000b\u001a\u00020\u0004*\u00020\u00072\n\u0010\f\u001a\u00060\rj\u0002`\u000eH\u0082\b\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0007H\u0002\u001a\f\u0010\u0011\u001a\u00020\u0010*\u00020\u0007H\u0002\u001a\n\u0010\u0012\u001a\u00020\u0007*\u00020\u0007\u001a\u0018\u0010\u0013\u001a\u00020\u0004*\u00020\u00072\n\u0010\f\u001a\u00060\rj\u0002`\u000eH\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"HeaderFieldValueSeparators", "", "", "append", "", "Lio/ktor/util/StringValuesBuilder;", "name", "", "value", "Lio/ktor/http/HeaderValueWithParameters;", "escapeIfNeeded", "escapeIfNeededTo", "out", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "isQuoted", "", "needQuotes", "quote", "quoteTo", "ktor-http"})
@SourceDebugExtension(value={"SMAP\nHeaderValueWithParameters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeaderValueWithParameters.kt\nio/ktor/http/HeaderValueWithParametersKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,152:1\n1#2:153\n*E\n"})
public final class HeaderValueWithParametersKt {
    @NotNull
    private static final Set<Character> HeaderFieldValueSeparators;

    public static final void append(@NotNull StringValuesBuilder $this$append, @NotNull String name, @NotNull HeaderValueWithParameters value) {
        Intrinsics.checkNotNullParameter((Object)$this$append, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        $this$append.append(name, value.toString());
    }

    @NotNull
    public static final String escapeIfNeeded(@NotNull String $this$escapeIfNeeded) {
        Intrinsics.checkNotNullParameter((Object)$this$escapeIfNeeded, (String)"<this>");
        return HeaderValueWithParametersKt.needQuotes($this$escapeIfNeeded) ? HeaderValueWithParametersKt.quote($this$escapeIfNeeded) : $this$escapeIfNeeded;
    }

    private static final void escapeIfNeededTo(String $this$escapeIfNeededTo, StringBuilder out) {
        boolean $i$f$escapeIfNeededTo = false;
        if (HeaderValueWithParametersKt.needQuotes($this$escapeIfNeededTo)) {
            out.append(HeaderValueWithParametersKt.quote($this$escapeIfNeededTo));
        } else {
            out.append($this$escapeIfNeededTo);
        }
    }

    private static final boolean needQuotes(String $this$needQuotes) {
        if (((CharSequence)$this$needQuotes).length() == 0) {
            return true;
        }
        if (HeaderValueWithParametersKt.isQuoted($this$needQuotes)) {
            return false;
        }
        int n = $this$needQuotes.length();
        for (int index = 0; index < n; ++index) {
            if (!HeaderFieldValueSeparators.contains(Character.valueOf($this$needQuotes.charAt(index)))) continue;
            return true;
        }
        return false;
    }

    private static final boolean isQuoted(String $this$isQuoted) {
        int index;
        if ($this$isQuoted.length() < 2) {
            return false;
        }
        if (StringsKt.first((CharSequence)$this$isQuoted) != '\"' || StringsKt.last((CharSequence)$this$isQuoted) != '\"') {
            return false;
        }
        int startIndex = 1;
        while ((index = StringsKt.indexOf$default((CharSequence)$this$isQuoted, (char)'\"', (int)startIndex, (boolean)false, (int)4, null)) != StringsKt.getLastIndex((CharSequence)$this$isQuoted)) {
            int slashesCount = 0;
            int slashIndex = index - 1;
            while ($this$isQuoted.charAt(slashIndex) == '\\') {
                ++slashesCount;
                --slashIndex;
            }
            if (slashesCount % 2 == 0) {
                return false;
            }
            startIndex = index + 1;
            if (startIndex < $this$isQuoted.length()) continue;
        }
        return true;
    }

    @NotNull
    public static final String quote(@NotNull String $this$quote) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$quote, (String)"<this>");
        StringBuilder $this$quote_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        HeaderValueWithParametersKt.quoteTo($this$quote, $this$quote_u24lambda_u240);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private static final void quoteTo(String $this$quoteTo, StringBuilder out) {
        out.append("\"");
        int n = $this$quoteTo.length();
        for (int i = 0; i < n; ++i) {
            char ch = $this$quoteTo.charAt(i);
            if (ch == '\\') {
                out.append("\\\\");
                continue;
            }
            if (ch == '\n') {
                out.append("\\n");
                continue;
            }
            if (ch == '\r') {
                out.append("\\r");
                continue;
            }
            if (ch == '\t') {
                out.append("\\t");
                continue;
            }
            if (ch == '\"') {
                out.append("\\\"");
                continue;
            }
            out.append(ch);
        }
        out.append("\"");
    }

    static {
        Object[] objectArray = new Character[]{Character.valueOf('('), Character.valueOf(')'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('@'), Character.valueOf(','), Character.valueOf(';'), Character.valueOf(':'), Character.valueOf('\\'), Character.valueOf('\"'), Character.valueOf('/'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('?'), Character.valueOf('='), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf(' '), Character.valueOf('\t'), Character.valueOf('\n'), Character.valueOf('\r')};
        HeaderFieldValueSeparators = SetsKt.setOf((Object[])objectArray);
    }
}

