/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.CodecsKt;
import io.ktor.http.Parameters;
import io.ktor.http.QueryKt;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLBuilderKt;
import io.ktor.http.URLParserException;
import io.ktor.http.URLProtocol;
import io.ktor.util.CharsetKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\u001a(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a \u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002\u001a$\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002\u001a\u001c\u0010\u0010\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002\u001a\f\u0010\u0011\u001a\u00020\u0012*\u00020\u000bH\u0002\u001a,\u0010\u0013\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006H\u0002\u001a$\u0010\u0015\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002\u001a$\u0010\u0016\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002\u001a$\u0010\u0017\u001a\u00020\u0006*\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002\u001a\u0012\u0010\u0018\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0002\u001a\u0014\u0010\u0019\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0002H\u0000\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001a"}, d2={"ROOT_PATH", "", "", "getROOT_PATH", "()Ljava/util/List;", "count", "", "urlString", "startIndex", "endIndex", "char", "", "findScheme", "fillHost", "", "Lio/ktor/http/URLBuilder;", "indexOfColonInHostPort", "isLetter", "", "parseFile", "slashCount", "parseFragment", "parseMailto", "parseQuery", "takeFrom", "takeFromUnsafe", "ktor-http"})
@SourceDebugExtension(value={"SMAP\nURLParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 URLParser.kt\nio/ktor/http/URLParserKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,263:1\n151#2,6:264\n163#2,6:270\n1#3:276\n*S KotlinDebug\n*F\n+ 1 URLParser.kt\nio/ktor/http/URLParserKt\n*L\n34#1:264,6\n35#1:270,6\n*E\n"})
public final class URLParserKt {
    @NotNull
    private static final List<String> ROOT_PATH = CollectionsKt.listOf((Object)"");

    @NotNull
    public static final List<String> getROOT_PATH() {
        return ROOT_PATH;
    }

    @NotNull
    public static final URLBuilder takeFrom(@NotNull URLBuilder $this$takeFrom, @NotNull String urlString) {
        URLBuilder uRLBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$takeFrom, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        if (StringsKt.isBlank((CharSequence)urlString)) {
            return $this$takeFrom;
        }
        try {
            uRLBuilder = URLParserKt.takeFromUnsafe($this$takeFrom, urlString);
        }
        catch (Throwable cause) {
            throw new URLParserException(urlString, cause);
        }
        return uRLBuilder;
    }

    @NotNull
    public static final URLBuilder takeFromUnsafe(@NotNull URLBuilder $this$takeFromUnsafe, @NotNull String urlString) {
        int pathEnd;
        int it;
        int n;
        int startIndex;
        block17: {
            int n2;
            int n3;
            block16: {
                Intrinsics.checkNotNullParameter((Object)$this$takeFromUnsafe, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
                CharSequence $this$indexOfFirst$iv = urlString;
                boolean $i$f$indexOfFirst = false;
                n3 = $this$indexOfFirst$iv.length();
                for (int index$iv = 0; index$iv < n3; ++index$iv) {
                    char it2 = $this$indexOfFirst$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!(!CharsKt.isWhitespace((char)it2))) continue;
                    n2 = index$iv;
                    break block16;
                }
                n2 = -1;
            }
            startIndex = n2;
            CharSequence $this$indexOfLast$iv = urlString;
            boolean $i$f$indexOfLast = false;
            n3 = $this$indexOfLast$iv.length() + -1;
            if (0 <= n3) {
                do {
                    int index$iv = n3--;
                    char it3 = $this$indexOfLast$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!(!CharsKt.isWhitespace((char)it3))) continue;
                    n = index$iv;
                    break block17;
                } while (0 <= n3);
            }
            n = -1;
        }
        int endIndex = n + 1;
        int schemeLength = URLParserKt.findScheme(urlString, startIndex, endIndex);
        if (schemeLength > 0) {
            String string = urlString.substring(startIndex, startIndex + schemeLength);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String scheme = string;
            $this$takeFromUnsafe.setProtocol(URLProtocol.Companion.createOrDefault(scheme));
            startIndex += schemeLength + 1;
        }
        int slashCount = URLParserKt.count(urlString, startIndex, endIndex, '/');
        startIndex += slashCount;
        if (Intrinsics.areEqual((Object)$this$takeFromUnsafe.getProtocol().getName(), (Object)"file")) {
            URLParserKt.parseFile($this$takeFromUnsafe, urlString, startIndex, endIndex, slashCount);
            return $this$takeFromUnsafe;
        }
        if (Intrinsics.areEqual((Object)$this$takeFromUnsafe.getProtocol().getName(), (Object)"mailto")) {
            if (!(slashCount == 0)) {
                String index$iv = "Failed requirement.";
                throw new IllegalArgumentException(index$iv.toString());
            }
            URLParserKt.parseMailto($this$takeFromUnsafe, urlString, startIndex, endIndex);
            return $this$takeFromUnsafe;
        }
        if (slashCount >= 2) {
            int delimiter;
            while (true) {
                Integer it3 = StringsKt.indexOfAny$default((CharSequence)urlString, (char[])CharsetKt.toCharArray((String)"@/\\?#"), (int)startIndex, (boolean)false, (int)4, null);
                it = ((Number)it3).intValue();
                boolean bl = false;
                Integer n4 = it > 0 ? it3 : null;
                int n5 = delimiter = n4 != null ? n4 : endIndex;
                if (delimiter >= endIndex || urlString.charAt(delimiter) != '@') break;
                int passwordIndex = URLParserKt.indexOfColonInHostPort(urlString, startIndex, delimiter);
                if (passwordIndex != -1) {
                    String string = urlString.substring(startIndex, passwordIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    $this$takeFromUnsafe.setEncodedUser(string);
                    String string2 = urlString.substring(passwordIndex + 1, delimiter);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    $this$takeFromUnsafe.setEncodedPassword(string2);
                } else {
                    String string = urlString.substring(startIndex, delimiter);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    $this$takeFromUnsafe.setEncodedUser(string);
                }
                startIndex = delimiter + 1;
            }
            URLParserKt.fillHost($this$takeFromUnsafe, urlString, startIndex, delimiter);
            startIndex = delimiter;
        }
        if (startIndex >= endIndex) {
            $this$takeFromUnsafe.setEncodedPathSegments(urlString.charAt(endIndex - 1) == '/' ? ROOT_PATH : CollectionsKt.emptyList());
            return $this$takeFromUnsafe;
        }
        $this$takeFromUnsafe.setEncodedPathSegments(slashCount == 0 ? CollectionsKt.dropLast($this$takeFromUnsafe.getEncodedPathSegments(), (int)1) : CollectionsKt.emptyList());
        Integer it3 = StringsKt.indexOfAny$default((CharSequence)urlString, (char[])CharsetKt.toCharArray((String)"?#"), (int)startIndex, (boolean)false, (int)4, null);
        it = ((Number)it3).intValue();
        boolean bl2 = false;
        Integer n6 = it > 0 ? it3 : null;
        int n7 = pathEnd = n6 != null ? n6 : endIndex;
        if (pathEnd > startIndex) {
            List list;
            List basePath;
            String string = urlString.substring(startIndex, pathEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String rawPath = string;
            List list2 = $this$takeFromUnsafe.getEncodedPathSegments().size() == 1 && ((CharSequence)CollectionsKt.first($this$takeFromUnsafe.getEncodedPathSegments())).length() == 0 ? CollectionsKt.emptyList() : (basePath = $this$takeFromUnsafe.getEncodedPathSegments());
            if (Intrinsics.areEqual((Object)rawPath, (Object)"/")) {
                list = ROOT_PATH;
            } else {
                char[] bl2 = new char[]{'/'};
                list = StringsKt.split$default((CharSequence)rawPath, (char[])bl2, (boolean)false, (int)0, (int)6, null);
            }
            List rawChunks = list;
            List relativePath = CollectionsKt.plus((Collection)(slashCount == 1 ? ROOT_PATH : CollectionsKt.emptyList()), (Iterable)rawChunks);
            $this$takeFromUnsafe.setEncodedPathSegments(CollectionsKt.plus((Collection)basePath, (Iterable)relativePath));
            startIndex = pathEnd;
        }
        if (startIndex < endIndex && urlString.charAt(startIndex) == '?') {
            startIndex = URLParserKt.parseQuery($this$takeFromUnsafe, urlString, startIndex, endIndex);
        }
        URLParserKt.parseFragment($this$takeFromUnsafe, urlString, startIndex, endIndex);
        return $this$takeFromUnsafe;
    }

    private static final void parseFile(URLBuilder $this$parseFile, String urlString, int startIndex, int endIndex, int slashCount) {
        switch (slashCount) {
            case 2: {
                int nextSlash = StringsKt.indexOf$default((CharSequence)urlString, (char)'/', (int)startIndex, (boolean)false, (int)4, null);
                if (nextSlash == -1 || nextSlash == endIndex) {
                    String string = urlString.substring(startIndex, endIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    $this$parseFile.setHost(string);
                    return;
                }
                String string = urlString.substring(startIndex, nextSlash);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                $this$parseFile.setHost(string);
                String string2 = urlString.substring(nextSlash, endIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                URLBuilderKt.setEncodedPath($this$parseFile, string2);
                break;
            }
            case 3: {
                $this$parseFile.setHost("");
                StringBuilder stringBuilder = new StringBuilder().append('/');
                String string = urlString.substring(startIndex, endIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                URLBuilderKt.setEncodedPath($this$parseFile, stringBuilder.append(string).toString());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid file url: " + urlString);
            }
        }
    }

    private static final void parseMailto(URLBuilder $this$parseMailto, String urlString, int startIndex, int endIndex) {
        int delimiter = StringsKt.indexOf$default((CharSequence)urlString, (String)"@", (int)startIndex, (boolean)false, (int)4, null);
        if (delimiter == -1) {
            throw new IllegalArgumentException("Invalid mailto url: " + urlString + ", it should contain '@'.");
        }
        String string = urlString.substring(startIndex, delimiter);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        $this$parseMailto.setUser(CodecsKt.decodeURLPart$default(string, 0, 0, null, 7, null));
        String string2 = urlString.substring(delimiter + 1, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        $this$parseMailto.setHost(string2);
    }

    private static final int parseQuery(URLBuilder $this$parseQuery, String urlString, int startIndex, int endIndex) {
        if (startIndex + 1 == endIndex) {
            $this$parseQuery.setTrailingQuery(true);
            return endIndex;
        }
        Integer n = StringsKt.indexOf$default((CharSequence)urlString, (char)'#', (int)(startIndex + 1), (boolean)false, (int)4, null);
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it > 0 ? n : null;
        int fragmentStart = n2 != null ? n2 : endIndex;
        String string = urlString.substring(startIndex + 1, fragmentStart);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        Parameters rawParameters = QueryKt.parseQueryString$default(string, 0, 0, false, 6, null);
        rawParameters.forEach((Function2)new Function2<String, List<? extends String>, Unit>($this$parseQuery){
            final /* synthetic */ URLBuilder $this_parseQuery;
            {
                this.$this_parseQuery = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String key, @NotNull List<String> values) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter(values, (String)"values");
                this.$this_parseQuery.getEncodedParameters().appendAll(key, values);
            }
        });
        return fragmentStart;
    }

    private static final void parseFragment(URLBuilder $this$parseFragment, String urlString, int startIndex, int endIndex) {
        if (startIndex < endIndex && urlString.charAt(startIndex) == '#') {
            String string = urlString.substring(startIndex + 1, endIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            $this$parseFragment.setEncodedFragment(string);
        }
    }

    private static final void fillHost(URLBuilder $this$fillHost, String urlString, int startIndex, int endIndex) {
        Integer n = URLParserKt.indexOfColonInHostPort(urlString, startIndex, endIndex);
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it > 0 ? n : null;
        int colonIndex = n2 != null ? n2 : endIndex;
        String string = urlString.substring(startIndex, colonIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        $this$fillHost.setHost(string);
        if (colonIndex + 1 < endIndex) {
            String string2 = urlString.substring(colonIndex + 1, endIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            $this$fillHost.setPort(Integer.parseInt(string2));
        } else {
            $this$fillHost.setPort(0);
        }
    }

    private static final int findScheme(String urlString, int startIndex, int endIndex) {
        int current = startIndex;
        int incorrectSchemePosition = -1;
        char firstChar = urlString.charAt(current);
        if (!('a' <= firstChar ? firstChar < '{' : false)) {
            if (!('A' <= firstChar ? firstChar < '[' : false)) {
                incorrectSchemePosition = current;
            }
        }
        while (current < endIndex) {
            char c = urlString.charAt(current);
            if (c == ':') {
                if (incorrectSchemePosition != -1) {
                    throw new IllegalArgumentException("Illegal character in scheme at position " + incorrectSchemePosition);
                }
                return current - startIndex;
            }
            if (c == '/' || c == '?' || c == '#') {
                return -1;
            }
            if (incorrectSchemePosition == -1) {
                if (!('a' <= c ? c < '{' : false)) {
                    if (!('A' <= c ? c < '[' : false)) {
                        if (!('0' <= c ? c < ':' : false) && c != '.' && c != '+' && c != '-') {
                            incorrectSchemePosition = current;
                        }
                    }
                }
            }
            ++current;
        }
        return -1;
    }

    private static final int count(String urlString, int startIndex, int endIndex, char c) {
        int result = 0;
        while (startIndex + result < endIndex && urlString.charAt(startIndex + result) == c) {
            ++result;
        }
        return result;
    }

    private static final int indexOfColonInHostPort(String $this$indexOfColonInHostPort, int startIndex, int endIndex) {
        boolean skip = false;
        for (int index = startIndex; index < endIndex; ++index) {
            char c = $this$indexOfColonInHostPort.charAt(index);
            if (c == '[') {
                skip = true;
                continue;
            }
            if (c == ']') {
                skip = false;
                continue;
            }
            if (c != ':' || skip) continue;
            return index;
        }
        return -1;
    }

    private static final boolean isLetter(char $this$isLetter) {
        char c = Character.toLowerCase($this$isLetter);
        return 'a' <= c ? c < '{' : false;
    }
}

