/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.Parameters;
import io.ktor.http.URLProtocol;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b7\u0018\u0000 E2\u00020\u0001:\u0001EBe\b\u0000\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\u0004\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001a\u0010\u0017\u001a\u00020\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001b\u001a\u0004\b\u001c\u0010\u0015R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001d\u001a\u0004\b\u001e\u0010\u001aR\u001d\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u001f\u001a\u0004\b \u0010!R\u0017\u0010\u000b\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\"\u001a\u0004\b#\u0010$R\u0017\u0010\f\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\u001b\u001a\u0004\b%\u0010\u0015R\u0019\u0010\r\u001a\u0004\u0018\u00010\u00048\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u001b\u001a\u0004\b&\u0010\u0015R\u0019\u0010\u000e\u001a\u0004\u0018\u00010\u00048\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u001b\u001a\u0004\b'\u0010\u0015R\u0017\u0010\u0010\u001a\u00020\u000f8\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010(\u001a\u0004\b)\u0010*R\u0014\u0010\u0011\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u001bR\u0019\u0010+\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010,\u001a\u0004\b/\u0010.R\u0011\u00101\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u001aR\u001b\u00105\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u00103\u001a\u0004\b4\u0010\u0015R\u001b\u00108\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b6\u00103\u001a\u0004\b7\u0010\u0015R\u001b\u0010;\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b9\u00103\u001a\u0004\b:\u0010\u0015R\u001d\u0010>\u001a\u0004\u0018\u00010\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b<\u00103\u001a\u0004\b=\u0010\u0015R\u001d\u0010A\u001a\u0004\u0018\u00010\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b?\u00103\u001a\u0004\b@\u0010\u0015R\u001b\u0010D\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bB\u00103\u001a\u0004\bC\u0010\u0015\u00a8\u0006F"}, d2={"Lio/ktor/http/Url;", "", "Lio/ktor/http/URLProtocol;", "protocol", "", "host", "", "specifiedPort", "", "pathSegments", "Lio/ktor/http/Parameters;", "parameters", "fragment", "user", "password", "", "trailingQuery", "urlString", "<init>", "(Lio/ktor/http/URLProtocol;Ljava/lang/String;ILjava/util/List;Lio/ktor/http/Parameters;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;)V", "toString", "()Ljava/lang/String;", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "Ljava/lang/String;", "getHost", "I", "getSpecifiedPort", "Ljava/util/List;", "getPathSegments", "()Ljava/util/List;", "Lio/ktor/http/Parameters;", "getParameters", "()Lio/ktor/http/Parameters;", "getFragment", "getUser", "getPassword", "Z", "getTrailingQuery", "()Z", "protocolOrNull", "Lio/ktor/http/URLProtocol;", "getProtocolOrNull", "()Lio/ktor/http/URLProtocol;", "getProtocol", "getPort", "port", "encodedPath$delegate", "Lkotlin/Lazy;", "getEncodedPath", "encodedPath", "encodedQuery$delegate", "getEncodedQuery", "encodedQuery", "encodedPathAndQuery$delegate", "getEncodedPathAndQuery", "encodedPathAndQuery", "encodedUser$delegate", "getEncodedUser", "encodedUser", "encodedPassword$delegate", "getEncodedPassword", "encodedPassword", "encodedFragment$delegate", "getEncodedFragment", "encodedFragment", "Companion", "ktor-http"})
@SourceDebugExtension(value={"SMAP\nUrl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Url.kt\nio/ktor/http/Url\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,153:1\n1#2:154\n*E\n"})
public final class Url {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String host;
    private final int specifiedPort;
    @NotNull
    private final List<String> pathSegments;
    @NotNull
    private final Parameters parameters;
    @NotNull
    private final String fragment;
    @Nullable
    private final String user;
    @Nullable
    private final String password;
    private final boolean trailingQuery;
    @NotNull
    private final String urlString;
    @Nullable
    private final URLProtocol protocolOrNull;
    @NotNull
    private final URLProtocol protocol;
    @NotNull
    private final Lazy encodedPath$delegate;
    @NotNull
    private final Lazy encodedQuery$delegate;
    @NotNull
    private final Lazy encodedPathAndQuery$delegate;
    @NotNull
    private final Lazy encodedUser$delegate;
    @NotNull
    private final Lazy encodedPassword$delegate;
    @NotNull
    private final Lazy encodedFragment$delegate;

    public Url(@Nullable URLProtocol protocol, @NotNull String host, int specifiedPort, @NotNull List<String> pathSegments, @NotNull Parameters parameters, @NotNull String fragment, @Nullable String user, @Nullable String password, boolean trailingQuery, @NotNull String urlString) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter(pathSegments, (String)"pathSegments");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        this.host = host;
        this.specifiedPort = specifiedPort;
        this.pathSegments = pathSegments;
        this.parameters = parameters;
        this.fragment = fragment;
        this.user = user;
        this.password = password;
        this.trailingQuery = trailingQuery;
        this.urlString = urlString;
        int n = this.specifiedPort;
        if (!(0 <= n ? n < 65536 : false)) {
            boolean bl = false;
            String string = "Port must be between 0 and 65535, or 0 if not set. Provided: " + this.specifiedPort;
            throw new IllegalArgumentException(string.toString());
        }
        this.protocolOrNull = protocol;
        URLProtocol uRLProtocol = this.protocolOrNull;
        if (uRLProtocol == null) {
            uRLProtocol = URLProtocol.Companion.getHTTP();
        }
        this.protocol = uRLProtocol;
        this.encodedPath$delegate = LazyKt.lazy(() -> Url.encodedPath_delegate$lambda$2(this));
        this.encodedQuery$delegate = LazyKt.lazy(() -> Url.encodedQuery_delegate$lambda$3(this));
        this.encodedPathAndQuery$delegate = LazyKt.lazy(() -> Url.encodedPathAndQuery_delegate$lambda$4(this));
        this.encodedUser$delegate = LazyKt.lazy(() -> Url.encodedUser_delegate$lambda$5(this));
        this.encodedPassword$delegate = LazyKt.lazy(() -> Url.encodedPassword_delegate$lambda$6(this));
        this.encodedFragment$delegate = LazyKt.lazy(() -> Url.encodedFragment_delegate$lambda$7(this));
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final int getSpecifiedPort() {
        return this.specifiedPort;
    }

    @NotNull
    public final List<String> getPathSegments() {
        return this.pathSegments;
    }

    @NotNull
    public final Parameters getParameters() {
        return this.parameters;
    }

    @NotNull
    public final String getFragment() {
        return this.fragment;
    }

    @Nullable
    public final String getUser() {
        return this.user;
    }

    @Nullable
    public final String getPassword() {
        return this.password;
    }

    public final boolean getTrailingQuery() {
        return this.trailingQuery;
    }

    @Nullable
    public final URLProtocol getProtocolOrNull() {
        return this.protocolOrNull;
    }

    @NotNull
    public final URLProtocol getProtocol() {
        return this.protocol;
    }

    public final int getPort() {
        Integer n = this.specifiedPort;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = !(it == 0) ? n : null;
        return n2 != null ? n2.intValue() : this.protocol.getDefaultPort();
    }

    @NotNull
    public final String getEncodedPath() {
        Lazy lazy = this.encodedPath$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getEncodedQuery() {
        Lazy lazy = this.encodedQuery$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getEncodedPathAndQuery() {
        Lazy lazy = this.encodedPathAndQuery$delegate;
        return (String)lazy.getValue();
    }

    @Nullable
    public final String getEncodedUser() {
        Lazy lazy = this.encodedUser$delegate;
        return (String)lazy.getValue();
    }

    @Nullable
    public final String getEncodedPassword() {
        Lazy lazy = this.encodedPassword$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getEncodedFragment() {
        Lazy lazy = this.encodedFragment$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public String toString() {
        return this.urlString;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Url cfr_ignored_0 = (Url)other;
        return Intrinsics.areEqual((Object)this.urlString, (Object)((Url)other).urlString);
    }

    public int hashCode() {
        return this.urlString.hashCode();
    }

    private static final String encodedPath_delegate$lambda$2(Url this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.pathSegments.isEmpty()) {
            return "";
        }
        int pathStartIndex = StringsKt.indexOf$default((CharSequence)this$0.urlString, (char)'/', (int)(this$0.protocol.getName().length() + 3), (boolean)false, (int)4, null);
        if (pathStartIndex == -1) {
            return "";
        }
        char[] cArray = new char[]{'?', '#'};
        int pathEndIndex = StringsKt.indexOfAny$default((CharSequence)this$0.urlString, (char[])cArray, (int)pathStartIndex, (boolean)false, (int)4, null);
        if (pathEndIndex == -1) {
            String string = this$0.urlString.substring(pathStartIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }
        String string = this$0.urlString.substring(pathStartIndex, pathEndIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    private static final String encodedQuery_delegate$lambda$3(Url this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int queryStart = StringsKt.indexOf$default((CharSequence)this$0.urlString, (char)'?', (int)0, (boolean)false, (int)6, null) + 1;
        if (queryStart == 0) {
            return "";
        }
        int queryEnd = StringsKt.indexOf$default((CharSequence)this$0.urlString, (char)'#', (int)queryStart, (boolean)false, (int)4, null);
        if (queryEnd == -1) {
            String string = this$0.urlString.substring(queryStart);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }
        String string = this$0.urlString.substring(queryStart, queryEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    private static final String encodedPathAndQuery_delegate$lambda$4(Url this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int pathStart = StringsKt.indexOf$default((CharSequence)this$0.urlString, (char)'/', (int)(this$0.protocol.getName().length() + 3), (boolean)false, (int)4, null);
        if (pathStart == -1) {
            return "";
        }
        int queryEnd = StringsKt.indexOf$default((CharSequence)this$0.urlString, (char)'#', (int)pathStart, (boolean)false, (int)4, null);
        if (queryEnd == -1) {
            String string = this$0.urlString.substring(pathStart);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }
        String string = this$0.urlString.substring(pathStart, queryEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    private static final String encodedUser_delegate$lambda$5(Url this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.user == null) {
            return null;
        }
        if (((CharSequence)this$0.user).length() == 0) {
            return "";
        }
        int usernameStart = this$0.protocol.getName().length() + 3;
        char[] cArray = new char[]{':', '@'};
        int usernameEnd = StringsKt.indexOfAny$default((CharSequence)this$0.urlString, (char[])cArray, (int)usernameStart, (boolean)false, (int)4, null);
        String string = this$0.urlString.substring(usernameStart, usernameEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    private static final String encodedPassword_delegate$lambda$6(Url this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.password == null) {
            return null;
        }
        if (((CharSequence)this$0.password).length() == 0) {
            return "";
        }
        int passwordStart = StringsKt.indexOf$default((CharSequence)this$0.urlString, (char)':', (int)(this$0.protocol.getName().length() + 3), (boolean)false, (int)4, null) + 1;
        int passwordEnd = StringsKt.indexOf$default((CharSequence)this$0.urlString, (char)'@', (int)0, (boolean)false, (int)6, null);
        String string = this$0.urlString.substring(passwordStart, passwordEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    private static final String encodedFragment_delegate$lambda$7(Url this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int fragmentStart = StringsKt.indexOf$default((CharSequence)this$0.urlString, (char)'#', (int)0, (boolean)false, (int)6, null) + 1;
        if (fragmentStart == 0) {
            return "";
        }
        String string = this$0.urlString.substring(fragmentStart);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lio/ktor/http/Url$Companion;", "", "<init>", "()V", "ktor-http"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

